/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.home;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.cluster.home.HomeException;
import oracle.cluster.home.HomeType;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrChMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;

public class HomeArgs {
    private String m_name = null;
    private String m_path = null;
    private HomeType m_type = null;
    private String[] m_nodes = null;
    private List<Node> m_nodeList = null;
    private String m_addNode = null;
    private String m_deleteNode = null;
    private boolean m_siha = false;

    public HomeArgs() {
    }

    public HomeArgs(boolean siha) {
        this.m_siha = siha;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) throws HomeException {
        this.assertAgainstNullAndEmptyString(name, "name");
        this.m_name = name.toLowerCase();
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String path) throws HomeException {
        this.assertAgainstNullAndEmptyString(path, "path");
        this.assertPath(path);
        this.m_path = path;
    }

    public HomeType getType() {
        return this.m_type;
    }

    public void setType(HomeType type) throws HomeException {
        this.assertAgainstNull((Object)type, "type");
        this.m_type = type;
        this.assertHomeOptions();
    }

    public String[] getNodes() {
        return this.m_nodes;
    }

    public List<Node> getNodeList() {
        return this.m_nodeList;
    }

    public void setNodes(String[] nodes) throws HomeException {
        try {
            this.assertAgainstNull(nodes, "node list");
            this.m_nodes = nodes;
            this.m_nodeList = new ArrayList<Node>(nodes.length);
            ServerFactory srvFact = ServerFactory.getInstance();
            for (String node : nodes) {
                this.m_nodeList.add(srvFact.getNode(node));
            }
            this.assertHomeOptions();
        }
        catch (NodeException ne) {
            throw new HomeException(ne);
        }
        catch (ServerException se) {
            throw new HomeException(se);
        }
    }

    public String getAddNode() {
        return this.m_addNode;
    }

    public void setAddNode(String node) throws HomeException {
        this.assertAgainstNullAndEmptyString(node, "node");
        this.m_addNode = node;
        this.assertHomeOptions();
    }

    public void setDeleteNode(String node) throws HomeException {
        this.assertAgainstNullAndEmptyString(node, "node");
        this.m_addNode = node;
    }

    public String getDeleteNode() {
        return this.m_deleteNode;
    }

    private void assertAgainstNull(Object objToValidate, String paramName) throws HomeException {
        if (objToValidate == null) {
            throw new HomeException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, paramName);
        }
    }

    private void assertAgainstNullAndEmptyString(String strToValidate, String paramName) throws HomeException {
        if (strToValidate == null || strToValidate.trim().length() == 0) {
            throw new HomeException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, paramName);
        }
    }

    private void assertHomeOptions() throws HomeException {
        this.assertSIHAOptions();
        if ((this.m_addNode != null || this.m_deleteNode != null || this.m_nodes != null) && this.m_type == HomeType.POLICY) {
            throw new HomeException((MessageKey)PrChMsgID.UNSUPPORTED_NODELIST_POLICY, new Object[0]);
        }
    }

    private void assertSIHAOptions() throws HomeException {
        if (this.m_siha && this.m_type != null) {
            throw new HomeException((MessageKey)PrChMsgID.OHOME_UNSUPPORTED_SIHA_NODES, new Object[0]);
        }
        if (this.m_siha && (this.m_nodes != null || this.m_addNode != null) || this.m_deleteNode != null) {
            throw new HomeException((MessageKey)PrChMsgID.OHOME_UNSUPPORTED_SIHA_TYPE, new Object[0]);
        }
    }

    private void assertPath(String path) throws HomeException {
        File fileToValidate = new File(path);
        if (!fileToValidate.exists()) {
            throw new HomeException((MessageKey)PrCtMsgID.INVALID_FILE_PATH, path);
        }
    }
}

