/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.helper.HelperException;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.remote.ExecCommand;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.RemoteFactory;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class UserActionHelper {
    private MessageBundle m_msgBndl = MessageBundle.getMessageBundle(PrCgMsgID.facility);

    public UserActionHelper() {
        this.m_msgBndl.setPackage("oracle.cluster.resources");
    }

    public void executeUserActions(String baseDir, String uaInfo, String[] args, String[] nodeList, ProgressListener plsnr) throws HelperException {
        Trace.out("BaseDir: " + baseDir);
        Trace.out("UserActionInfo passed to ExecCommand.executeUserActions: " + uaInfo);
        Trace.out("args: " + Utils.strArrToList(args));
        Trace.out("nodeList: " + Utils.strArrToList(nodeList));
        ArrayList<String> uaInfoList = new ArrayList<String>();
        Pattern p = null;
        p = Pattern.compile("\\[(.*?)\\]");
        Trace.out("Pattern compiled successfully");
        Matcher m = p.matcher(uaInfo);
        while (m.find()) {
            uaInfoList.add(m.group(1));
        }
        for (String ua : uaInfoList) {
            String[] uaArr = ua.split(",");
            String userActionName = uaArr[0];
            String actionScriptName = uaArr[1];
            boolean allNodes = uaArr[2].equals("1");
            boolean isFatal = uaArr[3].equals("1");
            Trace.out("Beginning execution of useraction " + userActionName);
            String filepath = baseDir + File.separator + userActionName + File.separator + actionScriptName;
            try {
                RemoteFactory remoteFactory = RemoteFactory.getInstance();
                ExecCommand execCmd = remoteFactory.getExecCommand();
                if (allNodes) {
                    if (plsnr != null) {
                        plsnr.write(MessageBundle.getMessage(PrCgMsgID.EXECUTING_USERACTION_NODES, false, userActionName, Utils.strArrToList(nodeList)));
                    }
                    execCmd.runCmd(filepath, args, new String[0], nodeList, plsnr);
                } else {
                    if (plsnr != null) {
                        plsnr.write(MessageBundle.getMessage(PrCgMsgID.EXECUTING_USERACTION_NODES, false, userActionName, nodeList[0]));
                    }
                    execCmd.runCmd(filepath, args, new String[0], new String[]{nodeList[0]}, plsnr);
                }
                if (plsnr != null) {
                    plsnr.write(MessageBundle.getMessage(PrCgMsgID.DONE_EXECUTING_USERACTION, false, userActionName));
                }
                Trace.out("Useraction " + userActionName + " executed successfully...");
            }
            catch (ExecException e) {
                if (isFatal) {
                    Trace.out("UserAction " + userActionName + " failed!!");
                    Trace.out("ExecException: " + e.getMessage());
                    throw new HelperException(e);
                }
                Trace.out("WARNING: " + userActionName + " failed!!");
            }
            catch (CompositeOperationException e) {
                if (isFatal) {
                    Trace.out("UserAction " + userActionName + " failed!!");
                    Trace.out("ExecException: " + e.getMessage());
                    throw new HelperException(e);
                }
                Trace.out("WARNING: " + userActionName + " failed!!");
            }
            catch (InvalidArgsException e) {
                Trace.out("InvalidArgsException: " + e.getMessage());
                throw new HelperException(e);
            }
        }
        Trace.out("All useractions executed successfully...");
    }
}

