/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.hanfs;

import java.util.Arrays;
import java.util.List;
import oracle.cluster.hanfs.ExportFSException;
import oracle.cluster.hanfs.ExportType;
import oracle.cluster.resources.PrCcMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public enum Platform {
    WINDOWS("WINDOWS"){

        @Override
        public List<ExportType> supportedExportTypes() {
            ExportType[] supportedExport = new ExportType[]{ExportType.SMB};
            return Arrays.asList(supportedExport);
        }
    }
    ,
    UNIX("UNIX"){

        @Override
        public List<ExportType> supportedExportTypes() {
            ExportType[] supportedFS = new ExportType[]{ExportType.NFS, ExportType.SMB};
            return Arrays.asList(supportedFS);
        }
    };

    private String m_value;

    private Platform(String value) {
        this.m_value = value;
    }

    public String getValue() {
        return this.m_value;
    }

    public static Platform getMember(String value) throws ExportFSException {
        for (Platform member : Platform.values()) {
            if (!member.getValue().equalsIgnoreCase(value)) continue;
            return member;
        }
        throw new ExportFSException((MessageKey)PrCcMsgID.INVALID_PLATFORM_ENUM, value);
    }

    public abstract List<ExportType> supportedExportTypes();
}

