/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.hanfs;

import oracle.cluster.hanfs.NetStorageServiceException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public enum NetStorageServiceType {
    NFS("NFS"),
    CIFS("SMB");

    private String m_value;

    private NetStorageServiceType(String value) {
        this.m_value = value;
    }

    public String getValue() {
        return this.m_value;
    }

    public static String getAllTypes() {
        StringBuilder sb = null;
        for (NetStorageServiceType member : NetStorageServiceType.values()) {
            if (sb == null) {
                sb = new StringBuilder(member.getValue());
                continue;
            }
            sb.append(",").append(member.getValue());
        }
        if (sb != null) {
            return sb.toString();
        }
        return "";
    }

    public static NetStorageServiceType getMember(String value) throws NetStorageServiceException {
        for (NetStorageServiceType member : NetStorageServiceType.values()) {
            if (!member.getValue().equalsIgnoreCase(value)) continue;
            return member;
        }
        throw new NetStorageServiceException((MessageKey)PrCcMsgID.INVALID_NETSTORAGESRV_TYPE, value, NetStorageServiceType.getAllTypes());
    }
}

