/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.hanfs;

import oracle.cluster.hanfs.MountFSException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public class MountFSArgs {
    private String m_name = null;
    private String m_exportServer = null;
    private String m_exportPath = null;
    private String m_mountPointPath = null;
    private String m_user = null;
    private String m_mtOptions = null;

    public void setMountFSName(String name) throws MountFSException {
        this.validateAgainstNullAndEmptyString(name, "name");
        this.m_name = name.trim();
    }

    public void setMountPointPath(String mountPointPath) throws MountFSException {
        this.validateAgainstNullAndEmptyString(mountPointPath, "mountPointPath");
        this.m_mountPointPath = mountPointPath;
    }

    public void setExportServer(String exptSrvName) throws MountFSException {
        this.validateAgainstNullAndEmptyString(exptSrvName, "exportserver");
        this.m_exportServer = exptSrvName.trim();
    }

    public void setExportPath(String exptPath) throws MountFSException {
        this.validateAgainstNullAndEmptyString(exptPath, "exportpath");
        this.m_exportPath = exptPath;
    }

    public void setMountOptions(String mountOptions) throws MountFSException {
        this.validateAgainstNull(mountOptions, "mountOptions");
        this.m_mtOptions = mountOptions;
    }

    public void setUser(String user) throws MountFSException {
        this.validateAgainstNullAndEmptyString(user, "user");
        this.m_user = user;
    }

    public String getMountFSName() {
        return this.m_name;
    }

    public String getExportServer() {
        return this.m_exportServer;
    }

    public String getExportPath() {
        return this.m_exportPath;
    }

    public String getMountPointPath() {
        return this.m_mountPointPath;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getMountOptions() {
        return this.m_mtOptions;
    }

    private void validateAgainstNull(Object objToValidate, String paramName) throws MountFSException {
        if (objToValidate == null) {
            throw new MountFSException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, paramName);
        }
    }

    private void validateAgainstNullAndEmptyString(String strToValidate, String paramName) throws MountFSException {
        if (strToValidate == null || strToValidate.trim().length() == 0) {
            throw new MountFSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, paramName);
        }
    }
}

