/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.hanfs;

import java.net.InetAddress;
import java.util.List;
import oracle.cluster.asm.AsmClusterFileSystem;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.hanfs.ExportFS;
import oracle.cluster.hanfs.ExportFSException;
import oracle.cluster.hanfs.ExportType;
import oracle.cluster.hanfs.HAVIP;
import oracle.cluster.hanfs.HAVIPException;
import oracle.cluster.hanfs.MountFS;
import oracle.cluster.hanfs.MountFSArgs;
import oracle.cluster.hanfs.MountFSException;
import oracle.cluster.hanfs.NetStorageService;
import oracle.cluster.hanfs.NetStorageServiceException;
import oracle.cluster.impl.hanfs.HANFSFactoryImpl;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nodeapps.VIPAddress;

public class HANFSFactory {
    private static HANFSFactory s_instance;
    private static HANFSFactoryImpl s_factoryImpl;

    private HANFSFactory() throws SoftwareModuleException {
        s_factoryImpl = HANFSFactoryImpl.getInstance();
    }

    public static synchronized HANFSFactory getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new HANFSFactory();
        }
        return s_instance;
    }

    public HAVIP getHAVIP(String id) throws NotExistsException, HAVIPException {
        return s_factoryImpl.getHAVIP(id);
    }

    public HAVIP getHAVIPbyAddress(String ipAddress) throws NotExistsException, HAVIPException {
        return s_factoryImpl.getHAVIPbyAddress(ipAddress);
    }

    public List<HAVIP> getHAVIPs() throws NotExistsException, HAVIPException {
        return s_factoryImpl.getHAVIPs();
    }

    public ExportFS createExportFS(String id, String expName, String exportPath, String clients, String expOptions, Version version) throws AlreadyExistsException, ExportFSException {
        return s_factoryImpl.createExportFS(id, expName, exportPath, clients, expOptions, version, false);
    }

    public ExportFS createExportFS(String id, String expName, String exportPath, String clients, String expOptions, ExportType expType, Version version) throws AlreadyExistsException, ExportFSException {
        return s_factoryImpl.createExportFS(id, expName, exportPath, clients, expOptions, expType, version, false);
    }

    public ExportFS createExportFS(String id, String expName, String exportPath, String clients, String expOptions, Version version, boolean ghExport) throws AlreadyExistsException, ExportFSException {
        return s_factoryImpl.createExportFS(id, expName, exportPath, clients, expOptions, version, ghExport);
    }

    public ExportFS createExportFS(String id, String expName, String exportPath, String clients, String expOptions, ExportType expType, Version version, boolean ghExport) throws AlreadyExistsException, ExportFSException {
        return s_factoryImpl.createExportFS(id, expName, exportPath, clients, expOptions, expType, version, ghExport);
    }

    public MountFS createMountFS(String mountPointPath, String name, String exportPath, String exportServer) throws AlreadyExistsException, MountFSException {
        return s_factoryImpl.createMountFS(mountPointPath, name, exportPath, exportServer);
    }

    public MountFS createMountFS(MountFSArgs mtArgs) throws AlreadyExistsException, MountFSException {
        return s_factoryImpl.createMountFS(mtArgs);
    }

    public NetStorageService createNetStorageService(AsmClusterFileSystem acfs) throws AlreadyExistsException, NetStorageServiceException {
        return s_factoryImpl.createNetStorageService(acfs);
    }

    public HAVIP createHAVIP(VIPAddress vipAddress, String id, int netNum, String subnet, DHCPServerType serverType, Version version, String description) throws AlreadyExistsException, HAVIPException {
        return s_factoryImpl.createHAVIP(vipAddress, id, netNum, subnet, serverType, version, description);
    }

    public HAVIP createHAVIP(VIPAddress vipAddress, String id, int netNum, String subnet, DHCPServerType serverType, Version version, String description, boolean skipVIPReachabilityCheck) throws AlreadyExistsException, HAVIPException {
        return s_factoryImpl.createHAVIP(vipAddress, id, netNum, subnet, serverType, version, description, skipVIPReachabilityCheck);
    }

    public HAVIP createHAVIP(VIPAddress vipAddress, String id, int netNum, String subnet, DHCPServerType serverType, Version version, String description, boolean skipVIPReachabilityCheck, String homeNode) throws AlreadyExistsException, HAVIPException {
        return s_factoryImpl.createHAVIP(vipAddress, id, netNum, subnet, serverType, version, description, skipVIPReachabilityCheck, homeNode);
    }

    public HAVIP modifyHAVIP(InetAddress inetAddress) throws HAVIPException {
        throw new RuntimeException("Not implemented");
    }

    public HAVIP modifyHAVIP(InetAddress inetAddress, boolean skipVIPReachabilityCheck) throws HAVIPException {
        throw new RuntimeException("Not implemented");
    }

    public void upgradeExportFS12101To12102LastPhase() throws UpgradeException {
        s_factoryImpl.upgradeExportFS12101To12102LastPhase();
    }

    public void upgradeHAVIP12101To122LastPhase() throws UpgradeException {
        s_factoryImpl.upgradeHAVIP12101To122LastPhase();
    }

    public ExportFS getExportFS(String expname) throws NotExistsException, ExportFSException {
        return s_factoryImpl.getExportFS(expname);
    }

    public List<ExportFS> getExportFSs() throws NotExistsException, ExportFSException {
        return s_factoryImpl.getExportFSs();
    }

    public MountFS getMountFS(String mountPointPath) throws NotExistsException, MountFSException {
        return s_factoryImpl.getMountFS(mountPointPath);
    }

    public MountFS getMountFSbyName(String resourceName) throws NotExistsException, MountFSException {
        return s_factoryImpl.getMountFSbyName(resourceName);
    }

    public List<MountFS> getMountFSList() throws NotExistsException, MountFSException {
        return s_factoryImpl.getMountFSList();
    }

    public NetStorageService getNetStorageService() throws NotExistsException, NetStorageServiceException {
        return s_factoryImpl.getNetStorageService();
    }

    public MountFS getMountFSbyPath(String path) throws NotExistsException, MountFSException {
        return s_factoryImpl.getMountFSbyPath(path);
    }

    public boolean isPathOnMountFS(String path) throws MountFSException {
        return s_factoryImpl.isPathOnMountFS(path);
    }

    public void startExportFSforHAVIP(String id) throws ExportFSException, AlreadyRunningException, CompositeOperationException {
        s_factoryImpl.startExportFSforHAVIP(id);
    }

    public void startExportFSforHAVIP(String id, ExportType exportType) throws ExportFSException, AlreadyRunningException, CompositeOperationException {
        s_factoryImpl.startExportFSforHAVIP(id, exportType);
    }

    public void stopExportFSforHAVIP(String id) throws ExportFSException, AlreadyStoppedException, CompositeOperationException {
        s_factoryImpl.stopExportFSforHAVIP(id, false);
    }

    public void stopExportFSforHAVIP(String id, boolean force) throws ExportFSException, AlreadyStoppedException, CompositeOperationException {
        s_factoryImpl.stopExportFSforHAVIP(id, force);
    }

    public void stopExportFSforHAVIP(String id, ExportType exportType) throws ExportFSException, AlreadyStoppedException, CompositeOperationException {
        s_factoryImpl.stopExportFSforHAVIP(id, exportType, false);
    }

    public void stopExportFSforHAVIP(String id, ExportType exportType, boolean force) throws ExportFSException, AlreadyStoppedException, CompositeOperationException {
        s_factoryImpl.stopExportFSforHAVIP(id, exportType, force);
    }

    public List<ExportFS> getExportFSs(String id) throws NotExistsException, ExportFSException {
        return s_factoryImpl.getExportFSs(id);
    }

    public static String getNFSResourceName(String name) throws CRSException {
        return HANFSFactoryImpl.getNFSResourceName(name);
    }
}

