/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gridhome.credentials;

import oracle.cluster.gridhome.credentials.Credentials;
import oracle.cluster.gridhome.credentials.CredentialsException;
import oracle.cluster.impl.gridhome.credentials.CredentialsFactoryImpl;

public class CredentialsFactory {
    private static CredentialsFactory s_instance;
    private CredentialsFactoryImpl s_factoryImpl = CredentialsFactoryImpl.getInstance();

    private CredentialsFactory() throws CredentialsException {
    }

    public static CredentialsFactory getInstance() throws CredentialsException {
        if (null == s_instance) {
            s_instance = new CredentialsFactory();
        }
        return s_instance;
    }

    public void createClientData(String clusterName, Credentials creds) throws CredentialsException {
        this.s_factoryImpl.createClientData(clusterName, creds);
    }

    public void exportClientData(String clusterName, String dataFile, Credentials creds) throws CredentialsException {
        this.s_factoryImpl.exportClientData(clusterName, dataFile, creds);
    }

    public String exportClientDataBuf(String clusterName, Credentials creds) throws CredentialsException {
        return this.s_factoryImpl.exportClientDataBuf(clusterName, creds);
    }

    public String exportClientDataBuf(String clusterName, Credentials creds, String version) throws CredentialsException {
        return this.s_factoryImpl.exportClientDataBuf(clusterName, creds, version);
    }

    public String exportClientDataBuf(String clusterName, Credentials creds, String credFile, String version) throws CredentialsException {
        return this.s_factoryImpl.exportClientDataBuf(clusterName, creds, credFile, version);
    }

    public void importClientData(String clusterName, String dataFile) throws CredentialsException {
        this.s_factoryImpl.importClientData(clusterName, dataFile);
    }

    public String getClientSecret(String clusterName) throws CredentialsException {
        return this.s_factoryImpl.getClientSecret(clusterName);
    }

    public String getServerSecret(String clusterName) throws CredentialsException {
        return this.s_factoryImpl.getServerSecret(clusterName);
    }

    public void deleteClientCredentials(String clusterName) throws CredentialsException {
        this.s_factoryImpl.deleteClientCredentials(clusterName);
    }
}

