/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gridhome.credentials;

import java.util.HashMap;
import oracle.cluster.gridhome.credentials.CredentialsException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class Credentials {
    private String m_userName = null;
    private String m_password = null;
    private String m_ghcpassword = null;
    private String m_ghspassword = null;
    private String m_clientData = null;
    private HashMap<String, String> m_properties = null;
    private static final String SERVER_PASSWD_SEP = "?";

    public Credentials() {
        Trace.out("credentials empty constructor");
    }

    public Credentials(String pass) {
        Trace.out("credentials constructor with pass string");
        String[] pwarr = pass.split("\\?");
        this.m_ghcpassword = pwarr[0];
        this.m_ghspassword = pwarr[1];
    }

    public void setUserName(String userName) throws CredentialsException {
        this.assertNotNull(userName, "userName");
        this.assertNotEmptyString(userName, "userName");
        this.m_userName = userName;
    }

    public String getUser() {
        return this.m_userName;
    }

    public void setghcPassword(String password) throws CredentialsException {
        this.assertNotNull(password, "password");
        this.assertNotEmptyString(password, "password");
        this.m_ghcpassword = password;
    }

    public void setghsPassword(String password) throws CredentialsException {
        this.assertNotNull(password, "password");
        this.assertNotEmptyString(password, "password");
        this.m_ghspassword = password;
    }

    public String getPassword() {
        String pass = this.m_ghcpassword + SERVER_PASSWD_SEP + this.m_ghspassword;
        return pass;
    }

    public String getghcPassword() {
        return this.m_ghcpassword;
    }

    public String getghsPassword() {
        return this.m_ghspassword;
    }

    public void setClientData(String clientData) throws CredentialsException {
        this.assertNotNull(clientData, "clientData");
        this.m_clientData = clientData;
    }

    public String getClientData() {
        return this.m_clientData;
    }

    public void setProperties(HashMap<String, String> properties) throws CredentialsException {
        this.assertNotNull(properties, "properties");
        this.m_properties = properties;
    }

    public HashMap<String, String> getProperties() {
        return this.m_properties;
    }

    private void assertNotEmptyString(String str, String name) throws CredentialsException {
        if (str == null || str.trim().length() == 0) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, name);
        }
    }

    private void assertNotNull(Object o, String name) throws CredentialsException {
        if (o == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, name);
        }
    }
}

