/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gridhome;

import java.util.List;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.gridhome.GHContainerType;
import oracle.cluster.gridhome.GridHomeClient;
import oracle.cluster.gridhome.GridHomeClientArgs;
import oracle.cluster.gridhome.GridHomeClientException;
import oracle.cluster.gridhome.GridHomeException;
import oracle.cluster.gridhome.GridHomeServer;
import oracle.cluster.gridhome.GridHomeServerArgs;
import oracle.cluster.gridhome.GridHomeServerException;
import oracle.cluster.gridhome.RHPContainerType;
import oracle.cluster.impl.gridhome.GridHomeFactoryImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;

public class GridHomeFactory {
    private static GridHomeFactory s_instance;
    private GridHomeFactoryImpl s_factoryImpl = GridHomeFactoryImpl.getInstance();

    private GridHomeFactory() throws SoftwareModuleException {
    }

    public static synchronized GridHomeFactory getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new GridHomeFactory();
        }
        return s_instance;
    }

    public GridHomeServer createGridHomeServer(String storagePath, List<DiskGroup> dgList, Version version) throws AlreadyExistsException, GridHomeServerException {
        return this.s_factoryImpl.createGridHomeServer(storagePath, dgList, version);
    }

    public GridHomeServer createGridHomeServer(String storagePath, List<DiskGroup> dgList, Version version, ProgressListener plsnrClient) throws AlreadyExistsException, GridHomeServerException {
        if (plsnrClient == null) {
            throw new GridHomeServerException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "plsnrClient");
        }
        return this.s_factoryImpl.createGridHomeServer(storagePath, dgList, version, plsnrClient);
    }

    public GridHomeServer createGridHomeServer(String storagePath, List<DiskGroup> dgList, Version version, GridHomeServerArgs ghsArgs) throws AlreadyExistsException, GridHomeServerException {
        return this.s_factoryImpl.createGridHomeServer(storagePath, dgList, version, ghsArgs);
    }

    public GridHomeServer createGridHomeServer(String storagePath, List<DiskGroup> dgList, Version version, ProgressListener plsnrClient, GridHomeServerArgs ghsArgs) throws AlreadyExistsException, GridHomeServerException {
        if (plsnrClient == null) {
            throw new GridHomeServerException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "plsnrClient");
        }
        return this.s_factoryImpl.createGridHomeServer(storagePath, dgList, version, plsnrClient, ghsArgs);
    }

    public GridHomeServer createGridHomeServer(String storagePath, List<DiskGroup> dgList, Version version, ProgressListener plsnrClient, GridHomeServerArgs ghsArgs, boolean isUpg) throws AlreadyExistsException, GridHomeServerException {
        if (plsnrClient == null) {
            throw new GridHomeServerException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "plsnrClient");
        }
        return this.s_factoryImpl.createGridHomeServer(storagePath, dgList, version, plsnrClient, ghsArgs);
    }

    public GridHomeServer getGridHomeServer() throws NotExistsException, GridHomeServerException {
        return this.s_factoryImpl.getGridHomeServer();
    }

    public GridHomeServer getGridHomeServer(Version ver) throws NotExistsException, GridHomeServerException {
        return this.s_factoryImpl.getGridHomeServer(ver);
    }

    public static String getRHPSSchemaName() {
        return GridHomeFactoryImpl.getRHPSSchemaName();
    }

    public GridHomeClient createGridHomeClient(String clientData, Version version) throws AlreadyExistsException, GridHomeClientException {
        return this.s_factoryImpl.createGridHomeClient(clientData, version);
    }

    public GridHomeClient createGridHomeClient(String clientData, GridHomeClientArgs ghcArgs, Version version) throws AlreadyExistsException, GridHomeClientException {
        return this.s_factoryImpl.createGridHomeClient(clientData, ghcArgs, version);
    }

    public GridHomeServer createGridHomeServer(String storagePath, List<DiskGroup> dgList, Version version, boolean isUpg) throws AlreadyExistsException, GridHomeServerException {
        return this.s_factoryImpl.createGridHomeServer(storagePath, dgList, version, isUpg);
    }

    public GridHomeClient createGridHomeClient(String clientData, GridHomeClientArgs ghcArgs, Version version, ProgressListener plsnrClient) throws AlreadyExistsException, GridHomeClientException {
        if (plsnrClient == null) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "plsnrClient");
        }
        return this.s_factoryImpl.createGridHomeClient(clientData, ghcArgs, version, plsnrClient);
    }

    public void modifyGridHomeClient(GridHomeClientArgs ghcArgs) throws NotExistsException, GridHomeClientException {
        this.s_factoryImpl.modifyGridHomeClient(ghcArgs);
    }

    public void modifyGridHomeServer(GridHomeServerArgs ghsArgs) throws NotExistsException, GridHomeServerException {
        this.s_factoryImpl.modifyGridHomeServer(ghsArgs);
    }

    public GridHomeClient getGridHomeClient() throws NotExistsException, GridHomeClientException {
        return this.s_factoryImpl.getGridHomeClient();
    }

    public GridHomeClient getGridHomeClient(Version ver) throws NotExistsException, GridHomeClientException {
        return this.s_factoryImpl.getGridHomeClient(ver);
    }

    public GHContainerType getGridHomeClusterType() throws SoftwareModuleException {
        return this.s_factoryImpl.getGridHomeClusterType();
    }

    public RHPContainerType getRHPClusterType() throws GridHomeException {
        return this.s_factoryImpl.getRHPClusterType();
    }

    public String getGridHomeSiteName() throws GridHomeClientException {
        return this.s_factoryImpl.getGridHomeSiteName();
    }

    public void resetRepos() throws GridHomeServerException {
        this.s_factoryImpl.resetRepos();
    }

    public void upgradeClientFrom121() throws AlreadyExistsException, GridHomeClientException {
        this.s_factoryImpl.upgradeClientFrom121();
    }

    public boolean isTLSEnabled() throws SoftwareModuleException {
        return this.s_factoryImpl.isTLSEnabled();
    }
}

