/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gridhome;

import java.io.File;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.gridhome.GridHomeArgs;
import oracle.cluster.gridhome.GridHomeClientException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCgMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public class GridHomeClientArgs
extends GridHomeArgs {
    private DiskGroup m_dg = null;
    private String m_storagePath = null;
    private String m_clientData = null;
    private Integer m_portNum = null;

    public void setDiskGroup(DiskGroup dg) throws GridHomeClientException {
        this.sureNotNull(dg, "dg");
        this.m_dg = dg;
    }

    public DiskGroup getDiskGroup() {
        return this.m_dg;
    }

    public void setStoragePath(String storagePath) throws GridHomeClientException {
        if (storagePath == null || storagePath.trim().length() == 0) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "storagePath");
        }
        if (!new File(storagePath).isAbsolute()) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.INVALID_STORAGE_PATH, storagePath);
        }
        this.m_storagePath = storagePath.trim();
        if (this.m_storagePath.endsWith(File.separator)) {
            this.m_storagePath = this.m_storagePath.substring(0, this.m_storagePath.length() - 1);
        }
    }

    public String getStoragePath() {
        return this.m_storagePath;
    }

    public void setClientData(String clientData) throws GridHomeClientException {
        this.sureNotNull(clientData, "clientData");
        this.m_clientData = clientData;
    }

    public String getClientData() {
        return this.m_clientData;
    }

    public void setPort(int portNum) throws GridHomeClientException {
        this.sureNotNull(portNum, "portNum");
        this.m_portNum = portNum;
    }

    public Integer getPort() throws GridHomeClientException {
        return this.m_portNum;
    }

    private void sureNotNull(Object o, String name) throws GridHomeClientException {
        if (o == null) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, name);
        }
    }
}

