/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gns;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.gns.GNSException;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;

public class GNSUtils {
    public static boolean isDomainNameValid(String domain) throws GNSException {
        String pattern = "[a-zA-Z][[a-zA-Z0-9-]*[a-zA-Z0-9]]*";
        if (domain == null || domain.length() == 0) {
            throw new GNSException((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, "gns-domainnamevalid");
        }
        String[] labelArr = domain.split("\\.");
        if (domain.endsWith(".")) {
            throw new GNSException((MessageKey)PrCsMsgID.GNS_DOMAIN_INVALID_END_CHAR, domain, ".");
        }
        for (String label : labelArr) {
            if (label.length() == 0) {
                throw new GNSException((MessageKey)PrCsMsgID.GNS_DOMAIN_NAME_CHECK_FAILED, "..", domain);
            }
            if (label.length() > 63) {
                throw new GNSException((MessageKey)PrCsMsgID.GNS_DOMAIN_LABEL_TOO_LONG, label, domain);
            }
            if (label.endsWith("-")) {
                throw new GNSException((MessageKey)PrCsMsgID.GNS_DOMAIN_NAME_CHECK_FAILED, label, domain);
            }
            if (label.matches(pattern)) continue;
            throw new GNSException((MessageKey)PrCsMsgID.GNS_DOMAIN_NAME_CHECK_FAILED, label, domain);
        }
        return true;
    }

    public static boolean isValidFQDN(String fullyQualifiedMachineName) throws GNSException {
        if (fullyQualifiedMachineName == null || fullyQualifiedMachineName.length() == 0) {
            throw new GNSException((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, "gns-validfqdn");
        }
        InetAddress[] allIPs = null;
        try {
            allIPs = InetAddress.getAllByName(fullyQualifiedMachineName);
            Trace.out("name " + fullyQualifiedMachineName + "resolved to " + allIPs.length + " IP's");
        }
        catch (UnknownHostException e) {
            throw new GNSException((MessageKey)PrCsMsgID.GNS_FQDN_UNRESOLVED, fullyQualifiedMachineName + Constants.LINE_SEPARATOR + e.getMessage());
        }
        return true;
    }

    public static boolean isValidGNSVIP(String gnsVIPstr) throws GNSException {
        return GNSUtils.isValidGNSVIP(gnsVIPstr, true);
    }

    public static boolean isValidGNSVIP(String gnsVIPstr, boolean preCheck) throws GNSException {
        NodeAppsFactory nodeApps = null;
        Network defaultNet = null;
        Object[] allIPs = null;
        int cntIpv6 = 0;
        int cntIpv4 = 0;
        ArrayList<InetAddress> ip4List = new ArrayList<InetAddress>();
        ArrayList<InetAddress> ip6List = new ArrayList<InetAddress>();
        if (gnsVIPstr == null || gnsVIPstr.length() == 0) {
            throw new GNSException((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, "gns-ValidGNSVIP");
        }
        try {
            String ipList;
            allIPs = InetAddress.getAllByName(gnsVIPstr);
            Trace.out("name " + gnsVIPstr + " resolved to " + allIPs.length + " IP's");
            if (preCheck) {
                if (allIPs.length != 1) {
                    throw new GNSException((MessageKey)PrCsMsgID.GNS_RESOLVED_MULTIPLE_IP, gnsVIPstr, Arrays.toString(allIPs));
                }
                return true;
            }
            for (InetAddress inetAddress : allIPs) {
                if (inetAddress instanceof Inet4Address) {
                    ip4List.add(inetAddress);
                    continue;
                }
                ip6List.add(inetAddress);
            }
            cntIpv4 = ip4List.size();
            cntIpv6 = ip6List.size();
            Trace.out("IPv4 cont " + cntIpv4 + "  IPv6 cont " + cntIpv6);
            nodeApps = NodeAppsFactory.getInstance();
            defaultNet = nodeApps.getNetwork(nodeApps.getDefaultNetworkNumber());
            if (defaultNet.addressType() == IPAddressUtil.IPAddrType.BOTH) {
                Trace.out("Both IP types are allowed");
                if (cntIpv6 > 1 && cntIpv4 > 1) {
                    ipList = Arrays.toString(ip4List.toArray()) + " " + Arrays.toString(ip6List.toArray());
                    throw new GNSException((MessageKey)PrCsMsgID.GNS_RESOLVED_MULTIPLE_IP_MIXED, gnsVIPstr, ipList);
                }
                if (cntIpv6 > 1) {
                    throw new GNSException((MessageKey)PrCsMsgID.GNS_RESOLVED_MULTIPLE_IP_AAAA, gnsVIPstr, Arrays.toString(ip6List.toArray()));
                }
                if (cntIpv4 > 1) {
                    throw new GNSException((MessageKey)PrCsMsgID.GNS_RESOLVED_MULTIPLE_IP_A, gnsVIPstr, Arrays.toString(ip4List.toArray()));
                }
            } else {
                if (cntIpv4 > 1 && cntIpv6 > 1) {
                    ipList = Arrays.toString(ip4List.toArray()) + " " + Arrays.toString(ip6List.toArray());
                    throw new GNSException((MessageKey)PrCsMsgID.GNS_RESOLVED_MULTIPLE_IP_MIXED, gnsVIPstr, ipList);
                }
                if (defaultNet.addressType() == IPAddressUtil.IPAddrType.IPv4) {
                    Trace.out("Only IPv4 is allowed");
                    if (cntIpv4 > 1) {
                        throw new GNSException((MessageKey)PrCsMsgID.GNS_RESOLVED_MULTIPLE_IP_A, gnsVIPstr, Arrays.toString(ip4List.toArray()));
                    }
                    if (cntIpv6 >= 1) {
                        throw new GNSException((MessageKey)PrCsMsgID.GNS_RESOLVED_MULTIPLE_IP_AAAA, gnsVIPstr, Arrays.toString(ip6List.toArray()));
                    }
                } else if (defaultNet.addressType() == IPAddressUtil.IPAddrType.IPv6) {
                    Trace.out("Only IPv6 is allowed");
                    if (cntIpv6 > 1) {
                        throw new GNSException((MessageKey)PrCsMsgID.GNS_RESOLVED_MULTIPLE_IP_AAAA, gnsVIPstr, Arrays.toString(ip6List.toArray()));
                    }
                    if (cntIpv4 >= 1) {
                        throw new GNSException((MessageKey)PrCsMsgID.GNS_RESOLVED_MULTIPLE_IP_A, gnsVIPstr, Arrays.toString(ip4List.toArray()));
                    }
                }
            }
        }
        catch (UnknownHostException e) {
            throw new GNSException((MessageKey)PrCsMsgID.GNS_FQDN_UNRESOLVED, gnsVIPstr + Constants.LINE_SEPARATOR + e.getMessage());
        }
        catch (SoftwareModuleException e) {
            throw new GNSException(e);
        }
        catch (NotExistsException e) {
            throw new GNSException(e);
        }
        return true;
    }
}

