/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.cluster.deployment.ractrans.DirListing;
import oracle.cluster.deployment.ractrans.DirectoryMap;
import oracle.cluster.deployment.ractrans.FileDescriptor;
import oracle.cluster.deployment.ractrans.FileHandler;
import oracle.cluster.deployment.ractrans.MultiTierTransferConstants;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class TransferOptimizer {
    private DirListing m_dirListing;
    private long m_effectiveTotalFileSize;

    protected TransferOptimizer(String topDirPathname, String excludeListFilePathname, boolean excludePathnamesCanBeRegex, String includeListFilePathname, boolean includePathnamesCanBeRegex, boolean linkDestAreRelativePaths) throws RACTransErrorException {
        FileDescriptor topDir;
        try {
            topDir = new FileDescriptor(topDirPathname);
        }
        catch (FileNotFoundException fnfe) {
            Trace.out("The top-level directory \"" + topDirPathname + "\" does not exist.");
            throw new RACTransErrorException((MessageKey)PrCfMsgID.TOP_DIR_NOT_FOUND, topDirPathname);
        }
        File excludeListFile = excludeListFilePathname == null ? null : new File(excludeListFilePathname);
        File includeListFile = includeListFilePathname == null ? null : new File(includeListFilePathname);
        this.m_dirListing = new DirListing(topDir, excludeListFile, excludePathnamesCanBeRegex, includeListFile, includePathnamesCanBeRegex, linkDestAreRelativePaths);
        List<FileDescriptor> nonReadableDirs = this.m_dirListing.getNonReadableDirs();
        List<FileDescriptor> nonReadableFiles = this.m_dirListing.getNonReadableFiles();
        if (!nonReadableDirs.isEmpty() || !nonReadableFiles.isEmpty()) {
            StringBuilder commaSeparatedListOfDirs = new StringBuilder();
            int numOfNonReadableDirs = nonReadableDirs.size();
            if (numOfNonReadableDirs > 0) {
                commaSeparatedListOfDirs.append(nonReadableDirs.get(0).getPath());
                for (int i = 1; i < numOfNonReadableDirs; ++i) {
                    commaSeparatedListOfDirs.append(", ");
                    commaSeparatedListOfDirs.append(nonReadableDirs.get(i).getPath());
                }
            }
            StringBuilder commaSeparatedListOfFiles = new StringBuilder();
            int numOfNonReadableFiles = nonReadableFiles.size();
            if (numOfNonReadableFiles > 0) {
                commaSeparatedListOfFiles.append(nonReadableFiles.get(0).getPath());
                for (int i = 1; i < numOfNonReadableFiles; ++i) {
                    commaSeparatedListOfFiles.append(", ");
                    commaSeparatedListOfFiles.append(nonReadableFiles.get(i).getPath());
                }
            }
            throw new RACTransErrorException((MessageKey)PrCfMsgID.NON_READABLE_CONTENTS, commaSeparatedListOfDirs.toString(), commaSeparatedListOfFiles.toString());
        }
        this.m_dirListing.concatenateAllContents();
    }

    protected long getEffectiveTotalFileSize() {
        return this.m_effectiveTotalFileSize;
    }

    protected int createDataPlanFiles(String tempDir, boolean useMttrans) throws RACTransErrorException {
        Trace.out("In createDataPlanFiles with tempDir-->" + tempDir);
        List<FileDescriptor>[] threadWorkloads_filesOnly = this.distributeWorkload_filesOnly();
        int numOfFiles = threadWorkloads_filesOnly.length;
        if (numOfFiles == 0) {
            threadWorkloads_filesOnly = new List[]{new ArrayList<FileDescriptor>()};
        }
        if (tempDir == null || tempDir.trim().length() == 0) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.INVALID_PATHNAME, tempDir);
        }
        if (!new File(tempDir = tempDir.trim()).isDirectory()) {
            Trace.out(tempDir + " is not a directory");
            Trace.out("Path:" + new File(tempDir).getPath());
            throw new RACTransErrorException((MessageKey)PrCfMsgID.NOT_A_DIR, tempDir);
        }
        if (!tempDir.endsWith(File.separator)) {
            tempDir = tempDir + File.separator;
        }
        List<FileDescriptor> dirList = this.m_dirListing.getAllDirs();
        FileDescriptor[][] threadWorkloads_symlinksOnly = this.distributeWorkload_symlinksOnly(threadWorkloads_filesOnly.length);
        TreeMap<FileDescriptor, List<FileDescriptor>> dirDependencyMap = new TreeMap<FileDescriptor, List<FileDescriptor>>();
        Set parentDirs = null;
        ComparatorImpl comparator = new ComparatorImpl();
        for (int i = 0; i < threadWorkloads_filesOnly.length; ++i) {
            String relativePathname;
            Object currDir;
            ArrayList<String> planFileContents = null;
            ArrayList<String> includeListFileContents = null;
            if (useMttrans) {
                planFileContents = new ArrayList<String>();
            } else {
                includeListFileContents = new ArrayList<String>();
            }
            String topLevelDirPath = this.m_dirListing.getTopDirPath();
            this.updateDirDependencies(dirDependencyMap, threadWorkloads_symlinksOnly[i]);
            this.updateDirDependencies(dirDependencyMap, threadWorkloads_filesOnly[i].toArray(new FileDescriptor[0]));
            parentDirs = dirDependencyMap.keySet();
            TreeSet<FileDescriptor> requiredDirs = new TreeSet<FileDescriptor>(comparator);
            FileDescriptor topLevelDir = null;
            try {
                topLevelDir = new FileDescriptor(this.m_dirListing.getTopDirPath());
            }
            catch (FileNotFoundException fnfe) {
                Trace.out("\"" + this.m_dirListing.getTopDirPath() + "\" must exist as it is the top level directory. " + "If it didn't there would be no directory listing at " + "all.");
                throw new RACTransErrorException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre014");
            }
            String topLevelDirCanonicalPath = "";
            try {
                topLevelDirCanonicalPath = topLevelDir.getCanonicalPath();
            }
            catch (IOException ignored) {
                Trace.out("Cannot determine the canonical path for top-level directory '" + topLevelDir.getPath() + "'");
            }
            Iterator ignored = parentDirs.iterator();
            while (ignored.hasNext()) {
                for (currDir = (FileDescriptor)ignored.next(); !(currDir == null || ((FileDescriptor)currDir).equals(topLevelDir) || ((FileDescriptor)currDir).getPath().equals(topLevelDirCanonicalPath) || requiredDirs.contains(currDir)); currDir = ((FileDescriptor)currDir).getParentDir()) {
                    requiredDirs.add((FileDescriptor)currDir);
                }
            }
            dirList.removeAll(requiredDirs);
            if (i == threadWorkloads_filesOnly.length - 1) {
                for (FileDescriptor emptyDir : dirList) {
                    relativePathname = emptyDir.getRelativePath(topLevelDirPath);
                    Trace.out("  EMPTY DIR  -->" + relativePathname);
                    requiredDirs.add(emptyDir);
                    if (useMttrans) continue;
                    includeListFileContents.add(relativePathname + MultiTierTransferConstants.NEW_LINE);
                }
            }
            if (useMttrans) {
                planFileContents.add(MultiTierTransferConstants.DATA_PLAN_FILE_KEYNOTE);
                planFileContents.add(MultiTierTransferConstants.NEW_LINE);
                for (FileDescriptor currDir2 : requiredDirs) {
                    planFileContents.add(this.buildMkdirCmd(currDir2, topLevelDirPath) + MultiTierTransferConstants.NEW_LINE);
                }
                planFileContents.add("BARRIER_1" + MultiTierTransferConstants.NEW_LINE);
            }
            currDir = threadWorkloads_filesOnly[i].iterator();
            while (currDir.hasNext()) {
                FileDescriptor currFile = currDir.next();
                relativePathname = currFile.getRelativePath(topLevelDirPath);
                if (useMttrans) {
                    planFileContents.add(this.buildWrfileCmd(currFile, topLevelDirPath) + MultiTierTransferConstants.NEW_LINE);
                    continue;
                }
                includeListFileContents.add(relativePathname + MultiTierTransferConstants.NEW_LINE);
            }
            if (useMttrans) {
                planFileContents.add("BARRIER_2" + MultiTierTransferConstants.NEW_LINE);
            }
            if (threadWorkloads_symlinksOnly[i] != null) {
                for (int j = 0; j < threadWorkloads_symlinksOnly[i].length; ++j) {
                    FileDescriptor currLink = threadWorkloads_symlinksOnly[i][j];
                    relativePathname = currLink.getRelativePath(topLevelDirPath);
                    if (useMttrans) {
                        planFileContents.add(this.buildMklinkCmd(currLink, topLevelDirPath) + MultiTierTransferConstants.NEW_LINE);
                        continue;
                    }
                    includeListFileContents.add(relativePathname + MultiTierTransferConstants.NEW_LINE);
                }
            }
            if (useMttrans) {
                String dataPlanPathname = tempDir + "mttdata" + i + ".plan";
                Trace.out("Creating data plan file " + dataPlanPathname);
                FileHandler.writeFile(dataPlanPathname, planFileContents, false);
                continue;
            }
            String includeFilePathname = tempDir + "rapidtrans-include" + i;
            Trace.out("Creating include-list file " + includeFilePathname);
            FileHandler.writeFile(includeFilePathname, includeListFileContents, false);
        }
        return threadWorkloads_filesOnly.length;
    }

    private List<FileDescriptor>[] distributeWorkload_filesOnly() {
        DirectoryMap directoryMap = this.m_dirListing.getDirMapping();
        this.m_effectiveTotalFileSize = directoryMap.getTotalFilesize() + directoryMap.getTotalNumberOfFiles() * 629145L;
        int maxNumOfThreadsPerNode = this.getMaxNumberOfThreadsPerChildNode(this.m_effectiveTotalFileSize);
        long maxDataSizePerThread = this.m_effectiveTotalFileSize / (long)maxNumOfThreadsPerNode;
        String statsInfo = "Statistics:" + MultiTierTransferConstants.NEW_LINE + "    Maximum number of threads per node = " + maxNumOfThreadsPerNode + MultiTierTransferConstants.NEW_LINE + "    Effective total size = " + this.m_effectiveTotalFileSize + " bytes" + MultiTierTransferConstants.NEW_LINE + "    Maximum data size per thread = " + maxDataSizePerThread + " bytes";
        SortedMap<Long, List<FileDescriptor>> filesizeMap = this.m_dirListing.getDirMapping().getFilesizeMap();
        ArrayList threadWorkloads_filesOnly = new ArrayList(maxNumOfThreadsPerNode);
        Set<Long> filesizeList = filesizeMap.keySet();
        Iterator<Long> filesizeListItr = filesizeList.iterator();
        boolean currFilesizeProcessed = true;
        FileDescriptor[] fileList = null;
        int nextFileIndex = -1;
        for (int i = 0; i < maxNumOfThreadsPerNode && (filesizeListItr.hasNext() || !currFilesizeProcessed); ++i) {
            ArrayList<FileDescriptor> currThreadWorkload_filesOnly = new ArrayList<FileDescriptor>();
            long totalFilesizeSoFar = 0L;
            long actualThreadFilesize = 0L;
            boolean noFileAddedForCurrThread = true;
            while (totalFilesizeSoFar < maxDataSizePerThread || i == maxNumOfThreadsPerNode - 1) {
                if (currFilesizeProcessed && filesizeListItr.hasNext()) {
                    Long currFilesize = filesizeListItr.next();
                    fileList = ((List)filesizeMap.get(currFilesize)).toArray(new FileDescriptor[0]);
                    nextFileIndex = 0;
                    currFilesizeProcessed = false;
                }
                if (nextFileIndex < fileList.length) {
                    if ((totalFilesizeSoFar = totalFilesizeSoFar + fileList[nextFileIndex].length() + 629145L) > maxDataSizePerThread && i != maxNumOfThreadsPerNode - 1 && !noFileAddedForCurrThread) break;
                    currThreadWorkload_filesOnly.add(fileList[nextFileIndex]);
                    actualThreadFilesize = totalFilesizeSoFar;
                    noFileAddedForCurrThread = false;
                    boolean bl = currFilesizeProcessed = ++nextFileIndex == fileList.length;
                }
                if (i != maxNumOfThreadsPerNode - 1 || !currFilesizeProcessed || filesizeListItr.hasNext()) continue;
            }
            threadWorkloads_filesOnly.add(currThreadWorkload_filesOnly);
            statsInfo = statsInfo + MultiTierTransferConstants.NEW_LINE + "    Total file size (thread-" + i + ") = " + String.valueOf(actualThreadFilesize) + " bytes";
        }
        Trace.out(statsInfo);
        return threadWorkloads_filesOnly.toArray(new List[0]);
    }

    private FileDescriptor[][] distributeWorkload_symlinksOnly(int divisor) throws RACTransErrorException {
        int currProcessedLinks;
        FileDescriptor[][] threadWorkloads_symlinksOnly = new FileDescriptor[divisor][];
        FileDescriptor[] links = this.m_dirListing.getAllLinks().toArray(new FileDescriptor[0]);
        int numOfLinksPerThread = (int)Math.ceil((double)links.length / (double)divisor);
        int remainingLinksToProcess = links.length;
        int startCopyIndexInclusive = 0;
        for (int threadIndex = 0; threadIndex < divisor && remainingLinksToProcess > 0; remainingLinksToProcess -= currProcessedLinks, ++threadIndex) {
            currProcessedLinks = Math.min(remainingLinksToProcess, numOfLinksPerThread);
            int endCopyIndexExclusive = startCopyIndexInclusive + currProcessedLinks;
            FileDescriptor[] currThreadWorkload_symlinksOnly = Arrays.copyOfRange(links, startCopyIndexInclusive, endCopyIndexExclusive);
            threadWorkloads_symlinksOnly[threadIndex] = currThreadWorkload_symlinksOnly;
            startCopyIndexInclusive = endCopyIndexExclusive;
        }
        return threadWorkloads_symlinksOnly;
    }

    private void updateDirDependencies(SortedMap<FileDescriptor, List<FileDescriptor>> dirDependencyMap, FileDescriptor[] contentsToProcess) throws RACTransErrorException {
        if (contentsToProcess != null) {
            for (int i = 0; i < contentsToProcess.length; ++i) {
                FileDescriptor parentDir = contentsToProcess[i].getParentDir();
                ArrayList<FileDescriptor> parentDirDependencyList = (ArrayList<FileDescriptor>)dirDependencyMap.get(parentDir);
                if (parentDirDependencyList == null) {
                    parentDirDependencyList = new ArrayList<FileDescriptor>();
                }
                parentDirDependencyList.add(contentsToProcess[i]);
                dirDependencyMap.put(parentDir, parentDirDependencyList);
            }
        }
    }

    private int getMaxNumberOfThreadsPerChildNode(long totalSize) {
        int maxNumOfThreadsPerChildNode = totalSize < 0x40000000L ? (totalSize < 0x6400000L ? 1 : (totalSize < 0x19000000L ? 2 : 3)) : 4 + (int)((totalSize - 0x40000000L) / 0x40000000L);
        if (maxNumOfThreadsPerChildNode > 6) {
            Trace.out("The number of threads per node (" + maxNumOfThreadsPerChildNode + ") exceeds the maximum limit (" + 6 + "). Hence the " + "maximum limit is returned as max number of threads.");
            maxNumOfThreadsPerChildNode = 6;
        }
        return maxNumOfThreadsPerChildNode;
    }

    private String buildMkdirCmd(FileDescriptor dir, String topLevelDirPath) {
        String relativePathname = dir.getRelativePath(topLevelDirPath);
        return String.format("<5>mkdir<%d>%s[m%s][u%d][g%d]", relativePathname.getBytes().length, relativePathname, dir.getPermissions(), dir.getOwnerID(), dir.getGroupID());
    }

    private String buildWrfileCmd(FileDescriptor file, String topLevelDirPath) {
        String relativePathname = file.getRelativePath(topLevelDirPath);
        return String.format("<6>wrfile<%d>%s[m%s][u%d][g%d][%d]", relativePathname.getBytes().length, relativePathname, file.getPermissions(), file.getOwnerID(), file.getGroupID(), file.length());
    }

    private String buildMklinkCmd(FileDescriptor symlink, String topLevelDirPath) {
        int prependTopLevelDirValue = 0;
        String linkDestination = symlink.getLinkDestination();
        if (linkDestination.startsWith(topLevelDirPath)) {
            linkDestination = linkDestination.substring(topLevelDirPath.length()).substring(1);
            prependTopLevelDirValue = 1;
        }
        String relativePathname = symlink.getRelativePath(topLevelDirPath);
        return String.format("<6>mklink<%d>%s<%d>%s[m%s][u%d][g%d][s%d]", linkDestination.getBytes().length, linkDestination, relativePathname.getBytes().length, relativePathname, symlink.getPermissions(), symlink.getOwnerID(), symlink.getGroupID(), prependTopLevelDirValue);
    }

    private static class ComparatorImpl
    implements Comparator<FileDescriptor> {
        private ComparatorImpl() {
        }

        @Override
        public int compare(FileDescriptor file1, FileDescriptor file2) {
            String pathname1 = file1.getAbsolutePath();
            StringTokenizer pathnameTokenizer1 = new StringTokenizer(pathname1, File.separator);
            String pathname2 = file2.getAbsolutePath();
            StringTokenizer pathnameTokenizer2 = new StringTokenizer(pathname2, File.separator);
            if (pathnameTokenizer1.countTokens() > pathnameTokenizer2.countTokens()) {
                return 1;
            }
            if (pathnameTokenizer1.countTokens() < pathnameTokenizer2.countTokens()) {
                return -1;
            }
            while (pathnameTokenizer1.hasMoreTokens()) {
                String currTokenFile2;
                String currTokenFile1 = pathnameTokenizer1.nextToken().trim();
                int compRes = currTokenFile1.compareTo(currTokenFile2 = pathnameTokenizer2.nextToken().trim());
                if (compRes > 0) {
                    return 1;
                }
                if (compRes >= 0) continue;
                return -1;
            }
            return 0;
        }
    }
}

