/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.util.List;
import oracle.cluster.deployment.ractrans.IllegalArgException;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public class TransferNode {
    private final int m_nodeID;
    private final String m_nodeName;
    private final String m_sourceDir;
    private final String m_destDir;
    private final List<Integer> m_childNodeIDs;

    protected TransferNode(int nodeID, String nodeName, String sourceDir, String destDir, List<Integer> childNodeIDs) throws IllegalArgException {
        if (nodeName == null) {
            throw new IllegalArgException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre015");
        }
        if (destDir == null) {
            throw new IllegalArgException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre016");
        }
        this.m_nodeID = nodeID;
        this.m_nodeName = nodeName;
        this.m_sourceDir = sourceDir;
        this.m_destDir = destDir;
        this.m_childNodeIDs = childNodeIDs == null || childNodeIDs.isEmpty() ? null : childNodeIDs;
    }

    public String toString() {
        StringBuilder strRepresentation = new StringBuilder();
        if (this.isJavaNode()) {
            strRepresentation.append("Java Node");
        } else if (this.isLeafNode()) {
            strRepresentation.append("Leaf Node");
        } else {
            strRepresentation.append("Intermediate Node");
        }
        strRepresentation.append(" -- ID: " + this.m_nodeID);
        strRepresentation.append(" -- Name : " + this.m_nodeName);
        if (!this.isLeafNode()) {
            strRepresentation.append(" -- Source Dir : " + this.m_sourceDir);
        }
        if (this.m_destDir != null) {
            strRepresentation.append(" -- Dest Dir : " + this.m_destDir);
        }
        if (!this.isLeafNode()) {
            strRepresentation.append(" -- Child Nodes: " + this.m_childNodeIDs);
        }
        return strRepresentation.toString();
    }

    protected boolean isJavaNode() {
        return this.m_nodeID == 0;
    }

    protected boolean isLeafNode() {
        return this.m_childNodeIDs == null;
    }

    protected int getID() {
        return this.m_nodeID;
    }

    protected String getName() {
        return this.m_nodeName;
    }

    protected String getSourceDir() {
        return this.m_sourceDir;
    }

    protected String getDestDir() {
        return this.m_destDir;
    }

    protected List<Integer> getChildNodeIDs() {
        return this.m_childNodeIDs;
    }
}

