/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.deployment.ractrans.MultiTierTransferConstants;
import oracle.cluster.deployment.ractrans.NodeStatusUpdate;
import oracle.cluster.deployment.ractrans.ReportParseException;
import oracle.cluster.deployment.ractrans.TransferResult;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReportReader {
    protected ReportReader() {
    }

    protected Object readStream(InputStream inStream) throws ReportParseException {
        String inputString = this.convertInputStreamToString(inStream);
        inputString = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + inputString;
        inStream = new ByteArrayInputStream(inputString.getBytes(Charset.forName("UTF-8")));
        if (MultiTierTransferConstants.DEBUG_MODE) {
            Trace.out("Input stream as String:" + MultiTierTransferConstants.NEW_LINE + inputString);
            String inputHex = this.getHexStringFromStream(inStream, 10);
            Trace.out("Input stream as Hex:" + MultiTierTransferConstants.NEW_LINE + inputHex);
        }
        try {
            Document doc = this.getNormalizedDocument(inStream);
            Element rootElement = doc.getDocumentElement();
            String rootNodeName = rootElement.getNodeName();
            MultiTierTransferConstants.NodeStateTag nodeStateXMLTag = MultiTierTransferConstants.NodeStateTag.getNodeStateTag(rootNodeName);
            if (nodeStateXMLTag != null && nodeStateXMLTag == MultiTierTransferConstants.NodeStateTag.STATE_REPORT) {
                Trace.out("The input to parse is a node state update");
                return this.readNodeStateUpdate(rootElement);
            }
            MultiTierTransferConstants.TransferResultTag transferResultTag = MultiTierTransferConstants.TransferResultTag.getTransferResultTag(rootNodeName);
            if (transferResultTag != null && transferResultTag == MultiTierTransferConstants.TransferResultTag.RESULT) {
                Trace.out("The input to parse is a transfer result report");
                return this.readTransferReport(rootElement);
            }
            MultiTierTransferConstants.NodeStatusUpdateTag nodeStatusUpdateXMLTag = MultiTierTransferConstants.NodeStatusUpdateTag.getNodeStatusUpdateTag(rootNodeName);
            if (nodeStatusUpdateXMLTag != null && nodeStatusUpdateXMLTag == MultiTierTransferConstants.NodeStatusUpdateTag.UPDATE) {
                Trace.out("The input to parse is a transfer error update");
                return this.readTransferErrorUpdate(rootElement);
            }
            throw new ReportParseException("Root node <" + rootNodeName + "> is not a node state update, a " + "transfer error update or a " + "transfer result node");
        }
        catch (ReportParseException rpe) {
            Trace.out("Error parsing the following input stream:" + MultiTierTransferConstants.NEW_LINE + inputString);
            throw rpe;
        }
    }

    private TransferResult readTransferReport(Element rootElement) throws ReportParseException {
        NodeList sourceNodeIDs = rootElement.getElementsByTagName(MultiTierTransferConstants.NodeStatusUpdateTag.SOURCE_NODE.toString());
        if (sourceNodeIDs.getLength() != 1) {
            throw new ReportParseException("Expected a single <" + MultiTierTransferConstants.NodeStatusUpdateTag.SOURCE_NODE.toString() + ">...</" + MultiTierTransferConstants.NodeStatusUpdateTag.SOURCE_NODE.toString() + "> instead of " + sourceNodeIDs.getLength());
        }
        String sourceNodeIDStr = sourceNodeIDs.item(0).getTextContent();
        Trace.out(MultiTierTransferConstants.NodeStatusUpdateTag.SOURCE_NODE.toString() + ": " + sourceNodeIDStr);
        if (!MultiTierTransferConstants.TransferResultTag.getTransferResultTag(MultiTierTransferConstants.NodeStatusUpdateTag.SOURCE_NODE.toString()).hasValidValue(sourceNodeIDStr)) {
            throw new ReportParseException("Invalid value for <" + MultiTierTransferConstants.NodeStatusUpdateTag.SOURCE_NODE.toString() + ">: " + sourceNodeIDStr);
        }
        Integer sourceNodeID = Integer.valueOf(sourceNodeIDStr);
        NodeList targetNodeIDs = rootElement.getElementsByTagName(MultiTierTransferConstants.NodeStatusUpdateTag.TARGET_NODE.toString());
        if (targetNodeIDs.getLength() != 1) {
            throw new ReportParseException("Expected a single <" + MultiTierTransferConstants.NodeStatusUpdateTag.TARGET_NODE.toString() + ">...</" + MultiTierTransferConstants.NodeStatusUpdateTag.TARGET_NODE.toString() + "> instead of " + targetNodeIDs.getLength());
        }
        String targetNodeIDStr = targetNodeIDs.item(0).getTextContent();
        Trace.out(MultiTierTransferConstants.NodeStatusUpdateTag.TARGET_NODE.toString() + ": " + targetNodeIDStr);
        if (!MultiTierTransferConstants.TransferResultTag.getTransferResultTag(MultiTierTransferConstants.NodeStatusUpdateTag.TARGET_NODE.toString()).hasValidValue(targetNodeIDStr)) {
            throw new ReportParseException("Invalid value for <" + MultiTierTransferConstants.NodeStatusUpdateTag.TARGET_NODE.toString() + ">: " + targetNodeIDStr);
        }
        Integer targetNodeID = Integer.valueOf(targetNodeIDStr);
        NodeList statusCodes = rootElement.getElementsByTagName(MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString());
        if (statusCodes.getLength() != 1) {
            throw new ReportParseException("Expected a single <" + MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString() + ">...</" + MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString() + "> instead of " + statusCodes.getLength());
        }
        String statusCodeStr = statusCodes.item(0).getTextContent();
        Trace.out(MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString() + ": " + statusCodeStr);
        if (!MultiTierTransferConstants.TransferResultTag.getTransferResultTag(MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString()).hasValidValue(statusCodeStr)) {
            throw new ReportParseException("Invalid value for <" + MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString() + ">: " + statusCodeStr);
        }
        Integer statusCode = Integer.valueOf(statusCodeStr);
        TransferResult.TransferStatus transferStatus = TransferResult.TransferStatus.getTransferStatus(statusCode);
        Trace.out("Transfer status (for " + MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString() + " = " + statusCode + "): " + (Object)((Object)transferStatus));
        return new TransferResult(sourceNodeID, targetNodeID, transferStatus);
    }

    private NodeStatusUpdate readTransferErrorUpdate(Element rootElement) throws ReportParseException {
        NodeList sourceNodeIDs = rootElement.getElementsByTagName(MultiTierTransferConstants.NodeStatusUpdateTag.SOURCE_NODE.toString());
        if (sourceNodeIDs.getLength() != 1) {
            throw new ReportParseException("Expected a single <" + MultiTierTransferConstants.NodeStatusUpdateTag.SOURCE_NODE.toString() + ">...</" + MultiTierTransferConstants.NodeStatusUpdateTag.SOURCE_NODE.toString() + "> instead of " + sourceNodeIDs.getLength());
        }
        String sourceNodeIDStr = sourceNodeIDs.item(0).getTextContent();
        Trace.out(MultiTierTransferConstants.NodeStatusUpdateTag.SOURCE_NODE.toString() + ": " + sourceNodeIDStr);
        if (!MultiTierTransferConstants.NodeStatusUpdateTag.getNodeStatusUpdateTag(MultiTierTransferConstants.NodeStatusUpdateTag.SOURCE_NODE.toString()).hasValidValue(sourceNodeIDStr)) {
            throw new ReportParseException("Invalid value for <" + MultiTierTransferConstants.NodeStatusUpdateTag.SOURCE_NODE.toString() + ">: " + sourceNodeIDStr);
        }
        Integer sourceNodeID = Integer.valueOf(sourceNodeIDStr);
        NodeList targetNodeIDs = rootElement.getElementsByTagName(MultiTierTransferConstants.NodeStatusUpdateTag.TARGET_NODE.toString());
        if (targetNodeIDs.getLength() != 1) {
            throw new ReportParseException("Expected a single <" + MultiTierTransferConstants.NodeStatusUpdateTag.TARGET_NODE.toString() + ">...</" + MultiTierTransferConstants.NodeStatusUpdateTag.TARGET_NODE.toString() + "> instead of " + targetNodeIDs.getLength());
        }
        String targetNodeIDStr = targetNodeIDs.item(0).getTextContent();
        Trace.out(MultiTierTransferConstants.NodeStatusUpdateTag.TARGET_NODE.toString() + ": " + targetNodeIDStr);
        if (!MultiTierTransferConstants.NodeStatusUpdateTag.getNodeStatusUpdateTag(MultiTierTransferConstants.NodeStatusUpdateTag.TARGET_NODE.toString()).hasValidValue(targetNodeIDStr)) {
            throw new ReportParseException("Invalid value for <" + MultiTierTransferConstants.NodeStatusUpdateTag.TARGET_NODE.toString() + ">: " + targetNodeIDStr);
        }
        Integer targetNodeID = Integer.valueOf(targetNodeIDStr);
        NodeList statusCodes = rootElement.getElementsByTagName(MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString());
        if (statusCodes.getLength() != 1) {
            throw new ReportParseException("Expected a single <" + MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString() + ">...</" + MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString() + "> instead of " + statusCodes.getLength());
        }
        String statusCodeStr = statusCodes.item(0).getTextContent();
        Trace.out(MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString() + ": " + statusCodeStr);
        if (!MultiTierTransferConstants.NodeStatusUpdateTag.getNodeStatusUpdateTag(MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString()).hasValidValue(statusCodeStr)) {
            throw new ReportParseException("Invalid value for <" + MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString() + ">: " + statusCodeStr);
        }
        Integer statusCode = Integer.valueOf(statusCodeStr);
        TransferResult.TransferStatus errorCriticality = TransferResult.TransferStatus.getTransferStatus(statusCode);
        Trace.out("Error ciritcality (for " + MultiTierTransferConstants.NodeStatusUpdateTag.STATUS.toString() + " = " + statusCode + "): " + (Object)((Object)errorCriticality));
        NodeList listOfFailureDetails = rootElement.getElementsByTagName(MultiTierTransferConstants.NodeStatusUpdateTag.FAILURE_DETAILS.toString());
        if (listOfFailureDetails.getLength() != 1) {
            Trace.out("Transfer error update. Therefore, expected a single <" + MultiTierTransferConstants.NodeStatusUpdateTag.FAILURE_DETAILS.toString() + ">...</" + MultiTierTransferConstants.NodeStatusUpdateTag.FAILURE_DETAILS.toString() + "> instead of " + listOfFailureDetails.getLength());
            Object[] args = new Object[]{sourceNodeIDStr, targetNodeIDStr};
            String errorMsg = MessageBundle.getMessage(PrCfMsgID.GENERIC_TRANSFER_ERROR, true, args);
            return new NodeStatusUpdate(sourceNodeID, targetNodeID, errorMsg, NodeStatusUpdate.ErrorType.GENERAL_ERROR, null, errorCriticality);
        }
        Node failureDetailsNode = listOfFailureDetails.item(0);
        if (failureDetailsNode.getNodeType() != 1) {
            throw new ReportParseException("<" + MultiTierTransferConstants.NodeStatusUpdateTag.FAILURE_DETAILS.toString() + ">...</" + MultiTierTransferConstants.NodeStatusUpdateTag.FAILURE_DETAILS.toString() + "> is not an Element node");
        }
        Element failureDetails = (Element)failureDetailsNode;
        NodeList failureDetailsChildNodes = failureDetails.getChildNodes();
        int numOfChildNodes = failureDetailsChildNodes.getLength();
        String errorMsg = null;
        String pathname = null;
        NodeStatusUpdate.ErrorType errorType = null;
        for (int i = 0; i < numOfChildNodes; ++i) {
            Node childNode = failureDetailsChildNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            String childNodeName = childNode.getNodeName();
            MultiTierTransferConstants.NodeStatusUpdateTag nodeStatusUpdateTag = MultiTierTransferConstants.NodeStatusUpdateTag.getNodeStatusUpdateTag(childNodeName);
            switch (nodeStatusUpdateTag) {
                case ERROR: {
                    errorType = NodeStatusUpdate.ErrorType.GENERAL_ERROR;
                    errorMsg = this.getErrorMessage(childNode);
                    break;
                }
                case DIR: {
                    errorType = NodeStatusUpdate.ErrorType.DIR_ERROR;
                    break;
                }
                case FILE: {
                    errorType = NodeStatusUpdate.ErrorType.FILE_ERROR;
                    break;
                }
                case SYMLINK: {
                    errorType = NodeStatusUpdate.ErrorType.SYMLINK_ERROR;
                    break;
                }
                default: {
                    throw new ReportParseException("Unexpected child-node <" + childNodeName + "> under <" + MultiTierTransferConstants.NodeStatusUpdateTag.FAILURE_DETAILS.toString() + ">");
                }
            }
            if (errorType == NodeStatusUpdate.ErrorType.DIR_ERROR || errorType == NodeStatusUpdate.ErrorType.FILE_ERROR || errorType == NodeStatusUpdate.ErrorType.SYMLINK_ERROR) {
                SortedMap<String, String> errorMap = this.getPathRelatedErrorMap(childNode);
                pathname = errorMap.firstKey();
                errorMsg = (String)errorMap.get(pathname);
            }
            return new NodeStatusUpdate(sourceNodeID, targetNodeID, errorMsg, errorType, pathname, errorCriticality);
        }
        Trace.out("Transfer error update. Therefore, expected a child node under <" + MultiTierTransferConstants.NodeStatusUpdateTag.FAILURE_DETAILS.toString() + ">...</" + MultiTierTransferConstants.NodeStatusUpdateTag.FAILURE_DETAILS.toString() + ">");
        Object[] args = new Object[]{sourceNodeIDStr, targetNodeIDStr};
        errorMsg = MessageBundle.getMessage(PrCfMsgID.GENERIC_TRANSFER_ERROR, true, args);
        return new NodeStatusUpdate(sourceNodeID, targetNodeID, errorMsg, NodeStatusUpdate.ErrorType.GENERAL_ERROR, null, errorCriticality);
    }

    private NodeStatusUpdate readNodeStateUpdate(Element rootElement) throws ReportParseException {
        NodeList nodeIDs = rootElement.getElementsByTagName(MultiTierTransferConstants.NodeStateTag.NODE.toString());
        if (nodeIDs.getLength() != 1) {
            throw new ReportParseException("Expected a single <" + MultiTierTransferConstants.NodeStateTag.NODE.toString() + ">...</" + MultiTierTransferConstants.NodeStateTag.NODE.toString() + "> instead of " + nodeIDs.getLength());
        }
        String nodeIDStr = nodeIDs.item(0).getTextContent();
        Trace.out(MultiTierTransferConstants.NodeStateTag.NODE.toString() + ": " + nodeIDStr);
        if (!MultiTierTransferConstants.NodeStateTag.getNodeStateTag(MultiTierTransferConstants.NodeStateTag.NODE.toString()).hasValidValue(nodeIDStr)) {
            throw new ReportParseException("Invalid value for <" + MultiTierTransferConstants.NodeStateTag.NODE.toString() + ">: " + nodeIDStr);
        }
        Integer nodeID = Integer.valueOf(nodeIDStr);
        NodeList stateCodes = rootElement.getElementsByTagName(MultiTierTransferConstants.NodeStateTag.STATE_CODE.toString());
        if (stateCodes.getLength() != 1) {
            throw new ReportParseException("Expected a single <" + MultiTierTransferConstants.NodeStateTag.STATE_CODE.toString() + ">...</" + MultiTierTransferConstants.NodeStateTag.STATE_CODE.toString() + "> instead of " + stateCodes.getLength());
        }
        String stateCodeStr = stateCodes.item(0).getTextContent();
        Trace.out(MultiTierTransferConstants.NodeStateTag.STATE_CODE.toString() + ": " + stateCodeStr);
        if (!MultiTierTransferConstants.NodeStateTag.getNodeStateTag(MultiTierTransferConstants.NodeStateTag.STATE_CODE.toString()).hasValidValue(stateCodeStr)) {
            throw new ReportParseException("Invalid value for <" + MultiTierTransferConstants.NodeStateTag.STATE_CODE.toString() + ">: " + stateCodeStr);
        }
        Integer stateCode = Integer.valueOf(stateCodeStr);
        NodeStatusUpdate.NodeState nodeState = NodeStatusUpdate.NodeState.getNodeState(stateCode);
        if (nodeState == null) {
            throw new ReportParseException("Malformed node state update : Unknown node state with code: " + stateCode);
        }
        return new NodeStatusUpdate(nodeID, nodeState);
    }

    private Document getNormalizedDocument(InputStream inStream) throws ReportParseException {
        Document doc;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(inStream);
        }
        catch (ParserConfigurationException pce) {
            throw new ReportParseException("Error creating the DocumentBuilder from the input stream. Details: " + MultiTierTransferConstants.NEW_LINE + pce.getMessage());
        }
        catch (IOException ioe) {
            throw new ReportParseException("I/O error. Details: " + MultiTierTransferConstants.NEW_LINE + ioe.getMessage());
        }
        catch (SAXException se) {
            throw new ReportParseException("Parse error. Details: " + MultiTierTransferConstants.NEW_LINE + se.getMessage());
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        doc.getDocumentElement().normalize();
        return doc;
    }

    private SortedMap<String, String> getPathRelatedErrorMap(Node node) throws ReportParseException {
        TreeMap<String, String> errorMap = new TreeMap<String, String>();
        if (node.getNodeType() != 1) {
            throw new ReportParseException("<" + node.getNodeName() + ">...</" + node.getNodeName() + "> is not an Element node");
        }
        Element element = (Element)node;
        NodeList errorPaths = element.getElementsByTagName(MultiTierTransferConstants.NodeStatusUpdateTag.PATH.toString());
        int numOfErrorPaths = errorPaths.getLength();
        if (numOfErrorPaths == 0) {
            throw new ReportParseException("Expected at least one <" + MultiTierTransferConstants.NodeStatusUpdateTag.PATH.toString() + ">...</" + MultiTierTransferConstants.NodeStatusUpdateTag.PATH.toString());
        }
        NodeList errors = element.getElementsByTagName(MultiTierTransferConstants.NodeStatusUpdateTag.ERROR.toString());
        int numOfErrors = errors.getLength();
        if (numOfErrors != numOfErrorPaths) {
            throw new ReportParseException("Expected " + numOfErrorPaths + "<" + MultiTierTransferConstants.NodeStatusUpdateTag.ERROR.toString() + ">...</" + MultiTierTransferConstants.NodeStatusUpdateTag.ERROR.toString() + " instead of " + numOfErrors);
        }
        for (int i = 0; i < numOfErrorPaths; ++i) {
            String pathname = errorPaths.item(i).getTextContent();
            String errorMsg = this.getErrorMessage(errors.item(i));
            errorMap.put(pathname, errorMsg);
        }
        return errorMap;
    }

    private String getErrorMessage(Node errorNode) throws ReportParseException {
        if (errorNode.getNodeType() != 1) {
            throw new ReportParseException("<" + errorNode.getNodeName() + ">...</" + errorNode.getNodeName() + "> is not an Element node");
        }
        Element errorElement = (Element)errorNode;
        NodeList errorCodes = errorElement.getElementsByTagName(MultiTierTransferConstants.NodeStatusUpdateTag.ERROR_CODE.toString());
        if (errorCodes.getLength() != 1) {
            throw new ReportParseException("Expected a single <" + MultiTierTransferConstants.NodeStatusUpdateTag.ERROR_CODE.toString() + ">...</" + MultiTierTransferConstants.NodeStatusUpdateTag.ERROR_CODE.toString() + "> instead of " + errorCodes.getLength());
        }
        String errorName = errorCodes.item(0).getTextContent();
        if (!MultiTierTransferConstants.TransferResultTag.getTransferResultTag(MultiTierTransferConstants.NodeStatusUpdateTag.ERROR_CODE.toString()).hasValidValue(errorName)) {
            throw new ReportParseException("Invalid value for <" + MultiTierTransferConstants.NodeStatusUpdateTag.ERROR_CODE.toString() + ">: " + errorName);
        }
        NodeList errorArguments = errorElement.getElementsByTagName(MultiTierTransferConstants.NodeStatusUpdateTag.ERROR_ARG.toString());
        LinkedList<String> errorArgs = new LinkedList<String>();
        for (int i = 0; i < errorArguments.getLength(); ++i) {
            String errorArg = errorArguments.item(i).getTextContent();
            if (errorArg == null || errorArg.trim().length() == 0) {
                throw new ReportParseException("Invalid value for <" + MultiTierTransferConstants.NodeStatusUpdateTag.ERROR_ARG.toString() + ">: " + errorArg);
            }
            errorArgs.add(errorArg);
        }
        return this.getErrorMessage(errorName, errorArgs);
    }

    private String getErrorMessage(String errorName, List<String> errorArgs) {
        MessageKey msgKey = MultiTierTransferConstants.MSG_LOOKUP.get(errorName);
        if (!errorArgs.isEmpty()) {
            Object[] args = errorArgs.toArray(new String[0]);
            return MessageBundle.getMessage(msgKey, true, args);
        }
        return MultiTierTransferConstants.MSG_BUNDLE.getMessage(msgKey, true);
    }

    private String convertInputStreamToString(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter("\\A");
        String result = scanner.hasNext() ? scanner.next() : "";
        try {
            inputStream.close();
        }
        catch (IOException ioe) {
            Trace.out("An non-critical error happened while closing the input stream. Details:" + MultiTierTransferConstants.NEW_LINE + ioe.getMessage());
        }
        scanner.close();
        return result;
    }

    private String getHexStringFromStream(InputStream inputStream, int numOfColumns) {
        long streamPtr = 0L;
        StringBuilder inputStrAsHex = new StringBuilder();
        try {
            while (inputStream.available() > 0) {
                long col = streamPtr++ % (long)numOfColumns;
                Formatter formatter = new Formatter();
                formatter.format("%02x ", inputStream.read());
                inputStrAsHex.append(formatter.toString());
                formatter.close();
                if (col != (long)(numOfColumns - 1)) continue;
                inputStrAsHex.append(MultiTierTransferConstants.NEW_LINE);
            }
        }
        catch (IOException ioe) {
            Trace.out("Error converting iput stream to HEX. Details:" + MultiTierTransferConstants.NEW_LINE + ioe.getMessage());
        }
        return inputStrAsHex.toString();
    }
}

