/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.deployment.ractrans.ClientHandlerSupervisor;
import oracle.cluster.deployment.ractrans.DirListing;
import oracle.cluster.deployment.ractrans.DirListingConstants;
import oracle.cluster.deployment.ractrans.FileDescriptor;
import oracle.cluster.deployment.ractrans.NodeRegistryModel;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.deployment.ractrans.RACTransWarningException;
import oracle.cluster.deployment.ractrans.RACTransferConstants;
import oracle.cluster.deployment.ractrans.RapidTransfer;
import oracle.cluster.deployment.ractrans.RemoteFileOpException;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class RACTransferCore {
    private NodeRegistryModel m_nodeRegistryModel = new NodeRegistryModel();
    private DirListing m_dirListing;
    private Map<DirListingConstants.PathType, List<String>> m_excludeContentMap;
    private boolean m_excludePathnamesCanBeRegex;
    private Map<DirListingConstants.PathType, List<String>> m_includeContentMap;
    private boolean m_includePathnamesCanBeRegex;
    private ClientHandlerSupervisor m_clientHandlerSupervisor;
    private int m_numOfNodes = 0;
    private long m_startTime;
    private String m_nonReadableContentsMsg;
    private final RapidTransfer m_transferProgressMonitor;

    protected RACTransferCore() {
        this(null);
    }

    protected RACTransferCore(RapidTransfer transferProgressMonitor) {
        this.m_transferProgressMonitor = transferProgressMonitor;
    }

    protected RACTransferConstants.Status setExcludeList(File fileWithExcludePathnames, boolean excludePathnamesCanBeRegex, String topDirPathname) {
        this.m_excludePathnamesCanBeRegex = excludePathnamesCanBeRegex;
        this.m_excludeContentMap = new HashMap<DirListingConstants.PathType, List<String>>();
        if (fileWithExcludePathnames != null && fileWithExcludePathnames.exists()) {
            try {
                this.m_excludeContentMap = DirListing.extractPathnameMapFromFile(fileWithExcludePathnames, topDirPathname);
                return RACTransferConstants.Status.SUCCESSFUL;
            }
            catch (RACTransWarningException we) {
                Trace.out("RACTransferCore: RACTransWarningException encountered while setting the exclude-list file");
                return RACTransferConstants.Status.PARTIALLY_SUCCESSFUL;
            }
        }
        return RACTransferConstants.Status.UNSUCCESSFUL;
    }

    protected void setExcludeMap(Map<DirListingConstants.PathType, List<String>> map2exclude, boolean excludePathnamesCanBeRegex) {
        this.m_excludePathnamesCanBeRegex = excludePathnamesCanBeRegex;
        this.m_excludeContentMap = map2exclude;
    }

    protected RACTransferConstants.Status setIncludeList(File fileWithIncludePathnames, boolean includePathnamesCanBeRegex, String topDirPathname) {
        this.m_includePathnamesCanBeRegex = includePathnamesCanBeRegex;
        this.m_includeContentMap = new HashMap<DirListingConstants.PathType, List<String>>();
        if (fileWithIncludePathnames != null && fileWithIncludePathnames.exists()) {
            try {
                this.m_includeContentMap = DirListing.extractPathnameMapFromFile(fileWithIncludePathnames, topDirPathname);
                return RACTransferConstants.Status.SUCCESSFUL;
            }
            catch (RACTransWarningException we) {
                Trace.out("RACTransferCore: RACTransWarningException encountered while setting the include-list file");
                return RACTransferConstants.Status.PARTIALLY_SUCCESSFUL;
            }
        }
        return RACTransferConstants.Status.UNSUCCESSFUL;
    }

    protected void setIncludeMap(Map<DirListingConstants.PathType, List<String>> map2include, boolean includePathnamesCanBeRegex) {
        this.m_includePathnamesCanBeRegex = includePathnamesCanBeRegex;
        this.m_includeContentMap = map2include;
    }

    protected void createDirListing(FileDescriptor topDir) throws RACTransWarningException, RACTransErrorException {
        this.m_startTime = System.currentTimeMillis();
        this.m_dirListing = new DirListing(topDir, this.m_excludeContentMap, this.m_excludePathnamesCanBeRegex, this.m_includeContentMap, this.m_includePathnamesCanBeRegex, false);
        long totalTime = (System.currentTimeMillis() - this.m_startTime) / 1000L;
        Trace.out("To create the directory listing it takes " + totalTime + " seconds");
        List<FileDescriptor> nonReadableDirs = this.m_dirListing.getNonReadableDirs();
        List<FileDescriptor> nonReadableFiles = this.m_dirListing.getNonReadableFiles();
        this.m_nonReadableContentsMsg = "";
        int numOfNonReadableDirs = nonReadableDirs.size();
        int numOfNonReadableFiles = nonReadableFiles.size();
        if (numOfNonReadableDirs > 0 || numOfNonReadableFiles > 0) {
            StringBuilder nonReadableDirsStrBuilder = new StringBuilder("");
            if (nonReadableDirs.size() > 0) {
                for (int i = 0; i < numOfNonReadableDirs - 1; ++i) {
                    nonReadableDirsStrBuilder.append(i + 1);
                    nonReadableDirsStrBuilder.append(") ");
                    nonReadableDirsStrBuilder.append(nonReadableDirs.get(i).getPath());
                    nonReadableDirsStrBuilder.append(RACTransferConstants.NEW_LINE);
                }
                nonReadableDirsStrBuilder.append(numOfNonReadableDirs);
                nonReadableDirsStrBuilder.append(") ");
                nonReadableDirsStrBuilder.append(nonReadableDirs.get(numOfNonReadableDirs - 1).getPath());
            } else {
                nonReadableDirsStrBuilder.append("-");
            }
            StringBuilder nonReadableFilesStrBuilder = new StringBuilder("");
            if (numOfNonReadableFiles > 0) {
                for (int i = 0; i < numOfNonReadableFiles - 1; ++i) {
                    nonReadableFilesStrBuilder.append(i + 1);
                    nonReadableFilesStrBuilder.append(") ");
                    nonReadableFilesStrBuilder.append(nonReadableFiles.get(i).getPath());
                    nonReadableFilesStrBuilder.append("\n   ");
                }
                nonReadableFilesStrBuilder.append(numOfNonReadableFiles);
                nonReadableFilesStrBuilder.append(") ");
                nonReadableFilesStrBuilder.append(nonReadableFiles.get(numOfNonReadableFiles - 1).getPath());
            } else {
                nonReadableDirsStrBuilder.append("-");
            }
            this.m_nonReadableContentsMsg = MessageBundle.getMessage(PrCfMsgID.NON_READABLE_CONTENTS, true, nonReadableDirsStrBuilder.toString(), nonReadableFilesStrBuilder.toString());
            throw new RACTransWarningException((MessageKey)PrCfMsgID.NON_READABLE_CONTENTS, nonReadableDirsStrBuilder, nonReadableFilesStrBuilder);
        }
    }

    protected void saveDirListingToFile(File filename) throws RACTransWarningException {
        String dirListing = this.m_dirListing.getListing();
        try {
            boolean append = false;
            FileWriter fileWriter = new FileWriter(filename, append);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(dirListing);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException ioe) {
            throw new RACTransWarningException((MessageKey)PrCfMsgID.FILESAVE_DIR_LISTING_PROBLEM, filename.getName(), ioe.getMessage());
        }
    }

    protected void connectToRemoteNodes(String[] remoteNodeNames, int[] remoteNodePorts) throws RACTransErrorException {
        if (remoteNodeNames.length != remoteNodePorts.length) {
            Trace.out("RAC Transfer cannot proceed because the remote node names do not match the remote node ports.");
            throw new RACTransErrorException((MessageKey)PrCfMsgID.MISSMATCH_NODE_NAMES_AND_PORTS, true);
        }
        if (remoteNodeNames.length == 0) {
            Trace.out("RAC Transfer cannot proceed because the list of remote nodes is empty.");
            throw new RACTransErrorException((MessageKey)PrCfMsgID.EMPTY_LIST_OF_REMOTE_NODES, true);
        }
        ArrayList<InetAddress> hostList = new ArrayList<InetAddress>();
        ArrayList<Integer> portList = new ArrayList<Integer>();
        ArrayList<String> nodeNamesList = new ArrayList<String>();
        InetAddress curr_inetAddr = null;
        for (int i = 0; i < remoteNodeNames.length; ++i) {
            boolean skipCurrNode = false;
            try {
                curr_inetAddr = InetAddress.getByName(remoteNodeNames[i]);
            }
            catch (UnknownHostException uhe) {
                Trace.out("\"" + remoteNodeNames[i] + "\" is an invalid IP address or host name.");
                skipCurrNode = true;
            }
            if (skipCurrNode) continue;
            hostList.add(curr_inetAddr);
            portList.add(remoteNodePorts[i]);
            nodeNamesList.add(remoteNodeNames[i]);
            ++this.m_numOfNodes;
        }
        if (this.m_numOfNodes == 0) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.NO_REMOTE_NODE, true);
        }
        this.m_nodeRegistryModel.initRegistry(this.m_numOfNodes);
        int unsuccessfulConnections = 0;
        if (this.m_numOfNodes > 0) {
            this.m_clientHandlerSupervisor = new ClientHandlerSupervisor(this.m_transferProgressMonitor, this.m_nodeRegistryModel, this.m_numOfNodes, this.m_nonReadableContentsMsg);
            for (int i = 0; i < this.m_numOfNodes; ++i) {
                try {
                    this.m_clientHandlerSupervisor.connectToServer((InetAddress)hostList.get(i), (Integer)portList.get(i), (String)nodeNamesList.get(i));
                    continue;
                }
                catch (RACTransWarningException connectionRefused) {
                    ++unsuccessfulConnections;
                    Trace.out("Connection to host/IP address:" + ((InetAddress)hostList.get(i)).getHostAddress() + " -- port:" + portList.get(i) + " refused.");
                }
            }
        }
        if (unsuccessfulConnections == this.m_numOfNodes) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.NO_REMOTE_NODE_LEFT_AFTER_CONNECTION_ATTEMPTS, true);
        }
        try {
            this.m_clientHandlerSupervisor.getAllConnectionsBarrierSemaphore().acquire();
        }
        catch (InterruptedException ie) {
            Trace.out("Unexpected exception." + RACTransferConstants.NEW_LINE + "Details: " + ie.getMessage());
        }
        int lastNumberOfNodes = this.m_numOfNodes;
        this.m_numOfNodes -= unsuccessfulConnections;
        this.m_clientHandlerSupervisor.setNumOfNodes(this.m_numOfNodes);
        this.m_nodeRegistryModel.updateNumOfNodes(this.m_clientHandlerSupervisor, lastNumberOfNodes, this.m_numOfNodes);
    }

    protected void sendDummyStructureToNodes(String[] remoteNodeDestDir) throws RACTransErrorException {
        this.m_startTime = System.currentTimeMillis();
        this.m_dirListing.concatenateAllContents();
        this.m_clientHandlerSupervisor.broadcastCommand(this.m_dirListing, "mkdir", remoteNodeDestDir);
        this.m_clientHandlerSupervisor.broadcastCommand(this.m_dirListing, "mklink", remoteNodeDestDir);
        long totalTime = (System.currentTimeMillis() - this.m_startTime) / 1000L;
        Trace.out("To send the commands to the remote nodes and execute them it takes " + totalTime + " seconds");
    }

    protected void broadcastFiles() {
        this.m_startTime = System.currentTimeMillis();
        List<FileDescriptor> files2send = this.m_dirListing.getAllFiles();
        String topDirPath = this.m_dirListing.getTopDirPath();
        this.m_clientHandlerSupervisor.broadcastData(files2send, topDirPath);
        long totalTime = (System.currentTimeMillis() - this.m_startTime) / 1000L;
        Trace.out("To send the actual data (size: " + this.m_dirListing.getTotalFilesize() + " bytes) to the remote nodes takes " + totalTime + " seconds");
    }

    protected void checkForTransferErrors() throws RemoteFileOpException {
        this.m_clientHandlerSupervisor.checkForErrors();
    }

    protected void threadCleanup() {
        this.m_clientHandlerSupervisor.threadCleanup();
    }
}

