/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.deployment.ractrans.MultiTierTransferConstants;
import oracle.cluster.deployment.ractrans.TransferResult;

public class NodeStatusUpdate {
    private final UpdateType m_updateType;
    private Integer m_sourceNodeID;
    private final Integer m_targetNodeID;
    private final List<String> m_errors = new ArrayList<String>();
    private final List<TransferResult.TransferStatus> m_errorCriticalities = new ArrayList<TransferResult.TransferStatus>();
    private final List<Long> m_errorTimestamps = new ArrayList<Long>();
    private NodeState m_nodeState;
    private ErrorType m_errorType;
    private String m_pathname;

    public NodeStatusUpdate(int targetNodeID, NodeState nodeState) {
        this.m_updateType = UpdateType.STATE;
        this.m_sourceNodeID = null;
        this.m_targetNodeID = targetNodeID;
        this.m_nodeState = nodeState;
        this.m_errorType = null;
        this.m_pathname = null;
    }

    public NodeStatusUpdate(int sourceNodeID, int targetNodeID, String errorMsg, ErrorType errorType, String pathname, TransferResult.TransferStatus errorCriticality) {
        this.m_updateType = UpdateType.ERROR;
        this.m_sourceNodeID = sourceNodeID;
        this.m_targetNodeID = targetNodeID;
        this.m_errorType = errorType;
        this.m_pathname = pathname;
        this.m_errors.add(errorMsg);
        this.m_errorCriticalities.add(errorCriticality);
        this.m_errorTimestamps.add(System.currentTimeMillis());
    }

    public String toString() {
        StringBuilder strRepresentation = new StringBuilder();
        switch (this.m_updateType) {
            case STATE: {
                strRepresentation.append("Node ID: " + this.m_targetNodeID + " -- new state: " + (Object)((Object)this.m_nodeState));
                break;
            }
            case ERROR: {
                strRepresentation.append("Source node ID: " + this.m_sourceNodeID + MultiTierTransferConstants.NEW_LINE);
                strRepresentation.append("Target node ID: " + this.m_targetNodeID + MultiTierTransferConstants.NEW_LINE);
                int numOfErrors = this.m_errors.size();
                for (int i = 0; i < numOfErrors; ++i) {
                    Date timestamp = new Date(this.m_errorTimestamps.get(i));
                    strRepresentation.append(this.m_errorCriticalities.get(i).toString() + ": " + this.m_errors.get(i) + " (timestamp: " + timestamp + ")");
                }
                break;
            }
        }
        return strRepresentation.toString();
    }

    protected synchronized void addError(String error, TransferResult.TransferStatus errorCriticality) {
        this.m_errors.add(error);
        this.m_errorCriticalities.add(errorCriticality);
    }

    protected int getSourceNodeID() {
        return this.m_sourceNodeID;
    }

    protected int getTargetNodeID() {
        return this.m_targetNodeID;
    }

    protected NodeState getNodeState() {
        return this.m_nodeState;
    }

    protected List<String> getErrors() {
        return this.m_errors;
    }

    protected ErrorType getErrorType() {
        return this.m_errorType;
    }

    protected String getErrorRelatedPathname() {
        return this.m_pathname;
    }

    protected List<TransferResult.TransferStatus> getErrorCriticalities() {
        return this.m_errorCriticalities;
    }

    protected final List<Long> getErrorTimestamps() {
        return this.m_errorTimestamps;
    }

    protected UpdateType getUpdateType() {
        return this.m_updateType;
    }

    protected NodeState setNodeState(NodeState nodeState) {
        this.m_nodeState = nodeState;
        return this.m_nodeState;
    }

    protected static enum ErrorType {
        GENERAL_ERROR("GENERAL"),
        DIR_ERROR("DIR"),
        FILE_ERROR("FILE"),
        SYMLINK_ERROR("SYMLINK");

        private final String errorDescription;

        private ErrorType(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        protected static ErrorType toErrorType(String errorDescription) {
            for (ErrorType errorType : ErrorType.values()) {
                if (!errorType.errorDescription.equalsIgnoreCase(errorDescription)) continue;
                return errorType;
            }
            return null;
        }
    }

    protected static enum UpdateType {
        INFO,
        ERROR,
        PROGRESS,
        STATE;

    }

    protected static enum NodeState {
        INIT(1, "Invoked in transfer", 300),
        RECEIVED_PLAN(2, "Received transfer plan", 360),
        CREATED_DIR_STRUCTURE(3, "Created dir structure", 3600),
        RECEIVED_FILES(4, "Received files", 300),
        DONE(5, "Transfer completed", 0);

        private static final Map<Integer, NodeState> lookup;
        private final int m_stateCode;
        private final String m_strRepresentation;
        private final int m_timeoutLimitInSec;

        private NodeState(int stateCode, String strRepresentation, int timeoutLimitInSec) {
            this.m_stateCode = stateCode;
            this.m_strRepresentation = strRepresentation;
            this.m_timeoutLimitInSec = timeoutLimitInSec;
        }

        protected static NodeState getNodeState(int nodeStateCode) {
            return lookup.get(nodeStateCode);
        }

        protected boolean precedes(NodeState other) {
            return this.m_stateCode < other.m_stateCode;
        }

        protected int getStateCode() {
            return this.m_stateCode;
        }

        protected int getTimeoutLimit() {
            return this.m_timeoutLimitInSec;
        }

        public String toString() {
            return this.m_strRepresentation;
        }

        static {
            lookup = new HashMap<Integer, NodeState>();
            for (NodeState nodeState : NodeState.values()) {
                lookup.put(nodeState.m_stateCode, nodeState);
            }
        }
    }
}

