/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.cluster.deployment.ractrans.ClientHandlerSupervisor;
import oracle.cluster.deployment.ractrans.ConnectionInfo;
import oracle.cluster.deployment.ractrans.NodeRegistryModelListener;
import oracle.cluster.deployment.ractrans.RACTransferConstants;

public class NodeRegistryModel {
    private RACTransferConstants.Connection[] m_nodeStatus;
    private Collection<NodeRegistryModelListener> m_listenerList;

    protected NodeRegistryModel() {
    }

    protected void initRegistry(int totalNumOfNodes) {
        this.m_nodeStatus = new RACTransferConstants.Connection[totalNumOfNodes];
        for (int i = 0; i < totalNumOfNodes; ++i) {
            this.m_nodeStatus[i] = RACTransferConstants.Connection.NOT_CONNECTED;
        }
        this.notifyAllListeners();
    }

    protected void updateNumOfNodes(ClientHandlerSupervisor clientHandlerSupervisor, int lastTotalNumOfNodes, int currTotalNumOfNodes) {
        ConnectionInfo[] oldConnectionInfoArray = clientHandlerSupervisor.getConnectionInfoArray();
        ConnectionInfo[] connectionInfoArray = new ConnectionInfo[currTotalNumOfNodes];
        RACTransferConstants.Connection[] oldNodeStatus = this.m_nodeStatus;
        this.m_nodeStatus = new RACTransferConstants.Connection[currTotalNumOfNodes];
        int index = 0;
        for (int i = 0; i < lastTotalNumOfNodes; ++i) {
            if (!oldNodeStatus[i].equals((Object)RACTransferConstants.Connection.CONNECTION_ALIVE)) continue;
            this.m_nodeStatus[index] = oldNodeStatus[i];
            connectionInfoArray[index] = oldConnectionInfoArray[i];
            connectionInfoArray[index].setNodeID(index);
            if (++index == lastTotalNumOfNodes) break;
        }
        clientHandlerSupervisor.setConnectionInfoArray(connectionInfoArray);
        this.notifyAllListeners();
    }

    protected void addListener(NodeRegistryModelListener listener2add) {
        if (this.m_listenerList == null) {
            this.m_listenerList = new ArrayList<NodeRegistryModelListener>();
        }
        this.m_listenerList.add(listener2add);
    }

    private void notifyAllListeners(int threadID) {
        if (this.m_listenerList == null) {
            return;
        }
        Iterator<NodeRegistryModelListener> itr = this.m_listenerList.iterator();
        while (itr.hasNext()) {
            itr.next().fireNodeStatusChanged(this, threadID);
        }
    }

    private void notifyAllListeners() {
        if (this.m_listenerList == null) {
            return;
        }
        for (NodeRegistryModelListener nodeRegistryModelListener : this.m_listenerList) {
            nodeRegistryModelListener.fireAllNodeStatusChanged(this);
        }
    }

    protected RACTransferConstants.Connection getConnectionStatus(int nodeID) {
        return this.m_nodeStatus[nodeID];
    }

    protected int getTotalNumberOfNodes() {
        return this.m_nodeStatus.length;
    }

    protected int getNumOfConnectedNodes() {
        int numOfConnectedNodes = 0;
        for (int i = 0; i < this.m_nodeStatus.length; ++i) {
            if (!this.m_nodeStatus[i].equals((Object)RACTransferConstants.Connection.CONNECTION_ALIVE)) continue;
            ++numOfConnectedNodes;
        }
        return numOfConnectedNodes;
    }

    protected synchronized void setNodeStatus(int nodeID, RACTransferConstants.Connection currStatus) {
        this.m_nodeStatus[nodeID] = currStatus;
        this.notifyAllListeners(nodeID);
    }
}

