/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import oracle.cluster.deployment.ractrans.DirListingConstants;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class FileDescriptor
extends File {
    private String m_permissions;
    private int m_ownerID;
    private int m_groupID;
    private long m_size;
    private boolean m_isDir;
    private boolean m_isFile;
    private boolean m_isLink;
    private String m_linkDestination;
    private String m_osError;
    private List<FileDescriptor> m_linksPointingHere;
    private static NativeSystem s_nativeSyatem;
    private static boolean s_isUnixSystem;

    protected FileDescriptor(String pathname) throws FileNotFoundException, RACTransErrorException {
        this(pathname, true, false);
    }

    protected FileDescriptor(String pathname, boolean checkForExistence, boolean isLinkDestination) throws FileNotFoundException, RACTransErrorException {
        super(pathname);
        this.retrieveFileInfo(checkForExistence, isLinkDestination);
        this.m_linksPointingHere = new ArrayList<FileDescriptor>();
    }

    private void retrieveFileInfo(boolean checkForExistence, boolean isLinkDestination) throws FileNotFoundException, RACTransErrorException {
        if (!this.exists()) {
            if (checkForExistence) {
                throw new FileNotFoundException();
            }
            if (isLinkDestination) {
                return;
            }
        }
        if (!s_isUnixSystem) {
            Trace.out("The user tried to call the method retrieveFileInfo() on Windows OS. FileDescriptor constructor calls are restricted to Unix OS only.");
            throw new FileNotFoundException(MessageBundle.getMessageBundle(PrCfMsgID.UNIX_SUPPORT_ONLY).getMessage(PrCfMsgID.UNIX_SUPPORT_ONLY, true));
        }
        if (DirListingConstants.IS_WINDOWS_OS) {
            this.m_isDir = super.isDirectory();
            this.m_isFile = super.isFile();
            this.m_isLink = false;
            this.m_size = super.length();
        } else {
            this.retrieveFileInfo(this.getAbsolutePath());
            this.m_size = super.length();
        }
    }

    private void retrieveFileInfo(String path) throws RACTransErrorException {
        int rc = this.retrieveFileInfo(path.getBytes());
        switch (rc) {
            case 0: {
                return;
            }
            case -1: {
                throw new RACTransErrorException((MessageKey)PrCfMsgID.NAME_IS_TOO_LONG, path);
            }
            case -2: {
                throw new RACTransErrorException((MessageKey)PrCfMsgID.LINK_IS_TOO_LONG, path);
            }
        }
        throw new RACTransErrorException((MessageKey)PrCfMsgID.LSTAT_FAILED, path, this.m_osError);
    }

    private native int retrieveFileInfo(byte[] var1);

    private void setInfo(int ownerID, int groupID, int permissions, boolean isLink, boolean isFile, boolean isDir, String linkDestination, String osError) {
        this.m_ownerID = ownerID;
        this.m_groupID = groupID;
        this.m_permissions = Integer.toOctalString(permissions);
        this.m_isDir = isDir;
        this.m_isFile = isFile;
        this.m_isLink = isLink;
        this.m_linkDestination = linkDestination;
        this.m_osError = osError;
    }

    protected boolean equals(File obj) {
        return this.getAbsolutePath().equals(obj.getAbsolutePath());
    }

    protected boolean appendLinkList(List<FileDescriptor> linksPointingHere) {
        return this.m_linksPointingHere.addAll(linksPointingHere);
    }

    protected boolean appendLinkList(FileDescriptor linkPointingHere) {
        if (this.m_linksPointingHere.contains(linkPointingHere)) {
            return false;
        }
        return this.m_linksPointingHere.add(linkPointingHere);
    }

    protected boolean removeFromLinkList(FileDescriptor link2remove) {
        return this.m_linksPointingHere.remove(link2remove);
    }

    @Override
    public String getPath() {
        return super.getPath();
    }

    public String getRelativePath(String referencePath) {
        String pathname = this.getPath();
        if (!pathname.startsWith(referencePath)) {
            return null;
        }
        return pathname.substring(referencePath.length()).substring(1);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public FileDescriptor getParentDir() throws RACTransErrorException {
        try {
            return new FileDescriptor(this.getParent());
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
        catch (RACTransErrorException ee) {
            Trace.out("\"" + this.getPath() + "\" has obviously a longer pathname than its parent directory \"" + this.getParent() + "\" does not. Hence an internal error as there must be no pathname " + "length issue for its parent directory");
            throw new RACTransErrorException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre013");
        }
    }

    protected String getPermissions() {
        return this.m_permissions;
    }

    protected int getOwnerID() {
        return this.m_ownerID;
    }

    protected int getGroupID() {
        return this.m_groupID;
    }

    @Override
    public long length() {
        return this.m_size;
    }

    @Override
    public boolean isDirectory() {
        return this.m_isDir;
    }

    @Override
    public boolean isFile() {
        return this.m_isFile;
    }

    protected boolean isLink() {
        return this.m_isLink;
    }

    public static boolean isLink(String pathname) {
        try {
            return new FileDescriptor(pathname).isLink();
        }
        catch (FileNotFoundException fnfe) {
            Trace.out("Pathname \"" + pathname + "\" does not exist. Details: " + fnfe.getMessage());
            return false;
        }
        catch (RACTransErrorException error) {
            Trace.out("Unable to determine whether pathname \"" + pathname + "\" is a symbolic link or not. Details: " + error.getMessage());
            return false;
        }
    }

    protected String getLinkDestination() {
        return this.m_linkDestination;
    }

    protected List<FileDescriptor> getLinksPointingHere() {
        return this.m_linksPointingHere;
    }

    static {
        try {
            s_nativeSyatem = new SystemFactory().CreateSystem();
            s_isUnixSystem = s_nativeSyatem.isUnixSystem();
            s_nativeSyatem.loadSRVMNativeLibrary();
        }
        catch (NativeException ne) {
            Trace.out("Failed to load SRVM library: " + ne);
        }
    }
}

