/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import oracle.cluster.deployment.ractrans.DirListingConstants;
import oracle.cluster.deployment.ractrans.DirStruct;
import oracle.cluster.deployment.ractrans.FileDescriptor;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.deployment.ractrans.RACTransWarningException;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class DirectoryMap {
    private HashMap<FileDescriptor, DirStruct> m_dirMap;
    private Set<String> m_excludeSet;
    private final List<String> m_excludeRegexList;
    private HashMap<FileDescriptor, List<FileDescriptor>> m_linkDestinationHashMap;
    private FileDescriptor m_topDir;
    private boolean m_linkDestAreRelativePaths;
    private List<FileDescriptor> m_nonReadableDirs;
    private List<FileDescriptor> m_nonReadableFiles;
    private SortedMap<Long, List<FileDescriptor>> m_filesizeMap;
    private long m_totalFilesize;
    private long m_totalNumberOfFiles;

    protected DirectoryMap(File topDir, boolean linkDestAreRelativePaths) throws RACTransErrorException {
        this(topDir, null, false, null, false, linkDestAreRelativePaths);
    }

    protected DirectoryMap(File topDir, Map<DirListingConstants.PathType, List<String>> map2exclude, boolean allowRegexForExclude, Map<DirListingConstants.PathType, List<String>> map2include, boolean allowRegexForInclude, boolean linkDestAreRelativePaths) throws RACTransErrorException {
        try {
            this.m_topDir = new FileDescriptor(topDir.getAbsolutePath());
            if (!this.m_topDir.isDirectory()) {
                try {
                    this.m_topDir = new FileDescriptor(topDir.getCanonicalPath());
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.DIR_NOT_EXISTS, topDir.getName());
        }
        if (!this.m_topDir.isDirectory()) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.TOP_DIR_NOT_A_DIR, topDir.getName());
        }
        this.m_linkDestAreRelativePaths = linkDestAreRelativePaths;
        this.m_dirMap = new HashMap();
        this.m_excludeSet = new HashSet<String>();
        this.m_linkDestinationHashMap = new HashMap();
        this.m_nonReadableDirs = new ArrayList<FileDescriptor>();
        this.m_nonReadableFiles = new ArrayList<FileDescriptor>();
        this.m_filesizeMap = new TreeMap<Long, List<FileDescriptor>>();
        this.m_totalFilesize = 0L;
        this.m_totalNumberOfFiles = 0L;
        if (map2exclude != null) {
            if (allowRegexForExclude) {
                if (map2exclude.containsKey((Object)DirListingConstants.PathType.NON_REGULAR_EXPRESSION)) {
                    this.buildExcludeList(map2exclude.get((Object)DirListingConstants.PathType.NON_REGULAR_EXPRESSION));
                }
                this.m_excludeRegexList = map2exclude.get((Object)DirListingConstants.PathType.REGULAR_EXPRESSION);
            } else {
                this.m_excludeRegexList = null;
                List<String> pathnamesToExclude = null;
                if (map2exclude.containsKey((Object)DirListingConstants.PathType.NON_REGULAR_EXPRESSION)) {
                    pathnamesToExclude = map2exclude.get((Object)DirListingConstants.PathType.NON_REGULAR_EXPRESSION);
                }
                if (map2exclude.containsKey((Object)DirListingConstants.PathType.REGULAR_EXPRESSION)) {
                    if (pathnamesToExclude != null) {
                        pathnamesToExclude.addAll((Collection<String>)map2exclude.get((Object)DirListingConstants.PathType.REGULAR_EXPRESSION));
                    } else {
                        pathnamesToExclude = map2exclude.get((Object)DirListingConstants.PathType.REGULAR_EXPRESSION);
                    }
                }
                if (pathnamesToExclude != null) {
                    this.buildExcludeList(pathnamesToExclude);
                }
            }
        } else {
            this.m_excludeRegexList = null;
        }
        if (map2include == null) {
            this.processDir(this.m_topDir);
        } else {
            if (!allowRegexForInclude && map2include.containsKey((Object)DirListingConstants.PathType.REGULAR_EXPRESSION)) {
                List<String> pathnamesToInclude = map2include.remove((Object)DirListingConstants.PathType.REGULAR_EXPRESSION);
                if (map2include.containsKey((Object)DirListingConstants.PathType.NON_REGULAR_EXPRESSION)) {
                    pathnamesToInclude.addAll((Collection<String>)map2include.get((Object)DirListingConstants.PathType.NON_REGULAR_EXPRESSION));
                }
                map2include.put(DirListingConstants.PathType.NON_REGULAR_EXPRESSION, pathnamesToInclude);
            }
            List<FileDescriptor> addList = this.buildAddList(map2include);
            for (FileDescriptor currContent : addList) {
                this.add(currContent);
            }
        }
        this.updateLinkDestinationsWithLinkInfo();
    }

    private void processDir(FileDescriptor dir) throws RACTransErrorException {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        if (!dir.canRead()) {
            this.m_nonReadableDirs.add(dir);
            return;
        }
        DirStruct dirStructure = new DirStruct();
        File[] dirContents = dir.listFiles();
        FileDescriptor curr_content = null;
        for (int i = 0; i < dirContents.length; ++i) {
            boolean forceInclude;
            FileDescriptor linkDestination;
            if (dirContents[i].getName().equals("lost+found") || this.m_excludeSet.contains(this.getCanonicalPath(dirContents[i]))) continue;
            try {
                curr_content = new FileDescriptor(dirContents[i].getPath());
            }
            catch (FileNotFoundException fnfe) {
                if (dirContents[i].isDirectory() || dirContents[i].isFile()) {
                    throw new RACTransErrorException((MessageKey)PrCfMsgID.FILE_NOT_FOUND, dirContents[i].getName());
                }
                Trace.out("Warning (while while creating the directory listing): The target of the link \"" + dirContents[i].getName() + "\" does not exist.");
                try {
                    curr_content = new FileDescriptor(dirContents[i].getPath(), false, false);
                }
                catch (FileNotFoundException linkNotFound) {
                    Trace.out("Got a FileNotFoundException in the method processDir() of class DirectroyMap.java. This exception is never expected to be thrown.");
                }
            }
            String canonicalPath = this.getCanonicalPath(curr_content);
            if (this.regexMatch(canonicalPath, this.m_excludeRegexList) || this.regexMatch(curr_content.getPath(), this.m_excludeRegexList)) {
                this.m_excludeSet.add(canonicalPath);
                continue;
            }
            if (curr_content.isDirectory()) {
                if (curr_content.canRead()) {
                    dirStructure.addDir(curr_content);
                }
                this.processDir(curr_content);
                continue;
            }
            if (curr_content.isFile()) {
                if (curr_content.canRead()) {
                    dirStructure.addFile(curr_content);
                    this.updateTotalNumOfFilesAndFilesize(curr_content);
                    continue;
                }
                this.m_nonReadableFiles.add(curr_content);
                continue;
            }
            if (!curr_content.isLink()) continue;
            try {
                linkDestination = !this.m_linkDestAreRelativePaths ? new FileDescriptor(curr_content.getLinkDestination(), false, true) : new FileDescriptor(this.m_topDir.getPath() + File.separator + curr_content.getLinkDestination(), false, true);
            }
            catch (FileNotFoundException fnfe) {
                throw new RACTransErrorException((MessageKey)PrCfMsgID.LINK_DEST_NOT_FOUND, curr_content.getLinkDestination());
            }
            boolean bl = forceInclude = linkDestination.getPath().startsWith("." + File.separator) || linkDestination.getPath().startsWith(".." + File.separator);
            if (!forceInclude) {
                // empty if block
            }
            dirStructure.addLink(curr_content);
            this.updateLinkDestinationHashMap(linkDestination, curr_content);
        }
        this.m_dirMap.put(dir, dirStructure);
    }

    protected void checkForCollisionAndAdd(FileDescriptor content2add) throws RACTransWarningException, RACTransErrorException {
        if (this.collidesWithExcludeList(content2add)) {
            throw new RACTransWarningException((MessageKey)PrCfMsgID.CONFLICT_WITH_EXCLUDE_LIST, content2add.getName());
        }
        this.add(content2add);
    }

    private void add(FileDescriptor content2add) throws RACTransErrorException {
        if (content2add.isDirectory()) {
            if (!this.m_dirMap.containsKey(content2add)) {
                this.processDir(content2add);
                this.wireDirWithParents(content2add);
            } else {
                Trace.out(PrCfMsgID.DIR_EXISTS_IN_DIRECTORY_MAP, content2add.getName());
            }
        } else {
            boolean mustWireParentDir;
            DirStruct dirStructure;
            FileDescriptor parentDir;
            try {
                parentDir = new FileDescriptor(content2add.getParent());
            }
            catch (FileNotFoundException fnfe) {
                throw new RACTransErrorException((MessageKey)PrCfMsgID.PARENT_DIR_NOT_EXISTS, content2add);
            }
            if (!this.m_dirMap.containsKey(parentDir)) {
                dirStructure = new DirStruct();
                mustWireParentDir = true;
            } else {
                dirStructure = this.m_dirMap.get(parentDir);
                mustWireParentDir = false;
            }
            if (content2add.isFile()) {
                if (!dirStructure.getChildFiles().contains(content2add)) {
                    dirStructure.addFile(content2add);
                    this.updateTotalNumOfFilesAndFilesize(content2add);
                } else {
                    Trace.out(PrCfMsgID.FILE_EXISTS_IN_DIRECTORY_MAP, content2add.getName());
                }
            } else if (content2add.isLink()) {
                if (!dirStructure.getChildLinks().contains(content2add)) {
                    FileDescriptor linkDestination;
                    try {
                        linkDestination = new FileDescriptor(content2add.getLinkDestination(), false, true);
                    }
                    catch (FileNotFoundException fnfe) {
                        throw new RACTransErrorException((MessageKey)PrCfMsgID.LINK_DEST_NOT_FOUND, content2add.getLinkDestination());
                    }
                    DirStruct linkDestinationDirStuct = this.m_dirMap.get(linkDestination.getParentFile());
                    boolean linkDestinationExistsInDirMap = false;
                    if (linkDestinationDirStuct != null) {
                        if (linkDestination.isDirectory()) {
                            linkDestinationExistsInDirMap = linkDestinationDirStuct.getChildDirs().contains(linkDestination);
                            if (linkDestinationExistsInDirMap) {
                                linkDestinationDirStuct.addLinkDependenciesToDir(linkDestination, content2add);
                            }
                        } else if (linkDestination.isFile()) {
                            linkDestinationExistsInDirMap = linkDestinationDirStuct.getChildFiles().contains(linkDestination);
                            if (linkDestinationExistsInDirMap) {
                                linkDestinationDirStuct.addLinkDependenciesToFile(linkDestination, content2add);
                            }
                        } else if (linkDestination.isLink() && (linkDestinationExistsInDirMap = linkDestinationDirStuct.getChildLinks().contains(linkDestination))) {
                            linkDestinationDirStuct.addLinkDependenciesToLink(linkDestination, content2add);
                        }
                    }
                    if (!linkDestinationExistsInDirMap) {
                        // empty if block
                    }
                    dirStructure.addLink(content2add);
                    this.updateLinkDestinationHashMap(linkDestination, content2add);
                } else {
                    Trace.out(PrCfMsgID.LINK_EXISTS_IN_DIRECTORY_MAP, content2add.getName());
                }
            }
            this.m_dirMap.put(parentDir, dirStructure);
            if (mustWireParentDir) {
                this.wireDirWithParents(parentDir);
            }
        }
    }

    private void wireDirWithParents(FileDescriptor dir2wire) throws RACTransErrorException {
        if (!dir2wire.isDirectory()) {
            boolean isDir = false;
            try {
                String canonicalPath = dir2wire.getCanonicalPath();
                isDir = new File(canonicalPath).isDirectory();
                Trace.out("Cannonical path for '" + dir2wire.getName() + "': '" + canonicalPath + "'. isDirectory() returns " + isDir);
            }
            catch (IOException canonicalPath) {
                // empty catch block
            }
            if (!isDir) {
                throw new RACTransErrorException((MessageKey)PrCfMsgID.NOT_A_DIR, dir2wire.getName());
            }
        }
        boolean parentDirExistsInDirMap = false;
        while (!(parentDirExistsInDirMap || dir2wire.equals(this.m_topDir) || dir2wire.equals(DirListingConstants.ROOT_DIRECTORY))) {
            DirStruct dirStructure;
            FileDescriptor parentDir;
            try {
                parentDir = new FileDescriptor(dir2wire.getParent());
            }
            catch (FileNotFoundException fnfe) {
                throw new RACTransErrorException((MessageKey)PrCfMsgID.PARENT_DIR_NOT_EXISTS, dir2wire);
            }
            if (!this.m_dirMap.containsKey(parentDir)) {
                dirStructure = new DirStruct();
            } else {
                dirStructure = this.m_dirMap.get(parentDir);
                parentDirExistsInDirMap = true;
            }
            dirStructure.addDir(dir2wire);
            this.m_dirMap.put(parentDir, dirStructure);
            if (parentDir.equals(this.m_topDir)) {
                parentDirExistsInDirMap = true;
                continue;
            }
            dir2wire = parentDir;
        }
    }

    private void updateTotalNumOfFilesAndFilesize(FileDescriptor file) {
        long filesize = file.length();
        ArrayList<FileDescriptor> filesizeList = (ArrayList<FileDescriptor>)this.m_filesizeMap.get(filesize);
        if (filesizeList == null) {
            filesizeList = new ArrayList<FileDescriptor>();
        }
        filesizeList.add(file);
        this.m_filesizeMap.put(filesize, filesizeList);
        this.m_totalFilesize += filesize;
        ++this.m_totalNumberOfFiles;
    }

    private void buildExcludeList(List<String> list2exclude) throws RACTransErrorException {
        ArrayList<String> nonExistingPathnames = new ArrayList<String>();
        for (String pathnameToExclude : list2exclude) {
            File fileToExclude = new File(pathnameToExclude);
            if (fileToExclude.exists()) {
                this.m_excludeSet.add(this.getCanonicalPath(fileToExclude));
                continue;
            }
            nonExistingPathnames.add(pathnameToExclude);
        }
        if (nonExistingPathnames.size() > 0) {
            Trace.out("Warning! The following pathnames in the exclude-list do not exist:");
            int i = 1;
            for (String currPathname : nonExistingPathnames) {
                Trace.out("     " + i + ") " + currPathname);
                ++i;
            }
        }
    }

    private List<FileDescriptor> buildAddList(Map<DirListingConstants.PathType, List<String>> map2add) throws RACTransErrorException {
        ArrayList<FileDescriptor> addList = new ArrayList<FileDescriptor>();
        String warningReportMessage = "";
        if (map2add.containsKey((Object)DirListingConstants.PathType.NON_REGULAR_EXPRESSION)) {
            List<String> existingPathnamesToInclude = map2add.get((Object)DirListingConstants.PathType.NON_REGULAR_EXPRESSION);
            ArrayList<String> nonExistingPathnames = new ArrayList<String>();
            boolean skip_currContent = false;
            FileDescriptor curr_content = null;
            for (String string : existingPathnamesToInclude) {
                try {
                    curr_content = new FileDescriptor(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    boolean nonExistingPathname = true;
                    try {
                        curr_content = new FileDescriptor(string, false, false);
                        if (curr_content.isLink()) {
                            nonExistingPathname = false;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException2) {
                    }
                    catch (RACTransErrorException rACTransErrorException) {
                        // empty catch block
                    }
                    if (nonExistingPathname) {
                        nonExistingPathnames.add(string);
                        continue;
                    }
                }
                catch (RACTransErrorException rACTransErrorException) {
                    Trace.out("RACTransErrorException thrown while calling the FileDescriptor() constructor with pathname \"" + string + "\"");
                    throw rACTransErrorException;
                }
                if (this.m_excludeSet.size() > 0) {
                    try {
                        skip_currContent = this.collidesWithExcludeList(curr_content);
                    }
                    catch (RACTransWarningException rACTransWarningException) {
                        warningReportMessage = warningReportMessage + rACTransWarningException.getMessage() + DirListingConstants.NEW_LINE;
                        skip_currContent = true;
                    }
                }
                if (skip_currContent) continue;
                String string2 = this.getCanonicalPath(curr_content);
                if (this.regexMatch(string2, this.m_excludeRegexList)) {
                    this.m_excludeSet.add(string2);
                    continue;
                }
                addList.add(curr_content);
            }
            if (nonExistingPathnames.size() > 0) {
                Trace.out("Warning! The following pathnames in the include-list do not exist:");
                int i = 1;
                for (String string : nonExistingPathnames) {
                    Trace.out("     " + i + ") " + string);
                    ++i;
                }
            }
        }
        if (map2add.containsKey((Object)DirListingConstants.PathType.REGULAR_EXPRESSION)) {
            List<String> regexList = map2add.get((Object)DirListingConstants.PathType.REGULAR_EXPRESSION);
            List<FileDescriptor> contentList = null;
            try {
                DirectoryMap dirMap = new DirectoryMap(this.m_topDir, this.m_linkDestAreRelativePaths);
                DirStruct topLevelDirStruct = dirMap.getDirStruct(this.m_topDir);
                contentList = this.getAllContents(dirMap, topLevelDirStruct);
            }
            catch (RACTransErrorException ee) {
                Trace.out("Unexpected exception encountered. Details: " + ee.getMessage());
                warningReportMessage = warningReportMessage + ee.getMessage() + DirListingConstants.NEW_LINE;
            }
            if (contentList != null) {
                boolean existsExcludeRegexList = this.m_excludeRegexList != null && this.m_excludeRegexList.size() > 0;
                block12: for (FileDescriptor curr_content : contentList) {
                    String string = this.getCanonicalPath(curr_content);
                    for (String currRegex : regexList) {
                        if (currRegex.contains("//")) {
                            currRegex = currRegex.replaceAll("//", "/");
                        }
                        if (!Pattern.matches(currRegex, string)) continue;
                        if (existsExcludeRegexList) {
                            if (this.regexMatch(string, this.m_excludeRegexList)) {
                                this.m_excludeSet.add(string);
                                continue block12;
                            }
                            addList.add(curr_content);
                            continue block12;
                        }
                        addList.add(curr_content);
                        continue block12;
                    }
                }
            }
        }
        if (!warningReportMessage.equals("")) {
            Trace.out("The following contents cannot be added to the add-list.\nDetails : " + warningReportMessage);
        }
        return addList;
    }

    private boolean regexMatch(String stringToCheckForMatch, List<String> regexList) {
        if (stringToCheckForMatch == null || stringToCheckForMatch.trim().length() == 0 || regexList == null || regexList.size() == 0) {
            return false;
        }
        for (String currRegex : regexList) {
            if (!Pattern.matches(currRegex, stringToCheckForMatch)) continue;
            return true;
        }
        return false;
    }

    private List<FileDescriptor> getAllContents(DirectoryMap dirMap, DirStruct dirStruct) {
        ArrayList<FileDescriptor> contentList = new ArrayList<FileDescriptor>();
        List<FileDescriptor> childDirs = dirStruct.getChildDirs();
        contentList.addAll(childDirs);
        contentList.addAll(dirStruct.getChildFiles());
        contentList.addAll(dirStruct.getChildLinks());
        for (FileDescriptor currChildDir : childDirs) {
            DirStruct curr_dirStruct = dirMap.getDirStruct(currChildDir);
            contentList.addAll(this.getAllContents(dirMap, curr_dirStruct));
        }
        return contentList;
    }

    private boolean collidesWithExcludeList(FileDescriptor fileDescriptor) throws RACTransWarningException {
        if (this.m_excludeSet.contains(this.getCanonicalPath(fileDescriptor))) {
            return true;
        }
        boolean isExcluded = false;
        if (!fileDescriptor.equals(this.m_topDir) && !fileDescriptor.equals(DirListingConstants.ROOT_DIRECTORY)) {
            File parentDir = fileDescriptor.getParentFile();
            while (!(parentDir.equals(this.m_topDir) || parentDir.equals(DirListingConstants.ROOT_DIRECTORY) || isExcluded)) {
                isExcluded = this.m_excludeSet.contains(this.getCanonicalPath(parentDir));
                parentDir = parentDir.getParentFile();
            }
        }
        if (isExcluded) {
            return true;
        }
        if (!fileDescriptor.isLink()) {
            return false;
        }
        return false;
    }

    private void updateLinkDestinationHashMap(FileDescriptor linkDestination, FileDescriptor link) {
        List<FileDescriptor> linkList = !this.m_linkDestinationHashMap.containsKey(linkDestination) ? new ArrayList<FileDescriptor>() : this.m_linkDestinationHashMap.get(linkDestination);
        linkList.add(link);
        this.m_linkDestinationHashMap.put(linkDestination, linkList);
    }

    private void updateLinkDestinationsWithLinkInfo() {
        for (FileDescriptor curr_linkDestination : this.m_linkDestinationHashMap.keySet()) {
            List<FileDescriptor> curr_linkList = this.m_linkDestinationHashMap.get(curr_linkDestination);
            File linkDestinationParentDir = curr_linkDestination.getParentFile();
            boolean linkDestinationExistsInDirMap = false;
            if (this.m_dirMap.containsKey(linkDestinationParentDir)) {
                DirStruct dirStruct = this.m_dirMap.get(linkDestinationParentDir);
                if (curr_linkDestination.isDirectory()) {
                    linkDestinationExistsInDirMap = dirStruct.getChildDirs().contains(curr_linkDestination);
                    if (linkDestinationExistsInDirMap) {
                        dirStruct.addLinkDependenciesToDir(curr_linkDestination, curr_linkList);
                    }
                } else if (curr_linkDestination.isFile()) {
                    linkDestinationExistsInDirMap = dirStruct.getChildFiles().contains(curr_linkDestination);
                    if (linkDestinationExistsInDirMap) {
                        dirStruct.addLinkDependenciesToFile(curr_linkDestination, curr_linkList);
                    }
                } else if (curr_linkDestination.isLink() && (linkDestinationExistsInDirMap = dirStruct.getChildLinks().contains(curr_linkDestination))) {
                    dirStruct.addLinkDependenciesToLink(curr_linkDestination, curr_linkList);
                }
            } else {
                linkDestinationExistsInDirMap = false;
            }
            if (linkDestinationExistsInDirMap) continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void remove(FileDescriptor content2remove) throws RACTransWarningException {
        if (content2remove.isDirectory()) {
            int index;
            if (!this.m_dirMap.containsKey(content2remove)) throw new RACTransWarningException((MessageKey)PrCfMsgID.REMOVE_CONTENT_IMPOSSIBLE, content2remove.getName());
            if (content2remove.equals(this.m_topDir)) {
                Trace.out("Removing the top directory is not allowed!");
                return;
            }
            DirStruct parentDirStruct = this.m_dirMap.get(content2remove.getParentFile());
            if (parentDirStruct == null || (index = parentDirStruct.getChildDirs().indexOf(content2remove)) == -1) return;
            FileDescriptor dir2remove = parentDirStruct.getChildDirs().remove(index);
            List<FileDescriptor> links2remove = dir2remove.getLinksPointingHere();
            links2remove = this.getAllLinksPointingUnderThisDir(content2remove, links2remove);
            Iterator<FileDescriptor> linkItr = links2remove.iterator();
            while (linkItr.hasNext()) {
                this.removeLink(linkItr.next());
            }
            ArrayList<FileDescriptor> initialListOfDirs = new ArrayList<FileDescriptor>();
            initialListOfDirs.add(content2remove);
            List<FileDescriptor> keys2remove = this.getAllSubdirs(content2remove, initialListOfDirs);
            Iterator<FileDescriptor> keyItr = keys2remove.iterator();
            while (keyItr.hasNext()) {
                this.m_dirMap.remove(keyItr.next());
            }
            return;
        } else if (content2remove.isFile()) {
            DirStruct parentDirStruct = this.m_dirMap.get(content2remove.getParentFile());
            if (parentDirStruct == null) return;
            int index = parentDirStruct.getChildFiles().indexOf(content2remove);
            if (index == -1) throw new RACTransWarningException((MessageKey)PrCfMsgID.REMOVE_CONTENT_IMPOSSIBLE, content2remove.getName());
            FileDescriptor file2remove = parentDirStruct.getChildFiles().remove(index);
            List<FileDescriptor> links2remove = file2remove.getLinksPointingHere();
            Iterator<FileDescriptor> itr = links2remove.iterator();
            while (itr.hasNext()) {
                this.removeLink(itr.next());
            }
            return;
        } else {
            DirStruct parentDirStruct;
            if (!content2remove.isLink() || (parentDirStruct = this.m_dirMap.get(content2remove.getParentFile())) == null) return;
            int index = parentDirStruct.getChildLinks().indexOf(content2remove);
            if (index == -1) throw new RACTransWarningException((MessageKey)PrCfMsgID.REMOVE_CONTENT_IMPOSSIBLE, content2remove.getName());
            FileDescriptor link2remove = parentDirStruct.getChildFiles().remove(index);
            List<FileDescriptor> links2remove = link2remove.getLinksPointingHere();
            Iterator<FileDescriptor> itr = links2remove.iterator();
            while (itr.hasNext()) {
                this.removeLink(itr.next());
            }
        }
    }

    private List<FileDescriptor> getAllLinksPointingUnderThisDir(FileDescriptor dir, List<FileDescriptor> listOfLinksPointingUnderThisDirSoFar) {
        List<FileDescriptor> listOfLinksPointingUnderThisDir = listOfLinksPointingUnderThisDirSoFar;
        DirStruct directoryStructure = this.m_dirMap.get(dir);
        if (directoryStructure != null) {
            ArrayList<FileDescriptor> dirChildren = new ArrayList<FileDescriptor>();
            dirChildren.addAll(directoryStructure.getChildDirs());
            dirChildren.addAll(directoryStructure.getChildFiles());
            dirChildren.addAll(directoryStructure.getChildLinks());
            Iterator childrenItr = dirChildren.iterator();
            while (childrenItr.hasNext()) {
                listOfLinksPointingUnderThisDirSoFar.addAll(((FileDescriptor)childrenItr.next()).getLinksPointingHere());
            }
            List<FileDescriptor> childDirs = directoryStructure.getChildDirs();
            Iterator<FileDescriptor> dirItr = childDirs.iterator();
            while (dirItr.hasNext()) {
                this.getAllLinksPointingUnderThisDir(dirItr.next(), listOfLinksPointingUnderThisDirSoFar);
            }
        }
        return listOfLinksPointingUnderThisDir;
    }

    private List<FileDescriptor> getAllSubdirs(FileDescriptor dir, List<FileDescriptor> listOfDirsSoFar) {
        List<FileDescriptor> listOfDirs = listOfDirsSoFar;
        DirStruct directoryStructure = this.m_dirMap.get(dir);
        if (directoryStructure != null) {
            List<FileDescriptor> childDirs = directoryStructure.getChildDirs();
            listOfDirs.addAll(childDirs);
            Iterator<FileDescriptor> itr = childDirs.iterator();
            while (itr.hasNext()) {
                this.getAllSubdirs(itr.next(), listOfDirs);
            }
        }
        return listOfDirs;
    }

    private boolean removeLink(FileDescriptor link2remove) {
        DirStruct parentDir_hashMapValue = this.m_dirMap.get(link2remove.getParentFile());
        if (parentDir_hashMapValue == null) {
            return false;
        }
        return parentDir_hashMapValue.getChildLinks().remove(link2remove);
    }

    protected DirStruct getDirStruct(FileDescriptor dir) {
        return this.m_dirMap.get(dir);
    }

    protected FileDescriptor getTopDir() {
        return this.m_topDir;
    }

    protected SortedMap<Long, List<FileDescriptor>> getFilesizeMap() {
        return this.m_filesizeMap;
    }

    protected long getTotalFilesize() {
        return this.m_totalFilesize;
    }

    protected long getTotalNumberOfFiles() {
        return this.m_totalNumberOfFiles;
    }

    protected List<FileDescriptor> getNonReadableDirs() {
        return this.m_nonReadableDirs;
    }

    protected List<FileDescriptor> getNonReadableFiles() {
        return this.m_nonReadableFiles;
    }

    private String getCanonicalPath(File file) {
        boolean isSymlink;
        try {
            FileDescriptor fileDesriptor = new FileDescriptor(file.getPath(), false, false);
            isSymlink = fileDesriptor.isLink();
        }
        catch (FileNotFoundException impossible) {
            Trace.out("Should never get here b/c there is no check whehter \"" + file.getPath() + "\" exists");
            return file.getAbsolutePath();
        }
        catch (RACTransErrorException error) {
            Trace.out("Error while constructing a FileDescriptor instance from \"" + file.getPath() + "\". Details:" + DirListingConstants.NEW_LINE + error.getMessage());
            Trace.out("Cannot construct the cannonical path for the given file with path \"" + file.getPath() + "\". Returning the absolute path instead");
            return file.getAbsolutePath();
        }
        try {
            if (isSymlink) {
                String parentDir = file.getParent();
                String symlinkName = file.getName();
                String canonicalPath = new File(parentDir).getCanonicalPath() + File.separator + symlinkName;
                Trace.out("The canonical path returned for symlink \"" + file.getPath() + "\" is \"" + canonicalPath + "\"");
                return canonicalPath;
            }
            return file.getCanonicalPath();
        }
        catch (IOException ioe) {
            Trace.out("Cannot construct the cannonical path for the given file with path \"" + file.getPath() + "\". Returning the absolute path instead");
            return file.getAbsolutePath();
        }
    }
}

