/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.deployment.ractrans.FileDescriptor;

public class DirStruct {
    private List<FileDescriptor> m_childDirs = new ArrayList<FileDescriptor>();
    private List<FileDescriptor> m_childFiles = new ArrayList<FileDescriptor>();
    private List<FileDescriptor> m_childLinks = new ArrayList<FileDescriptor>();

    protected DirStruct() {
    }

    protected boolean addDir(FileDescriptor dir) {
        return this.m_childDirs.add(dir);
    }

    protected boolean addLinkDependenciesToDir(FileDescriptor dir, List<FileDescriptor> linksToDir) {
        int index = this.m_childDirs.indexOf(dir);
        if (index == -1) {
            return false;
        }
        this.m_childDirs.get(index).appendLinkList(linksToDir);
        return true;
    }

    protected boolean addLinkDependenciesToDir(FileDescriptor dir, FileDescriptor linkToDir) {
        int index = this.m_childDirs.indexOf(dir);
        if (index == -1) {
            return false;
        }
        this.m_childDirs.get(index).appendLinkList(linkToDir);
        return true;
    }

    protected boolean addFile(FileDescriptor file) {
        return this.m_childFiles.add(file);
    }

    protected boolean addLinkDependenciesToFile(FileDescriptor file, List<FileDescriptor> linksToFile) {
        int index = this.m_childFiles.indexOf(file);
        if (index == -1) {
            return false;
        }
        this.m_childFiles.get(index).appendLinkList(linksToFile);
        return true;
    }

    protected boolean addLinkDependenciesToFile(FileDescriptor file, FileDescriptor linkToFile) {
        int index = this.m_childFiles.indexOf(file);
        if (index == -1) {
            return false;
        }
        this.m_childFiles.get(index).appendLinkList(linkToFile);
        return true;
    }

    protected boolean addLink(FileDescriptor link) {
        return this.m_childLinks.add(link);
    }

    protected boolean addLinkDependenciesToLink(FileDescriptor link, List<FileDescriptor> linksToLink) {
        int index = this.m_childLinks.indexOf(link);
        if (index == -1) {
            return false;
        }
        this.m_childLinks.get(index).appendLinkList(linksToLink);
        return true;
    }

    protected boolean addLinkDependenciesToLink(FileDescriptor link, FileDescriptor linkToLink) {
        int index = this.m_childLinks.indexOf(link);
        if (index == -1) {
            return false;
        }
        this.m_childLinks.get(index).appendLinkList(linkToLink);
        return true;
    }

    protected List<FileDescriptor> getChildDirs() {
        return this.m_childDirs;
    }

    protected List<FileDescriptor> getChildFiles() {
        return this.m_childFiles;
    }

    protected List<FileDescriptor> getChildLinks() {
        return this.m_childLinks;
    }
}

