/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import oracle.cluster.deployment.ractrans.DirListingConstants;
import oracle.cluster.deployment.ractrans.DirStruct;
import oracle.cluster.deployment.ractrans.DirectoryMap;
import oracle.cluster.deployment.ractrans.FileDescriptor;
import oracle.cluster.deployment.ractrans.IllegalArgException;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.deployment.ractrans.RACTransWarningException;
import oracle.cluster.deployment.ractrans.RACTransfer;
import oracle.cluster.deployment.ractrans.RACTransferConstants;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class DirListing {
    static boolean m_tabsEnabled;
    static boolean m_tagsEnabled;
    private DirectoryMap m_directoryMap;
    protected String m_listingString;
    private PathFormat m_pathFormat;
    private List<FileDescriptor> m_allDirs;
    private List<FileDescriptor> m_allFiles;
    private List<FileDescriptor> m_allLinks;

    public DirListing(FileDescriptor topDir, File fileWithExcludePathnames, boolean excludePathnamesCanBeRegex, File fileWithIncludePathnames, boolean includePathnamesCanBeRegex, boolean linkDestAreRelativePaths) throws RACTransErrorException {
        this(topDir, PathFormat.RELATIVE_PATH, true, false, null, fileWithExcludePathnames, excludePathnamesCanBeRegex, null, fileWithIncludePathnames, includePathnamesCanBeRegex, linkDestAreRelativePaths);
    }

    public DirListing(FileDescriptor topDir, Map<DirListingConstants.PathType, List<String>> map2exclude, boolean excludePathnamesCanBeRegex, Map<DirListingConstants.PathType, List<String>> map2include, boolean includePathnamesCanBeRegex, boolean linkDestAreRelativePaths) throws RACTransErrorException {
        this(topDir, PathFormat.RELATIVE_PATH, true, false, map2exclude, null, excludePathnamesCanBeRegex, map2include, null, includePathnamesCanBeRegex, linkDestAreRelativePaths);
    }

    public DirListing(FileDescriptor topDir, PathFormat pathFormat, boolean tabsEnabled, boolean tagsEnabled, Map<DirListingConstants.PathType, List<String>> map2exclude, File fileWithExcludePathnames, boolean excludePathnamesCanBeRegex, Map<DirListingConstants.PathType, List<String>> map2include, File fileWithIncludePathnames, boolean includePathnamesCanBeRegex, boolean linkDestAreRelativePaths) throws RACTransErrorException {
        Map<DirListingConstants.PathType, List<String>> includeMap;
        Map<DirListingConstants.PathType, List<String>> excludeMap;
        if (topDir == null) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre001");
        }
        try {
            RACTransfer.assertDir(topDir.getPath());
        }
        catch (IllegalArgException iae) {
            throw new RACTransErrorException(iae);
        }
        this.m_pathFormat = pathFormat;
        m_tabsEnabled = tabsEnabled;
        m_tagsEnabled = tagsEnabled;
        if (fileWithExcludePathnames != null && fileWithExcludePathnames.exists()) {
            Trace.out("File with pathnames to exclude: " + fileWithExcludePathnames.getPath());
            excludeMap = new HashMap<DirListingConstants.PathType, List<String>>();
            try {
                excludeMap = DirListing.extractPathnameMapFromFile(fileWithExcludePathnames, topDir.getAbsolutePath());
            }
            catch (RACTransWarningException we) {
                Trace.out("Got RACTransWarningException while reading the exclude-list file");
            }
        } else {
            excludeMap = map2exclude;
        }
        if (fileWithIncludePathnames != null && fileWithIncludePathnames.exists()) {
            Trace.out("File with pathnames to include: " + fileWithIncludePathnames.getPath());
            includeMap = new HashMap<DirListingConstants.PathType, List<String>>();
            try {
                includeMap = DirListing.extractPathnameMapFromFile(fileWithIncludePathnames, topDir.getAbsolutePath());
            }
            catch (RACTransWarningException we) {
                Trace.out("Got RACTransWarningException while reading the include-list file");
            }
        } else {
            includeMap = map2include;
        }
        this.m_directoryMap = new DirectoryMap(topDir, excludeMap, excludePathnamesCanBeRegex, includeMap, includePathnamesCanBeRegex, linkDestAreRelativePaths);
        this.m_allDirs = new ArrayList<FileDescriptor>();
        this.m_allFiles = new ArrayList<FileDescriptor>();
        this.m_allLinks = new ArrayList<FileDescriptor>();
    }

    public DirectoryMap getDirMapping() {
        return this.m_directoryMap;
    }

    public String getTopDirPath() {
        return this.m_directoryMap.getTopDir().getAbsolutePath();
    }

    public String getListing() throws RACTransWarningException {
        if (this.m_directoryMap.getTopDir() == null) {
            throw new RACTransWarningException((MessageKey)PrCfMsgID.NO_DIR_MAP_ENTRY, new Object[0]);
        }
        DirStruct topDirStruct = this.m_directoryMap.getDirStruct(this.m_directoryMap.getTopDir());
        this.dir2string(this.m_directoryMap.getTopDir(), 0);
        this.generateListingRepresentation(topDirStruct, 0);
        this.addEndDirInfoToListing(0);
        return this.m_listingString;
    }

    protected List<String> getListing_mkdirCommandList() {
        ArrayList<String> mkdirList = new ArrayList<String>();
        String topDirPath = this.getTopDirPath();
        for (FileDescriptor curr_dir : this.m_allDirs) {
            String name = curr_dir.getRelativePath(topDirPath);
            mkdirList.add("<" + name.getBytes().length + ">" + name + "[m" + curr_dir.getPermissions() + "]");
        }
        return mkdirList;
    }

    protected List<String> getListing_mklinkCommandList(String pathPrefix) {
        ArrayList<String> mklinkList = new ArrayList<String>();
        String topDirPath = this.getTopDirPath();
        for (FileDescriptor curr_link : this.m_allLinks) {
            String name = curr_link.getRelativePath(topDirPath);
            String linkDestination = curr_link.getLinkDestination();
            if (linkDestination.startsWith(topDirPath)) {
                linkDestination = pathPrefix + File.separator + linkDestination.substring(topDirPath.length()).substring(1);
            }
            mklinkList.add("<" + linkDestination.getBytes().length + ">" + linkDestination + "<" + name.getBytes().length + ">" + name);
        }
        return mklinkList;
    }

    protected List<FileDescriptor> getAllFiles() {
        return this.m_allFiles;
    }

    protected List<FileDescriptor> getAllDirs() throws RACTransErrorException {
        this.concatenateAllContents();
        return this.m_allDirs;
    }

    protected List<FileDescriptor> getAllLinks() throws RACTransErrorException {
        this.concatenateAllContents();
        return this.m_allLinks;
    }

    protected long getTotalFilesize() {
        return this.m_directoryMap.getTotalFilesize();
    }

    protected List<FileDescriptor> getNonReadableDirs() {
        if (this.m_directoryMap != null) {
            return this.m_directoryMap.getNonReadableDirs();
        }
        return null;
    }

    protected List<FileDescriptor> getNonReadableFiles() {
        if (this.m_directoryMap != null) {
            return this.m_directoryMap.getNonReadableFiles();
        }
        return null;
    }

    public void add(File content) throws RACTransWarningException, RACTransErrorException {
        FileDescriptor content2add;
        if (this.m_directoryMap == null) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.CONTENT_ADDITION_IMPOSSIBLE_NO_DIR_MAP, content.getName());
        }
        try {
            content2add = new FileDescriptor(content.getAbsolutePath());
        }
        catch (FileNotFoundException fnfe) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.CONTENT_ADDITION_IMPOSSIBLE_CONTENT_NOT_FOUND, content.getName());
        }
        this.m_directoryMap.checkForCollisionAndAdd(content2add);
    }

    public void remove(File content) throws RACTransWarningException, RACTransErrorException {
        FileDescriptor content2remove;
        if (this.m_directoryMap == null) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.CONTENT_REMOVAL_IMPOSSIBLE_NO_DIR_MAP, content.getName());
        }
        try {
            content2remove = new FileDescriptor(content.getAbsolutePath());
        }
        catch (FileNotFoundException fnfe) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.CONTENT_REMOVAL_IMPOSSIBLE_CONTENT_NOT_FOUND, content.getName());
        }
        this.m_directoryMap.remove(content2remove);
    }

    public void concatenateContents(DirStruct dirStruct) {
        List<FileDescriptor> childDirs = dirStruct.getChildDirs();
        this.m_allDirs.addAll(childDirs);
        this.m_allFiles.addAll(dirStruct.getChildFiles());
        this.m_allLinks.addAll(dirStruct.getChildLinks());
        for (FileDescriptor childDir : childDirs) {
            DirStruct curr_dirStruct = this.m_directoryMap.getDirStruct(childDir);
            this.concatenateContents(curr_dirStruct);
        }
    }

    public void concatenateAllContents() throws RACTransErrorException {
        FileDescriptor topDir = this.m_directoryMap.getTopDir();
        if (topDir == null) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.NO_DIR_MAP_ENTRY, new Object[0]);
        }
        DirStruct topDirStruct = this.m_directoryMap.getDirStruct(topDir);
        if (topDirStruct == null) {
            return;
        }
        this.m_allDirs.clear();
        this.m_allFiles.clear();
        this.m_allLinks.clear();
        this.concatenateContents(topDirStruct);
    }

    protected static Map<DirListingConstants.PathType, List<String>> extractPathnameMapFromFile(File fileWithPathnames, String topDirPathname) throws RACTransWarningException {
        FileReader fileReader;
        try {
            fileReader = new FileReader(fileWithPathnames);
        }
        catch (FileNotFoundException fnfe) {
            Trace.out("The file \"" + fileWithPathnames.getName() + "\" does not exist.");
            throw new RACTransWarningException((MessageKey)PrCfMsgID.FILE_NOT_FOUND, fileWithPathnames.getName());
        }
        BufferedReader bufReader = new BufferedReader(fileReader);
        ArrayList<String> listWithPathnames = new ArrayList<String>();
        try {
            String currLine;
            while ((currLine = bufReader.readLine()) != DirListingConstants.END_OF_FILE) {
                listWithPathnames.add(currLine);
            }
            fileReader.close();
            bufReader.close();
        }
        catch (IOException ioe) {
            Trace.out("An unexpected error condition was detected during reading the exclude-list or include-list file. Details: " + ioe.getMessage());
            throw new RACTransWarningException((MessageKey)PrCfMsgID.EXCEPTION_DETAILS, ioe.getMessage());
        }
        return DirListing.extractPathnameMapFromList(listWithPathnames, topDirPathname);
    }

    protected static Map<DirListingConstants.PathType, List<String>> extractPathnameMapFromList(List<String> listWithPathnames, String topDirPathname) throws RACTransWarningException {
        try {
            new FileDescriptor(topDirPathname);
        }
        catch (FileNotFoundException fnfe) {
            throw new RACTransWarningException((MessageKey)PrCfMsgID.TOP_DIR_NOT_FOUND, topDirPathname);
        }
        catch (RACTransErrorException rte) {
            throw new RACTransWarningException(rte);
        }
        HashMap<DirListingConstants.PathType, List<String>> pathnameMap = new HashMap<DirListingConstants.PathType, List<String>>();
        ArrayList<String> nonRegularExpressions = new ArrayList<String>();
        ArrayList<String> regularExpressions = new ArrayList<String>();
        boolean traceRegexNonRegexParts = true;
        HashSet<String> processedStrings = new HashSet<String>(listWithPathnames.size());
        for (String currString : listWithPathnames) {
            String topDirCanonicalPath;
            if ((currString = currString.trim()).equals("") || processedStrings.contains(currString)) continue;
            int nonRegexPartEndIndex = currString.lastIndexOf(File.separator);
            try {
                topDirCanonicalPath = new File(topDirPathname).getCanonicalPath();
            }
            catch (IOException ioe) {
                topDirCanonicalPath = null;
            }
            String nonRegexPart = topDirPathname;
            String regexPart = currString;
            while (nonRegexPartEndIndex != -1) {
                String currLineSubstring = currString.substring(0, nonRegexPartEndIndex);
                if (currLineSubstring.length() == 0) {
                    nonRegexPart = "";
                    break;
                }
                try {
                    String baseDirCanonicalPath = new File(topDirPathname + File.separator + currLineSubstring).getCanonicalPath();
                    if (new File(baseDirCanonicalPath).isDirectory() && !DirListing.isPotentialRegularExpression(baseDirCanonicalPath)) {
                        int beginIndex = baseDirCanonicalPath.indexOf(topDirPathname);
                        if (beginIndex == -1 && topDirCanonicalPath != null) {
                            beginIndex = baseDirCanonicalPath.indexOf(topDirCanonicalPath);
                        }
                        nonRegexPart = baseDirCanonicalPath.substring(beginIndex);
                        break;
                    }
                    nonRegexPartEndIndex = currLineSubstring.lastIndexOf(File.separator);
                }
                catch (IOException ioe) {
                    nonRegexPartEndIndex = currLineSubstring.lastIndexOf(File.separator);
                }
            }
            if (nonRegexPartEndIndex != -1) {
                block22: {
                    try {
                        if (nonRegexPart.length() <= 0) break block22;
                        nonRegexPart = new File(nonRegexPart).getCanonicalPath();
                        if (DirListing.isPotentialRegularExpression(topDirPathname) && topDirPathname.startsWith(nonRegexPart)) break block22;
                        nonRegexPart = DirListing.getAbsolutePath(nonRegexPart, topDirPathname);
                    }
                    catch (IOException ignored) {
                        Trace.out("Ignored exception while trying to find the absolute canonical path for \"" + nonRegexPart + "\"");
                        continue;
                    }
                }
                regexPart = currString.substring(nonRegexPartEndIndex + 1);
            }
            String absolutePath = nonRegexPart + File.separator + regexPart;
            if (traceRegexNonRegexParts) {
                Trace.out("absolutePath = nonRegexPart + '/' + regexPart-->" + nonRegexPart + " + '/' + " + regexPart);
                traceRegexNonRegexParts = RACTransferConstants.VERBOSE_TRACING;
            }
            if (DirListing.isPotentialRegularExpression(absolutePath)) {
                regularExpressions.add(absolutePath);
            } else {
                nonRegularExpressions.add(absolutePath);
            }
            processedStrings.add(currString);
        }
        if (regularExpressions.size() != 0) {
            String potentialRegexList = "";
            int i = 1;
            Iterator itr = regularExpressions.iterator();
            while (itr.hasNext()) {
                potentialRegexList = potentialRegexList + i + ") " + (String)itr.next() + DirListingConstants.NEW_LINE;
                ++i;
            }
            if (System.getProperty("SRVM_PARALLEL_TRANSFER") == null || Trace.isLevelEnabled(1)) {
                Trace.out("The following pathnames may be regular-expressions:" + DirListingConstants.NEW_LINE + potentialRegexList);
            }
            pathnameMap.put(DirListingConstants.PathType.REGULAR_EXPRESSION, regularExpressions);
        }
        if (nonRegularExpressions.size() != 0) {
            pathnameMap.put(DirListingConstants.PathType.NON_REGULAR_EXPRESSION, nonRegularExpressions);
        }
        return pathnameMap;
    }

    private static boolean isPotentialRegularExpression(String path) {
        int stringLength = path.length();
        for (int i = 0; i < stringLength; ++i) {
            char currChar = path.charAt(i);
            if (Character.isLetterOrDigit(currChar) || currChar == File.separatorChar) continue;
            return true;
        }
        return false;
    }

    private static FilenameFilter filter(final String regex) {
        return new FilenameFilter(){
            private Pattern pattern;
            {
                this.pattern = Pattern.compile(regex);
            }

            @Override
            public boolean accept(File dir, String name) {
                return this.pattern.matcher(new File(name).getName()).matches();
            }
        };
    }

    public static boolean compareDirs(String topDirPathname_struct1, String excludeListFile_struct1, boolean fileWithExcludePathnamesContainsRegex_struct1, String includeListFile_struct1, boolean fileWithIncludePathnamesContainsRegex_struct1, boolean linkDestAreRelativePaths_struct1, String topDirPathname_struct2, String excludeListFile_struct2, boolean fileWithExcludePathnamesContainsRegex_struct2, String includeListFile_struct2, boolean fileWithIncludePathnamesContainsRegex_struct2, boolean linkDestAreRelativePaths_struct2) throws RACTransWarningException, RACTransErrorException {
        File topDirectory_struct1 = null;
        if (topDirPathname_struct1 != null && !topDirPathname_struct1.equals("")) {
            topDirectory_struct1 = new File(topDirPathname_struct1);
        }
        File fileWithExcludePathnames_struct1 = null;
        if (excludeListFile_struct1 != null && !excludeListFile_struct1.equals("")) {
            fileWithExcludePathnames_struct1 = new File(excludeListFile_struct1);
        }
        File fileWithIncludePathnames_struct1 = null;
        if (includeListFile_struct1 != null && !includeListFile_struct1.equals("")) {
            fileWithIncludePathnames_struct1 = new File(includeListFile_struct1);
        }
        File topDirectory_struct2 = null;
        if (topDirPathname_struct2 != null && !topDirPathname_struct2.equals("")) {
            topDirectory_struct2 = new File(topDirPathname_struct2);
        }
        File fileWithExcludePathnames_struct2 = null;
        if (excludeListFile_struct2 != null && !excludeListFile_struct2.equals("")) {
            fileWithExcludePathnames_struct2 = new File(excludeListFile_struct2);
        }
        File fileWithIncludePathnames_struct2 = null;
        if (includeListFile_struct2 != null && !includeListFile_struct2.equals("")) {
            fileWithIncludePathnames_struct2 = new File(includeListFile_struct2);
        }
        return DirListing.compareDirStructures(topDirectory_struct1, fileWithExcludePathnames_struct1, fileWithExcludePathnamesContainsRegex_struct1, fileWithIncludePathnames_struct1, fileWithIncludePathnamesContainsRegex_struct1, linkDestAreRelativePaths_struct1, topDirectory_struct2, fileWithExcludePathnames_struct2, fileWithExcludePathnamesContainsRegex_struct1, fileWithIncludePathnames_struct2, fileWithIncludePathnamesContainsRegex_struct2, linkDestAreRelativePaths_struct2);
    }

    public static boolean compareDirStructures(File topDirectory_struct1, File fileWithExcludePathnames_struct1, boolean excludePathnamesCanBeRegex_struct1, File fileWithIncludePathnames_struct1, boolean includePathnamesCanBeRegex_struct1, boolean linkDestAreRelativePaths_struct1, File topDirectory_struct2, File fileWithExcludePathnames_struct2, boolean excludePathnamesCanBeRegex_struct2, File fileWithIncludePathnames_struct2, boolean includePathnamesCanBeRegex_struct2, boolean linkDestAreRelativePaths_struct2) throws RACTransWarningException, RACTransErrorException {
        String relativePath_struct2;
        String relativePath_struct1;
        if (topDirectory_struct1 == null || !topDirectory_struct1.exists()) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.FILE_NOT_FOUND, new Object[0]);
        }
        FileDescriptor topDir_struct1 = null;
        try {
            topDir_struct1 = new FileDescriptor(topDirectory_struct1.getAbsolutePath());
        }
        catch (FileNotFoundException fnfe) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.DIR_NOT_EXISTS, topDirectory_struct1.getName());
        }
        Map<DirListingConstants.PathType, List<String>> map2exclude_struct1 = null;
        if (fileWithExcludePathnames_struct1 != null && fileWithExcludePathnames_struct1.exists()) {
            map2exclude_struct1 = DirListing.extractPathnameMapFromFile(fileWithExcludePathnames_struct1, topDir_struct1.getAbsolutePath());
        }
        Map<DirListingConstants.PathType, List<String>> map2include_struct1 = null;
        if (fileWithIncludePathnames_struct1 != null && fileWithIncludePathnames_struct1.exists()) {
            map2include_struct1 = DirListing.extractPathnameMapFromFile(fileWithIncludePathnames_struct1, topDir_struct1.getAbsolutePath());
        }
        DirListing struct_1 = new DirListing(topDir_struct1, map2exclude_struct1, excludePathnamesCanBeRegex_struct1, map2include_struct1, includePathnamesCanBeRegex_struct1, linkDestAreRelativePaths_struct1);
        if (topDirectory_struct2 == null || !topDirectory_struct2.exists()) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.FILE_NOT_FOUND, new Object[0]);
        }
        FileDescriptor topDir_struct2 = null;
        try {
            topDir_struct2 = new FileDescriptor(topDirectory_struct2.getAbsolutePath());
        }
        catch (FileNotFoundException fnfe) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.DIR_NOT_EXISTS, topDirectory_struct2.getName());
        }
        Map<DirListingConstants.PathType, List<String>> map2exclude_struct2 = null;
        if (fileWithExcludePathnames_struct2 != null && fileWithExcludePathnames_struct2.exists()) {
            map2exclude_struct2 = DirListing.extractPathnameMapFromFile(fileWithExcludePathnames_struct2, topDir_struct2.getAbsolutePath());
        }
        Map<DirListingConstants.PathType, List<String>> map2include_struct2 = null;
        if (fileWithIncludePathnames_struct2 != null && fileWithIncludePathnames_struct2.exists()) {
            map2include_struct2 = DirListing.extractPathnameMapFromFile(fileWithIncludePathnames_struct2, topDir_struct2.getAbsolutePath());
        }
        DirListing struct_2 = new DirListing(topDir_struct2, map2exclude_struct2, excludePathnamesCanBeRegex_struct2, map2include_struct2, includePathnamesCanBeRegex_struct2, linkDestAreRelativePaths_struct2);
        Trace.out("Comparing the directories...");
        String topDirPath_struct1 = topDir_struct1.getPath();
        String topDirPath_struct2 = topDir_struct2.getPath();
        Trace.out("First directory: " + topDirPath_struct1);
        Trace.out("Second directory: " + topDirPath_struct2);
        struct_1.concatenateAllContents();
        struct_2.concatenateAllContents();
        SortedSet<FileDescriptor> dirs_struct1 = DirListing.sortByRelativePathname(struct_1.m_allDirs, topDirPath_struct1);
        SortedSet<FileDescriptor> dirs_struct2 = DirListing.sortByRelativePathname(struct_2.m_allDirs, topDirPath_struct2);
        if (dirs_struct1.size() != dirs_struct2.size()) {
            DirListing.debugDifference(dirs_struct1, topDirPath_struct1, dirs_struct2, topDirPath_struct2);
            return false;
        }
        Iterator dirItr_struct1 = dirs_struct1.iterator();
        Iterator dirItr_struct2 = dirs_struct2.iterator();
        while (dirItr_struct1.hasNext()) {
            String permissions_struct2;
            FileDescriptor dir_struct1 = (FileDescriptor)dirItr_struct1.next();
            FileDescriptor dir_struct2 = (FileDescriptor)dirItr_struct2.next();
            relativePath_struct1 = dir_struct1.getRelativePath(topDirPath_struct1);
            if (!relativePath_struct1.equals(relativePath_struct2 = dir_struct1.getRelativePath(topDirPath_struct1))) {
                Trace.out("Relative pathname mismatch: E.g. structure 1: '" + relativePath_struct1 + "' -- structure 2: '" + relativePath_struct2 + "'");
                DirListing.debugDifference(dirs_struct1, topDirPath_struct1, dirs_struct2, topDirPath_struct2);
                return false;
            }
            String permissions_struct1 = dir_struct1.getPermissions();
            if (permissions_struct1.equals(permissions_struct2 = dir_struct2.getPermissions())) continue;
            Trace.out("Permissions mismatch: E.g. for relative path '" + relativePath_struct1 + "' structure 1 permissions: " + permissions_struct1 + " -- structure 2 permissions : " + permissions_struct2);
            return false;
        }
        Trace.out("The directories match. Now comparing the files...");
        SortedSet<FileDescriptor> files_struct1 = DirListing.sortByRelativePathname(struct_1.m_allFiles, topDirPath_struct1);
        SortedSet<FileDescriptor> files_struct2 = DirListing.sortByRelativePathname(struct_2.m_allFiles, topDirPath_struct2);
        if (files_struct1.size() != files_struct2.size()) {
            DirListing.debugDifference(files_struct1, topDirPath_struct1, files_struct2, topDirPath_struct2);
            return false;
        }
        Iterator fileItr_struct1 = files_struct1.iterator();
        Iterator fileItr_struct2 = files_struct2.iterator();
        while (fileItr_struct1.hasNext()) {
            long fileSize_struct2;
            String permissions_struct2;
            FileDescriptor file_struct1 = (FileDescriptor)fileItr_struct1.next();
            FileDescriptor file_struct2 = (FileDescriptor)fileItr_struct2.next();
            relativePath_struct1 = file_struct1.getRelativePath(topDirPath_struct1);
            if (!relativePath_struct1.equals(relativePath_struct2 = file_struct2.getRelativePath(topDirPath_struct2))) {
                Trace.out("Relative pathname mismatch: E.g. structure 1: '" + relativePath_struct1 + "' -- structure 2: '" + relativePath_struct2 + "'");
                DirListing.debugDifference(files_struct1, topDirPath_struct1, files_struct2, topDirPath_struct2);
                return false;
            }
            String permissions_struct1 = file_struct1.getPermissions();
            if (!permissions_struct1.equals(permissions_struct2 = file_struct2.getPermissions())) {
                Trace.out("Permissions mismatch: E.g. for relative path '" + relativePath_struct1 + "' structure 1 permissions: " + permissions_struct1 + " -- structure 2 permissions : " + permissions_struct2);
                return false;
            }
            long fileSize_struct1 = file_struct1.length();
            if (fileSize_struct1 == (fileSize_struct2 = file_struct2.length())) continue;
            Trace.out("File size mismatch: E.g. for relative path '" + relativePath_struct1 + "' structure 1 file size: " + fileSize_struct1 + " -- structure 2 file size : " + fileSize_struct2);
            return false;
        }
        Trace.out("The files match. Comparing the symlinks...");
        SortedSet<FileDescriptor> symlinks_struct1 = DirListing.sortByRelativePathname(struct_1.m_allLinks, topDirPath_struct1);
        SortedSet<FileDescriptor> symlinks_struct2 = DirListing.sortByRelativePathname(struct_2.m_allLinks, topDirPath_struct2);
        if (symlinks_struct1.size() != symlinks_struct2.size()) {
            DirListing.debugDifference(symlinks_struct1, topDirPath_struct1, symlinks_struct2, topDirPath_struct2);
            return false;
        }
        Iterator symlinkItr_struct1 = symlinks_struct1.iterator();
        Iterator symlinkItr_struct2 = symlinks_struct2.iterator();
        while (symlinkItr_struct1.hasNext()) {
            String linkDestRelativePath_struct2;
            FileDescriptor symlink_struct1 = (FileDescriptor)symlinkItr_struct1.next();
            FileDescriptor symlink_struct2 = (FileDescriptor)symlinkItr_struct2.next();
            relativePath_struct1 = symlink_struct1.getRelativePath(topDirPath_struct1);
            if (!relativePath_struct1.equals(relativePath_struct2 = symlink_struct2.getRelativePath(topDirPath_struct2))) {
                Trace.out("Relative pathname mismatch: E.g. structure 1: '" + relativePath_struct1 + "' -- structure 2: '" + relativePath_struct2 + "'");
                DirListing.debugDifference(symlinks_struct1, topDirPath_struct1, symlinks_struct2, topDirPath_struct2);
                return false;
            }
            String linkDestRelativePath_struct1 = symlink_struct1.getLinkDestination();
            if (linkDestRelativePath_struct1.startsWith(topDirPath_struct1)) {
                linkDestRelativePath_struct1 = linkDestRelativePath_struct1.substring(topDirPath_struct1.length()).substring(1);
            }
            if ((linkDestRelativePath_struct2 = symlink_struct2.getLinkDestination()).startsWith(topDirPath_struct2)) {
                linkDestRelativePath_struct2 = linkDestRelativePath_struct2.substring(topDirPath_struct2.length()).substring(1);
            }
            if (linkDestRelativePath_struct1.equals(linkDestRelativePath_struct2)) continue;
            Trace.out("Symlink target mismatch: E.g. for relative path '" + relativePath_struct1 + "' structure 1 symlink relative destination: " + linkDestRelativePath_struct1 + "' -- structure 1 symlink relative destination: " + linkDestRelativePath_struct2);
            return false;
        }
        return true;
    }

    private static SortedSet<FileDescriptor> sortByRelativePathname(List<FileDescriptor> listOfFiles, final String referencePath) {
        TreeSet<FileDescriptor> sortedFiles = new TreeSet<FileDescriptor>(new Comparator<FileDescriptor>(){

            @Override
            public int compare(FileDescriptor file1, FileDescriptor file2) {
                String relativePath1 = file1.getRelativePath(referencePath);
                String relativePath2 = file2.getRelativePath(referencePath);
                return relativePath1.compareTo(relativePath2);
            }
        });
        for (FileDescriptor file : listOfFiles) {
            sortedFiles.add(file);
        }
        return sortedFiles;
    }

    private static String getAbsolutePath(String pathname, String topDirPathname) throws IOException {
        try {
            topDirPathname = new File(topDirPathname).getCanonicalPath();
        }
        catch (IOException ioe) {
            Trace.out("Cannot get the canonical path for the top-level directory.Therefore, using the initial path as top-level directory path \"" + topDirPathname + "\"");
        }
        if (topDirPathname.startsWith(pathname)) {
            return pathname;
        }
        if (!pathname.startsWith(topDirPathname) && !new File(pathname).getCanonicalPath().startsWith(new File(topDirPathname).getCanonicalPath())) {
            pathname = topDirPathname + File.separator + pathname;
            pathname = new File(pathname).getCanonicalPath();
        }
        return pathname;
    }

    private void generateListingRepresentation(DirStruct dir, int level) {
        ++level;
        List<FileDescriptor> dirList = dir.getChildDirs();
        for (int i = 0; i < dirList.size(); ++i) {
            FileDescriptor curr_dir = dirList.get(i);
            this.dir2string(curr_dir, level);
            DirStruct curr_dirStruct = this.m_directoryMap.getDirStruct(curr_dir);
            this.generateListingRepresentation(curr_dirStruct, level);
            this.addEndDirInfoToListing(level);
        }
        List<FileDescriptor> fileList = dir.getChildFiles();
        for (int i = 0; i < fileList.size(); ++i) {
            FileDescriptor curr_file = fileList.get(i);
            this.file2string(curr_file, level);
        }
        List<FileDescriptor> linkList = dir.getChildLinks();
        for (int i = 0; i < linkList.size(); ++i) {
            FileDescriptor curr_link = linkList.get(i);
            this.link2string(curr_link, level);
        }
    }

    private void dir2string(FileDescriptor dirDescriptor, int level) {
        String name = "";
        if (this.m_pathFormat == PathFormat.ABSOLUTE_PATH) {
            name = dirDescriptor.getPath();
        } else if (this.m_pathFormat == PathFormat.RELATIVE_PATH) {
            if (!dirDescriptor.equals(this.m_directoryMap.getTopDir())) {
                String topDirPath = this.getTopDirPath();
                name = dirDescriptor.getRelativePath(topDirPath);
            }
        } else if (this.m_pathFormat == PathFormat.LEVELED_PATH) {
            name = dirDescriptor.getName();
        }
        if (m_tagsEnabled) {
            this.m_listingString = this.m_listingString + this.addTabs(level) + DirListingConstants.DIR_OPEN_TAG;
        }
        this.m_listingString = !DirListingConstants.IS_WINDOWS_OS ? this.m_listingString + this.getFormat(name, "NAME", DirListingConstants.FileType.DIR, level) + this.getFormat(String.valueOf(dirDescriptor.getPermissions()), "PERMISSIONS", DirListingConstants.FileType.DIR, level) + this.getFormat(String.valueOf(dirDescriptor.getOwnerID()), "OWNER_ID", DirListingConstants.FileType.DIR, level) + this.getFormat(String.valueOf(dirDescriptor.getGroupID()), "GROUP_ID", DirListingConstants.FileType.DIR, level) + this.getFormat(String.valueOf(dirDescriptor.length()), "SIZE", DirListingConstants.FileType.DIR, level) : this.m_listingString + this.getFormat(name, "NAME", DirListingConstants.FileType.DIR, level);
    }

    private void file2string(FileDescriptor fileDescriptor, int level) {
        String name = "";
        if (this.m_pathFormat == PathFormat.ABSOLUTE_PATH) {
            name = fileDescriptor.getPath();
        } else if (this.m_pathFormat == PathFormat.RELATIVE_PATH) {
            String topDirPath = this.getTopDirPath();
            name = fileDescriptor.getRelativePath(topDirPath);
        } else if (this.m_pathFormat == PathFormat.LEVELED_PATH) {
            name = fileDescriptor.getName();
        }
        if (m_tagsEnabled) {
            this.m_listingString = this.m_listingString + this.addTabs(level) + DirListingConstants.FILE_OPEN_TAG;
        }
        this.m_listingString = !DirListingConstants.IS_WINDOWS_OS ? this.m_listingString + this.getFormat(name, "NAME", DirListingConstants.FileType.FILE, level) + this.getFormat(String.valueOf(fileDescriptor.getPermissions()), "PERMISSIONS", DirListingConstants.FileType.FILE, level) + this.getFormat(String.valueOf(fileDescriptor.getOwnerID()), "OWNER_ID", DirListingConstants.FileType.FILE, level) + this.getFormat(String.valueOf(fileDescriptor.getGroupID()), "GROUP_ID", DirListingConstants.FileType.FILE, level) + this.getFormat(String.valueOf(fileDescriptor.length()), "SIZE", DirListingConstants.FileType.FILE, level) : this.m_listingString + this.getFormat(name, "NAME", DirListingConstants.FileType.FILE, level) + this.getFormat(String.valueOf(fileDescriptor.length()), "SIZE", DirListingConstants.FileType.FILE, level);
        if (m_tagsEnabled) {
            this.m_listingString = this.m_listingString + this.addTabs(level) + DirListingConstants.FILE_CLOSE_TAG;
        }
    }

    private void link2string(FileDescriptor link, int level) {
        String name = "";
        String linkDestination = link.getLinkDestination();
        if (this.m_pathFormat == PathFormat.ABSOLUTE_PATH) {
            name = link.getPath();
        } else if (this.m_pathFormat == PathFormat.RELATIVE_PATH) {
            String topDirPath = this.getTopDirPath();
            name = link.getRelativePath(topDirPath);
            linkDestination = linkDestination.substring(topDirPath.length()).substring(1);
        } else if (this.m_pathFormat == PathFormat.LEVELED_PATH) {
            String topDirPath = this.getTopDirPath();
            name = link.getName();
            linkDestination = linkDestination.substring(topDirPath.length()).substring(1);
        }
        if (m_tagsEnabled) {
            this.m_listingString = this.m_listingString + this.addTabs(level) + DirListingConstants.LINK_OPEN_TAG;
        }
        if (!DirListingConstants.IS_WINDOWS_OS) {
            this.m_listingString = this.m_listingString + this.getFormat(name, "NAME", DirListingConstants.FileType.LINK, level) + this.getFormat(linkDestination, "POINTEE", DirListingConstants.FileType.LINK, level) + this.getFormat(String.valueOf(link.getPermissions()), "PERMISSIONS", DirListingConstants.FileType.LINK, level) + this.getFormat(String.valueOf(link.getOwnerID()), "OWNER_ID", DirListingConstants.FileType.LINK, level) + this.getFormat(String.valueOf(link.getGroupID()), "GROUP_ID", DirListingConstants.FileType.LINK, level) + this.getFormat(String.valueOf(link.length()), "SIZE", DirListingConstants.FileType.LINK, level);
        }
        if (m_tagsEnabled) {
            this.m_listingString = this.m_listingString + this.addTabs(level) + DirListingConstants.LINK_CLOSE_TAG;
        }
    }

    private void addEndDirInfoToListing(int level) {
        if (m_tagsEnabled) {
            this.m_listingString = this.m_listingString + this.addTabs(level) + DirListingConstants.DIR_CLOSE_TAG;
        }
    }

    private String addTabs(int level) {
        String tabs = "";
        for (int i = 0; i < level; ++i) {
            tabs = tabs + "    ";
        }
        return tabs;
    }

    private String getFormat(String info, String tagName, DirListingConstants.FileType type, int level) {
        String tabs = "";
        if (m_tabsEnabled) {
            tabs = this.addTabs(level);
        }
        if (m_tagsEnabled) {
            switch (type) {
                case DIR: {
                    return tabs + "    " + "<DIR-" + tagName + ">" + info + "</DIR-" + tagName + ">" + DirListingConstants.NEW_LINE;
                }
                case FILE: {
                    return tabs + "    " + "<FILE-" + tagName + ">" + info + "</FILE-" + tagName + ">" + DirListingConstants.NEW_LINE;
                }
                case LINK: {
                    return tabs + "    " + "<LINK-" + tagName + ">" + info + "</LINK-" + tagName + ">" + DirListingConstants.NEW_LINE;
                }
            }
            return null;
        }
        switch (type) {
            case DIR: {
                if (tagName.equals("NAME")) {
                    return DirListingConstants.NEW_LINE + tabs + "DIR: " + info + DirListingConstants.NEW_LINE;
                }
                return tabs + tabs + "DIR-" + tagName + ": " + info + DirListingConstants.NEW_LINE;
            }
            case FILE: {
                if (tagName.equals("NAME")) {
                    return DirListingConstants.NEW_LINE + tabs + "FILE: " + info + DirListingConstants.NEW_LINE;
                }
                return tabs + tabs + "FILE-" + tagName + ": " + info + DirListingConstants.NEW_LINE;
            }
            case LINK: {
                if (tagName.equals("NAME")) {
                    return DirListingConstants.NEW_LINE + tabs + "LINK: " + info + DirListingConstants.NEW_LINE;
                }
                return tabs + tabs + "LINK-" + tagName + ": " + info + DirListingConstants.NEW_LINE;
            }
        }
        return null;
    }

    private static void debugDifference(SortedSet<FileDescriptor> files_struct1, String referencePath_struct1, SortedSet<FileDescriptor> files_struct2, String referencePath_struct2) {
        int size2;
        int size1 = files_struct1.size();
        if (size1 != (size2 = files_struct2.size())) {
            Trace.out("The are " + size1 + " directories/files for structure 1 whereas there are " + size2 + " directories/files for structure 2");
        }
        StringBuilder details = new StringBuilder();
        details.append("Relative path names for structure 1:" + DirListingConstants.NEW_LINE);
        for (FileDescriptor file : files_struct1) {
            details.append("  -->" + file.getRelativePath(referencePath_struct1) + DirListingConstants.NEW_LINE);
        }
        details.append("-----------------------" + DirListingConstants.NEW_LINE);
        details.append("Relative path names for structure 2:" + DirListingConstants.NEW_LINE);
        for (FileDescriptor file : files_struct2) {
            details.append("  -->" + file.getRelativePath(referencePath_struct2) + DirListingConstants.NEW_LINE);
        }
        details.append("-----------------------" + DirListingConstants.NEW_LINE);
        Trace.out(details.toString());
    }

    static enum PathFormat {
        RELATIVE_PATH,
        ABSOLUTE_PATH,
        LEVELED_PATH;

    }
}

