/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import oracle.cluster.deployment.ractrans.ClientHandlerSupervisor;
import oracle.cluster.deployment.ractrans.RACTransferConstants;

public class ConnectionInfo {
    private ClientHandlerSupervisor m_clientHandlerSupervisor;
    private int m_serverPort;
    private InetAddress m_serverHostOrIPAddress;
    private int m_clientPort;
    private BufferedReader m_streamComingFromServer;
    private RACTransferConstants.Connection m_connectionStatus;
    private int m_nodeID;
    private String m_nodeName;
    private List<String> m_errorLog;

    protected ConnectionInfo(ClientHandlerSupervisor clientHandlerSupervisor, int nodeID, String nodeName, Socket socketToServer) {
        this.m_clientHandlerSupervisor = clientHandlerSupervisor;
        this.m_nodeID = nodeID;
        this.m_nodeName = nodeName;
        this.m_errorLog = new ArrayList<String>();
        String commonWarningMsg = this.m_clientHandlerSupervisor.getCommonWarningMsg();
        if (commonWarningMsg != null && !commonWarningMsg.trim().equals("")) {
            this.m_errorLog.add(commonWarningMsg);
        }
        this.m_serverHostOrIPAddress = socketToServer.getInetAddress();
        SocketAddress serverSocketAddress = socketToServer.getRemoteSocketAddress();
        String serverSocketAddressString = serverSocketAddress.toString().trim();
        serverSocketAddressString = serverSocketAddressString.substring(serverSocketAddressString.lastIndexOf(58) + 1, serverSocketAddressString.length());
        try {
            this.m_serverPort = Integer.parseInt(serverSocketAddressString);
        }
        catch (NumberFormatException nfe) {
            this.m_serverPort = -1;
        }
        SocketAddress clientSocketAddress = socketToServer.getLocalSocketAddress();
        String clientSocketAddressString = clientSocketAddress.toString().trim();
        clientSocketAddressString = clientSocketAddressString.substring(clientSocketAddressString.lastIndexOf(58) + 1, clientSocketAddressString.length());
        try {
            this.m_clientPort = Integer.parseInt(clientSocketAddressString);
        }
        catch (NumberFormatException nfe) {
            this.m_clientPort = -1;
        }
        try {
            this.m_streamComingFromServer = new BufferedReader(new InputStreamReader(socketToServer.getInputStream()));
        }
        catch (IOException ioe) {
            this.m_streamComingFromServer = null;
        }
        this.m_connectionStatus = this.m_streamComingFromServer != null && this.m_clientPort != -1 ? RACTransferConstants.Connection.CONNECTION_ALIVE : RACTransferConstants.Connection.CONNECTION_LOST;
    }

    protected void setStatus(RACTransferConstants.Connection connectionStatus) {
        this.m_connectionStatus = connectionStatus;
    }

    protected void setNodeID(int nodeID) {
        this.m_nodeID = nodeID;
    }

    protected void setNodeName(String nodeName) {
        this.m_nodeName = nodeName;
    }

    protected void appendErrorLog(String errorMsg) {
        this.m_errorLog.add(errorMsg);
    }

    protected int getServerPort() {
        return this.m_serverPort;
    }

    protected String getServerHostName() {
        return this.m_serverHostOrIPAddress.getHostName();
    }

    protected String getServerIPAddress() {
        return this.m_serverHostOrIPAddress.getHostAddress();
    }

    protected int getClientPort() {
        return this.m_clientPort;
    }

    protected String getConnectionDescription() {
        return "Server Port       : " + this.m_serverPort + RACTransferConstants.NEW_LINE + "Server IP Address : " + this.getServerHostName() + RACTransferConstants.NEW_LINE + "Server Host Name  : " + this.getServerIPAddress() + RACTransferConstants.NEW_LINE + "Client Port       : " + this.getClientPort() + RACTransferConstants.NEW_LINE + "Connection Status : " + this.getStatusStr() + RACTransferConstants.NEW_LINE + "Node ID           : " + this.getNodeID();
    }

    protected String getStatusStr() {
        return this.m_connectionStatus.toString();
    }

    protected RACTransferConstants.Connection getStatus() {
        return this.m_connectionStatus;
    }

    protected int getNodeID() {
        return this.m_nodeID;
    }

    protected String getNodeName() {
        return this.m_nodeName;
    }

    protected String[] getErrorLog() {
        return this.m_errorLog.toArray(new String[0]);
    }
}

