/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import oracle.cluster.deployment.ractrans.ClientHandler;
import oracle.cluster.deployment.ractrans.ConnectionInfo;
import oracle.cluster.deployment.ractrans.DirListing;
import oracle.cluster.deployment.ractrans.FileDescriptor;
import oracle.cluster.deployment.ractrans.NodeRegistryModel;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.deployment.ractrans.RACTransWarningException;
import oracle.cluster.deployment.ractrans.RACTransferConstants;
import oracle.cluster.deployment.ractrans.RapidTransfer;
import oracle.cluster.deployment.ractrans.RemoteFileOpException;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ClientHandlerSupervisor {
    private final String m_msgFormat = "Warning! This is a non-expected exception (i.e., if triggered it's a bug).\nWho threw the exception: {0} encountered InterruptedException while {1}";
    private NodeRegistryModel m_nodeRegistryModel;
    private String m_commonWarningMsg;
    private int m_numOfNodes;
    private ClientHandler[] m_clientHandler;
    private Semaphore m_establishedAllConnections;
    private Semaphore m_canConnect;
    private Semaphore[] m_canSendMkdirCommand;
    private Semaphore[] m_canSendMklinkCommand;
    private boolean[] m_successfulCmdExecution;
    private boolean[] m_connectionAlive;
    private ConnectionInfo[] m_connectionInfoArray;
    private int m_nextNodeID;
    private int m_lastConnectedNodeID;
    private ArrayList<Integer> m_connectionLostNodeIDList;
    private Object m_connectionLostNodeIDList_lock;
    private Semaphore m_canAccessNextNodeID;
    private final RapidTransfer m_transferProgressMonitor;

    protected ClientHandlerSupervisor(RapidTransfer transferProgressMonitor, NodeRegistryModel nodeRegistryModel, int numOfNodes, String commonWarningMsg) {
        this.m_transferProgressMonitor = transferProgressMonitor;
        this.m_nodeRegistryModel = nodeRegistryModel;
        this.m_numOfNodes = numOfNodes;
        this.m_commonWarningMsg = commonWarningMsg;
        this.m_nextNodeID = 0;
        this.m_canConnect = new Semaphore(1);
        this.m_establishedAllConnections = new Semaphore(-numOfNodes + 1);
        this.m_clientHandler = new ClientHandler[this.m_numOfNodes];
        this.m_connectionInfoArray = new ConnectionInfo[this.m_numOfNodes];
        this.m_connectionLostNodeIDList = new ArrayList(numOfNodes);
        this.m_connectionLostNodeIDList_lock = new Object();
        this.m_successfulCmdExecution = new boolean[numOfNodes];
        this.m_connectionAlive = new boolean[numOfNodes];
        this.m_canSendMkdirCommand = new Semaphore[numOfNodes];
        this.m_canSendMklinkCommand = new Semaphore[numOfNodes];
        for (int i = 0; i < numOfNodes; ++i) {
            this.m_successfulCmdExecution[i] = true;
            this.m_connectionAlive[i] = true;
            this.m_canSendMkdirCommand[i] = new Semaphore(1);
            this.m_canSendMklinkCommand[i] = new Semaphore(0);
        }
        this.m_canAccessNextNodeID = new Semaphore(1);
    }

    protected void connectToServer(InetAddress hostNameOrIP, int port, String nodeName) throws RACTransWarningException {
        int nodeID;
        try {
            this.m_canConnect.acquire();
        }
        catch (InterruptedException ie) {
            Trace.out(MessageFormat.format("Warning! This is a non-expected exception (i.e., if triggered it's a bug).\nWho threw the exception: {0} encountered InterruptedException while {1}", "ClientHandlerSupervisor", "acquiring the permit to connect a renote node."));
        }
        try {
            this.m_canAccessNextNodeID.acquire();
            nodeID = this.m_nextNodeID;
            Trace.out("Acquired the semaphore to access the next node ID. Value of m_nextNodeID = " + this.m_nextNodeID);
        }
        catch (InterruptedException ie) {
            Trace.out("Encountered unexpected interrupted exception while trying to acquire the lock to connect to node \"" + nodeName + "\"");
            this.m_canAccessNextNodeID.release();
            Trace.out("Released semaphore m_canAccessNextNodeID.");
            this.m_canConnect.release();
            Trace.out("Released semaphore m_canConnect.");
            throw new RACTransWarningException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre005");
        }
        try {
            ClientHandler clientHandler;
            this.m_clientHandler[nodeID] = clientHandler = new ClientHandler(this, hostNameOrIP, port, nodeID, nodeName);
        }
        catch (RACTransWarningException warning) {
            this.m_canAccessNextNodeID.release();
            Trace.out("Released semaphore m_canAccessNextNodeID.");
            this.m_canConnect.release();
            Trace.out("Released semaphore m_canConnect.");
            throw warning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectionEstablished(ConnectionInfo connectionInfo) {
        int nodeID;
        if (this.m_connectionLostNodeIDList.isEmpty()) {
            nodeID = this.m_nextNodeID++;
            this.m_nextNodeID %= this.m_numOfNodes;
        } else {
            Object object = this.m_connectionLostNodeIDList_lock;
            synchronized (object) {
                nodeID = this.m_connectionLostNodeIDList.remove(0);
            }
        }
        connectionInfo.setNodeID(nodeID);
        Trace.out("Connection established to node \"" + connectionInfo.getNodeName() + "\"");
        this.m_connectionInfoArray[nodeID] = connectionInfo;
        Trace.out(" ==> (m_connectionInfoArray[" + nodeID + "] != null) ? ---> " + (this.m_connectionInfoArray[nodeID] != null));
        this.m_nodeRegistryModel.setNodeStatus(nodeID, connectionInfo.getStatus());
        this.m_lastConnectedNodeID = nodeID;
        Trace.out("Connection details: " + connectionInfo.getConnectionDescription());
        this.m_canAccessNextNodeID.release();
        Trace.out("Released semaphore m_canAccessNextNodeID.");
        this.m_canConnect.release();
        Trace.out("Released semaphore m_canConnect.");
        Trace.out("- - - - - - - - - - - - - - - - - - - - - - - - - - - -");
        this.m_establishedAllConnections.release();
        Trace.out("Released semaphore m_establishedAllConnections");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectionLost(ConnectionInfo connectionInfo) {
        int nodeID = connectionInfo.getNodeID();
        Object object = this.m_connectionLostNodeIDList_lock;
        synchronized (object) {
            this.m_connectionLostNodeIDList.add(nodeID);
        }
        connectionInfo.setNodeID(-1);
        this.m_nodeRegistryModel.setNodeStatus(nodeID, RACTransferConstants.Connection.CONNECTION_LOST);
    }

    protected void updateConnectionInfo(int nodeID, ConnectionInfo connectionInfo) {
        this.m_nodeRegistryModel.setNodeStatus(nodeID, connectionInfo.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(int nodeID) {
        if (this.m_clientHandler[nodeID] != null) {
            this.m_clientHandler[nodeID].closeSocket();
            Object object = this.m_connectionLostNodeIDList_lock;
            synchronized (object) {
                this.m_connectionLostNodeIDList.add(nodeID);
            }
            ConnectionInfo connectionInfo = this.m_connectionInfoArray[nodeID];
            if (connectionInfo != null) {
                connectionInfo.setNodeID(-1);
                this.m_nodeRegistryModel.setNodeStatus(nodeID, RACTransferConstants.Connection.CONNECTION_LOST);
            }
        }
    }

    protected void closeMostRecentConnection() {
        this.closeConnection(this.m_lastConnectedNodeID);
    }

    protected void closeAllConnections() {
        for (int nodeID = 0; nodeID < this.m_numOfNodes; ++nodeID) {
            this.closeConnection(nodeID);
        }
        this.m_nextNodeID = 0;
        this.m_connectionLostNodeIDList.clear();
    }

    protected void sendSinglePacketCommandToNode(int nodeID, byte[] dataOut) throws RACTransErrorException {
        try {
            this.m_clientHandler[nodeID].send_singlePacket(dataOut);
        }
        catch (RACTransErrorException rtee) {
            String command = new String(dataOut);
            Trace.out("Error sending command \"" + command + "\". Details:" + RACTransferConstants.NEW_LINE + rtee.getMessage());
            throw new RACTransErrorException((MessageKey)PrCfMsgID.COMMAND_SEND_ERROR, command, rtee.getMessage());
        }
    }

    protected void sendMultiPacketCommandToNode(int nodeID, byte[] fileWrapper) throws RACTransErrorException {
        this.m_clientHandler[nodeID].send_multiPacket(fileWrapper);
    }

    protected void sendMultiPacketCommandToNode(int nodeID, FileDescriptor file) throws RACTransErrorException {
        try {
            this.m_clientHandler[nodeID].send_multiPacket(file);
        }
        catch (RACTransErrorException rtee) {
            String filePathame = file.getPath();
            Trace.out("Error sending file \"" + filePathame + "\". Details:" + RACTransferConstants.NEW_LINE + rtee.getMessage());
            throw new RACTransErrorException((MessageKey)PrCfMsgID.FILE_SEND_ERROR, filePathame, rtee.getMessage());
        }
        if (this.m_transferProgressMonitor != null) {
            long deltaEffectiveProcessedSize = file.length() + 629145L;
            this.m_transferProgressMonitor.incrementTransferredEffectiveFileSize(deltaEffectiveProcessedSize);
        }
    }

    private void sendCommandToNode(int nodeID, List<String> commandList, String command) throws RACTransErrorException {
        if (!command.equals("mkdir") && !command.equals("mklink")) {
            Trace.out("Command \"" + command + "\" is unknown.\n" + "Valid commands: i) \"" + "mkdir" + "\" or ii) \"" + "mklink" + "\".");
            return;
        }
        if (!commandList.isEmpty()) {
            int commandListSize = commandList.size();
            String dataOutString = "<" + command.length() + ">" + command + commandList.get(0);
            if (commandListSize == 1) {
                dataOutString = dataOutString + "<0>";
                this.sendSinglePacketCommandToNode(nodeID, dataOutString.getBytes());
            } else {
                this.sendSinglePacketCommandToNode(nodeID, dataOutString.getBytes());
                for (int i = 1; i < commandListSize - 1; ++i) {
                    dataOutString = commandList.get(i);
                    this.sendSinglePacketCommandToNode(nodeID, dataOutString.getBytes());
                }
                dataOutString = commandList.get(commandListSize - 1) + "<0>";
                this.sendSinglePacketCommandToNode(nodeID, dataOutString.getBytes());
            }
        }
    }

    protected void broadcastCommand(DirListing dirListing, String command, String[] linkDestPathPrefix) {
        final Semaphore finished = new Semaphore(-this.m_numOfNodes + 1);
        for (int nodeID = 0; nodeID < this.m_numOfNodes; ++nodeID) {
            final String innerCommand = command;
            final int innerNodeID = nodeID;
            final DirListing innerDirListing = dirListing;
            final String innerLinkDestPathPrefix = linkDestPathPrefix[nodeID];
            if (!this.m_nodeRegistryModel.getConnectionStatus(nodeID).equals((Object)RACTransferConstants.Connection.CONNECTION_ALIVE)) continue;
            new Thread(){

                @Override
                public void run() {
                    if (ClientHandlerSupervisor.this.m_connectionAlive[innerNodeID]) {
                        if (innerCommand.equals("mkdir")) {
                            try {
                                ClientHandlerSupervisor.this.m_canSendMkdirCommand[innerNodeID].acquire();
                            }
                            catch (InterruptedException ie) {
                                Trace.out(MessageFormat.format("Warning! This is a non-expected exception (i.e., if triggered it's a bug).\nWho threw the exception: {0} encountered InterruptedException while {1}", "ClientHandlerSupervisor", "acquiring the permit to send mkdir command to node \"" + ClientHandlerSupervisor.this.m_connectionInfoArray[innerNodeID].getNodeName() + "\"."));
                            }
                            List<String> mkdirCommandList = innerDirListing.getListing_mkdirCommandList();
                            try {
                                ClientHandlerSupervisor.this.sendCommandToNode(innerNodeID, mkdirCommandList, innerCommand);
                            }
                            catch (RACTransErrorException ree) {
                                ((ClientHandlerSupervisor)ClientHandlerSupervisor.this).m_connectionAlive[innerNodeID] = false;
                                ClientHandlerSupervisor.this.appendErrorLog(innerNodeID, ree.getMessage());
                            }
                            ClientHandlerSupervisor.this.m_canSendMklinkCommand[innerNodeID].release();
                        } else if (innerCommand.equals("mklink")) {
                            try {
                                ClientHandlerSupervisor.this.m_canSendMklinkCommand[innerNodeID].acquire();
                            }
                            catch (InterruptedException ie) {
                                Trace.out(MessageFormat.format("Warning! This is a non-expected exception (i.e., if triggered it's a bug).\nWho threw the exception: {0} encountered InterruptedException while {1}", "ClientHandlerSupervisor", "acquiring the permit to send mklink command to node \"" + ClientHandlerSupervisor.this.m_connectionInfoArray[innerNodeID].getNodeName() + "\"."));
                            }
                            List<String> mklinkCommandList = innerDirListing.getListing_mklinkCommandList(innerLinkDestPathPrefix);
                            try {
                                ClientHandlerSupervisor.this.sendCommandToNode(innerNodeID, mklinkCommandList, innerCommand);
                            }
                            catch (RACTransErrorException ree) {
                                ((ClientHandlerSupervisor)ClientHandlerSupervisor.this).m_connectionAlive[innerNodeID] = false;
                                ClientHandlerSupervisor.this.appendErrorLog(innerNodeID, ree.getMessage());
                            }
                            finished.release();
                        }
                    }
                }
            }.start();
        }
        if (command.equals("mklink")) {
            try {
                finished.acquire();
            }
            catch (InterruptedException ie) {
                Trace.out(MessageFormat.format("Warning! This is a non-expected exception (i.e., if triggered it's a bug).\nWho threw the exception: {0} encountered InterruptedException while {1}", "ClientHandlerSupervisor", "while waiting for all nodes to finish receiving and executing the mkdir and mklink commands"));
            }
            for (int nodeID = 0; nodeID < this.m_numOfNodes; ++nodeID) {
                Trace.out("   m_connectionInfoArray[" + nodeID + "] != null -->" + (this.m_connectionInfoArray[nodeID] != null));
                this.m_connectionInfoArray[nodeID].setStatus(RACTransferConstants.Connection.SENDING_DATA);
                this.updateConnectionInfo(nodeID, this.m_connectionInfoArray[nodeID]);
            }
        }
    }

    private void sendDataToNode(int nodeID, List<FileDescriptor> fileList, String topLevelDirPathname) throws RACTransErrorException {
        int indexOfFirstExistingFile;
        int fileListSize = fileList.size();
        for (indexOfFirstExistingFile = 0; indexOfFirstExistingFile < fileListSize && !fileList.get(indexOfFirstExistingFile).exists(); ++indexOfFirstExistingFile) {
            Trace.out("While sending the data to node " + this.m_connectionInfoArray[nodeID].getNodeName() + " file \"" + fileList.get(indexOfFirstExistingFile).getPath() + "\" was no longer present on the local node");
        }
        if (indexOfFirstExistingFile < fileListSize) {
            byte[] commandPrefix = RACTransferConstants.WRFILE_IDENTIFIER.getBytes();
            FileDescriptor fileToSend = fileList.get(indexOfFirstExistingFile);
            byte[] fileDescriptionBytes = this.getFileDescriptionBytes(fileToSend, topLevelDirPathname);
            ByteBuffer byteBuffer = ByteBuffer.allocate(commandPrefix.length + fileDescriptionBytes.length);
            byteBuffer.put(commandPrefix);
            byteBuffer.put(fileDescriptionBytes);
            try {
                this.sendMultiPacketCommandToNode(nodeID, byteBuffer.array());
            }
            catch (RACTransErrorException rtee) {
                String command = new String(byteBuffer.array());
                Trace.out("Error sending command \"" + command + "\". Details:" + RACTransferConstants.NEW_LINE + rtee.getMessage());
                throw new RACTransErrorException((MessageKey)PrCfMsgID.COMMAND_SEND_ERROR, command, rtee.getMessage());
            }
            if (RACTransferConstants.VERBOSE_TRACING) {
                Trace.out("Sending file \"" + fileToSend.getName() + "\" to node \"" + this.m_connectionInfoArray[nodeID].getNodeName() + "\"");
            }
            this.sendMultiPacketCommandToNode(nodeID, fileToSend);
            if (indexOfFirstExistingFile == fileListSize - 1) {
                byte[] endOfWrfile = "<0>".getBytes();
                try {
                    this.sendMultiPacketCommandToNode(nodeID, endOfWrfile);
                }
                catch (RACTransErrorException rtee) {
                    String command = new String(endOfWrfile);
                    Trace.out("Error sending command \"" + command + "\". Details:" + RACTransferConstants.NEW_LINE + rtee.getMessage());
                    throw new RACTransErrorException((MessageKey)PrCfMsgID.COMMAND_SEND_ERROR, command, rtee.getMessage());
                }
            }
            for (int i = indexOfFirstExistingFile + 1; i < fileListSize; ++i) {
                if (fileList.get(i).exists()) {
                    fileToSend = fileList.get(i);
                    fileDescriptionBytes = this.getFileDescriptionBytes(fileToSend, topLevelDirPathname);
                    byteBuffer = ByteBuffer.allocate(fileDescriptionBytes.length);
                    byteBuffer.put(fileDescriptionBytes);
                    this.sendMultiPacketCommandToNode(nodeID, byteBuffer.array());
                    if (RACTransferConstants.VERBOSE_TRACING) {
                        Trace.out("Sending file \"" + fileToSend.getName() + "\" to node \"" + this.m_connectionInfoArray[nodeID].getNodeName() + "\"");
                    }
                    this.sendMultiPacketCommandToNode(nodeID, fileToSend);
                    continue;
                }
                Trace.out("While sending the data to node " + this.m_connectionInfoArray[nodeID].getNodeName() + " file \"" + fileToSend.getPath() + "\" was no longer present on the local node");
            }
            if (RACTransferConstants.VERBOSE_TRACING) {
                Trace.out("Sending EOC to node \"" + this.m_connectionInfoArray[nodeID].getNodeName() + "\".");
            }
            byte[] endOfWrfile = "<0><4>quit".getBytes();
            try {
                this.sendMultiPacketCommandToNode(nodeID, endOfWrfile);
            }
            catch (RACTransErrorException rtee) {
                String command = new String(endOfWrfile);
                Trace.out("Error sending command \"" + command + "\". Details:" + RACTransferConstants.NEW_LINE + rtee.getMessage());
                throw new RACTransErrorException((MessageKey)PrCfMsgID.COMMAND_SEND_ERROR, command, rtee.getMessage());
            }
        }
    }

    protected void broadcastData(final List<FileDescriptor> fileList, final String topDirPath) {
        final Semaphore finished = new Semaphore(-this.m_numOfNodes + 1);
        for (int nodeID = 0; nodeID < this.m_numOfNodes; ++nodeID) {
            final int innerNodeID = nodeID;
            if (!this.m_nodeRegistryModel.getConnectionStatus(nodeID).equals((Object)RACTransferConstants.Connection.SENDING_DATA)) continue;
            new Thread(){

                @Override
                public void run() {
                    if (ClientHandlerSupervisor.this.m_connectionAlive[innerNodeID]) {
                        try {
                            ClientHandlerSupervisor.this.sendDataToNode(innerNodeID, fileList, topDirPath);
                        }
                        catch (RACTransErrorException ree) {
                            ((ClientHandlerSupervisor)ClientHandlerSupervisor.this).m_connectionAlive[innerNodeID] = false;
                            ClientHandlerSupervisor.this.appendErrorLog(innerNodeID, ree.getMessage());
                        }
                    }
                    finished.release();
                }
            }.start();
        }
        try {
            finished.acquire();
        }
        catch (InterruptedException ie) {
            Trace.out(MessageFormat.format("Warning! This is a non-expected exception (i.e., if triggered it's a bug).\nWho threw the exception: {0} encountered InterruptedException while {1}", "ClientHandlerSupervisor", "while waiting for all nodes to finish receiving and storing the actual file data (i.e., wrfile command)"));
        }
    }

    protected void checkForErrors() throws RemoteFileOpException {
        boolean allCommandsSuccessfullyExecutedOnAllNodes = true;
        NativeResult[] result = new NativeResult[this.m_numOfNodes];
        Trace.out("--- TRANSFER_RESULTS ---");
        for (int nodeID = 0; nodeID < this.m_numOfNodes; ++nodeID) {
            result[nodeID] = this.getRemoteNodeResult(nodeID);
            if (result[nodeID].getStatus()) continue;
            allCommandsSuccessfullyExecutedOnAllNodes = false;
        }
        if (!allCommandsSuccessfullyExecutedOnAllNodes) {
            String msg = MessageBundle.getMessageBundle(PrCfMsgID.facility).getMessage(PrCfMsgID.COMMAND_ERROR_NOTIFICATION, true);
            throw new RemoteFileOpException(msg, result);
        }
    }

    protected Semaphore getAllConnectionsBarrierSemaphore() {
        return this.m_establishedAllConnections;
    }

    private NativeResult getRemoteNodeResult(int nodeID) {
        NativeResult result = new NativeResult();
        String[] errorLog = this.m_connectionInfoArray[nodeID].getErrorLog();
        String nodeName = this.m_connectionInfoArray[nodeID].getNodeName();
        StringBuilder report = new StringBuilder();
        MessageBundle msgBundle = MessageBundle.getMessageBundle(PrCfMsgID.facility);
        report.append(MessageBundle.getMessage(PrCfMsgID.NODE_NAME, false, nodeName));
        if (errorLog != null && errorLog.length > 0) {
            result.setStatus(false);
            result.setNodeName(nodeName);
            result.setOSString(errorLog);
            this.m_connectionInfoArray[nodeID].setStatus(RACTransferConstants.Connection.UNSUCCESSFUL_TRANSFER);
            this.updateConnectionInfo(nodeID, this.m_connectionInfoArray[nodeID]);
            report.append(" -- " + msgBundle.getMessage(PrCfMsgID.ERRORS, false) + ':' + RACTransferConstants.NEW_LINE);
            for (String error : errorLog) {
                report.append("        " + error + RACTransferConstants.NEW_LINE);
            }
        } else {
            result.setStatus(true);
            result.setNodeName(nodeName);
            this.m_connectionInfoArray[nodeID].setStatus(RACTransferConstants.Connection.SUCCESSFUL_TRANSFER);
            this.updateConnectionInfo(nodeID, this.m_connectionInfoArray[nodeID]);
            report.append(" -- Sucess");
            report.append(" -- " + msgBundle.getMessage(PrCfMsgID.SUCCESS, false));
        }
        Trace.out(report.toString());
        return result;
    }

    private void appendErrorLog(int nodeID, String errorDescription) {
        ConnectionInfo connectionInfo = this.m_connectionInfoArray[nodeID];
        Trace.out("Transfer error. Node   : " + connectionInfo.getNodeName() + RACTransferConstants.NEW_LINE + "                Details: " + errorDescription);
        connectionInfo.appendErrorLog(errorDescription);
    }

    private byte[] getFileDescriptionBytes(FileDescriptor file, String topDirPath) {
        String filename = file.getPath().substring(topDirPath.length()).substring(1);
        String fileDescriptor = "<" + filename.getBytes().length + ">" + filename + "[m" + file.getPermissions() + "]" + "[l" + file.length() + "]";
        return fileDescriptor.getBytes();
    }

    protected void threadCleanup() {
        for (int i = 0; i < this.m_clientHandler.length; ++i) {
            if (this.m_clientHandler[i] != null) {
                this.m_clientHandler[i].closeSocket();
                continue;
            }
            Trace.out("CLEANUP_WARNING --> m_clientHandler[" + i + "] is null");
        }
    }

    protected void reportConnectionError(int nodeID, String errorDescription) {
        this.appendErrorLog(nodeID, errorDescription);
        this.updateConnectionInfo(nodeID, this.m_connectionInfoArray[nodeID]);
    }

    protected ConnectionInfo getConnectionInfo(int nodeID) {
        if (nodeID < 0 || nodeID >= this.m_connectionInfoArray.length) {
            return null;
        }
        return this.m_connectionInfoArray[nodeID];
    }

    protected ConnectionInfo[] getConnectionInfoArray() {
        return this.m_connectionInfoArray;
    }

    public String getCommonWarningMsg() {
        return this.m_commonWarningMsg;
    }

    protected void setConnectionInfoArray(ConnectionInfo[] connectionInfoArray) {
        this.m_connectionInfoArray = connectionInfoArray;
    }

    protected void setNumOfNodes(int numOfNodes) {
        this.m_numOfNodes = numOfNodes;
    }
}

