/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment;

import java.util.Arrays;
import java.util.List;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.database.ServiceException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.ops.mgmt.nls.MessageKey;

public class DBServiceOperationInfo {
    private String m_svcName = null;
    private String m_dbName = null;
    private String m_tgtNode = null;
    private List<String> m_nodes = null;
    private ServiceOperation m_oper = null;

    public DBServiceOperationInfo(String svcName, String dbName, String srcNode, String tgtNode) throws InvalidArgsException {
        if (svcName == null || svcName.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-constr-1");
        }
        if (dbName == null || dbName.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-constr-2");
        }
        if (srcNode == null || srcNode.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-constr-3");
        }
        if (tgtNode == null || tgtNode.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-constr-4");
        }
        this.m_svcName = svcName;
        this.m_dbName = dbName;
        this.m_nodes = Arrays.asList(srcNode);
        this.m_tgtNode = tgtNode;
        this.m_oper = ServiceOperation.RELOCATE;
    }

    public DBServiceOperationInfo(String svcName, String dbName, List<String> nodes, boolean isStop) throws InvalidArgsException {
        this(svcName, dbName, nodes, isStop ? ServiceOperation.STOP : ServiceOperation.START);
    }

    public DBServiceOperationInfo(String svcName, String dbName, List<String> nodes, ServiceOperation oper) throws InvalidArgsException {
        if (svcName == null || svcName.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-constr3-1");
        }
        if (dbName == null || dbName.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-constr3-2");
        }
        if (nodes == null || nodes.isEmpty() || nodes.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-constr3-3");
        }
        if (oper == null || oper == ServiceOperation.RELOCATE) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-constr3-4");
        }
        this.m_svcName = svcName;
        this.m_dbName = dbName;
        this.m_nodes = nodes;
        this.m_oper = oper;
    }

    public DBServiceOperationInfo(String svcName, String dbName, ServiceOperation oper) throws InvalidArgsException {
        if (svcName == null || svcName.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-constr3-1");
        }
        if (dbName == null || dbName.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-constr3-2");
        }
        if (oper == null || oper == ServiceOperation.RELOCATE) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-constr3-4");
        }
        this.m_svcName = svcName;
        this.m_dbName = dbName;
        this.m_oper = oper;
    }

    public String getServiceName() {
        return this.m_svcName;
    }

    public String getDatabaseName() {
        return this.m_dbName;
    }

    public String getSourceNode() throws ServiceException {
        if (!this.isRelocated()) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-getSrcNode-1");
        }
        return this.m_nodes.get(0);
    }

    public String getTargetNode() throws ServiceException {
        if (!this.isRelocated()) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-getTgtNode-1");
        }
        return this.m_tgtNode;
    }

    public boolean isRelocated() {
        return this.m_oper == ServiceOperation.RELOCATE;
    }

    public boolean isStopped() {
        return this.m_oper == ServiceOperation.STOP;
    }

    public boolean isStarted() {
        return this.m_oper == ServiceOperation.START;
    }

    public boolean isEnabled() {
        return this.m_oper == ServiceOperation.ENABLE;
    }

    public boolean isDisabled() {
        return this.m_oper == ServiceOperation.DISABLE;
    }

    public ServiceOperation getOperation() {
        return this.m_oper;
    }

    @Deprecated
    public List<String> getStopNodes() throws ServiceException {
        if (!this.isStopped()) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-getStopNodes-1");
        }
        return this.m_nodes;
    }

    @Deprecated
    public List<String> getStartNodes() throws ServiceException {
        if (!this.isStarted()) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-getStartNodes-1");
        }
        return this.m_nodes;
    }

    public List<String> getNodes() throws ServiceException {
        if (this.isRelocated()) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-getNodes-1");
        }
        return this.m_nodes;
    }

    public static enum ServiceOperation {
        DISABLE("disabled"),
        ENABLE("enabled"),
        START("started"),
        STOP("stopped"),
        RELOCATE("relocated");

        private String m_op;

        private ServiceOperation(String op) {
            this.m_op = op;
        }

        public String toString() {
            return this.m_op;
        }

        public static ServiceOperation getEnumMember(String op) throws EnumConstNotFoundException {
            for (ServiceOperation val : ServiceOperation.values()) {
                if (!val.toString().equalsIgnoreCase(op)) continue;
                return val;
            }
            throw new EnumConstNotFoundException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcInfo-getEnum-1");
        }
    }
}

