/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.credentials.ASMProperties;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.credentials.GNSProperties;
import oracle.cluster.deployment.CredentialFileParserException;
import oracle.cluster.impl.credentials.ASMPropertiesImpl;
import oracle.cluster.resources.PrCiMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CredentialFileParser {
    Document m_document = null;
    Element m_docRoot = null;
    String m_xmlFilePath = null;
    private static final String ID = "id";

    public CredentialFileParser(String xmlFilePath, String xsdResource) throws CredentialFileParserException {
        this.m_xmlFilePath = xmlFilePath;
        this.loadXmlFile(xmlFilePath, xsdResource);
    }

    private void loadXmlFile(String xmlFilePath, String xsdResource) throws CredentialFileParserException {
        DocumentBuilderFactory xmlFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder xmlParser = null;
        String xmlFilePathURI = new File(xmlFilePath).toURI().toString();
        URL xsdURI = null;
        String xsdURIFile = null;
        if (xsdResource != null) {
            xsdURI = this.getClass().getResource(xsdResource);
            xsdURIFile = null != xsdURI ? xsdURI.toString() : new File(xsdResource).toURI().toString();
        }
        try {
            Trace.out("xsd URI = " + xsdURIFile);
            Trace.out("xml URI = " + xmlFilePathURI);
            if (!new File(xmlFilePath).exists()) {
                throw new CredentialFileParserException((MessageKey)PrCiMsgID.NO_SUCH_FILE, xmlFilePath);
            }
            if (xsdURIFile == null) {
                throw new CredentialFileParserException((MessageKey)PrCiMsgID.XSD_RESOURCE_NULL, xsdResource);
            }
            xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            xmlFactory.setNamespaceAware(true);
            xmlFactory.setValidating(true);
            xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", xsdURIFile);
            xmlParser = xmlFactory.newDocumentBuilder();
            ErrorHandler handler = new ErrorHandler(){

                @Override
                public void error(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void fatalError(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void warning(SAXParseException arg0) throws SAXException {
                    Trace.out("Ignored warning while parsing: " + arg0);
                }
            };
            xmlParser.setErrorHandler(handler);
            this.m_document = xmlParser.parse(xmlFilePathURI);
            this.m_docRoot = this.m_document.getDocumentElement();
        }
        catch (ParserConfigurationException pce) {
            Trace.out(pce.getMessage());
            throw new CredentialFileParserException(pce);
        }
        catch (IOException ioe) {
            Trace.out(ioe.getMessage());
            throw new CredentialFileParserException(ioe);
        }
        catch (SAXException se) {
            Trace.out(se.getMessage());
            throw new CredentialFileParserException(se);
        }
    }

    public String getProperty(String section, String property) {
        String propvalue = null;
        HashMap<String, String> propmap = new HashMap<String, String>();
        this.getPropertiesFromSection(false, section, this.m_docRoot.getChildNodes(), propmap);
        propvalue = propmap.get(property);
        return propvalue;
    }

    public HashMap<String, String> getProperties(String section) {
        HashMap<String, String> propmap = new HashMap<String, String>();
        this.getPropertiesFromSection(false, section, this.m_docRoot.getChildNodes(), propmap);
        return propmap;
    }

    public ASMProperties getASMAttributes() throws CredentialsException {
        HashMap<String, String> propmap = new HashMap<String, String>();
        this.getASMAttributeValue(this.m_docRoot.getChildNodes(), propmap);
        ASMPropertiesImpl props = new ASMPropertiesImpl(propmap);
        return props;
    }

    private void getASMAttributeValue(NodeList nodeList, HashMap<String, String> propmap) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList children;
            Node childNode = nodeList.item(i);
            if (childNode == null) {
                return;
            }
            if (childNode instanceof Element) {
                Element e = (Element)childNode;
                String key = e.getAttribute(ASMProperties.ASMPropName.CLUSTER_GUID.toString());
                if (!key.isEmpty()) {
                    Trace.out("Value of " + ASMProperties.ASMPropName.CLUSTER_GUID.toString() + ":" + key);
                    propmap.put(ASMProperties.ASMPropName.CLUSTER_GUID.toString(), key);
                }
                if (!(key = e.getAttribute(ASMProperties.ASMPropName.ASM_CLUSTER_GUID.toString())).isEmpty()) {
                    Trace.out("Value of " + ASMProperties.ASMPropName.ASM_CLUSTER_GUID.toString() + ":" + key);
                    propmap.put(ASMProperties.ASMPropName.ASM_CLUSTER_GUID.toString(), key);
                }
                if (!(key = e.getAttribute(ASMProperties.ASMPropName.CLUSTER_NAMES.toString())).isEmpty()) {
                    Trace.out("Value of " + ASMProperties.ASMPropName.CLUSTER_NAMES.toString() + ":" + key);
                    propmap.put(ASMProperties.ASMPropName.CLUSTER_NAMES.toString(), key);
                }
                if (!(key = e.getAttribute(ASMProperties.ASMPropName.ASM_CLUSTER_NAME.toString())).isEmpty()) {
                    Trace.out("Value of " + ASMProperties.ASMPropName.ASM_CLUSTER_NAME.toString() + ":" + key);
                    propmap.put(ASMProperties.ASMPropName.ASM_CLUSTER_NAME.toString(), key);
                }
                if (!(key = e.getAttribute(ASMProperties.ASMPropName.ASM_DISCOVERY_ADDRESS.toString())).isEmpty()) {
                    Trace.out("Value of " + ASMProperties.ASMPropName.ASM_DISCOVERY_ADDRESS.toString() + ":" + key);
                    propmap.put(ASMProperties.ASMPropName.ASM_DISCOVERY_ADDRESS.toString(), key);
                }
            }
            if ((children = childNode.getChildNodes()) == null) continue;
            this.getASMAttributeValue(children, propmap);
        }
    }

    public GNSProperties getGNSAttributes() throws CredentialsException {
        CredentialsFactory cFact = CredentialsFactory.getInstance();
        GNSProperties props = cFact.getGNSProperties(this.m_xmlFilePath);
        return props;
    }

    private void getPropertiesFromSection(boolean sectionFound, String section, NodeList nodeList, HashMap<String, String> propmap) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList children;
            Node childNode = nodeList.item(i);
            if (childNode == null) {
                return;
            }
            if (childNode instanceof Element) {
                Element e;
                String key;
                if (sectionFound && childNode.hasAttributes()) {
                    NamedNodeMap attrs = childNode.getAttributes();
                    for (int j = 0; j < attrs.getLength(); ++j) {
                        Attr attribute = (Attr)attrs.item(j);
                        Trace.out(attribute.getName() + " = " + attribute.getValue());
                        propmap.put(attribute.getName(), attribute.getValue());
                    }
                }
                if (!(key = (e = (Element)childNode).getAttribute(ID)).isEmpty() && key.equalsIgnoreCase(section)) {
                    Trace.out("Section found.Now fill the hashmap with attributes of the children of the present node : " + key);
                    NodeList children2 = childNode.getChildNodes();
                    if (children2 != null) {
                        this.getPropertiesFromSection(true, section, children2, propmap);
                    }
                    return;
                }
            }
            if ((children = childNode.getChildNodes()) == null) continue;
            this.getPropertiesFromSection(sectionFound, section, children, propmap);
        }
    }
}

