/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.cmdtools.AFDDriverUtil;
import oracle.cluster.cmdtools.ASMCMDUtil;
import oracle.cluster.cmdtools.CEMUTLUtil;
import oracle.cluster.cmdtools.CRSCTLUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.GETCRSHOMEUtil;
import oracle.cluster.cmdtools.KFODUtil;
import oracle.cluster.cmdtools.OCRDUMPUtil;
import oracle.cluster.cmdtools.OFSUtil;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.cmdtools.OIFCFGUtil;
import oracle.cluster.cmdtools.OLSNODESUtil;
import oracle.cluster.cmdtools.ORABASEUtil;
import oracle.cluster.cmdtools.ORADNFSUtil;
import oracle.cluster.cmdtools.OSDBAGRPUtil;
import oracle.cluster.cmdtools.SQLPLUSUtil;
import oracle.cluster.cmdtools.SRVCTLUtil;
import oracle.cluster.cmdtools.SRVMHELPERUtil;
import oracle.cluster.cmdtools.USMDriverUtil;
import oracle.cluster.common.CSSMode;
import oracle.cluster.common.ClusterClassification;
import oracle.cluster.common.ClusterType;
import oracle.cluster.common.DiskSpaceFlags;
import oracle.cluster.common.InterfaceType;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.NodeRole;
import oracle.cluster.credentials.ASMProperties;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.credentials.GIMRProperties;
import oracle.cluster.credentials.GNSProperties;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSFactory;
import oracle.cluster.crs.OracleCMCluster;
import oracle.cluster.crs.VendorCluster;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.OracleGroupsEnum;
import oracle.cluster.deployment.ACFSInfo;
import oracle.cluster.deployment.ASMDGInfo;
import oracle.cluster.deployment.ASMStatusInfo;
import oracle.cluster.deployment.BigCluster;
import oracle.cluster.deployment.BigClusterException;
import oracle.cluster.deployment.BigClusterFactory;
import oracle.cluster.deployment.ClientClusterComponent;
import oracle.cluster.deployment.ClientClusterInfo;
import oracle.cluster.deployment.CredentialFileParser;
import oracle.cluster.deployment.CredentialFileParserException;
import oracle.cluster.deployment.LWServerPool;
import oracle.cluster.deployment.VolumeInfo;
import oracle.cluster.deployment.ractrans.MultiTierTransfer;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.gridhome.RHPContainerType;
import oracle.cluster.helper.HelperException;
import oracle.cluster.helper.HelperUtil;
import oracle.cluster.impl.credentials.ASMPropertiesImpl;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.install.CRSInstall;
import oracle.cluster.install.HAInstall;
import oracle.cluster.install.InstallException;
import oracle.cluster.install.InstallFactory;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Site;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ClusterwareInfo {
    private static final String DELIMITER = "\\.";
    private static final String ASM_XSD = "/misc/asm.xsd";
    private static final String GNS_XSD = "/misc/gns.xsd";
    private static final String OPC_DIRECTORY = "/opt/oracle/opc";
    private final String APPLICATION_CLUSTER_TYPE = "application";
    static final String ODA_ENV_FILE = "/tmp/isODA246912";
    private static String HUB = ResourceLiterals.HUB.toString();
    private static String LEAF = ResourceLiterals.RIM.toString();
    private final int ONE_GB = 1024;

    static final void assertFile(String file) throws InstallException {
        if (file == null || file.trim().length() == 0) {
            throw new InstallException((MessageKey)PrCiMsgID.NULL_FILE_PATH, new Object[0]);
        }
    }

    static final void assertString(String str) throws InstallException {
        if (str == null || str.trim().length() == 0) {
            throw new InstallException((MessageKey)PrCiMsgID.NULL_PARAM, new Object[0]);
        }
    }

    static final void assertVersion(Version version) throws InstallException {
        if (version == null) {
            throw new InstallException((MessageKey)PrCtMsgID.NULL_VERSION, new Object[0]);
        }
    }

    static final void assertDir(String dirName, boolean checkPathType) throws InstallException {
        if (dirName == null || dirName.trim().length() == 0) {
            throw new InstallException((MessageKey)PrCiMsgID.NULL_DIR_NAME, new Object[0]);
        }
        if (checkPathType && !new File(dirName).isDirectory()) {
            throw new InstallException((MessageKey)PrCiMsgID.NO_SUCH_DIRECTORY, dirName);
        }
    }

    static final void assertNode(String nodeName) throws InstallException {
        if (nodeName == null || nodeName.trim().length() == 0) {
            throw new InstallException((MessageKey)PrCiMsgID.NULL_NODE_NAME, new Object[0]);
        }
    }

    static final void assertDBName(String dbName) throws InstallException {
        if (dbName == null || dbName.trim().length() == 0) {
            throw new InstallException((MessageKey)PrCiMsgID.NULL_DB_NAME, new Object[0]);
        }
    }

    static final void assertXMLFile(String xmlFilePath) throws InstallException {
        File inputFile = new File(xmlFilePath);
        if (!inputFile.exists()) {
            Trace.out("Input XML file - " + xmlFilePath + " does not exist");
            throw new InstallException((MessageKey)PrCiMsgID.NO_SUCH_FILE, xmlFilePath);
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
            Document document = dBuilder.parse(inputFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Trace.out("caught exception while parsing xml file " + xmlFilePath + " with exception message " + e.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.BAD_XML_FILE, (Throwable)e, xmlFilePath);
        }
    }

    private void assertNetNum(int netNum) throws InstallException {
        if (netNum < 0) {
            throw new InstallException((MessageKey)PrCiMsgID.INVALID_NETNUM, netNum);
        }
    }

    public boolean isHAInstalled(String ouiloc) throws InstallException {
        ClusterwareInfo.assertDir(ouiloc, true);
        try {
            HAInstall haInstall = InstallFactory.getInstance().getHAInstall(ouiloc);
            return true;
        }
        catch (NotExistsException e) {
            Trace.out(e.getMessage());
            return false;
        }
    }

    public boolean isHAInstalled(String ouiloc, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(ouiloc, true);
        try {
            HAInstall haInstall = InstallFactory.getInstance().getHAInstall(ouiloc, nodename);
            return true;
        }
        catch (NotExistsException e) {
            Trace.out(e.getMessage());
            return false;
        }
    }

    public String getHAHome(String ouiloc) throws InstallException {
        ClusterwareInfo.assertDir(ouiloc, true);
        try {
            HAInstall haInstall = InstallFactory.getInstance().getHAInstall(ouiloc);
            return haInstall.getDirectory();
        }
        catch (NotExistsException e) {
            Trace.out(e.getMessage());
            throw new InstallException(e);
        }
    }

    public String getHAHome(String ouiloc, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(ouiloc, true);
        try {
            HAInstall haInstall = InstallFactory.getInstance().getHAInstall(ouiloc, nodename);
            return haInstall.getDirectory();
        }
        catch (NotExistsException e) {
            Trace.out(e.getMessage());
            throw new InstallException(e);
        }
    }

    public boolean isCRSInstalled(String ouiloc) throws InstallException {
        ClusterwareInfo.assertDir(ouiloc, true);
        try {
            CRSInstall crsInstall = InstallFactory.getInstance().getCRSInstall(ouiloc);
            return true;
        }
        catch (NotExistsException e) {
            Trace.out(e.getMessage());
            return false;
        }
    }

    public boolean isCRSInstalled(String ouiloc, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(ouiloc, true);
        try {
            CRSInstall crsInstall = InstallFactory.getInstance().getCRSInstall(ouiloc, nodename);
            return true;
        }
        catch (NotExistsException e) {
            Trace.out(e.getMessage());
            return false;
        }
    }

    public String getConfiguredCRSHome(String oraHome) throws InstallException {
        try {
            return new GETCRSHOMEUtil(oraHome).getCRS_HOME();
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public String getConfiguredCRSHome(String oraHome, String nodeName) throws InstallException {
        ClusterwareInfo.assertNode(nodeName);
        if (nodeName.trim().equals("localnode")) {
            throw new InstallException((MessageKey)PrCiMsgID.CRS_NOT_EXIST_NODE, "localnode");
        }
        try {
            return new GETCRSHOMEUtil(oraHome).getCRS_HOME(nodeName);
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public String getCRSHome(String ouiloc) throws InstallException {
        ClusterwareInfo.assertDir(ouiloc, true);
        try {
            CRSInstall crsInstall = InstallFactory.getInstance().getCRSInstall(ouiloc);
            return crsInstall.getDirectory();
        }
        catch (NotExistsException e) {
            Trace.out(e.getMessage());
            throw new InstallException(e);
        }
    }

    public String getCRSHome(String ouiloc, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(ouiloc, true);
        try {
            CRSInstall crsInstall = InstallFactory.getInstance().getCRSInstall(ouiloc, nodename);
            return crsInstall.getDirectory();
        }
        catch (NotExistsException e) {
            Trace.out(e.getMessage());
            throw new InstallException(e);
        }
    }

    public VendorCluster getVendorCluster(String crsHome) throws NotExistsException, InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            VendorCluster vendorCluster = CRSFactory.getInstance().getVendorCluster();
            vendorCluster.setInstallCRSHome(crsHome);
            return vendorCluster;
        }
        catch (CRSException ce) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_VENDOR_CLUSTER_FAILED, (Throwable)ce, crsHome);
        }
    }

    public VendorCluster getVendorCluster(String crsHome, String nodeName) throws NotExistsException, InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            VendorCluster vc = CRSFactory.getInstance().getVendorCluster(nodeName);
            vc.setInstallCRSHome(crsHome);
            return vc;
        }
        catch (CRSException ce) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_VENDOR_CLUSTER_NODE_FAILED, (Throwable)ce, crsHome, nodeName);
        }
    }

    public OracleCMCluster getOracleCMCluster(String crsHome) throws NotExistsException, InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            OracleCMCluster ocm = CRSFactory.getInstance().getOracleCMCluster();
            ocm.setInstallCRSHome(crsHome);
            return ocm;
        }
        catch (CRSException ce) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_VENDOR_CLUSTER_FAILED, (Throwable)ce, crsHome);
        }
    }

    public OracleCMCluster getOracleCMCluster(String crsHome, String nodeName) throws NotExistsException, InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            OracleCMCluster ocm = CRSFactory.getInstance().getOracleCMCluster(nodeName);
            ocm.setInstallCRSHome(crsHome);
            return ocm;
        }
        catch (CRSException ce) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_ORACLECM_CLUSTER_NODE_FAILED, (Throwable)ce, crsHome, nodeName);
        }
    }

    public boolean isHARunning(String haHome) throws InstallException {
        ClusterwareInfo.assertDir(haHome, true);
        try {
            CRSCTLUtil crsctlUtil = new CRSCTLUtil(haHome);
            boolean ohasdRunning = crsctlUtil.isHARunning();
            if (ohasdRunning) {
                ohasdRunning &= crsctlUtil.isSIHA();
            }
            return ohasdRunning;
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.HA_RUNNING_CHECK_FAILED, (Throwable)e, haHome);
        }
    }

    public boolean isHARunning(String haHome, String nodeName) throws InstallException {
        ClusterwareInfo.assertDir(haHome, true);
        ClusterwareInfo.assertNode(nodeName);
        try {
            CRSCTLUtil crsctlUtil = new CRSCTLUtil(haHome);
            boolean ohasdRunning = crsctlUtil.isHARunning(nodeName);
            if (ohasdRunning) {
                ohasdRunning &= crsctlUtil.isSIHA(nodeName);
            }
            return ohasdRunning;
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.HA_RUNNING_NODE_CHECK_FAILED, (Throwable)e, haHome, nodeName);
        }
    }

    public void validateHARunning(String haHome, String nodeName) throws InstallException {
        ClusterwareInfo.assertDir(haHome, true);
        ClusterwareInfo.assertNode(nodeName);
        try {
            CRSCTLUtil crsctlUtil = new CRSCTLUtil(haHome);
            crsctlUtil.validateHARunning(nodeName);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.HA_RUNNING_NODE_CHECK_FAILED, (Throwable)e, haHome, nodeName);
        }
    }

    public boolean isCRSRunning(String crsHome) throws InstallException {
        return this.isCRSRunning(crsHome, new Version());
    }

    public boolean isCRSRunning(String crsHome, Version version) throws InstallException {
        ClusterwareInfo.assertVersion(version);
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            CRSCTLUtil crsctlUtil = new CRSCTLUtil(crsHome);
            return crsctlUtil.isCRSRunning(version);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.CRS_RUNNING_CHECK_FAILED, (Throwable)e, crsHome);
        }
    }

    public boolean isCRSRunning(String crsHome, String nodeName) throws InstallException {
        return this.isCRSRunning(crsHome, nodeName, new Version());
    }

    public boolean isCRSRunning(String crsHome, String nodeName, Version version) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        ClusterwareInfo.assertNode(nodeName);
        ClusterwareInfo.assertVersion(version);
        try {
            CRSCTLUtil crsctlUtil = new CRSCTLUtil(crsHome);
            return crsctlUtil.isCRSRunning(nodeName, version);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.CRS_RUNNING_NODE_CHECK_FAILED, (Throwable)e, crsHome, nodeName);
        }
    }

    public void validateCRSRunning(String crsHome, String nodeName, Version version) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        ClusterwareInfo.assertNode(nodeName);
        ClusterwareInfo.assertVersion(version);
        try {
            CRSCTLUtil crsctlUtil = new CRSCTLUtil(crsHome);
            crsctlUtil.validateCRSRunning(nodeName, version);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.CRS_RUNNING_NODE_CHECK_FAILED, (Throwable)e, crsHome, nodeName);
        }
    }

    public boolean isHAConfigured(String haHome) throws InstallException {
        ClusterwareInfo.assertDir(haHome, true);
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            return !system.isCRSConfigured(new Version()) && system.isHAConfigured(new Version());
        }
        catch (NativeException e) {
            throw new InstallException((MessageKey)PrCiMsgID.HA_CONFIGURED_CHECK_FAILED, (Throwable)e, haHome);
        }
    }

    public boolean isHAConfigured(String haHome, String nodeName) throws InstallException {
        ClusterwareInfo.assertDir(haHome, true);
        ClusterwareInfo.assertNode(nodeName);
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            return !system.isCRSConfigured(nodeName, new Version()) && system.isHAConfigured(nodeName, new Version());
        }
        catch (NativeException e) {
            throw new InstallException((MessageKey)PrCiMsgID.HA_CONFIGURED_NODE_CHECK_FAILED, (Throwable)e, haHome, nodeName);
        }
    }

    public boolean isHAConfigured() throws InstallException {
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            return !system.isCRSConfigured(new Version()) && system.isHAConfigured(new Version());
        }
        catch (NativeException e) {
            throw new InstallException((MessageKey)PrCiMsgID.HA_CONFIGURED_NO_HOME_CHECK_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public boolean isHAConfiguredOnNode(String nodeName) throws InstallException {
        ClusterwareInfo.assertNode(nodeName);
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            return !system.isCRSConfigured(nodeName, new Version()) && system.isHAConfigured(nodeName, new Version());
        }
        catch (NativeException e) {
            throw new InstallException((MessageKey)PrCiMsgID.HA_CONFIGURED_NODE_NO_HOME_CHECK_FAILED, (Throwable)e, nodeName);
        }
    }

    public boolean isCRSConfigured(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            return system.isCRSConfigured(new Version());
        }
        catch (NativeException e) {
            throw new InstallException((MessageKey)PrCiMsgID.CRS_CONFIGURED_CHECK_FAILED, (Throwable)e, crsHome);
        }
    }

    public boolean isCRSConfigured(String crsHome, String nodeName) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        ClusterwareInfo.assertNode(nodeName);
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            return system.isCRSConfigured(nodeName, new Version());
        }
        catch (NativeException e) {
            throw new InstallException((MessageKey)PrCiMsgID.CRS_CONFIGURED_NODE_CHECK_FAILED, (Throwable)e, crsHome, nodeName);
        }
    }

    public boolean isCRSConfigured() throws InstallException {
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            return system.isCRSConfigured(new Version());
        }
        catch (NativeException e) {
            throw new InstallException((MessageKey)PrCiMsgID.CRS_CONFIGURED_NO_HOME_CHECK_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public boolean isCRSConfiguredOnNode(String nodeName) throws InstallException {
        ClusterwareInfo.assertNode(nodeName);
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            return system.isCRSConfigured(nodeName, new Version());
        }
        catch (NativeException e) {
            throw new InstallException((MessageKey)PrCiMsgID.CRS_CONFIGURED_NODE_NO_HOME_CHECK_FAILED, (Throwable)e, nodeName);
        }
    }

    public String getCRSReleaseVersionString(String crsHome) throws InstallException, NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException {
        return new ClusterInfo(crsHome).getCRSReleaseVersionString();
    }

    public String getSIHAReleaseVersionString(String crsHome) throws InstallException, NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException {
        return new ClusterInfo(crsHome).getSIHAReleaseVersionString();
    }

    public String getCRSActiveVersionString(String crsHome) throws InstallException, NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException {
        if (!this.isCRSConfigured(crsHome)) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_ACTV_VRSN_FAILED_CRS_NOT_CONFIG, new Object[0]);
        }
        return new ClusterInfo(crsHome).getCRSActiveVersionString();
    }

    public String getCRSSoftwareVersionString(String crsHome, String nodeName) throws InstallException, NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException {
        return new ClusterInfo(crsHome).getCRSSoftwareVersionString(nodeName);
    }

    public String getSIHASoftwareVersionString(String crsHome) throws InstallException, NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException {
        return new ClusterInfo(crsHome).getSIHASoftwareVersionString();
    }

    public boolean isDatabaseExists(String crsHome, String dbUniqueName) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        ClusterwareInfo.assertDBName(dbUniqueName);
        try {
            return new CRSCTLUtil(crsHome).isDatabaseExists(dbUniqueName);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.DB_EXISTS_CHECK_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    public boolean isDatabaseExists(String oracleHome, String nodeName, String dbUniqueName) throws InstallException {
        return this.isDatabaseConfigured(oracleHome, dbUniqueName, nodeName);
    }

    public boolean isDatabaseConfigured(String oracleHome, String dbUniqueName, String nodeName) throws InstallException {
        ClusterwareInfo.assertDir(oracleHome, true);
        ClusterwareInfo.assertDBName(dbUniqueName);
        ClusterwareInfo.assertNode(nodeName);
        boolean retVal = false;
        try {
            List<String> adminDBConfigNodes = this.getAdminDBConfiguredNodes(oracleHome, dbUniqueName);
            if (adminDBConfigNodes.contains(nodeName)) {
                retVal = true;
            }
        }
        catch (InstallException e) {
            throw new InstallException((MessageKey)PrCiMsgID.DB_EXISTS_CHECK_NODE_FAILED, (Throwable)e, dbUniqueName, nodeName);
        }
        return retVal;
    }

    public boolean isDatabaseAdminManaged(String oracleHome, String dbUniqueName) throws InstallException {
        try {
            return new SRVMHELPERUtil(oracleHome).isDatabaseAdminManaged(dbUniqueName);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.DB_ADMIN_CHECK_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    public List<String> getAdminDBConfiguredNodes(String oracleHome, String dbUniqueName) throws InstallException {
        try {
            return new SRVMHELPERUtil(oracleHome).getAdminDBConfiguredNodes(dbUniqueName);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.DB_RETRIEVE_ADMIN_NODES_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    public String getPDBName(String clusterName) throws InstallException {
        return clusterName.replace('-', '_');
    }

    public List<String> getHAManagedDatabases(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            return new CRSCTLUtil(crsHome).getHAManagedDatabases();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_HA_MANAGED_DB_FAILED, (Throwable)e, new Object[0]);
        }
        catch (DatabaseException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_HA_MANAGED_DB_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public List<String> getHAManagedDatabases(String crsHome, String nodeName) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        ClusterwareInfo.assertNode(nodeName);
        try {
            return new CRSCTLUtil(crsHome).getHAManagedDatabases(nodeName);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_HA_MANAGED_DB_NODE_FAILED, (Throwable)e, nodeName);
        }
        catch (DatabaseException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_HA_MANAGED_DB_NODE_FAILED, (Throwable)e, nodeName);
        }
    }

    public boolean isDependentOnASM(String crsHome, String dbUniqueName) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        ClusterwareInfo.assertDBName(dbUniqueName);
        try {
            return new CRSCTLUtil(crsHome).isDependentOnASM(dbUniqueName);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.ASM_DEPENDENCY_CHECK_FAILED, (Throwable)e, dbUniqueName);
        }
        catch (CRSException e) {
            throw new InstallException((MessageKey)PrCiMsgID.ASM_DEPENDENCY_CHECK_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    public boolean isDependentOnASM(String crsHome, String nodeName, String dbUniqueName) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        ClusterwareInfo.assertDBName(dbUniqueName);
        ClusterwareInfo.assertNode(nodeName);
        try {
            return new CRSCTLUtil(crsHome).isDependentOnASM(nodeName, dbUniqueName);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.ASM_DEPENDENCY_CHECK_NODE_FAILED, (Throwable)e, dbUniqueName, nodeName);
        }
        catch (CRSException e) {
            throw new InstallException((MessageKey)PrCiMsgID.ASM_DEPENDENCY_CHECK_NODE_FAILED, (Throwable)e, dbUniqueName, nodeName);
        }
    }

    public boolean checkASMFilePathExists(String filePath, boolean asSysdba) throws InstallException {
        String crsHome = null;
        boolean bExists = false;
        try {
            crsHome = this.getCRSHome(new Version());
            ClusterwareInfo.assertDir(crsHome, true);
            Trace.out("Checking file path " + filePath);
            ASMCMDUtil asmcmd = new ASMCMDUtil(crsHome);
            bExists = asmcmd.checkASMFilePathExists(filePath, asSysdba);
            Trace.out("File path existence checking returns " + bExists);
        }
        catch (InstallException e) {
            Trace.out("exception while trying to get CRSHome: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (CmdToolUtilException e) {
            Trace.out("exception while trying to call asmcmd command: " + e.getMessage());
            throw new InstallException(e);
        }
        return bExists;
    }

    public List<ASMDGInfo> getASMDiskGroups() throws InstallException {
        String crsHome = null;
        Object errMsg = null;
        List<ASMDGInfo> diskList = null;
        try {
            crsHome = this.getCRSHome(new Version());
            ClusterwareInfo.assertDir(crsHome, true);
            Trace.out("creating instance of ASMCMDUtil");
            ASMCMDUtil asmcmd = new ASMCMDUtil(crsHome);
            diskList = asmcmd.getDGInfo();
            Trace.out("got all data");
        }
        catch (InstallException e) {
            Trace.out("exception while trying to get CRSHome: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (CmdToolUtilException e) {
            Trace.out("exception while trying to get disk group information: " + e.getMessage());
            throw new InstallException(e);
        }
        return diskList;
    }

    public ASMDGInfo findASMDiskGroup(List<ASMDGInfo> dgList, String dgName) {
        if (dgList != null && dgName != null) {
            for (ASMDGInfo dg : dgList) {
                if (!dgName.equals(dg.getName())) continue;
                return dg;
            }
        }
        return null;
    }

    public List<String> getDiskGroupNames(String kfodpath) throws InstallException {
        ClusterwareInfo.assertDir(kfodpath, true);
        try {
            return new KFODUtil(kfodpath).getDiskGroupNames();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public List<String> getDiskGroupNames(String kfodpath, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(kfodpath, true);
        ClusterwareInfo.assertNode(nodename);
        try {
            return new KFODUtil(kfodpath).getDiskGroupNames(nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isASMRunning(String kfodpath, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(kfodpath, true);
        ClusterwareInfo.assertNode(nodename);
        try {
            return new KFODUtil(kfodpath).isASMRunning(nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isODAEnv() throws InstallException {
        boolean isODA;
        boolean bl = isODA = System.getenv("SRVM_IS_ODA") != null || System.getProperty("SRVM_IS_ODA") != null;
        if (Utils.isDevelopmentEnv()) {
            File odaEnvFile = new File(ODA_ENV_FILE);
            try {
                if (odaEnvFile.exists()) {
                    isODA = true;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return isODA;
    }

    public boolean isODALiteEnv() throws InstallException {
        boolean isODALite = false;
        String key = "SYSTEM.ODA_CONFIG";
        try {
            String clusterTypeIdentifier = this.getOCRValue(key);
            if (clusterTypeIdentifier != null) {
                isODALite = clusterTypeIdentifier.equals("olite");
            }
        }
        catch (OCRException ocre) {
            throw new InstallException((MessageKey)PrCiMsgID.ODA_LITE_ENV_CHECK_FAILED, (Throwable)ocre, new Object[0]);
        }
        Trace.out("isODALiteEnv returns '" + isODALite + "'");
        return isODALite;
    }

    public boolean isODALiteEnv_lightweight() {
        return new File("/opt/oracle/olite").exists();
    }

    public boolean isODASingleIPEnv() throws InstallException {
        boolean isODASingleIP = false;
        String key = "SYSTEM.ODA_CONFIG";
        try {
            String clusterTypeIdentifier = this.getOCRValue(key);
            if (clusterTypeIdentifier != null) {
                isODASingleIP = clusterTypeIdentifier.equals("odasip");
            }
        }
        catch (OCRException ocre) {
            throw new InstallException((MessageKey)PrCiMsgID.ODA_SIP_ENV_CHECK_FAILED, (Throwable)ocre, new Object[0]);
        }
        Trace.out("isODASingleIPEnv returns '" + isODASingleIP + "'");
        return isODASingleIP;
    }

    public boolean isODASingleIPEnv_lightweight() {
        return new File("/opt/oracle/odasip").exists();
    }

    public boolean isOPCEnv() throws InstallException {
        boolean isOPC = false;
        String key = "SYSTEM.OPC_CLUSTER";
        try {
            String clusterTypeIdentifier = this.getOCRValue(key);
            if (clusterTypeIdentifier != null) {
                isOPC = clusterTypeIdentifier.equals("dom-u");
            }
        }
        catch (OCRException ocre) {
            throw new InstallException((MessageKey)PrCiMsgID.OPC_ENV_CHECK_FAILED, (Throwable)ocre, new Object[0]);
        }
        Trace.out("isOPCEnv returns '" + isOPC + "'");
        return isOPC;
    }

    public boolean isOPCEnv_lightweight() {
        return new File(OPC_DIRECTORY).exists();
    }

    private String getOCRValue(String key) throws OCRException {
        try {
            OCR ocr = OCR.init(3);
            if (ocr.keyExists(key)) {
                return ocr.getKeyValue(key);
            }
            return null;
        }
        catch (OCRException ocre) {
            Trace.out("Failed to retrieve the value for the OCR key \"" + key + "\". Details:\n" + ocre.getMessage());
            throw ocre;
        }
    }

    public boolean getASMInstanceType(String kfodpath) throws InstallException {
        ClusterwareInfo.assertDir(kfodpath, true);
        try {
            return new KFODUtil(kfodpath).getASMInstanceType();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public String getASMActiveVersion(String kfodpath) throws InstallException {
        ClusterwareInfo.assertDir(kfodpath, true);
        try {
            return new KFODUtil(kfodpath).getASMActiveVersion();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public String getASMActiveVersion(String kfodpath, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(kfodpath, true);
        ClusterwareInfo.assertNode(nodename);
        try {
            return new KFODUtil(kfodpath).getASMActiveVersion(nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public HashMap<String, String> getCredentialProperties(String credFile, String sectionName) throws InstallException {
        return this.getCredentialProperties(credFile, sectionName, null);
    }

    public HashMap<String, String> getCredentialProperties(String credFile, String sectionName, String XSDFile) throws InstallException {
        CredentialFileParser parser;
        ClusterwareInfo.assertFile(credFile);
        ClusterwareInfo.assertString(sectionName);
        ClusterwareInfo.assertFile(XSDFile);
        Object propmap = null;
        try {
            parser = new CredentialFileParser(credFile, XSDFile);
        }
        catch (CredentialFileParserException xpe) {
            Trace.out("caught CredentialFileParserException while parsing credentials file " + credFile + " with exception message " + xpe.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.INVALID_CREDENTIALS_FILE, (Throwable)xpe, credFile);
        }
        return parser.getProperties(sectionName);
    }

    public String getCredentialProperty(String credFile, String sectionName, String propertyName) throws InstallException {
        return this.getCredentialProperty(credFile, sectionName, propertyName, null);
    }

    public String getCredentialProperty(String credFile, String sectionName, String propertyName, String XSDFile) throws InstallException {
        ClusterwareInfo.assertFile(credFile);
        ClusterwareInfo.assertString(sectionName);
        ClusterwareInfo.assertString(propertyName);
        CredentialFileParser parser = null;
        try {
            parser = new CredentialFileParser(credFile, XSDFile);
        }
        catch (CredentialFileParserException xpe) {
            Trace.out("caught CredentialFileParserException while parsing credentials file " + credFile + " with exception message " + xpe.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.INVALID_CREDENTIALS_FILE, (Throwable)xpe, credFile);
        }
        return parser.getProperty(sectionName, propertyName);
    }

    public ASMProperties getASMProperties(String asmCredFile) throws InstallException {
        return this.getASMPropertiesInternal(null, asmCredFile, false);
    }

    public ASMProperties getASMProps(String asmCredFile) throws InstallException, NotExistsException {
        ClusterwareInfo.assertFile(asmCredFile);
        ClusterwareInfo.assertXMLFile(asmCredFile);
        CredentialsFactory cFact = null;
        try {
            cFact = CredentialsFactory.getInstance();
            Map<String, String> propmap = cFact.getCredProperties(asmCredFile, "ASM_attributes");
            return ASMPropertiesImpl.getAndValidateASMProperties((HashMap)propmap);
        }
        catch (CredentialsException ce) {
            Trace.out(" getASMPropertiesInternal CredentialsException " + ce.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_PROPERTIES_FAILED, (Throwable)ce, asmCredFile);
        }
    }

    public ASMProperties getASMProperties(String kfodBinPath, String asmCredFile, boolean isPreGIInst) throws InstallException {
        ClusterwareInfo.assertFile(asmCredFile);
        ClusterwareInfo.assertString(kfodBinPath);
        return this.getASMPropertiesInternal(kfodBinPath, asmCredFile, isPreGIInst);
    }

    private ASMProperties getASMPropertiesInternal(String kfodBinPath, String asmCredFile, boolean isPreGIInst) throws InstallException {
        ClusterwareInfo.assertFile(asmCredFile);
        ClusterwareInfo.assertXMLFile(asmCredFile);
        try {
            HashMap<String, String> propmap;
            Trace.out("Calling getASMProperties ...");
            if (kfodBinPath != null && kfodBinPath.trim().length() > 0) {
                Trace.out("kfodBinPath = " + kfodBinPath);
                propmap = new KFODUtil(kfodBinPath, isPreGIInst).getASMProperties(asmCredFile);
            } else {
                propmap = new KFODUtil().getASMProperties(asmCredFile);
            }
            return ASMPropertiesImpl.getAndValidateASMProperties(propmap);
        }
        catch (CmdToolUtilException ctue) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_PROPERTIES_FAILED, (Throwable)ctue, asmCredFile);
        }
        catch (CredentialsException ce) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_PROPERTIES_FAILED, (Throwable)ce, asmCredFile);
        }
    }

    public GNSProperties getGNSProperties(String gnsCredFile) throws InstallException {
        ClusterwareInfo.assertFile(gnsCredFile);
        CredentialsFactory cFact = null;
        GNSProperties props = null;
        try {
            cFact = CredentialsFactory.getInstance();
            props = cFact.getGNSProperties(gnsCredFile);
        }
        catch (CredentialsException ce) {
            Trace.out("caught credentials exception while extracting attributes from credentials file " + gnsCredFile + " with excpetion message " + ce.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_PROPERTIES_FAILED, (Throwable)ce, gnsCredFile);
        }
        return props;
    }

    public GNSProperties getGNSPropertiesFromManifest(String manifestFile) throws InstallException, NotExistsException {
        ClusterwareInfo.assertFile(manifestFile);
        CredentialsFactory cFact = null;
        GNSProperties props = null;
        try {
            cFact = CredentialsFactory.getInstance();
            props = cFact.getGNSPropertiesFromManifest(manifestFile);
        }
        catch (NotExistsException nee) {
            Trace.out("NotExistsexception while extracting attributes from credentials file " + manifestFile + " with exception" + " message " + nee.getMessage());
            throw new NotExistsException((MessageKey)PrCiMsgID.GET_PROPERTIES_FAILED, (Throwable)nee, manifestFile);
        }
        catch (CredentialsException ce) {
            Trace.out("caught credentials exception while extracting attributes from credentials file " + manifestFile + " with exception" + " message " + ce.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_PROPERTIES_FAILED, (Throwable)ce, manifestFile);
        }
        return props;
    }

    public List<ClientClusterComponent> getClusterServices(String credFile) throws InstallException {
        try {
            CredentialsFactory credFact = CredentialsFactory.getInstance();
            return credFact.getClusterServices(credFile);
        }
        catch (CredentialsException e) {
            throw new InstallException(e);
        }
    }

    public CSSMode getCSSMode() throws InstallException {
        try {
            new HelperUtil();
            CSSMode cssmode = HelperUtil.getCSSMode();
            return cssmode;
        }
        catch (HelperException e) {
            throw new InstallException(e);
        }
    }

    public ASMStatusInfo getASMStatusInfo() throws InstallException {
        this.apiUnsupportedOnSIHA("getASMStatusInfo");
        try {
            new HelperUtil();
            ASMStatusInfo asmStatusInfo = HelperUtil.getASMStatusInfo();
            return asmStatusInfo;
        }
        catch (HelperException e) {
            throw new InstallException(e);
        }
    }

    public String getOFSActiveVersion() throws InstallException {
        return this.do_getOFSActiveVersion(null);
    }

    public String getOFSActiveVersion(String acfsutilpath) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        return this.do_getOFSActiveVersion(acfsutilpath);
    }

    private String do_getOFSActiveVersion(String acfsutilpath) throws InstallException {
        return this.do1_getOFSActiveVersion(acfsutilpath, null);
    }

    public String getOFSActiveVersionforNode(String nodename) throws InstallException {
        ClusterwareInfo.assertNode(nodename);
        return this.do1_getOFSActiveVersion(null, nodename);
    }

    public String getOFSActiveVersion(String acfsutilpath, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        ClusterwareInfo.assertNode(nodename);
        return this.do1_getOFSActiveVersion(acfsutilpath, nodename);
    }

    private String do1_getOFSActiveVersion(String acfsutilpath, String nodename) throws InstallException {
        if (acfsutilpath != null) {
            ClusterwareInfo.assertDir(acfsutilpath, true);
        }
        if (nodename != null) {
            ClusterwareInfo.assertNode(nodename);
        }
        try {
            OFSUtil acfsutl = acfsutilpath == null ? new OFSUtil() : new OFSUtil(acfsutilpath);
            if (nodename != null) {
                return acfsutl.getOFSActiveVersion(nodename);
            }
            return acfsutl.getOFSActiveVersion();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public String getOFSUtilDirectory() throws InstallException {
        try {
            return new OFSUtil().getOFSUtilDirectory();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public String getOFSUtilDirectory(String acfsutilpath) throws InstallException {
        try {
            return new OFSUtil(acfsutilpath).getOFSUtilDirectory();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public String getOFSUtilExeName() throws InstallException {
        try {
            return new OFSUtil().getOFSUtilExeName();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isOFSPartition(String location) throws InstallException {
        return this.do_isOFSPartition(null, location);
    }

    public boolean isOFSPartition(String acfsutilpath, String location) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        return this.do_isOFSPartition(acfsutilpath, location);
    }

    private boolean do_isOFSPartition(String acfsutilpath, String location) throws InstallException {
        return this.do1_isOFSPartition(acfsutilpath, location, null);
    }

    public boolean isOFSPartitionforNode(String location, String nodename) throws InstallException {
        ClusterwareInfo.assertNode(nodename);
        return this.do1_isOFSPartition(null, location, nodename);
    }

    public boolean isOFSPartition(String acfsutilpath, String location, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        ClusterwareInfo.assertNode(nodename);
        return this.do1_isOFSPartition(acfsutilpath, location, nodename);
    }

    public boolean isOCROnASM() throws InstallException {
        try {
            new HelperUtil();
            boolean isOCROnASMVal = HelperUtil.isOCROnASM();
            return isOCROnASMVal;
        }
        catch (HelperException e) {
            throw new InstallException(e);
        }
    }

    private boolean do1_isOFSPartition(String acfsutilpath, String location, String nodename) throws InstallException {
        try {
            OFSUtil acfsutl = acfsutilpath == null ? new OFSUtil() : new OFSUtil(acfsutilpath);
            if (nodename != null) {
                return acfsutl.isOFSPartition(location, nodename);
            }
            return acfsutl.isOFSPartition(location);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public List<OIFCFGResult> getIPNetworks(String oifcfgLoc, InetAddress ipAddress) throws InstallException {
        return this.getIPNetworks("localnode", oifcfgLoc, false, ipAddress);
    }

    public List<OIFCFGResult> getIPNetworks(String oifcfgLoc, boolean useLightWeight, InetAddress ipAddress) throws InstallException {
        return this.getIPNetworks("localnode", oifcfgLoc, useLightWeight, ipAddress);
    }

    public List<OIFCFGResult> getIPNetworks(String nodeName, String oifcfgLoc, InetAddress ipAddress) throws InstallException {
        return this.getIPNetworks(nodeName, oifcfgLoc, false, ipAddress);
    }

    public List<OIFCFGResult> getIPNetworks(String nodeName, String oifcfgLoc, boolean useLightWeight, InetAddress ipAddress) throws InstallException {
        ClusterwareInfo.assertNode(nodeName);
        ClusterwareInfo.assertDir(oifcfgLoc, true);
        ArrayList<OIFCFGResult> ipNetworkList = new ArrayList<OIFCFGResult>();
        byte[] ipAddressBytes = ipAddress.getAddress();
        List<OIFCFGResult> oifcfgResultList = this.listInterfaces(nodeName, oifcfgLoc, useLightWeight);
        for (OIFCFGResult temp_oifcfgResult : oifcfgResultList) {
            int prefixLength;
            if (ipAddress instanceof Inet4Address && IPAddressUtil.isIPv4AddressString(temp_oifcfgResult.getSubnetMaskAsString())) {
                byte[] subnetMaskBytes = temp_oifcfgResult.getSubnetMask().getAddress();
                if (ipAddressBytes.length != subnetMaskBytes.length) {
                    throw new InstallException((MessageKey)PrCiMsgID.IPADDR_SUBNETMASK_LENGTH_MISMATCH, ipAddress.getHostAddress(), temp_oifcfgResult.getSubnetMask().getHostAddress());
                }
                byte[] resultingSubnetBytes = new byte[ipAddressBytes.length];
                for (int i = 0; i < ipAddressBytes.length; i = (int)((byte)(i + 1))) {
                    resultingSubnetBytes[i] = Integer.valueOf(Byte.valueOf(ipAddressBytes[i]).intValue() & Byte.valueOf(subnetMaskBytes[i]).intValue()).byteValue();
                }
                try {
                    InetAddress resultingIPv4Subnet = InetAddress.getByAddress(resultingSubnetBytes);
                    if (!resultingIPv4Subnet.getHostAddress().equals(temp_oifcfgResult.getSubnet().getHostAddress())) continue;
                    ipNetworkList.add(temp_oifcfgResult);
                    continue;
                }
                catch (UnknownHostException ohe) {
                    throw new InstallException((MessageKey)PrCiMsgID.INVALID_RESULTING_SUBNET_FORMAT, temp_oifcfgResult.getSubnetMask().getHostAddress(), ipAddress.getHostAddress());
                }
            }
            if (!(ipAddress instanceof Inet6Address) || !IPAddressUtil.isIPv6PrefixLength(temp_oifcfgResult.getSubnetMaskAsString())) continue;
            try {
                prefixLength = Integer.valueOf(temp_oifcfgResult.getSubnetMaskAsString());
            }
            catch (NumberFormatException nfe) {
                Trace.out("This exception should not be encountered. Expected an integer as IPv6 netmask, while got '" + temp_oifcfgResult.getSubnetMaskAsString() + "'");
                throw new InstallException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "not-an-integer-ipv6-netmask-error_1");
            }
            try {
                String resultingIPv6Subnet = IPAddressUtil.applyNetmaskOrPrefixLength(ipAddress.getHostAddress(), String.valueOf(prefixLength));
                if (!IPAddressUtil.sameIPAddresses(resultingIPv6Subnet, temp_oifcfgResult.getSubnet().getHostAddress())) continue;
                ipNetworkList.add(temp_oifcfgResult);
            }
            catch (IPAddressException ipae) {
                throw new InstallException((MessageKey)PrCiMsgID.INVALID_RESULTING_SUBNET_FORMAT, temp_oifcfgResult.getSubnetMask().getHostAddress(), ipAddress.getHostAddress());
            }
        }
        return ipNetworkList;
    }

    public List<OIFCFGResult> listInterfaces(String oifcfgLoc) throws InstallException {
        return this.listInterfaces(oifcfgLoc, false);
    }

    public List<OIFCFGResult> listInterfaces(String oifcfgLoc, boolean useLightWeight) throws InstallException {
        return this.listInterfaces("localnode", oifcfgLoc, useLightWeight);
    }

    public List<OIFCFGResult> listInterfaces(String nodeName, String oifcfgLoc) throws InstallException {
        return this.listInterfaces(nodeName, oifcfgLoc, false);
    }

    public List<OIFCFGResult> listInterfaces(String nodeName, String oifcfgLoc, boolean useLightWeight) throws InstallException {
        ClusterwareInfo.assertNode(nodeName);
        ClusterwareInfo.assertDir(oifcfgLoc, false);
        boolean skipCopy = false;
        String filePathname = oifcfgLoc + File.separator + OIFCFGUtil.OIFCFGUTL;
        try {
            skipCopy = new ClusterCmd().fileExists(nodeName, filePathname);
        }
        catch (ClusterException ce) {
            Trace.out("ClusterException thrown while checking if the file \"" + filePathname + "\" exists on node \"" + nodeName + "\". Details:" + ce.getMessage());
            throw new InstallException(ce);
        }
        try {
            OIFCFGUtil oifcfgUtil = new OIFCFGUtil(oifcfgLoc, skipCopy, useLightWeight);
            List<OIFCFGResult> ifList = oifcfgUtil.listInterfaces(nodeName);
            ArrayList<OIFCFGResult> filteredList = new ArrayList<OIFCFGResult>();
            for (OIFCFGResult res : ifList) {
                InetAddress iAddr = res.getSubnet();
                if (iAddr.isLinkLocalAddress()) {
                    Trace.out("Skipping interface corresponding to subnet: " + res.getSubnet().toString());
                    continue;
                }
                filteredList.add(res);
            }
            return filteredList;
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public List<OIFCFGResult> listClusterInterfaces(String oifcfgLoc) throws InstallException {
        return this.listClusterInterfacesInternal(oifcfgLoc, null);
    }

    public List<OIFCFGResult> listClusterInterfaces(String oifcfgLoc, Version version) throws InstallException {
        Trace.out("crs active version is " + version);
        return this.listClusterInterfacesInternal(oifcfgLoc, version);
    }

    private List<OIFCFGResult> listClusterInterfacesInternal(String oifcfgLoc, Version version) throws InstallException {
        return this.listClusterInterfacesInternal(oifcfgLoc, version, false, null);
    }

    private List<OIFCFGResult> listClusterInterfacesInternal(String oifcfgLoc, Version version, boolean getNetmask, InterfaceType interfaceType) throws InstallException {
        List<OIFCFGResult> ifListResult = null;
        List<OIFCFGResult> getIfResult = null;
        ArrayList<OIFCFGResult> interconnectList = new ArrayList<OIFCFGResult>();
        ClusterwareInfo.assertDir(oifcfgLoc, true);
        boolean skipCopy = true;
        String filePathname = oifcfgLoc + File.separator + OIFCFGUtil.OIFCFGUTL;
        try {
            skipCopy = new ClusterCmd().fileExists(filePathname);
        }
        catch (ClusterException ce) {
            Trace.out("ClusterException thrown while checking if the file \"" + filePathname + "\" exists on local node. Details:" + ce.getMessage());
            throw new InstallException(ce);
        }
        try {
            OIFCFGUtil oifcfgUtil = new OIFCFGUtil(oifcfgLoc, skipCopy, false);
            getIfResult = version == null ? oifcfgUtil.listClusterInterfaces() : oifcfgUtil.listClusterInterfaces(version);
            if (!getNetmask && interfaceType == null) {
                return getIfResult;
            }
            if (getNetmask) {
                ifListResult = oifcfgUtil.listInterfaces("localnode");
            }
            String interfaceTypeStr = null;
            if (interfaceType != null) {
                interfaceTypeStr = interfaceType.toString();
            }
            block5: for (OIFCFGResult getIfRes : getIfResult) {
                if (interfaceTypeStr != null && getIfRes.getInterfaceType().indexOf(interfaceTypeStr) == -1) continue;
                if (ifListResult == null) {
                    interconnectList.add(getIfRes);
                    continue;
                }
                String interfaceName = getIfRes.getInterfaceName();
                for (OIFCFGResult ifListRes : ifListResult) {
                    if (!ifListRes.getInterfaceName().equals(interfaceName) || !IPAddressUtil.sameIPAddresses(ifListRes.getSubnet().getHostAddress(), getIfRes.getSubnet().getHostAddress())) continue;
                    getIfRes.setSubnetMask(ifListRes.getSubnetMask(), ifListRes.getSubnetMaskPrefix());
                    interconnectList.add(getIfRes);
                    continue block5;
                }
            }
            return interconnectList;
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
        catch (IPAddressException e) {
            throw new InstallException(e);
        }
    }

    public List<OIFCFGResult> listClusterInterconnectInterfaces(String oifcfgLoc, Version version) throws InstallException {
        return this.listClusterInterfacesInternal(oifcfgLoc, version, true, InterfaceType.CLUSTER_INTERCONNECT);
    }

    public List<String> getOFSMountPoints() throws InstallException {
        return this.do_getOFSMountPoints(null);
    }

    public List<String> getOFSMountPoints(String acfsutilpath) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        return this.do_getOFSMountPoints(acfsutilpath);
    }

    private List<String> do_getOFSMountPoints(String acfsutilpath) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().getOFSMountPoints();
            }
            return new OFSUtil(acfsutilpath).getOFSMountPoints();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public List<String> getOFSMountPointsforNode(String nodename) throws InstallException {
        ClusterwareInfo.assertNode(nodename);
        return this.do1_getOFSMountPoints(null, nodename);
    }

    public List<String> getOFSMountPoints(String acfsutilpath, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        ClusterwareInfo.assertNode(nodename);
        return this.do1_getOFSMountPoints(acfsutilpath, nodename);
    }

    private List<String> do1_getOFSMountPoints(String acfsutilpath, String nodename) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().getOFSMountPoints(nodename);
            }
            return new OFSUtil(acfsutilpath).getOFSMountPoints(nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public List<String> getAllOFSDiskGroupNames() throws InstallException {
        return this.do_getAllOFSDiskGroupNames(null);
    }

    public List<String> getAllOFSDiskGroupNames(String acfsutilpath) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        return this.do_getAllOFSDiskGroupNames(acfsutilpath);
    }

    private List<String> do_getAllOFSDiskGroupNames(String acfsutilpath) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().getAllOFSDiskGroupNames();
            }
            return new OFSUtil(acfsutilpath).getAllOFSDiskGroupNames();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public List<String> getAllOFSDiskGroupNamesforNode(String nodename) throws InstallException {
        ClusterwareInfo.assertNode(nodename);
        return this.do1_getAllOFSDiskGroupNames(null, nodename);
    }

    public List<String> getAllOFSDiskGroupNames(String acfsutilpath, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        ClusterwareInfo.assertNode(nodename);
        return this.do1_getAllOFSDiskGroupNames(acfsutilpath, nodename);
    }

    private List<String> do1_getAllOFSDiskGroupNames(String acfsutilpath, String nodename) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().getAllOFSDiskGroupNames(nodename);
            }
            return new OFSUtil(acfsutilpath).getAllOFSDiskGroupNames(nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public String getOFSDiskGroupName(String location) throws InstallException {
        return this.do_getOFSDiskGroupName(null, location);
    }

    public String getOFSDiskGroupName(String acfsutilpath, String location) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        return this.do_getOFSDiskGroupName(acfsutilpath, location);
    }

    private String do_getOFSDiskGroupName(String acfsutilpath, String location) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().getOFSDiskGroupName(location);
            }
            return new OFSUtil(acfsutilpath).getOFSDiskGroupName(location);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public String getOFSDiskGroupNameforNode(String location, String nodename) throws InstallException {
        ClusterwareInfo.assertNode(nodename);
        return this.do1_getOFSDiskGroupName(null, location, nodename);
    }

    public String getOFSDiskGroupName(String acfsutilpath, String location, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        ClusterwareInfo.assertNode(nodename);
        return this.do1_getOFSDiskGroupName(acfsutilpath, location, nodename);
    }

    private String do1_getOFSDiskGroupName(String acfsutilpath, String location, String nodename) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().getOFSDiskGroupName(location, nodename);
            }
            return new OFSUtil(acfsutilpath).getOFSDiskGroupName(location, nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public Long getOFSTotalSize(String location) throws InstallException {
        return this.do_getOFSTotalSize(null, location);
    }

    public Long getOFSTotalSize(String acfsutilpath, String location) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        return this.do_getOFSTotalSize(acfsutilpath, location);
    }

    private Long do_getOFSTotalSize(String acfsutilpath, String location) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().getOFSTotalSize(location);
            }
            return new OFSUtil(acfsutilpath).getOFSTotalSize(location);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public Long getOFSTotalSizeforNode(String location, String nodename) throws InstallException {
        ClusterwareInfo.assertNode(nodename);
        return this.do1_getOFSTotalSize(null, location, nodename);
    }

    public Long getOFSTotalSize(String acfsutilpath, String location, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        ClusterwareInfo.assertNode(nodename);
        return this.do1_getOFSTotalSize(acfsutilpath, location, nodename);
    }

    private Long do1_getOFSTotalSize(String acfsutilpath, String location, String nodename) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().getOFSTotalSize(location, nodename);
            }
            return new OFSUtil(acfsutilpath).getOFSTotalSize(location, nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public Long getOFSFreeSpace(String location) throws InstallException {
        return this.do_getOFSFreeSpace(null, location);
    }

    public Long getOFSFreeSpace(String acfsutilpath, String location) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        return this.do_getOFSFreeSpace(acfsutilpath, location);
    }

    private Long do_getOFSFreeSpace(String acfsutilpath, String location) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().getOFSFreeSpace(location);
            }
            return new OFSUtil(acfsutilpath).getOFSFreeSpace(location);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public Long getOFSFreeSpaceforNode(String location, String nodename) throws InstallException {
        ClusterwareInfo.assertNode(nodename);
        return this.do1_getOFSFreeSpace(null, location, nodename);
    }

    public Long getOFSFreeSpace(String acfsutilpath, String location, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        ClusterwareInfo.assertNode(nodename);
        return this.do1_getOFSFreeSpace(acfsutilpath, location, nodename);
    }

    private Long do1_getOFSFreeSpace(String acfsutilpath, String location, String nodename) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().getOFSFreeSpace(location, nodename);
            }
            return new OFSUtil(acfsutilpath).getOFSFreeSpace(location, nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isOFSDriversInstalled() throws InstallException {
        return this.do_isOFSDriversInstalled(null);
    }

    public boolean isOFSDriversInstalled(String acfsutilpath) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        return this.do_isOFSDriversInstalled(acfsutilpath);
    }

    private boolean do_isOFSDriversInstalled(String acfsutilpath) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().isOFSDriversInstalled();
            }
            return new OFSUtil(acfsutilpath).isOFSDriversInstalled();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isOFSDriversInstalledforNode(String nodename) throws InstallException {
        ClusterwareInfo.assertNode(nodename);
        return this.do1_isOFSDriversInstalled(null, nodename);
    }

    public boolean isOFSDriversInstalled(String acfsutilpath, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        ClusterwareInfo.assertNode(nodename);
        return this.do1_isOFSDriversInstalled(acfsutilpath, nodename);
    }

    private boolean do1_isOFSDriversInstalled(String acfsutilpath, String nodename) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().isOFSDriversInstalled(nodename);
            }
            return new OFSUtil(acfsutilpath).isOFSDriversInstalled(nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isACFSDriversInstalled(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            USMDriverUtil util = new USMDriverUtil(crsHome);
            return util.checkACFSState(USMDriverUtil.ACFSDriverState.INSTALLED, crsHome);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isACFSDriversSupported(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            USMDriverUtil util = new USMDriverUtil(crsHome);
            return util.checkACFSState(USMDriverUtil.ACFSDriverState.SUPPORTED, crsHome);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isACFSDriversInstalled(String crsHome, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        ClusterwareInfo.assertNode(nodename);
        try {
            USMDriverUtil util = new USMDriverUtil(crsHome);
            return util.checkACFSState(USMDriverUtil.ACFSDriverState.INSTALLED, crsHome, nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isOFSDriversConfigured() throws InstallException {
        return this.do_isOFSDriversConfigured(null);
    }

    public boolean isOFSDriversConfigured(String acfsutilpath) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        return this.do_isOFSDriversConfigured(acfsutilpath);
    }

    private boolean do_isOFSDriversConfigured(String acfsutilpath) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().isOFSDriversConfigured();
            }
            return new OFSUtil(acfsutilpath).isOFSDriversConfigured();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isOFSDriversConfiguredforNode(String nodename) throws InstallException {
        ClusterwareInfo.assertNode(nodename);
        return this.do1_isOFSDriversConfigured(null, nodename);
    }

    public boolean isOFSDriversConfigured(String acfsutilpath, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        ClusterwareInfo.assertNode(nodename);
        return this.do1_isOFSDriversConfigured(acfsutilpath, nodename);
    }

    private boolean do1_isOFSDriversConfigured(String acfsutilpath, String nodename) throws InstallException {
        try {
            if (acfsutilpath == null) {
                return new OFSUtil().isOFSDriversConfigured(nodename);
            }
            return new OFSUtil(acfsutilpath).isOFSDriversConfigured(nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isACFSDriversConfigured(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            USMDriverUtil util = new USMDriverUtil(crsHome);
            return util.checkACFSState(USMDriverUtil.ACFSDriverState.LOADED, crsHome);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isACFSDriversConfigured(String crsHome, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        ClusterwareInfo.assertNode(nodename);
        try {
            USMDriverUtil util = new USMDriverUtil(crsHome);
            return util.checkACFSState(USMDriverUtil.ACFSDriverState.LOADED, crsHome, nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isAFDDriversLoaded(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            AFDDriverUtil util = new AFDDriverUtil(crsHome);
            return util.checkAFDState(AFDDriverUtil.AFDDriverState.LOADED, crsHome);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isAFDDriversLoaded(String crsHome, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        ClusterwareInfo.assertNode(nodename);
        try {
            AFDDriverUtil util = new AFDDriverUtil(crsHome);
            return util.checkAFDState(AFDDriverUtil.AFDDriverState.LOADED, crsHome, nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isAFDDriversInstalled(String crsHome, String nodename) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        ClusterwareInfo.assertNode(nodename);
        try {
            AFDDriverUtil util = new AFDDriverUtil(crsHome);
            return util.checkAFDState(AFDDriverUtil.AFDDriverState.INSTALLED, crsHome, nodename);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isAFDDriversInstalled(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            AFDDriverUtil util = new AFDDriverUtil(crsHome);
            return util.checkAFDState(AFDDriverUtil.AFDDriverState.INSTALLED, crsHome);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isAFDDriversSupported(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            AFDDriverUtil util = new AFDDriverUtil(crsHome);
            return util.checkAFDState(AFDDriverUtil.AFDDriverState.SUPPORTED, crsHome);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isASMLibInstalled(String nodeName) throws InstallException {
        boolean result = false;
        NativeSystem system = new SystemFactory().CreateSystem();
        if (system.isUnixSystem() && DeterminePlatform.getOSName().equals("Linux")) {
            String ASM_LIB = "/opt/oracle/extapi/64/asm/orcl/1/libasm.so";
            ClusterCmd cmd = new ClusterCmd();
            try {
                result = cmd.fileExists(nodeName, ASM_LIB);
            }
            catch (ClusterException ce) {
                throw new InstallException(ce);
            }
        }
        return result;
    }

    public String getClusterName(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        return this.getClusterName(crsHome, new Version());
    }

    public String getClusterName(String crsHome, Version ver) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        if (Version.isPre112(ver)) {
            try {
                CEMUTLUtil cemUtil = new CEMUTLUtil(crsHome);
                return cemUtil.getClusterName();
            }
            catch (CmdToolUtilException e) {
                throw new InstallException((MessageKey)PrCiMsgID.GET_CLUSTERNAME_FAILED, (Throwable)e, crsHome, ver.toString());
            }
        }
        try {
            OLSNODESUtil olsnUtil = new OLSNODESUtil(crsHome);
            return olsnUtil.getClusterName();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_CLUSTERNAME_FAILED, (Throwable)e, crsHome, ver.toString());
        }
    }

    public String getRemoteClusterName(String node, String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, false);
        ClusterwareInfo.assertNode(node);
        try {
            OLSNODESUtil olsnUtil = new OLSNODESUtil(node, crsHome);
            return olsnUtil.getRemoteClusterName();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public Map<String, List<ClientClusterComponent>> getClientClusterswithComp() throws NotExistsException, InstallException {
        HashMap<String, List<ClientClusterComponent>> clientClusterMap = new HashMap<String, List<ClientClusterComponent>>();
        List<ClientClusterInfo> clientClusters = this.getClientClusterInfo();
        for (ClientClusterInfo ccinfo : clientClusters) {
            clientClusterMap.put(ccinfo.getClusterName(), ccinfo.getClusterComponents());
        }
        return clientClusterMap;
    }

    public Map<String, Version> getClientClusters() throws NotExistsException, InstallException {
        HashMap<String, Version> clientClusterMap = new HashMap<String, Version>();
        List<ClientClusterInfo> clientClusters = this.getClientClusterInfo();
        for (ClientClusterInfo ccinfo : clientClusters) {
            clientClusterMap.put(ccinfo.getClusterName(), ccinfo.getVersion());
        }
        return clientClusterMap;
    }

    public List<ClientClusterInfo> getClientClusterInfo() throws NotExistsException, InstallException {
        String crsHome = null;
        List<ClientClusterInfo> clientClusters = null;
        try {
            crsHome = this.getCRSHome(new Version());
            ClusterwareInfo.assertDir(crsHome, true);
            Trace.out("creating instance of ASMCMDUtil");
            ASMCMDUtil asmcmd = new ASMCMDUtil(crsHome);
            clientClusters = asmcmd.getClientClusterInfo();
            Trace.out("got client clusters");
        }
        catch (CmdToolUtilException e) {
            Trace.out("exception while trying to get client cluster: " + e.getMessage());
            throw new InstallException(e);
        }
        return clientClusters;
    }

    public List<String> getActiveClusterNodes(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            OLSNODESUtil olsnUtil = new OLSNODESUtil(crsHome);
            return olsnUtil.getActiveClusterNodes();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public HashMap<String, String> getClusterPrivateHostnames(String pre11gR2CrsHome) throws InstallException {
        ClusterwareInfo.assertDir(pre11gR2CrsHome, true);
        try {
            OLSNODESUtil olsnUtil = new OLSNODESUtil(pre11gR2CrsHome);
            return olsnUtil.getClusterPrivateHosts();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public List<String> getInactiveClusterNodes(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            OLSNODESUtil olsnUtil = new OLSNODESUtil(crsHome);
            return olsnUtil.getInactiveClusterNodes();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public long getTotalSizeInBytes(String topDirPathname, String excludeListFilePathname, boolean excludePathnamesCanBeRegex, String includeListFilePathname, boolean includePathnamesCanBeRegex) throws InstallException {
        try {
            return MultiTierTransfer.getTotalSizeInBytes(topDirPathname, excludeListFilePathname, excludePathnamesCanBeRegex, includeListFilePathname, includePathnamesCanBeRegex);
        }
        catch (RACTransErrorException error) {
            throw new InstallException(error);
        }
    }

    public boolean isDHCPServerConfigured(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            return new CRSCTLUtil(crsHome).isDHCPServerConfigured();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.VIP_DHCP_CHECK_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public List<String> getPinnedClusterNodes(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            OLSNODESUtil olsnUtil = new OLSNODESUtil(crsHome);
            return olsnUtil.getPinnedClusterNodes();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public List<String> getUnpinnedClusterNodes(String crsHome) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        try {
            OLSNODESUtil olsnUtil = new OLSNODESUtil(crsHome);
            return olsnUtil.getUnpinnedClusterNodes();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isACFSPathRegistered(String crsHome, String path) throws InstallException {
        ClusterwareInfo.assertDir(crsHome, true);
        ClusterwareInfo.assertDir(path, true);
        if (!this.isPathOnACFS(crsHome, path, "localnode")) {
            throw new InstallException((MessageKey)PrCiMsgID.PATH_NOT_ON_ACFS, path);
        }
        try {
            NativeSystem system = new SystemFactory().CreateSystem();
            OFSUtil ofsUtil = system.isUnixSystem() ? new OFSUtil() : new OFSUtil(crsHome + File.separator + "bin");
            String mntPath = ofsUtil.getMountpoint(path);
            if (mntPath == null) {
                Trace.out("This is not an ACFS filesystem");
                return false;
            }
            Trace.out("mountpt path = " + mntPath);
            CRSCTLUtil crsUtil = new CRSCTLUtil(crsHome);
            return crsUtil.isACFSRegisteredForMtPt(mntPath);
        }
        catch (CmdToolUtilException cte) {
            Trace.out("CmdToolUtilException : " + cte.getMessage());
            throw new InstallException(cte);
        }
    }

    public boolean isACFSPath(String acfsutilpath, String path) throws InstallException {
        ClusterwareInfo.assertDir(acfsutilpath, true);
        ClusterwareInfo.assertDir(path, true);
        try {
            OFSUtil acfsUtil = new OFSUtil(acfsutilpath);
            String mntPath = acfsUtil.getMountpoint(path);
            if (mntPath == null) {
                Trace.out("This is not an ACFS filesystem");
                return false;
            }
            return acfsUtil.isOFSPartition(mntPath);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.ISGIVENPATHONACFS_CHECK_FAILED, (Throwable)e, path);
        }
    }

    public String getVolumeDevice(String path) throws InstallException {
        return this.doGetVolumeDevice(path, "localnode", null);
    }

    public String getVolumeDevice(String path, String node) throws InstallException {
        ClusterwareInfo.assertNode(node);
        return this.doGetVolumeDevice(path, node, null);
    }

    public String getVolumeDevice(String path, String node, String oraHome) throws InstallException {
        ClusterwareInfo.assertNode(node);
        return this.doGetVolumeDevice(path, node, oraHome);
    }

    private String doGetVolumeDevice(String path, String node, String oraHome) throws InstallException {
        Trace.out("oraHome=" + oraHome + " ;path=" + path + " ;node=" + node);
        try {
            OFSUtil ofsUtil = this.getOFSUtil(oraHome);
            String mntPath = ofsUtil.getMountPoint(path, node);
            if (mntPath == null) {
                Trace.out("This is not an ACFS filesystem");
                throw new InstallException((MessageKey)PrCiMsgID.PATH_NOT_ACFS_FILESYSTEM, path);
            }
            return ofsUtil.getVolumeDevice(mntPath);
        }
        catch (CmdToolUtilException e) {
            if (node == null || node.equals("localnode")) {
                throw new InstallException((MessageKey)PrCiMsgID.GETVOLUMEDEVICE_FAILED, (Throwable)e, path);
            }
            throw new InstallException((MessageKey)PrCiMsgID.GETVOLUMEDEVICE_NODE_FAILED, (Throwable)e, path, node);
        }
    }

    public List<VolumeInfo> getVolumes() throws InstallException, NotExistsException {
        return this.getVolumes(null);
    }

    public List<VolumeInfo> getVolumes(String user) throws InstallException, NotExistsException {
        String crsHome = null;
        List<VolumeInfo> volInfoList = null;
        try {
            Version version = new Version();
            crsHome = this.getCRSHome(version);
            ClusterwareInfo.assertDir(crsHome, true);
            Trace.out("creating instance of ASMCMDUtil");
            ASMCMDUtil asmcmd = new ASMCMDUtil(crsHome, "", version);
            volInfoList = asmcmd.getVolumes(user);
            Trace.out("got volumes");
        }
        catch (CmdToolUtilException e) {
            Trace.out("exception while trying to get volumes: " + e.getMessage());
            throw new InstallException(e);
        }
        return volInfoList;
    }

    private OFSUtil getOFSUtil(String oraHome) throws CmdToolUtilException {
        OFSUtil ofsUtil = null;
        ofsUtil = oraHome == null || oraHome.trim().length() == 0 ? new OFSUtil() : new OFSUtil(oraHome + File.separator + "bin");
        return ofsUtil;
    }

    public boolean isPathOnACFS(String path) throws InstallException {
        String crsHome = this.getCRSHome(new Version());
        return this.doIsPathOnACFS(crsHome, path, "localnode");
    }

    public String getACFSMountpoint(String oraHome, String path) throws InstallException {
        return this.doGetACFSMountpoint(oraHome, path, "localnode");
    }

    public String getACFSMountpoint(String oraHome, String path, String node) throws InstallException {
        return this.doGetACFSMountpoint(oraHome, path, node);
    }

    private String doGetACFSMountpoint(String oraHome, String path, String node) throws InstallException {
        ClusterwareInfo.assertNode(node);
        ClusterwareInfo.assertDir(oraHome, true);
        if (path == null || path.trim().length() == 0) {
            throw new InstallException((MessageKey)PrCiMsgID.NULL_DIR_NAME, new Object[0]);
        }
        try {
            OFSUtil ofs = new OFSUtil(oraHome + File.separator + "bin");
            String mtPoint = ofs.getMountPoint(path, node);
            if (mtPoint != null) {
                return mtPoint;
            }
            Trace.out("Path " + path + " is not on ACFS");
            throw new InstallException((MessageKey)PrCiMsgID.PATH_NOT_ACFS_FILESYSTEM, path);
        }
        catch (CmdToolUtilException cue) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_ACFS_MTPT_FAILED, (Throwable)cue, path);
        }
    }

    public boolean isPathOnACFS(String path, String node) throws InstallException {
        ClusterwareInfo.assertNode(node);
        String crsHome = this.getCRSHome(new Version());
        return this.doIsPathOnACFS(crsHome, path, node);
    }

    public boolean isPathOnACFS(String oraHome, String path, String node) throws InstallException {
        ClusterwareInfo.assertNode(node);
        return this.doIsPathOnACFS(oraHome, path, node);
    }

    private boolean doIsPathOnACFS(String oraHome, String path, String node) throws InstallException {
        Trace.out("\noraHome=" + oraHome + "\npath=" + path + "\nnode=" + node);
        if (oraHome != null && oraHome.trim().length() > 0) {
            try {
                OFSUtil ofsUtil = new OFSUtil(oraHome + File.separator + "bin");
                return ofsUtil.getMountPoint(path, node) != null;
            }
            catch (CmdToolUtilException e) {
                throw new InstallException((MessageKey)PrCiMsgID.ISPATHONACFS_CHECK_FAILED, (Throwable)e, path, node);
            }
        }
        Trace.out("Oracle home location is not supplied or is an empty string, returning false");
        return false;
    }

    public List<String> checkSharedFileSystemPath(String pathName, String localNode, String[] nodeList, String crsHome) throws InvalidNodeListException, SharedDeviceException, InstallException {
        String dirPath;
        if (nodeList == null || nodeList.length == 0) {
            Trace.out("nodeList passed is null or an empty list");
            throw new InvalidNodeListException("Prkc", "1062");
        }
        if (pathName == null || pathName.trim().length() == 0) {
            Trace.out("pathName passed is null or an empty string");
            throw new SharedDeviceException(MessageBundle.getMessageBundle("Prkc").getMessage("1055", true));
        }
        if (localNode == null || localNode.length() == 0) {
            Object[] args = new Object[]{"CIsharedFSP-01"};
            throw new InstallException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, args);
        }
        String localNodeName = Utils.getShortHostname(localNode);
        HashSet<String> nodeSet = new HashSet<String>();
        try {
            Iterator<String> iterator;
            Set<String> localNodeAliasList = Utils.getLocalHostAliasesFromNodeList(nodeList);
            if (!localNodeAliasList.isEmpty() && (iterator = localNodeAliasList.iterator()).hasNext()) {
                String alias = iterator.next();
                Trace.out("Local host (" + localNode + ") has an alias " + "by name (" + alias + "). Replacing with alias");
                localNodeName = alias;
            }
            try {
                InetAddress.getByName(localNodeName);
            }
            catch (UnknownHostException uhe) {
                Object[] args = new Object[]{localNodeName};
                throw new InstallException((MessageKey)PrCnMsgID.UNKNOWN_HOST, (Throwable)uhe, args);
            }
            Trace.out("NodeList=" + Arrays.asList(nodeList));
            for (String curnode : nodeList) {
                if (localNodeAliasList.contains(curnode = Utils.getShortHostname(curnode)) || localNode.equalsIgnoreCase(curnode)) continue;
                nodeSet.add(curnode.toLowerCase());
            }
            nodeSet.add(localNodeName.toLowerCase());
        }
        catch (UnknownHostException uhe) {
            Trace.out("Caught UnknownHostException : reporting " + uhe.getMessage());
            throw new InvalidNodeListException(uhe.getMessage());
        }
        String[] effectiveNodeList = nodeSet.toArray(new String[nodeSet.size()]);
        File file = new File(pathName);
        try {
            dirPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            dirPath = file.getAbsolutePath();
        }
        Trace.out("pathName=" + pathName + " dirPath = " + dirPath);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        NativeResult result = new NativeResult();
        List<String> pathSharedNodeList = new ArrayList<String>();
        if (nativeSystem.isUnixSystem()) {
            pathSharedNodeList = nativeSystem.checkSharedFileSystemPath(pathName, effectiveNodeList, localNodeName, result);
        } else if (crsHome != null && crsHome.trim().length() > 0 && this.isCRSConfigured(crsHome) && this.isACFSDriversSupported(crsHome) && this.isPathOnACFS(crsHome, pathName, localNodeName)) {
            pathSharedNodeList.addAll(Arrays.asList(effectiveNodeList));
        }
        return pathSharedNodeList;
    }

    public Version getSRVCTLVersion(String node, String oHome) throws InstallException {
        ClusterwareInfo.assertNode(node);
        ClusterwareInfo.assertDir(oHome, true);
        try {
            Version srvCtlver = new SRVCTLUtil(oHome).getSRVCTLVersion(node);
            return srvCtlver;
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public Version getSRVCTLVersion(String oHome) throws InstallException {
        ClusterwareInfo.assertDir(oHome, true);
        try {
            Version srvCtlver = new SRVCTLUtil(oHome).getSRVCTLVersion();
            return srvCtlver;
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public Version getSRVCTLVersionNLS(String node, String oHome) throws InstallException {
        ClusterwareInfo.assertNode(node);
        ClusterwareInfo.assertDir(oHome, true);
        try {
            Version srvCtlver = new SRVCTLUtil(oHome).getSRVCTLVersionNLS(node);
            return srvCtlver;
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public Version getSRVCTLVersionNLS(String oHome) throws InstallException {
        ClusterwareInfo.assertDir(oHome, true);
        try {
            Version srvCtlver = new SRVCTLUtil(oHome).getSRVCTLVersionNLS();
            return srvCtlver;
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public String getCRSHome(Version version) throws InstallException {
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            return system.getCRSHome(version);
        }
        catch (NativeException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_CRS_HOME_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public String getCRSHome(String node, Version version) throws InstallException {
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            return system.getCRSHome(node, version);
        }
        catch (NativeException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_CRS_HOME_NODE_FAILED, (Throwable)e, node);
        }
    }

    public String getCRSVersion(String crsHome) throws InstallException {
        String version = null;
        try {
            version = this.getCRSActiveVersionString(crsHome);
            return version;
        }
        catch (InstallException e) {
            Trace.out("Exception occured while trying to get CRSActiveVersion" + e);
            Trace.out("Now trying to get SIHASoftwareVersion");
        }
        catch (NoSuchCRSHomeException e) {
            Trace.out("Exception occured while trying to get CRSActiveVersion" + e);
            Trace.out("Now trying to get SIHASoftwareVersion");
        }
        catch (NoSuchExecutableException e) {
            Trace.out("Exception occured while trying to get CRSActiveVersion" + e);
            Trace.out("Now trying to get SIHASoftwareVersion");
        }
        catch (ClusterInfoException e) {
            Trace.out("Exception occured while trying to get CRSActiveVersion" + e);
            Trace.out("Now trying to get SIHASoftwareVersion");
        }
        try {
            version = this.getSIHASoftwareVersionString(crsHome);
            return version;
        }
        catch (InstallException e) {
            Trace.out("Exception occured while trying to get SIHASoftwareVersionString" + e);
            throw new InstallException(e);
        }
        catch (NoSuchCRSHomeException e) {
            Trace.out("Exception occured while trying to get SIHASoftwareVersionString" + e);
            throw new InstallException(e);
        }
        catch (NoSuchExecutableException e) {
            Trace.out("Exception occured while trying to get SIHASoftwareVersionString" + e);
            throw new InstallException(e);
        }
        catch (ClusterInfoException e) {
            Trace.out("Exception occured while trying to get SIHASoftwareVersionString" + e);
            throw new InstallException(e);
        }
    }

    public HashMap<String, NodeRole> getClusterNodeActiveRoles(String crsHome) throws InstallException {
        try {
            OLSNODESUtil olsnUtil = new OLSNODESUtil(crsHome);
            return olsnUtil.getClusterNodeActiveRoles();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_CLUSTER_ACTIVE_ROLES_FAILED, (Throwable)e, crsHome);
        }
    }

    public HashMap<String, NodeRole> getClusterNodeRoles(String crsHome) throws InstallException {
        try {
            OLSNODESUtil olsnUtil = new OLSNODESUtil(crsHome);
            return olsnUtil.getClusterNodeRoles();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_CLUSTER_NODE_ROLES_FAILED, (Throwable)e, crsHome);
        }
    }

    public List<String> getHistoricalClusterNodes(String crsHome) throws InstallException {
        try {
            OCRDUMPUtil ocrdumputil = new OCRDUMPUtil(crsHome);
            return ocrdumputil.getHistoricalClusterNodes();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public HashMap<String, NodeRole> getFlexHistoricalClusterNodes(String crsHome) throws InstallException {
        try {
            HashMap<String, NodeRole> nodeMap = new HashMap<String, NodeRole>();
            OLSNODESUtil olsnUtil = new OLSNODESUtil(crsHome);
            HashMap<String, NodeRole> nodesRoles = olsnUtil.getClusterNodeRoles();
            for (Map.Entry<String, NodeRole> entry : nodesRoles.entrySet()) {
                if (entry.getValue() != NodeRole.HUB) continue;
                nodeMap.put(entry.getKey(), NodeRole.HUB);
            }
            List<String> histLeafNodeList = olsnUtil.getHistoricalClusterNodes();
            for (String node : histLeafNodeList) {
                nodeMap.put(node, NodeRole.RIM);
            }
            Trace.out(" Flex historical cluster node map :" + nodeMap);
            return nodeMap;
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public NodeRole getActiveNodeRole(String crsHome, String nodeName) throws InstallException {
        try {
            HashMap<String, NodeRole> roleMap = this.getClusterNodeActiveRoles(crsHome);
            Iterator<String> iter = roleMap.keySet().iterator();
            NodeRole role = NodeRole.NONE;
            String[] temp = nodeName.split(DELIMITER);
            nodeName = temp[0];
            while (iter.hasNext()) {
                String node = iter.next();
                if (!node.equalsIgnoreCase(nodeName)) continue;
                role = roleMap.get(node);
                Trace.out("Active node role of the node " + nodeName + " is " + (Object)((Object)role));
            }
            return role;
        }
        catch (InstallException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_ACTIVE_NODE_ROLE_FAILED, (Throwable)e, nodeName);
        }
    }

    public HashMap<String, NodeRole> getClusterNodeConfigRoles(String crsHome) throws InstallException {
        try {
            CRSCTLUtil crsUtil = new CRSCTLUtil(crsHome);
            return crsUtil.getClusterNodeConfigRoles();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_CLUSTER_CONFIG_ROLES_FAILED, (Throwable)e, crsHome);
        }
    }

    public NodeRole getNodeConfigRole(String crsHome, String nodeName) throws InstallException {
        try {
            CRSCTLUtil crsUtil = new CRSCTLUtil(crsHome);
            NodeRole role = crsUtil.getNodeConfigRole(nodeName);
            Trace.out("Active node role of the node " + nodeName + " is " + (Object)((Object)role));
            return role;
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_CONFIG_NODE_ROLE_FAILED, (Throwable)e, nodeName);
        }
    }

    public String getMgmtDBName() {
        return "_mgmtdb";
    }

    public String getMgmtDBInstName() {
        return "-MGMTDB";
    }

    public String getMgmtDBNodeName() throws InstallException {
        HelperUtil hUtl = new HelperUtil();
        String mgmtDBNodeName = null;
        try {
            mgmtDBNodeName = hUtl.getMgmtDBNodeName();
        }
        catch (HelperException e) {
            throw new InstallException(e);
        }
        return mgmtDBNodeName;
    }

    public void setASMNetwork(String oifcfgLoc, String ifname, String subnet, boolean clusterInterconnect) throws InstallException {
        ClusterwareInfo.assertDir(oifcfgLoc, true);
        try {
            OIFCFGUtil oifcfgUtil = new OIFCFGUtil(oifcfgLoc);
            oifcfgUtil.setASMNetwork(ifname, subnet, clusterInterconnect);
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public int getMaxHubSize() throws InstallException {
        try {
            BigCluster bc = BigClusterFactory.getInstance().getBigCluster();
            int maxhubsize = bc.getMaxHubSize();
            return maxhubsize;
        }
        catch (BigClusterException be) {
            throw new InstallException(be);
        }
    }

    public List<LWServerPool> getHubPools() throws InstallException {
        try {
            return new SRVMHELPERUtil(this.getCRSHome(new Version())).getServerPools(HUB);
        }
        catch (CmdToolUtilException e) {
            Trace.out("srvmhelper getserverpools failed " + e.getMessage());
            throw new InstallException(e);
        }
    }

    public List<LWServerPool> getLeafPools() throws InstallException {
        try {
            return new SRVMHELPERUtil(this.getCRSHome(new Version())).getServerPools(LEAF);
        }
        catch (CmdToolUtilException e) {
            Trace.out("srvmhelper getserverpools failed " + e.getMessage());
            throw new InstallException(e);
        }
    }

    public Map<NodeRole, List<String>> getActiveServersForFreePool() throws InstallException {
        try {
            return new SRVMHELPERUtil(this.getCRSHome(new Version())).getActiveServers(ResourceLiterals.FREE_POOL.toString());
        }
        catch (CmdToolUtilException e) {
            Trace.out("srvmhelper getActiveServersForFreePool failed " + e.getMessage());
            throw new InstallException(e);
        }
    }

    public int getTargetHubSize() throws InstallException {
        int tgtHubSize;
        HelperUtil hUtl = new HelperUtil();
        try {
            tgtHubSize = hUtl.getTargetHubSize();
        }
        catch (HelperException e) {
            throw new InstallException(e);
        }
        return tgtHubSize;
    }

    int getRequiredMgmtDBSize(int numOfNodes) throws InstallException {
        return this.getRequiredMgmtDBSize(numOfNodes, 0, false);
    }

    public int getRequiredMgmtDBSize(int numOfNodes, int seedDBSize, boolean flexCluster) throws InstallException {
        NativeSystem system = new SystemFactory().CreateSystem();
        int size = 0;
        try {
            size = system.getMgmtDBSpace(numOfNodes, seedDBSize, flexCluster);
            Trace.out("Space returned from native code: " + size);
        }
        catch (NativeException ne) {
            Trace.out("Failed to get mgmtdb size from native code: " + ne);
            throw new InstallException((MessageKey)PrCiMsgID.GET_MGMTDB_SIZE_FAILED, new Throwable(ne), new Object[0]);
        }
        return size;
    }

    public int getGIMRDiskGroupSize(int noOfPDBs, int noOfHuborAutoNodes, int noOfLeafNodes, int seedDBSize, boolean isDSC, EnumSet<DiskSpaceFlags> diskSpaceFlagEnumSet) throws InstallException {
        NativeSystem system = new SystemFactory().CreateSystem();
        int size = 0;
        try {
            size = system.getGIMRDiskSpace(noOfHuborAutoNodes, noOfLeafNodes, seedDBSize, isDSC, noOfPDBs, diskSpaceFlagEnumSet);
            Trace.out("GIMR Space returned from native code: " + size);
        }
        catch (NativeException ne) {
            Trace.out("Failed to get GIMR size from native code: " + ne.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_GIMR_SIZE_FAILED, (Throwable)ne, new Object[0]);
        }
        return size;
    }

    public int getReqdDiskGroupSize(int numOfHubOrAutoNodes, int numOfLeafNodes, int seedDBSize, boolean isRHPS, boolean isDSC, int noOfMemberClusters, EnumSet<DiskSpaceFlags> diskSpaceFlagEnumSet) throws InstallException {
        int totalSize = 0;
        int size_per_node = 20480;
        int rhps_size = 102400;
        if (Utils.isHasInstallLRGEnv()) {
            size_per_node = 512;
            rhps_size = 20480;
        }
        if (isDSC && noOfMemberClusters <= 0) {
            throw new InstallException((MessageKey)PrCiMsgID.INVALID_MEMBER_CLUSTER_NUM, noOfMemberClusters);
        }
        totalSize += this.getBackupDGSize();
        totalSize += this.getGIMRDiskGroupSize(noOfMemberClusters, numOfHubOrAutoNodes, numOfLeafNodes, seedDBSize, isDSC, diskSpaceFlagEnumSet);
        if (isRHPS) {
            totalSize += rhps_size;
        }
        return totalSize;
    }

    public int getMgmtDBSize(int numOfNodes, int seedDBSize) throws InstallException {
        return this.getRequiredMgmtDBSize(numOfNodes, seedDBSize, false);
    }

    public int getMgmtDBSize(int numOfHubOrAutoNodes, int numOfLeafNodes, int seedDBSize) throws InstallException {
        return this.getRequiredMgmtDBSize(numOfHubOrAutoNodes + numOfLeafNodes, seedDBSize, false);
    }

    public int getMgmtDBSize(boolean flexCluster, int numOfRegularOrHubOrAutoNodes, int numOfLeafNodes, int seedDBSize) throws InstallException {
        return this.getRequiredMgmtDBSize(numOfRegularOrHubOrAutoNodes + numOfLeafNodes, seedDBSize, flexCluster);
    }

    public HashMap<String, String> getAdminGroups(String imagePath, Version version) throws InstallException {
        HashMap<String, String> grpTbl;
        ClusterwareInfo.assertVersion(version);
        try {
            grpTbl = new OSDBAGRPUtil(imagePath, version).getAdminGroups();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
        return grpTbl;
    }

    public Map<OracleGroupsEnum, String> getOracleGroups(String imagePath, Version version) throws InstallException {
        EnumMap<OracleGroupsEnum, String> grpTbl;
        ClusterwareInfo.assertVersion(version);
        try {
            Trace.out("Calling OSDBAGRPUtil");
            grpTbl = new OSDBAGRPUtil(imagePath, version).getOracleGroups();
        }
        catch (CmdToolUtilException e) {
            Trace.out(e);
            throw new InstallException(e);
        }
        return grpTbl;
    }

    public Map<OracleGroupsEnum, String> getOracleGroups(String imagePath, Version version, String node) throws InstallException {
        EnumMap<OracleGroupsEnum, String> grpTbl;
        ClusterwareInfo.assertVersion(version);
        try {
            Trace.out("Calling OSDBAGRPUtil");
            grpTbl = new OSDBAGRPUtil(imagePath, version).getOracleGroups(node);
        }
        catch (CmdToolUtilException e) {
            Trace.out(e);
            throw new InstallException(e);
        }
        return grpTbl;
    }

    public boolean isMgmtDBConfigured() throws InstallException {
        try {
            new HelperUtil();
            return HelperUtil.isMgmtDBConfigured();
        }
        catch (HelperException e) {
            throw new InstallException(e);
        }
    }

    public boolean isMgmtDBConfigured(Version version) throws InstallException {
        if (Version.isPre12101(version)) {
            return false;
        }
        if (Version.get12101Version().equals(version)) {
            String crsHome = this.getCRSHome(version);
            try {
                CRSCTLUtil crsctlUtil = new CRSCTLUtil(crsHome);
                return crsctlUtil.isMgmtDBRegistered();
            }
            catch (CmdToolUtilException cte) {
                throw new InstallException(cte);
            }
        }
        return this.isMgmtDBConfigured();
    }

    public GIMRProperties getGIMRProperties(String clientCluster, String credFile) throws InstallException, NotExistsException {
        try {
            CredentialsFactory credFactory = CredentialsFactory.getInstance();
            return credFactory.getGIMRProperties(clientCluster, credFile);
        }
        catch (CredentialsException e) {
            throw new InstallException(e);
        }
    }

    public boolean validateACFSPermission(String acfsPath, String user) throws InstallException {
        HelperUtil hutl = new HelperUtil();
        try {
            return hutl.hasACFSPermission(acfsPath, user);
        }
        catch (HelperException e) {
            throw new InstallException((MessageKey)PrCrMsgID.INSUFFICIENT_USER_PRIVILEGE_ERROR_ON_ACFS, (Throwable)e, acfsPath, user);
        }
    }

    public Version getSQLPLUSVersion(String oHome) throws InstallException {
        ClusterwareInfo.assertDir(oHome, true);
        try {
            Version sqlplusver = new SQLPLUSUtil(oHome).getSQLPLUSVersion();
            return sqlplusver;
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public Version getSQLPLUSVersion(String nodeName, String oHome) throws InstallException {
        ClusterwareInfo.assertDir(oHome, true);
        try {
            Version sqlplusver = new SQLPLUSUtil(oHome).getSQLPLUSVersion(nodeName);
            return sqlplusver;
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public String getSQLPLUSVersionStr(String oHome) throws InstallException {
        ClusterwareInfo.assertDir(oHome, true);
        try {
            String sqlplusver = new SQLPLUSUtil(oHome).getSQLPLUSVersionStr();
            return sqlplusver;
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public String getOracleBaseLoc(String oraHome, Version version) throws InstallException {
        try {
            return new ORABASEUtil(oraHome).getORABASE_LOC();
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public String getOracleBaseLoc(String oraHome, String nodeName, Version version) throws InstallException {
        ClusterwareInfo.assertNode(nodeName);
        try {
            return new ORABASEUtil(oraHome).getORABASE_LOC(nodeName);
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public String getCRSHomeOracleBase(Version version) throws InstallException {
        try {
            return this.getOracleBaseLoc(this.getCRSHome(version), version);
        }
        catch (InstallException ie) {
            throw new InstallException(ie);
        }
    }

    public String getCRSHomeOracleBase(String nodeName, Version version) throws InstallException {
        try {
            return this.getOracleBaseLoc(this.getCRSHome(nodeName, version), nodeName, version);
        }
        catch (InstallException ie) {
            throw new InstallException(ie);
        }
    }

    private void apiUnsupportedOnSIHA(String apiName) throws InstallException {
        try {
            CRSCTLUtil crsutl = new CRSCTLUtil(this.getCRSHome(new Version()));
            if (crsutl.isSIHA()) {
                Object[] args = new Object[]{apiName + " not supported on Oracle Restart"};
                throw new InstallException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, args);
            }
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public ClusterClassification getClusterClassification() throws InstallException {
        this.apiUnsupportedOnSIHA("getClusterClassification");
        try {
            CRSCTLUtil crsutl = new CRSCTLUtil(this.getCRSHome(new Version()));
            return crsutl.getClusterClassification();
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public String getClusterType() throws InstallException {
        this.apiUnsupportedOnSIHA("getClusterType");
        String type = null;
        try {
            CRSCTLUtil crsutl = new CRSCTLUtil(this.getCRSHome(new Version()));
            type = crsutl.getClusterType();
            return type;
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public boolean isApplicationCluster() throws InstallException {
        String clusterType = this.getClusterType();
        Trace.out("clusterType is " + clusterType);
        return clusterType != null && "application".equals(clusterType.trim());
    }

    public ClusterType getClusterTypeEnum() throws InstallException {
        String type = null;
        try {
            type = this.getClusterType();
            ClusterType ctype = ClusterType.getEnumMember(type);
            return ctype;
        }
        catch (InstallException cmdte) {
            throw new InstallException(cmdte);
        }
        catch (EnumConstantNotPresentException e) {
            throw new InstallException(e);
        }
    }

    public String getClusterGUID() throws InstallException {
        String guid = null;
        try {
            CRSCTLUtil crsutl = new CRSCTLUtil(this.getCRSHome(new Version()));
            guid = crsutl.getClusterGUID();
            return guid;
        }
        catch (CmdToolUtilException cmdte) {
            throw new InstallException(cmdte);
        }
    }

    public static boolean isLeafNodeAllowed(String oracleHome) throws InstallException {
        try {
            return new SRVMHELPERUtil(oracleHome).isLeafNodeAllowed();
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }

    public boolean isExtendedCluster() throws InstallException {
        try {
            Class<?> ServerFactoryClass = Class.forName("oracle.cluster.server.ServerFactory");
            Method getInstanceMethod = ServerFactoryClass.getMethod("getInstance", new Class[0]);
            Method isExtendedClusterMethod = ServerFactoryClass.getMethod("isExtendedCluster", new Class[0]);
            Object obj = getInstanceMethod.invoke(ServerFactoryClass, new Object[0]);
            return (Boolean)isExtendedClusterMethod.invoke(obj, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new InstallException(e);
        }
        catch (IllegalAccessException e) {
            throw new InstallException(e);
        }
        catch (NoSuchMethodException e) {
            throw new InstallException(e);
        }
        catch (InvocationTargetException e) {
            throw new InstallException(e);
        }
    }

    public List<Site> getConfiguredSites() throws InstallException {
        try {
            Class<?> ClusterUtilClass = Class.forName("oracle.ops.mgmt.has.ClusterUtil");
            Object clusterUtilObj = ClusterUtilClass.newInstance();
            Method getNodeNamesMethod = ClusterUtilClass.getMethod("getNodeNames", new Class[0]);
            String[] nodeNames = (String[])getNodeNamesMethod.invoke(clusterUtilObj, new Object[0]);
            Class<?> ServerFactoryClass = Class.forName("oracle.cluster.server.ServerFactory");
            Method getInstanceMethod = ServerFactoryClass.getMethod("getInstance", new Class[0]);
            Method getConfiguredSitesMethod = ServerFactoryClass.getMethod("getConfiguredSites", new Class[0]);
            Method getSitesForNodesMethod = ServerFactoryClass.getMethod("getSitesForNodes", String[].class);
            Object obj = getInstanceMethod.invoke(ServerFactoryClass, new Object[0]);
            List cfgSites = (List)getConfiguredSitesMethod.invoke(obj, new Object[0]);
            List sitesWithNodes = (List)getSitesForNodesMethod.invoke(obj, new Object[]{nodeNames});
            if (sitesWithNodes != null) {
                block6: for (Site sitewn : sitesWithNodes) {
                    for (Site site : cfgSites) {
                        if (!site.getSiteName().equalsIgnoreCase(sitewn.getSiteName())) continue;
                        site.setNodeList(sitewn.getNodeList());
                        continue block6;
                    }
                }
            }
            return cfgSites;
        }
        catch (ClassNotFoundException e) {
            Trace.out("Got ClassNotFoundException: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (InstantiationException e) {
            Trace.out("Got InstantiationException: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (IllegalAccessException e) {
            Trace.out("Got IllegalAccessException: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (NoSuchMethodException e) {
            Trace.out("Got NoSuchMethodException: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (InvocationTargetException e) {
            Trace.out("Got InvocationTargetException: " + e.getMessage());
            throw new InstallException(e);
        }
    }

    public Site getSiteForNode(String nodeName) throws InstallException {
        try {
            Class<?> ServerFactoryClass = Class.forName("oracle.cluster.server.ServerFactory");
            Method getInstanceMethod = ServerFactoryClass.getMethod("getInstance", new Class[0]);
            Method getSiteForNodeMethod = ServerFactoryClass.getMethod("getSiteForNode", String.class);
            Object obj = getInstanceMethod.invoke(ServerFactoryClass, new Object[0]);
            return (Site)getSiteForNodeMethod.invoke(obj, nodeName);
        }
        catch (ClassNotFoundException e) {
            throw new InstallException(e);
        }
        catch (IllegalAccessException e) {
            throw new InstallException(e);
        }
        catch (NoSuchMethodException e) {
            throw new InstallException(e);
        }
        catch (InvocationTargetException e) {
            throw new InstallException(e);
        }
    }

    public static boolean isOPCDoMUCluster() {
        Trace.out("isDBAASCluster: Not implemented yet");
        return false;
    }

    public boolean isPathOnASM(String path) {
        NativeSystem system = new SystemFactory().CreateSystem();
        return system.isPathOnASM(path);
    }

    public boolean isOHOMEDNFSEnabled(String oracleHome) throws InstallException {
        try {
            ORADNFSUtil odnfs = new ORADNFSUtil(oracleHome);
            return odnfs.isOHOMEDNFSEnabled(oracleHome);
        }
        catch (CmdToolUtilException cte) {
            throw new InstallException(cte);
        }
    }

    public boolean isPathOnDNFS(String path, String oracleHome) throws InstallException {
        try {
            ORADNFSUtil odnfs = new ORADNFSUtil(oracleHome);
            return odnfs.isPathOnDNFS(path);
        }
        catch (CmdToolUtilException cte) {
            throw new InstallException(cte);
        }
    }

    public String getMgmtDBDiskGroup() throws NotExistsException, InstallException {
        String diskGroup = "";
        String crsHome = this.getCRSHome(new Version());
        try {
            String crsVersion = this.getCRSVersion(crsHome);
            if (Version.isPre12101(Version.getVersion(crsVersion))) {
                throw new InstallException((MessageKey)PrCtMsgID.UNSUPPORTED_VERSION, crsVersion);
            }
        }
        catch (ConfigurationException e) {
            throw new InstallException(e);
        }
        try {
            CRSCTLUtil util = new CRSCTLUtil(crsHome);
            String spfile = util.getSpfileMgmtDB();
            if (!spfile.trim().isEmpty() && this.isPathOnASM(spfile)) {
                diskGroup = spfile.substring(0, spfile.indexOf(Constants.FILE_SEPARATOR));
            }
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
        return diskGroup;
    }

    public String getASMDGAtrribute(String dgName, String attributeName) throws InstallException {
        String crsHome = null;
        Object errMsg = null;
        String attributeValue = null;
        Trace.out("Diskgroup : " + dgName + " , Attribute : " + attributeName);
        ClusterwareInfo.assertString(dgName);
        ClusterwareInfo.assertString(attributeName);
        try {
            crsHome = this.getCRSHome(new Version());
            ClusterwareInfo.assertDir(crsHome, true);
            Trace.out("creating instance of ASMCMDUtil");
            ASMCMDUtil asmcmd = new ASMCMDUtil(crsHome);
            attributeValue = asmcmd.getDGAttribute(dgName, attributeName);
            Trace.out("Value of disk group attribute " + attributeName + " : " + attributeValue);
        }
        catch (InstallException e) {
            Trace.out("exception while trying to get CRSHome: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (CmdToolUtilException e) {
            Trace.out("exception while trying to get disk group attribute: " + e.getMessage());
            throw new InstallException(e);
        }
        return attributeValue;
    }

    public boolean isOPCHost() throws InstallException {
        File opsDir = new File(OPC_DIRECTORY);
        return opsDir.exists() && opsDir.isDirectory();
    }

    public HashMap<String, String> getASMDGAtrributeMap(String dgName) throws InstallException {
        String crsHome = null;
        Object errMsg = null;
        HashMap<String, String> attributeMap = new HashMap();
        Trace.out("Diskgroup " + dgName);
        ClusterwareInfo.assertString(dgName);
        try {
            crsHome = this.getCRSHome(new Version());
            ClusterwareInfo.assertDir(crsHome, true);
            Trace.out("creating instance of ASMCMDUtil");
            ASMCMDUtil asmcmd = new ASMCMDUtil(crsHome);
            attributeMap = asmcmd.getDGAttributeMap(dgName);
        }
        catch (InstallException e) {
            Trace.out("exception while trying to get CRSHome: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (CmdToolUtilException e) {
            Trace.out("exception while trying to get disk group attribute: " + e.getMessage());
            throw new InstallException(e);
        }
        return attributeMap;
    }

    public void mkASMDir(String dirName) throws InstallException {
        String crsHome = null;
        Object errMsg = null;
        Trace.out("Directory " + dirName);
        ClusterwareInfo.assertString(dirName);
        try {
            crsHome = this.getCRSHome(new Version());
            ClusterwareInfo.assertDir(crsHome, true);
            Trace.out("creating instance of ASMCMDUtil");
            ASMCMDUtil asmcmd = new ASMCMDUtil(crsHome);
            asmcmd.mkdir(dirName);
        }
        catch (InstallException e) {
            Trace.out("exception while trying to get CRSHome: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (CmdToolUtilException e) {
            Trace.out("exception while trying to make asm directory: " + e.getMessage());
            throw new InstallException(e);
        }
    }

    public ACFSInfo getACFSInfo(String dgName, String volName) throws InstallException {
        ClusterwareInfo.assertString(dgName);
        ClusterwareInfo.assertString(volName);
        Trace.out("Obtain ACFS info for disk group " + dgName + " and volume " + volName);
        try {
            String crsHome = this.getCRSHome(new Version());
            ClusterwareInfo.assertDir(crsHome, true);
            ASMCMDUtil asm = new ASMCMDUtil(crsHome);
            String volDevice = asm.getVolumeDevice(dgName, volName);
            return this.getACFSInfo4VolDevice(volDevice);
        }
        catch (InstallException e) {
            Trace.out("exception while trying to get CRSHome: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (NotExistsException e) {
            Trace.out("exception while trying to get volume device: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (CmdToolUtilException e) {
            Trace.out("exception while trying to get ACFSInfo " + e.getMessage());
            throw new InstallException(e);
        }
    }

    public ACFSInfo getACFSInfo4VolDevice(String volDevice) throws InstallException {
        String crsHome = null;
        ClusterwareInfo.assertString(volDevice);
        Trace.out("Device path " + volDevice);
        try {
            crsHome = this.getCRSHome(new Version());
            ClusterwareInfo.assertDir(crsHome, true);
            OFSUtil ofs = new OFSUtil(crsHome);
            SRVMHELPERUtil sh = new SRVMHELPERUtil(crsHome);
            boolean isNodeLocal = sh.isACFSNodeLocal(volDevice);
            String mountpoint = ofs.getMountPointFromVolDevice(volDevice);
            if (isNodeLocal) {
                List<String> nodes = sh.getACFSMountNodes(volDevice);
                return ofs.getACFSInformation(mountpoint, nodes.get(0));
            }
            return ofs.getACFSInformation(mountpoint);
        }
        catch (InstallException e) {
            Trace.out("exception while trying to get CRSHome: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (InvalidArgsException e) {
            Trace.out("exception while trying to get ACFSInfo " + e.getMessage());
            throw new InstallException(e);
        }
        catch (CmdToolUtilException e) {
            Trace.out("exception while trying to get ACFSInfo " + e.getMessage());
            throw new InstallException(e);
        }
    }

    public ACFSInfo getACFSInfo(String mountPoint) throws InstallException {
        String crsHome = null;
        ACFSInfo acfsInfo = null;
        Trace.out("Mount point path " + mountPoint);
        ClusterwareInfo.assertString(mountPoint);
        try {
            crsHome = this.getCRSHome(new Version());
            ClusterwareInfo.assertDir(crsHome, true);
            Trace.out("creating instance of OFSUtil");
            OFSUtil ofs = new OFSUtil(crsHome);
            acfsInfo = ofs.getACFSInformation(mountPoint);
        }
        catch (InstallException e) {
            Trace.out("exception while trying to get CRSHome: " + e.getMessage());
            throw new InstallException(e);
        }
        catch (CmdToolUtilException e) {
            Trace.out("exception while trying to get ACFSInfo " + e.getMessage());
            throw new InstallException(e);
        }
        return acfsInfo;
    }

    public List<String> getHAManagedAdminDatabases(String node) throws InvalidArgsException, InstallException {
        if (node == null || node.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ClusterInfo-getHAMngdAdminDBs-node");
        }
        try {
            String crsHome = this.getCRSHome(new Version());
            return new SRVMHELPERUtil(crsHome).getAdminDatabases(node);
        }
        catch (CmdToolUtilException e) {
            Trace.out(e);
            throw new InstallException(e);
        }
    }

    public int getBackupDGSize() throws InstallException {
        return 4096;
    }

    public String getScanName() throws InstallException {
        return this.getScanName(1);
    }

    public String getScanName(int netnum) throws InstallException {
        this.assertNetNum(netnum);
        try {
            String crsHome = this.getCRSHome(new Version());
            return new SRVMHELPERUtil(crsHome).getScanName(netnum);
        }
        catch (CmdToolUtilException e) {
            throw new InstallException((MessageKey)PrCiMsgID.GET_SCANNAME_FAILED, new Object[0]);
        }
    }

    public RHPContainerType getRHPClusterType(String crsHome) throws InstallException {
        try {
            RHPContainerType ghType;
            SRVCTLUtil srvctlUtil = new SRVCTLUtil(crsHome);
            Version version = srvctlUtil.getSRVCTLVersion();
            if (Version.isPre12102(version)) {
                ghType = RHPContainerType.NONE;
            } else if (Version.isPre122(version)) {
                ghType = srvctlUtil.isRHPConfigured(true) ? RHPContainerType.RHPS : (srvctlUtil.isRHPConfigured(false) ? RHPContainerType.RHPC : RHPContainerType.NONE);
            } else {
                SRVMHELPERUtil srvmUtil = new SRVMHELPERUtil(crsHome);
                ghType = srvmUtil.getRHPClusterType();
            }
            return ghType;
        }
        catch (CmdToolUtilException e) {
            throw new InstallException(e);
        }
    }
}

