/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.deployment.ClientClusterComponent;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.ops.mgmt.cluster.Version;

public class ClientClusterInfo {
    private String m_clusterName;
    private Version m_version;
    private String m_GUID;
    private List<ClientClusterComponent> m_cClusterComponents = new ArrayList<ClientClusterComponent>();

    public ClientClusterInfo(String clusterName, Version version, String GUID) {
        this.m_clusterName = clusterName;
        this.m_version = version;
        this.m_GUID = GUID;
    }

    public ClientClusterInfo(String clusterName, Version version, String GUID, String clusterComponents) {
        this.m_clusterName = clusterName;
        this.m_version = version;
        this.m_GUID = GUID;
        if (clusterComponents != null && !clusterComponents.isEmpty()) {
            String[] compArray;
            for (String component : compArray = clusterComponents.split(",")) {
                if (component.isEmpty()) continue;
                try {
                    this.m_cClusterComponents.add(ClientClusterComponent.getEnumMember(component));
                }
                catch (EnumConstNotFoundException enumConstNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public String getClusterName() {
        return this.m_clusterName;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public String getGUID() {
        return this.m_GUID;
    }

    public List<ClientClusterComponent> getClusterComponents() {
        return this.m_cClusterComponents;
    }
}

