/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment;

import oracle.ops.mgmt.trace.Trace;

public class ASMDGInfo {
    final String ASMCMD_LSDG_SPLIT_PATTERN = "[\\s]+";
    private DiskGroupState m_state;
    private RedundancyType m_type;
    private boolean m_rebal;
    private boolean m_votingFiles;
    private int m_sector;
    private int m_logicalSector;
    private int m_block;
    private int m_au;
    private int m_totalMB;
    private int m_freeMB;
    private int m_reqMirFreeMB;
    private int m_usableFileMB;
    private int m_offlineDisks;
    private String m_name;

    public ASMDGInfo(String line) {
        String[] lineArr = line.split("[\\s]+");
        this.m_state = DiskGroupState.valueOf(lineArr[0]);
        this.m_type = RedundancyType.valueOf(lineArr[1]);
        this.m_rebal = lineArr[2].equals("Y");
        this.m_sector = Integer.parseInt(lineArr[3]);
        this.m_logicalSector = Integer.parseInt(lineArr[4]);
        this.m_block = Integer.parseInt(lineArr[5]);
        this.m_au = Integer.parseInt(lineArr[6]);
        this.m_totalMB = Integer.parseInt(lineArr[7]);
        this.m_freeMB = Integer.parseInt(lineArr[8]);
        this.m_reqMirFreeMB = Integer.parseInt(lineArr[9]);
        this.m_usableFileMB = Integer.parseInt(lineArr[10]);
        this.m_offlineDisks = Integer.parseInt(lineArr[11]);
        this.m_votingFiles = lineArr[12].equals("Y");
        this.m_name = lineArr[13].substring(0, lineArr[13].length() - 1);
        Trace.out("Attributes inputted for " + lineArr[13]);
    }

    public DiskGroupState getState() {
        return this.m_state;
    }

    public RedundancyType getType() {
        return this.m_type;
    }

    public boolean getRebal() {
        return this.m_rebal;
    }

    public int getSector() {
        return this.m_sector;
    }

    public int getLogicalSector() {
        return this.m_logicalSector;
    }

    public int getBlock() {
        return this.m_block;
    }

    public int getAU() {
        return this.m_au;
    }

    public int getTotalMB() {
        return this.m_totalMB;
    }

    public int getFreeMB() {
        return this.m_freeMB;
    }

    public int getReqMirFreeMB() {
        return this.m_reqMirFreeMB;
    }

    public int getUsableFileMB() {
        return this.m_usableFileMB;
    }

    public int getOfflineDisks() {
        return this.m_offlineDisks;
    }

    public boolean getVotingFiles() {
        return this.m_votingFiles;
    }

    public String getName() {
        return this.m_name;
    }

    public static enum RedundancyType {
        NORMAL,
        HIGH,
        EXTERN;

    }

    public static enum DiskGroupState {
        BROKEN,
        CONNECTED,
        DISMOUNTED,
        MOUNTED,
        QUIESCING,
        UNKNOWN;

    }
}

