/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.install.InstallException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ACFSInfo {
    private static final String SPACE = " ";
    private static final String COMMA = ",";
    private ADVMInfo m_primaryVolume;
    private List<ADVMInfo> m_auxVolumes;
    private String m_acfsVersion;
    private String m_onDiskVersion;
    private String m_compatibleADVM;
    private String m_flags;
    private String m_mountTime;
    private String m_replicationStatus;
    private String m_compressionStatus;
    private String m_primaryVolumeDevice;
    private long m_allocationUnit;
    private long m_totalSize;
    private long m_totalFreeSpace;
    private long m_fileEntryTableAllocation;
    private long m_snapshotsSpaceUsage;
    private int m_metadataBlockSize;
    private int m_volumeCount;
    private int m_snapshotsCount;
    private boolean m_isNodeLocal = false;

    public ACFSInfo(Map<String, List<String>> cmdOutputs) throws InstallException {
        Trace.out("Set ACFS info attributes");
        ACFSInfo.assertNullOutput(cmdOutputs);
        this.generateInfo(cmdOutputs);
    }

    public String getACFSVersion() {
        return this.m_acfsVersion;
    }

    public String getOnDiskVersion() {
        return this.m_onDiskVersion;
    }

    public String getCompatibleADVM() {
        return this.m_compatibleADVM;
    }

    public String getFlags() {
        return this.m_flags;
    }

    public String getMountTime() {
        return this.m_mountTime;
    }

    public long getAllocationUnit() {
        return this.m_allocationUnit;
    }

    public int getMetadataBlockSize() {
        return this.m_metadataBlockSize;
    }

    public int getVolumeCount() {
        return this.m_volumeCount;
    }

    public long getTotalSize() {
        return this.m_totalSize;
    }

    public long getTotalFreeSpace() {
        return this.m_totalFreeSpace;
    }

    public long getFileEntryTableAllocation() {
        return this.m_fileEntryTableAllocation;
    }

    public int getSnapshotsCount() {
        return this.m_snapshotsCount;
    }

    public long getSnapshotsSpaceUsage() {
        return this.m_snapshotsSpaceUsage;
    }

    public String getReplicationStatus() {
        return this.m_replicationStatus;
    }

    public String getCompressionStatus() {
        return this.m_compressionStatus;
    }

    public String getPrimaryVolumeDevice() {
        return this.m_primaryVolumeDevice;
    }

    public ADVMInfo getPrimaryVolume() throws InstallException {
        this.assertPrimaryVolume();
        return this.m_primaryVolume;
    }

    public List<ADVMInfo> getAuxiliaryVolumes() throws InstallException {
        if (this.m_auxVolumes == null) {
            Trace.out("Invalid auxiliary volumes value");
            throw new InstallException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "acfsinfo-NAV");
        }
        return this.m_auxVolumes;
    }

    public boolean isNodeLocal() {
        return this.m_isNodeLocal;
    }

    static void assertNullProperty(ACFSInfoLabel label, String mapProperty) throws InstallException {
        if (mapProperty == null) {
            Trace.out("ACFSInfo label " + label.toString() + " is not configured.");
            throw new InstallException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "acfsinfo-ANC");
        }
    }

    static void assertNullProperty(String label, List<String> mapProperty) throws InstallException {
        if (mapProperty == null || mapProperty.isEmpty()) {
            Trace.out("ACFSInfo label " + label.toString() + " is not configured.");
            throw new InstallException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "acfsinfo-ANC");
        }
    }

    static long convertValue2Long(String value) throws InstallException {
        value = value.trim();
        String[] valueSplit = value.split(SPACE);
        return ACFSInfo.getLongValue(valueSplit[0].trim());
    }

    static long getLongValue(String value) throws InstallException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw new InstallException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "acfsinfo-NFELong");
        }
    }

    static int getIntValue(String value) throws InstallException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new InstallException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "acfsinfo-NFEInt");
        }
    }

    static void assertNullProperty(Map<ACFSInfoLabel, String> infoMap) throws InstallException {
        for (Map.Entry<ACFSInfoLabel, String> attr : infoMap.entrySet()) {
            ACFSInfo.assertNullProperty(attr.getKey(), attr.getValue());
        }
    }

    static void assertNullOutput(Map<String, List<String>> infoMap) throws InstallException {
        for (Map.Entry<String, List<String>> attr : infoMap.entrySet()) {
            ACFSInfo.assertNullProperty(attr.getKey(), attr.getValue());
        }
    }

    private void assertPrimaryVolume() throws InstallException {
        if (this.m_primaryVolume == null) {
            Trace.out("No primary volume is configured for this file system");
            throw new InstallException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "acfsinfo-NPV");
        }
    }

    private void generateInfo(Map<String, List<String>> propertyMap) throws InstallException {
        HashMap<ACFSInfoLabel, String> volMap = null;
        this.m_auxVolumes = new ArrayList<ADVMInfo>();
        Trace.out("Set ACFS info attributes");
        this.m_acfsVersion = propertyMap.get(ACFSInfoLabel.ACFS_VERSION.getValue()).get(0);
        this.m_onDiskVersion = propertyMap.get(ACFSInfoLabel.ONDISK_VERSION.getValue()).get(0);
        this.m_compatibleADVM = propertyMap.get(ACFSInfoLabel.COMPATIBLE_ADVM.getValue()).get(0);
        this.m_flags = propertyMap.get(ACFSInfoLabel.FLAGS.getValue()).get(0);
        this.m_mountTime = propertyMap.get(ACFSInfoLabel.MOUNT_TIME.getValue()).get(0);
        this.m_volumeCount = ACFSInfo.getIntValue(propertyMap.get(ACFSInfoLabel.VOLUMES_COUNT.getValue()).get(0));
        this.m_replicationStatus = propertyMap.get(ACFSInfoLabel.REPLICATION_STATUS.getValue()).get(0);
        this.m_compressionStatus = propertyMap.get(ACFSInfoLabel.COMPRESSION_STATUS.getValue()).get(0);
        this.m_primaryVolumeDevice = propertyMap.get(ACFSInfoLabel.PRIMARY_VOLUME.getValue()).get(0);
        this.m_allocationUnit = ACFSInfo.getLongValue(propertyMap.get(ACFSInfoLabel.ALLOCATION_UNIT.getValue()).get(0));
        this.m_totalSize = ACFSInfo.convertValue2Long(propertyMap.get(ACFSInfoLabel.TOTAL_SIZE.getValue()).get(0));
        this.m_totalFreeSpace = ACFSInfo.convertValue2Long(propertyMap.get(ACFSInfoLabel.TOTAL_FREE.getValue()).get(0));
        this.m_fileEntryTableAllocation = ACFSInfo.getLongValue(propertyMap.get(ACFSInfoLabel.FILE_ENTRY_TABLE_ALLOCATION.getValue()).get(0));
        this.m_snapshotsSpaceUsage = ACFSInfo.convertValue2Long(propertyMap.get(ACFSInfoLabel.SNAPSHOT_SPACE_USAGE.getValue()).get(0));
        this.m_snapshotsCount = ACFSInfo.getIntValue(propertyMap.get(ACFSInfoLabel.SNAPSHOT_NUMBER.getValue()).get(0));
        this.m_isNodeLocal = propertyMap.get(ACFSInfoLabel.IS_NODELOCAL.getValue()).get(0).equalsIgnoreCase("1");
        for (int i = 0; i < this.m_volumeCount; ++i) {
            volMap = new HashMap<ACFSInfoLabel, String>();
            if (propertyMap.containsKey(ACFSInfoLabel.VOL_LABEL.getValue())) {
                volMap.put(ACFSInfoLabel.VOL_LABEL, propertyMap.get(ACFSInfoLabel.VOL_LABEL.getValue()).get(i));
            } else {
                volMap.put(ACFSInfoLabel.VOL_LABEL, "");
            }
            volMap.put(ACFSInfoLabel.VOL_STATE, propertyMap.get(ACFSInfoLabel.VOL_STATE.getValue()).get(i));
            volMap.put(ACFSInfoLabel.VOL_MAJOR_MINOR, propertyMap.get(ACFSInfoLabel.VOL_MAJOR_MINOR.getValue()).get(i));
            volMap.put(ACFSInfoLabel.VOL_SIZE, propertyMap.get(ACFSInfoLabel.VOL_SIZE.getValue()).get(i));
            volMap.put(ACFSInfoLabel.VOL_FREE, propertyMap.get(ACFSInfoLabel.VOL_FREE.getValue()).get(i));
            volMap.put(ACFSInfoLabel.TOTAL_METADATA_READ, propertyMap.get(ACFSInfoLabel.TOTAL_METADATA_READ.getValue()).get(i));
            volMap.put(ACFSInfoLabel.TOTAL_METADATA_WRITTEN, propertyMap.get(ACFSInfoLabel.TOTAL_METADATA_WRITTEN.getValue()).get(i));
            volMap.put(ACFSInfoLabel.METADATA_READ_COUNT, propertyMap.get(ACFSInfoLabel.METADATA_READ_COUNT.getValue()).get(i));
            volMap.put(ACFSInfoLabel.METADATA_WRITE_COUNT, propertyMap.get(ACFSInfoLabel.METADATA_WRITE_COUNT.getValue()).get(i));
            volMap.put(ACFSInfoLabel.VOL_LOGICAL_SECTOR_SIZE, propertyMap.get(ACFSInfoLabel.VOL_LOGICAL_SECTOR_SIZE.getValue()).get(i));
            if (i == 0) {
                volMap.put(ACFSInfoLabel.PRIMARY_VOLUME, propertyMap.get(ACFSInfoLabel.PRIMARY_VOLUME.getValue()).get(i));
                volMap.put(ACFSInfoLabel.ADVM_DG, propertyMap.get(ACFSInfoLabel.ADVM_DG.getValue()).get(i));
                volMap.put(ACFSInfoLabel.ADVM_REDUNDANCY, propertyMap.get(ACFSInfoLabel.ADVM_REDUNDANCY.getValue()).get(i));
                volMap.put(ACFSInfoLabel.ADVM_RESIZE_INC, propertyMap.get(ACFSInfoLabel.ADVM_RESIZE_INC.getValue()).get(i));
                volMap.put(ACFSInfoLabel.ADVM_STRIPE_WIDTH, propertyMap.get(ACFSInfoLabel.ADVM_STRIPE_WIDTH.getValue()).get(i));
                volMap.put(ACFSInfoLabel.ADVM_STRIPE_COL, propertyMap.get(ACFSInfoLabel.ADVM_STRIPE_COL.getValue()).get(i));
                this.m_primaryVolume = new ADVMInfo(volMap, ADVMType.PRIMARY);
                continue;
            }
            volMap.put(ACFSInfoLabel.AUXILIARY_VOLUME, propertyMap.get(ACFSInfoLabel.AUXILIARY_VOLUME.getValue()).get(i - 1));
            volMap.put(ACFSInfoLabel.ACCELERATOR_VERSION, propertyMap.get(ACFSInfoLabel.ACCELERATOR_VERSION.getValue()).get(i - 1));
            this.m_auxVolumes.add(new ADVMInfo(volMap, ADVMType.AUXILIARY));
        }
    }

    public class ADVMInfo {
        private Map<ACFSInfoLabel, String> m_mapInfo;
        private String m_volumeDevice = null;
        private String m_label;
        private String m_diskgroup;
        private String m_redundancy;
        private String m_acceleratorVersion;
        private ADVMType m_type;
        private ADVMState m_state = null;
        private long m_major;
        private long m_minor;
        private long m_size;
        private long m_freeSpace;
        private long m_totalMetadataBytesRead;
        private long m_totalMetadataBytesWritten;
        private long m_resizeIncrement;
        private long m_stripeWidth;
        private int m_logicalSectorSize;
        private int m_metadataReadCount;
        private int m_metadataWriteCount;
        private int m_stripeColumns;

        ADVMInfo(Map<ACFSInfoLabel, String> infoMap, ADVMType type) throws InstallException {
            ACFSInfo.assertNullProperty(infoMap);
            this.m_type = type;
            this.m_mapInfo = infoMap;
            this.setValuesADVM();
        }

        public String getVolumeDevice() {
            return this.m_volumeDevice;
        }

        public String getLabel() {
            return this.m_label;
        }

        public ADVMState getState() {
            return this.m_state;
        }

        public long getMajor() {
            return this.m_major;
        }

        public long getMinor() {
            return this.m_minor;
        }

        public int getLogicalSectorSize() {
            return this.m_logicalSectorSize;
        }

        public long getSize() {
            return this.m_size;
        }

        public long getFreeSpace() {
            return this.m_freeSpace;
        }

        public int getMetadataReadCount() {
            return this.m_metadataReadCount;
        }

        public int getMetadataWriteCount() {
            return this.m_metadataWriteCount;
        }

        public long getTotalMetadataBytesRead() {
            return this.m_totalMetadataBytesRead;
        }

        public long getTotalMetadataBytesWritten() {
            return this.m_totalMetadataBytesWritten;
        }

        public String getDiskgroup() {
            return this.m_diskgroup;
        }

        public long getResizeIncrement() {
            return this.m_resizeIncrement;
        }

        public int getStripeColumns() {
            return this.m_stripeColumns;
        }

        public String getRedundancy() {
            return this.m_redundancy;
        }

        public long getStripeWidth() {
            return this.m_stripeWidth;
        }

        public String getAcceleratorVersion() {
            return this.m_acceleratorVersion;
        }

        private void setValuesADVM() throws InstallException {
            this.m_label = this.m_mapInfo.get((Object)ACFSInfoLabel.VOL_LABEL) == null ? "" : this.m_mapInfo.get((Object)ACFSInfoLabel.VOL_LABEL);
            this.m_state = ADVMState.getMember(this.m_mapInfo.get((Object)ACFSInfoLabel.VOL_STATE));
            this.m_major = this.getMajorOrMinor(this.m_mapInfo.get((Object)ACFSInfoLabel.VOL_MAJOR_MINOR), true);
            this.m_minor = this.getMajorOrMinor(this.m_mapInfo.get((Object)ACFSInfoLabel.VOL_MAJOR_MINOR), false);
            this.m_size = ACFSInfo.convertValue2Long(this.m_mapInfo.get((Object)ACFSInfoLabel.VOL_SIZE));
            this.m_freeSpace = ACFSInfo.convertValue2Long(this.m_mapInfo.get((Object)ACFSInfoLabel.VOL_FREE));
            this.m_totalMetadataBytesRead = ACFSInfo.convertValue2Long(this.m_mapInfo.get((Object)ACFSInfoLabel.TOTAL_METADATA_READ));
            this.m_totalMetadataBytesWritten = ACFSInfo.convertValue2Long(this.m_mapInfo.get((Object)ACFSInfoLabel.TOTAL_METADATA_WRITTEN));
            this.m_logicalSectorSize = ACFSInfo.getIntValue(this.m_mapInfo.get((Object)ACFSInfoLabel.VOL_LOGICAL_SECTOR_SIZE));
            this.m_metadataReadCount = ACFSInfo.getIntValue(this.m_mapInfo.get((Object)ACFSInfoLabel.METADATA_READ_COUNT));
            this.m_metadataWriteCount = ACFSInfo.getIntValue(this.m_mapInfo.get((Object)ACFSInfoLabel.METADATA_WRITE_COUNT));
            if (this.m_type == ADVMType.PRIMARY) {
                Trace.out("Filling primary volume information attributes");
                this.m_volumeDevice = this.m_mapInfo.get((Object)ACFSInfoLabel.PRIMARY_VOLUME);
                this.m_diskgroup = this.m_mapInfo.get((Object)ACFSInfoLabel.ADVM_DG);
                this.m_redundancy = this.m_mapInfo.get((Object)ACFSInfoLabel.ADVM_REDUNDANCY);
                this.m_resizeIncrement = ACFSInfo.getLongValue(this.m_mapInfo.get((Object)ACFSInfoLabel.ADVM_RESIZE_INC));
                this.m_stripeWidth = ACFSInfo.getLongValue(this.m_mapInfo.get((Object)ACFSInfoLabel.ADVM_STRIPE_WIDTH));
                this.m_stripeColumns = ACFSInfo.getIntValue(this.m_mapInfo.get((Object)ACFSInfoLabel.ADVM_STRIPE_COL));
            } else {
                Trace.out("Filling auxiliary volume information attributes");
                this.m_volumeDevice = this.m_mapInfo.get((Object)ACFSInfoLabel.AUXILIARY_VOLUME);
                this.m_acceleratorVersion = this.m_mapInfo.get((Object)ACFSInfoLabel.ACCELERATOR_VERSION);
            }
        }

        protected long getMajorOrMinor(String value, boolean major) throws InstallException {
            String[] minorMajor = value.trim().split(ACFSInfo.COMMA);
            return ACFSInfo.getLongValue((major ? minorMajor[0] : minorMajor[1]).trim());
        }
    }

    public static enum ADVMState {
        AVAILABLE("Available"),
        OFFLINE("Offline");

        private String m_value;

        private ADVMState(String value) {
            this.m_value = value;
        }

        public String getValue() {
            return this.m_value;
        }

        public static ADVMState getMember(String value) throws InstallException {
            for (ADVMState member : ADVMState.values()) {
                if (!member.getValue().equalsIgnoreCase(value.trim())) continue;
                return member;
            }
            Trace.out("No ADVMState member found for value " + value);
            throw new InstallException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "acfsinfo-MNF");
        }
    }

    public static enum ACFSInfoLabel {
        IS_NODELOCAL("node local"),
        ACFS_VERSION("ACFS Version"),
        ONDISK_VERSION("on-disk version"),
        COMPATIBLE_ADVM("compatible.advm"),
        FLAGS("flags"),
        MOUNT_TIME("mount time"),
        ALLOCATION_UNIT("allocation unit"),
        METADATA_BLOCK_SIZE("metadata block size"),
        VOLUMES_COUNT("volumes"),
        TOTAL_SIZE("total size"),
        TOTAL_FREE("total free"),
        FILE_ENTRY_TABLE_ALLOCATION("file entry table allocation"),
        PRIMARY_VOLUME("primary volume"),
        AUXILIARY_VOLUME("accelerator volume"),
        VOL_LABEL("label"),
        VOL_STATE("state"),
        VOL_MAJOR_MINOR("major, minor"),
        VOL_LOGICAL_SECTOR_SIZE("logical sector size"),
        VOL_SIZE("size"),
        VOL_FREE("free"),
        ADVM_DG("ADVM diskgroup"),
        ADVM_RESIZE_INC("ADVM resize increment"),
        ADVM_REDUNDANCY("ADVM redundancy"),
        ADVM_STRIPE_COL("ADVM stripe columns"),
        ADVM_STRIPE_WIDTH("ADVM stripe width"),
        SNAPSHOT_NUMBER("number of snapshots"),
        SNAPSHOT_SPACE_USAGE("snapshot space usage"),
        REPLICATION_STATUS("replication status"),
        COMPRESSION_STATUS("compression status"),
        ACCELERATOR_VERSION("accelerator version"),
        METADATA_READ_COUNT("metadata read I/O count"),
        METADATA_WRITE_COUNT("metadata write I/O count"),
        TOTAL_METADATA_READ("total metadata bytes read"),
        TOTAL_METADATA_WRITTEN("total metadata bytes written");

        private String m_value;

        private ACFSInfoLabel(String value) {
            this.m_value = value;
        }

        public String getValue() {
            return this.m_value;
        }

        public static ACFSInfoLabel getMember(String value) throws InstallException {
            for (ACFSInfoLabel member : ACFSInfoLabel.values()) {
                if (!member.getValue().equalsIgnoreCase(value.trim())) continue;
                return member;
            }
            Trace.out("No ACFSInfo label member found for value " + value);
            throw new InstallException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "acfsinfo-MNF");
        }
    }

    public static enum ADVMType {
        PRIMARY,
        AUXILIARY;

    }
}

