/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.database;

import java.util.List;
import oracle.cluster.common.VerboseListener;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.CLBGoal;
import oracle.cluster.database.DBRole;
import oracle.cluster.database.FailoverMethod;
import oracle.cluster.database.FailoverRestore;
import oracle.cluster.database.FailoverType;
import oracle.cluster.database.ManagementPolicy;
import oracle.cluster.database.RLBGoal;
import oracle.cluster.database.ServiceCardinality;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceType;
import oracle.cluster.database.SessionStateEnum;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.server.ServerGroup;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ServiceArgs {
    private ServerGroup m_sg = null;
    private Network m_network = null;
    private ServiceCardinality m_cardinality = null;
    private Boolean m_disconnect = null;
    private DBRole[] m_dbroles = null;
    private ManagementPolicy m_mgmtPolicy = null;
    private Boolean m_dtp = null;
    private Boolean m_aqhaNotification = null;
    private FailoverType m_failoverType = null;
    private Boolean m_global = null;
    private Boolean m_noreplay = null;
    private FailoverMethod m_failoverMethod = null;
    private Integer m_failoverRetry = null;
    private FailoverRestore m_failoverRestore = null;
    private Integer m_failoverDelay = null;
    private CLBGoal m_clbGoal = null;
    private RLBGoal m_rlbGoal = null;
    private String m_edition = null;
    private String m_translationProfile = null;
    private String m_plugDB = null;
    private String m_maxLagTime = null;
    private Boolean m_commitOutcome = null;
    private Integer m_retention = null;
    private Integer m_replayInitiationTime = null;
    private SessionStateEnum m_sessionState = null;
    private String m_pqservice = null;
    private String m_mainservice = null;
    private ServiceType m_serviceType = ServiceType.MAIN;
    private Integer m_gsmFlags = null;
    private StartOptions[] m_startOptions = null;
    private StopOptions[] m_stopOptions = null;
    private Integer m_drainTimeout = null;
    private Boolean m_wait = null;
    private RelocateOption[] m_relocateOptions = null;
    private Boolean m_force = null;
    private VerboseListener m_vlsnr = null;
    private List<String> m_svcNames = null;
    private CRSResource.CSSCritical m_cssCritical = null;
    private ServerGroup m_rfPool = null;

    public ServiceType getServiceType() {
        return this.m_serviceType;
    }

    public void setServiceType(ServiceType serviceType) throws ServiceException {
        this.sureNotNull((Object)serviceType, "service_type");
        this.m_serviceType = serviceType;
        Trace.out("set serviceType to " + (Object)((Object)this.m_serviceType));
    }

    public void setTranslationProfile(String profile) throws ServiceException {
        this.sureNotNull(profile, "translation_profile");
        this.m_translationProfile = profile;
    }

    public void setEdition(String edition) throws ServiceException {
        this.sureNotNull(edition, "edition");
        this.m_edition = edition;
    }

    public void setMaxLagTime(String maxLagTime) throws ServiceException {
        this.sureNotNull(maxLagTime, "max_lag_time");
        this.m_maxLagTime = maxLagTime;
    }

    public void setServerGroup(ServerGroup serverGroup) throws ServiceException {
        this.sureNotNull(serverGroup, "serverGroup");
        this.m_sg = serverGroup;
    }

    public void unsetServerGroup() {
        this.m_sg = null;
    }

    public void setNetwork(Network network) throws ServiceException {
        this.sureNotNull(network, "network");
        this.m_network = network;
    }

    public void setServiceCardinality(ServiceCardinality cardinality) throws ServiceException {
        this.sureNotNull((Object)cardinality, "cardinality");
        this.m_cardinality = cardinality;
    }

    public void setDisconnectOpt(boolean disconnect) {
        this.m_disconnect = new Boolean(disconnect);
    }

    public void setRoles(DBRole[] roles) throws ServiceException {
        this.sureNotNull(roles, "roles");
        this.m_dbroles = roles;
    }

    public void setStartOptions(StartOptions[] startOptions) throws ServiceException {
        this.sureNotNull(startOptions, "startOptions");
        this.m_startOptions = startOptions;
    }

    public void setStopOptions(StopOptions[] stopOptions) throws ServiceException {
        this.sureNotNull(stopOptions, "stopOptions");
        this.m_stopOptions = stopOptions;
    }

    public void setMgmtPolicy(ManagementPolicy policy) throws ServiceException {
        this.sureNotNull((Object)policy, "policy");
        this.m_mgmtPolicy = policy;
    }

    public Boolean getDTP() {
        return this.m_dtp;
    }

    public void setDTP(boolean dtp) throws ServiceException {
        this.sureNotNull(dtp, "dtp");
        this.m_dtp = dtp;
    }

    public String getPQService() {
        return this.m_pqservice;
    }

    public void setPQService(String pqservice) throws ServiceException {
        this.sureNotNull(pqservice, "pqservice");
        this.m_pqservice = pqservice;
        Trace.out("set pqservice to " + this.m_pqservice);
    }

    public void unsetPQService() {
        this.m_pqservice = null;
    }

    public String getMainService() {
        return this.m_mainservice;
    }

    public void setMainService(String mainservice) throws ServiceException {
        this.sureNotNull(mainservice, "mainservice");
        this.m_mainservice = mainservice;
        Trace.out("set mainservice to " + this.m_mainservice);
    }

    public Boolean getAQHANotification() {
        return this.m_aqhaNotification;
    }

    public void setAQHANotification(boolean aqhaNotification) throws ServiceException {
        this.sureNotNull(aqhaNotification, "aqhaNotification");
        this.m_aqhaNotification = aqhaNotification;
    }

    public Boolean getGlobal() {
        return this.m_global;
    }

    public void setGlobal(boolean global) throws ServiceException {
        this.m_global = global;
    }

    public Boolean getNoreplay() {
        return this.m_noreplay;
    }

    public void setNoreplay(boolean noreplay) throws ServiceException {
        this.sureNotNull(noreplay, "noreplay");
        this.m_noreplay = noreplay;
    }

    public FailoverType getFailoverType() {
        return this.m_failoverType;
    }

    public void setFailoverType(FailoverType failoverType) throws ServiceException {
        this.sureNotNull((Object)failoverType, "failoverType");
        this.m_failoverType = failoverType;
    }

    public FailoverMethod getFailoverMethod() {
        return this.m_failoverMethod;
    }

    public void setFailoverMethod(FailoverMethod failoverMethod) throws ServiceException {
        this.sureNotNull((Object)failoverMethod, "failoverMethod");
        this.m_failoverMethod = failoverMethod;
    }

    public Integer getFailoverRetry() {
        return this.m_failoverRetry;
    }

    public void setFailoverRetry(int failoverRetry) throws ServiceException {
        this.sureNotNull(failoverRetry, "failoverRetry");
        this.m_failoverRetry = failoverRetry;
    }

    public FailoverRestore getFailoverRestore() {
        return this.m_failoverRestore;
    }

    public void setFailoverRestore(FailoverRestore failoverRestore) throws ServiceException {
        this.sureNotNull((Object)failoverRestore, "failoverRestore");
        this.m_failoverRestore = failoverRestore;
    }

    public Integer getFailoverDelay() {
        return this.m_failoverDelay;
    }

    public void setFailoverDelay(int failoverDelay) throws ServiceException {
        this.sureNotNull(failoverDelay, "failoverDelay");
        this.m_failoverDelay = failoverDelay;
    }

    public CLBGoal getCLBGoal() {
        return this.m_clbGoal;
    }

    public void setCLBGoal(CLBGoal clbGoal) throws ServiceException {
        this.sureNotNull((Object)clbGoal, "clbGlobal");
        this.m_clbGoal = clbGoal;
    }

    public void setPDB(String pdbName) throws ServiceException {
        this.sureNotNull(pdbName, "pluggable_database");
        this.m_plugDB = pdbName;
    }

    public RLBGoal getRLBGoal() {
        return this.m_rlbGoal;
    }

    public void setRLBGoal(RLBGoal rlbGoal) throws ServiceException {
        this.sureNotNull((Object)rlbGoal, "rlbGoal");
        this.m_rlbGoal = rlbGoal;
    }

    public String getTranslationProfile() throws ServiceException {
        return this.m_translationProfile;
    }

    public String getEdition() {
        return this.m_edition;
    }

    public String getMaxLagTime() {
        return this.m_maxLagTime;
    }

    public Boolean getCommitOutcome() {
        return this.m_commitOutcome;
    }

    public void setCommitOutcome(boolean commitOutcome) throws ServiceException {
        this.sureNotNull(commitOutcome, "commit_outcome");
        this.m_commitOutcome = commitOutcome;
    }

    public Integer getRetention() {
        return this.m_retention;
    }

    public void setRetention(int seconds) throws ServiceException {
        this.sureNotNull(seconds, "retention");
        this.m_retention = seconds;
    }

    public Integer getReplayInitiationTime() {
        return this.m_replayInitiationTime;
    }

    public void setReplayInitiationTime(int seconds) throws ServiceException {
        this.sureNotNull(seconds, "replayInitiationTime");
        this.m_replayInitiationTime = seconds;
    }

    public SessionStateEnum getSessionState() {
        return this.m_sessionState;
    }

    public void setSessionState(SessionStateEnum seconds) throws ServiceException {
        this.sureNotNull((Object)seconds, "sessionState");
        this.m_sessionState = seconds;
    }

    public ServerGroup getServerGroup() {
        return this.m_sg;
    }

    public Network getNetwork() {
        return this.m_network;
    }

    public ServiceCardinality getServiceCardinality() {
        return this.m_cardinality;
    }

    public Boolean getDisconnectOpt() {
        return this.m_disconnect;
    }

    public DBRole[] getRoles() {
        return this.m_dbroles;
    }

    public StartOptions[] getStartOptions() {
        return this.m_startOptions;
    }

    public StopOptions[] getStopOptions() {
        return this.m_stopOptions;
    }

    public ManagementPolicy getMgmtPolicy() {
        return this.m_mgmtPolicy;
    }

    public String getPDB() {
        return this.m_plugDB;
    }

    public void setGSMFlags(int gsmFlags) throws ServiceException {
        this.sureNotNull(gsmFlags, "gsmFlags");
        this.m_gsmFlags = gsmFlags;
    }

    public Integer getGSMFlags() {
        return this.m_gsmFlags;
    }

    public void setDrainTimeout(Integer timeout) throws ServiceException {
        this.sureNotNull(timeout, "ServiceArgs-drain_timeout");
        if (timeout < -1) {
            throw new ServiceException((MessageKey)PrCdMsgID.INVALID_INTEGER, timeout.toString());
        }
        this.m_drainTimeout = timeout;
    }

    public Integer getDrainTimeout() {
        return this.m_drainTimeout;
    }

    public void setWait(boolean wait) {
        this.m_wait = wait;
    }

    public Boolean getWait() {
        return this.m_wait;
    }

    public void setForceFlag(boolean force) {
        this.m_force = force;
    }

    public Boolean getForceFlag() {
        return this.m_force;
    }

    public void setRelocateOptions(RelocateOption[] opts) throws ServiceException {
        this.sureNotNull(opts, "RelocateOptions");
        this.m_relocateOptions = opts;
    }

    public RelocateOption[] getRelocateOptions() {
        return this.m_relocateOptions;
    }

    public void setVerboseListener(VerboseListener vlsnr) throws ServiceException {
        this.sureNotNull(vlsnr, "ServiceArgs-VerboseListener");
        this.m_vlsnr = vlsnr;
    }

    public VerboseListener getVerboseListener() {
        return this.m_vlsnr;
    }

    public void setCSSCriticalOption(CRSResource.CSSCritical option) throws ServiceException {
        this.sureNotNull((Object)option, "ServiceArgs-css_critical");
        this.m_cssCritical = option;
    }

    public CRSResource.CSSCritical getCSSCriticalOption() {
        return this.m_cssCritical;
    }

    public void setServiceNames(List<String> svcNames) throws ServiceException {
        this.sureNotNull(svcNames, "ServiceArgs-setServiceNames");
        this.m_svcNames = svcNames;
    }

    public List<String> getServiceNames() throws ServiceException {
        return this.m_svcNames;
    }

    public ServerGroup getRFPool() {
        return this.m_rfPool;
    }

    public void setRFPool(ServerGroup rfPool) throws ServiceException {
        this.sureNotNull(rfPool, "DatabaseArgs-setRFPool");
        this.m_rfPool = rfPool;
    }

    private void sureNotNull(Object o, String name) throws ServiceException {
        if (o == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, name);
        }
    }

    public static enum RelocateOption {
        DISCONNECT("disconnect"),
        NOREPLAY("noreplay");

        private String m_opt;

        private RelocateOption(String option) {
            this.m_opt = option;
        }

        public String toString() {
            return this.m_opt;
        }

        public static RelocateOption getEnumMember(String relocateOpt) throws ServiceException {
            for (RelocateOption opt : RelocateOption.values()) {
                if (!opt.m_opt.equalsIgnoreCase(relocateOpt)) continue;
                return opt;
            }
            throw new ServiceException((MessageKey)PrCdMsgID.INVALID_RELOCATE_OPTION, relocateOpt);
        }
    }
}

