/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.database;

import java.util.List;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.database.CardinalDatabase;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.ops.mgmt.nls.MessageKey;

public interface RACOneNodeDatabase
extends CardinalDatabase {
    public static final int MAX_ONLINE_RELOCATION_TIMEOUT = 720;
    public static final int UNSPECIFIED_ONLINE_RELOCATION_TIMEOUT = 30;

    public int getOnlineRelocationTimeout() throws DatabaseException;

    public void setOnlineRelocationTimeout(int var1) throws DatabaseException;

    public ServerPool serverPool() throws ServerGroupException;

    @Override
    public void start(List<Node> var1) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException;

    @Override
    public void start(List<Node> var1, List<StartOptions> var2) throws AlreadyRunningException, CompositeOperationException, InstanceException;

    @Override
    public void addInstance(DatabaseInstance var1) throws AlreadyExistsException, InstanceException;

    @Override
    public void addInstance(DatabaseInstance var1, boolean var2) throws AlreadyExistsException, InstanceException;

    @Override
    public void removeInstance(DatabaseInstance var1) throws InstanceException;

    @Override
    public void modifyInstance(DatabaseInstance var1) throws InstanceException;

    @Override
    public void start(DatabaseInstance var1) throws AlreadyRunningException, InstanceException;

    @Override
    public void start(DatabaseInstance var1, List<StartOptions> var2) throws AlreadyRunningException, InstanceException;

    @Override
    public void remove(Node var1, boolean var2) throws AlreadyRunningException, InstanceException;

    @Override
    public void stop(List<Node> var1, boolean var2) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException;

    @Override
    public void stop(List<Node> var1, List<StopOptions> var2, boolean var3) throws AlreadyStoppedException, CompositeOperationException, InstanceException;

    public void stop(Node var1, List<StopOptions> var2, int var3, boolean var4) throws AlreadyStoppedException, InstanceException;

    @Override
    public void startServices(List<Service> var1, Node var2, ServiceArgs var3) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public static enum OmotionStatus {
        INACTIVE_OMOTION("INACTIVE"),
        ACTIVE_OMOTION("ACTIVE"),
        FAILED_OMOTION("FAILED");

        private String m_status;
        DatabaseInstance m_sourceInst = null;
        DatabaseInstance m_targetInst = null;

        public static OmotionStatus getEnumMember(String status) throws DatabaseException {
            for (OmotionStatus os : OmotionStatus.values()) {
                if (!os.m_status.equalsIgnoreCase(status)) continue;
                return os;
            }
            throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_OMOTION_STATUS, status);
        }

        private OmotionStatus(String status) {
            this.m_status = status;
        }

        public String toString() {
            return this.m_status;
        }

        public void setSourceInstance(DatabaseInstance srcInst) throws DatabaseException {
            if (srcInst == null) {
                throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "srcInst", srcInst);
            }
            this.m_sourceInst = srcInst;
        }

        public void setTargetInstance(DatabaseInstance targetInst) throws DatabaseException {
            if (targetInst == null) {
                throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "targetInst", targetInst);
            }
            this.m_targetInst = targetInst;
        }

        public DatabaseInstance getSourceInstance() {
            return this.m_sourceInst;
        }

        public DatabaseInstance getTargetInstance() {
            return this.m_targetInst;
        }
    }
}

