/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.database;

import oracle.cluster.common.SoftwareModule;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.InstanceException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageBundle;

public interface Instance
extends SoftwareModule {
    public CRSResource crsResource() throws NotExistsException, InstanceException;

    public boolean isDatabaseInstance();

    public Node node() throws InstanceException;

    public void setNode(Node var1) throws InstanceException;

    public String getState();

    public int getClientConnected();

    public void setClientConnected(int var1);

    public String getClientNames();

    public void setClientNames(String var1);

    public String getConnectedToInstance();

    public void setConnectedToInstance(String var1);

    public ConnectedToType getConnectedToType();

    public void setConnectedToType(String var1);

    public String getTNSConnectString(String var1) throws InstanceException;

    public static enum ConnectedToType {
        NONE(ResourceLiterals.NONE.name()),
        ASM(ResourceLiterals.ASM.name()),
        IOS(ResourceLiterals.IOS.name());

        private String m_connectedToType;

        private ConnectedToType(String connectedToType) {
            this.m_connectedToType = connectedToType;
        }

        public String toString() {
            return this.m_connectedToType;
        }

        public static ConnectedToType getEnumMember(String connectedToType) throws IllegalArgumentException {
            if (connectedToType.equals(ASM.toString())) {
                return ASM;
            }
            if (connectedToType.equals(IOS.toString())) {
                return IOS;
            }
            throw new IllegalArgumentException(MessageBundle.getMessage(PrCcMsgID.ENUM_NO_MEMBER_FOUND, true, ConnectedToType.class, connectedToType));
        }
    }

    public static enum InstanceState {
        ONLINE("ONLINE"),
        OFFLINE("OFFLINE"),
        UNKNOWN("UNKNOWN"),
        INTERMEDIATE("INTERMEDIATE");

        private String m_instState;

        private InstanceState(String instState) {
            this.m_instState = instState;
        }

        public String toString() {
            return this.m_instState;
        }

        public static InstanceState getEnumMember(String state) throws IllegalArgumentException {
            if (state.equals(ONLINE.toString())) {
                return ONLINE;
            }
            if (state.equals(OFFLINE.toString())) {
                return ONLINE;
            }
            if (state.equals(UNKNOWN.toString())) {
                return UNKNOWN;
            }
            if (state.equals(INTERMEDIATE.toString())) {
                return INTERMEDIATE;
            }
            throw new IllegalArgumentException(MessageBundle.getMessage(PrCcMsgID.ENUM_NO_MEMBER_FOUND, true, InstanceState.class, state));
        }
    }
}

