/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.database;

import java.util.List;
import java.util.Map;
import oracle.cluster.asm.AsmClusterFileSystem;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.VerboseListener;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.DBRole;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.ManagementPolicy;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerGroup;
import oracle.ops.mgmt.nls.MessageKey;

public class DatabaseOptionalArgs {
    private String m_dbName = null;
    private String m_dbDomain = null;
    private String m_instanceName = null;
    private Map<String, Node> m_instNodeMap = null;
    private String m_spfile = null;
    private StartOptions[] m_startModes = null;
    private StopOptions[] m_stopModes = null;
    private DBRole m_dbRole = null;
    private ManagementPolicy m_policy = null;
    private List<DiskGroup> m_diskGroupList = null;
    private List<String> m_acfsPaths = null;
    private List<AsmClusterFileSystem> m_acfs = null;
    private int m_timeout;
    private int m_start_concurrency = -1;
    private int m_stop_concurrency = -1;
    private String m_oracleUser = null;
    private List<ServerGroup> m_sgList = null;
    private List<ServerGroup> m_pqpools = null;
    private String m_pwfile = null;
    private Boolean m_force = null;
    private Integer m_drainTimeout = null;
    private Integer m_stopTimeout = null;
    private VerboseListener m_vlsnr = null;
    private CRSResource.CSSCritical m_cssCritical = null;
    private Integer m_cpuCount = null;
    private Integer m_memTarget = null;
    private Integer m_maxMemory = null;
    private Integer m_cpuCap = null;
    private List<ServerGroup> m_rfPools = null;
    private Network m_defaultNetwork = null;

    public void setDBName(String dbName) throws DatabaseException {
        this.sureNotNull(dbName, "dbName");
        this.m_dbName = dbName;
    }

    public void setDBDomain(String dbDomain) throws DatabaseException {
        this.sureNotNull(dbDomain, "dbDomain");
        this.m_dbDomain = dbDomain;
    }

    public void setInstanceName(String instanceName) throws DatabaseException {
        this.sureNotNull(instanceName, "instanceName");
        this.m_instanceName = instanceName;
    }

    public void setInstanceNodeMap(Map<String, Node> instNodeMap) throws DatabaseException {
        this.sureNotNull(instNodeMap, "instNodeMap");
        this.m_instNodeMap = instNodeMap;
    }

    public void setSPFile(String spfile) throws DatabaseException {
        this.sureNotNull(spfile, "spfile");
        this.m_spfile = spfile;
    }

    public void setStartMode(StartOptions startMode) throws DatabaseException {
        this.sureNotNull((Object)startMode, "startMode");
        this.m_startModes = new StartOptions[1];
        this.m_startModes[0] = startMode;
    }

    public void setStartModes(StartOptions[] startModes) throws DatabaseException {
        this.sureNotNull(startModes, "startModes");
        this.m_startModes = startModes;
    }

    public void setStopMode(StopOptions stopMode) throws DatabaseException {
        this.sureNotNull((Object)stopMode, "stopMode");
        this.m_stopModes = new StopOptions[1];
        this.m_stopModes[0] = stopMode;
    }

    public void setStopModes(StopOptions[] stopModes) throws DatabaseException {
        this.sureNotNull(stopModes, "stopModes");
        this.m_stopModes = stopModes;
    }

    public void setDBRole(DBRole dbRole) throws DatabaseException {
        this.sureNotNull((Object)dbRole, "dbRole");
        this.m_dbRole = dbRole;
    }

    public void setMgmtPolicy(ManagementPolicy policy) throws DatabaseException {
        this.sureNotNull((Object)policy, "policy");
        this.m_policy = policy;
    }

    public void setDiskGroupList(List<DiskGroup> diskGroupList) throws DatabaseException {
        this.sureNotNull(diskGroupList, "diskGroupList");
        this.m_diskGroupList = diskGroupList;
    }

    public void setACFSPaths(List<String> acfsPaths) throws DatabaseException {
        this.sureNotNull(acfsPaths, "acfsPaths");
        this.m_acfsPaths = acfsPaths;
    }

    public void setACFS(List<AsmClusterFileSystem> acfs) throws DatabaseException {
        this.sureNotNull(acfs, "acfs");
        this.m_acfs = acfs;
    }

    public void setPWFile(String pwfile) throws DatabaseException {
        this.sureNotNull(pwfile, "pwfile");
        this.m_pwfile = pwfile;
    }

    public String getPWFile() {
        return this.m_pwfile;
    }

    public String getDBName() {
        return this.m_dbName;
    }

    public String getDBDomain() {
        return this.m_dbDomain;
    }

    public String getInstanceName() {
        return this.m_instanceName;
    }

    public Map<String, Node> getInstNodeMap() {
        return this.m_instNodeMap;
    }

    public String getSPFile() {
        return this.m_spfile;
    }

    public StartOptions getStartMode() {
        if (this.m_startModes == null) {
            return null;
        }
        return this.m_startModes[0];
    }

    public StartOptions[] getStartModes() {
        return this.m_startModes;
    }

    public StopOptions getStopMode() {
        if (this.m_stopModes == null) {
            return null;
        }
        return this.m_stopModes[0];
    }

    public StopOptions[] getStopModes() {
        return this.m_stopModes;
    }

    public DBRole getDBRole() {
        return this.m_dbRole;
    }

    public ManagementPolicy getMgmtPolicy() {
        return this.m_policy;
    }

    public List<DiskGroup> getDiskGroupList() {
        return this.m_diskGroupList;
    }

    public List<String> getACFSPaths() {
        return this.m_acfsPaths;
    }

    public List<AsmClusterFileSystem> getACFS() {
        return this.m_acfs;
    }

    public void setOnlineRelocationTimeout(int timeout) throws DatabaseException {
        if (timeout < 1 || timeout > 720) {
            throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_OMOTION_TIMEOUT, timeout, 1, 720);
        }
        this.m_timeout = timeout;
    }

    public int getOnlineRelocationTimeout() {
        return this.m_timeout;
    }

    public void setStartConcurrency(int start_concurrency) throws DatabaseException {
        this.m_start_concurrency = start_concurrency;
    }

    public int getStartConcurrency() {
        return this.m_start_concurrency;
    }

    public void setStopConcurrency(int stop_concurrency) throws DatabaseException {
        this.m_stop_concurrency = stop_concurrency;
    }

    public int getStopConcurrency() {
        return this.m_stop_concurrency;
    }

    public void setOracleUser(String oracleUser) throws DatabaseException {
        this.sureNotEmptyString(oracleUser, "oracleUser");
        this.m_oracleUser = oracleUser;
    }

    public String getOracleUser() {
        return this.m_oracleUser;
    }

    public void setServerGroupList(List<ServerGroup> sgList) throws DatabaseException {
        this.sureNotNull(sgList, "sgList");
        this.m_sgList = sgList;
    }

    public List<ServerGroup> getServerGroupList() {
        return this.m_sgList;
    }

    public void setPQPools(List<ServerGroup> pqpools) throws DatabaseException {
        this.sureNotNull(pqpools, "pqpools");
        this.m_pqpools = pqpools;
    }

    public List<ServerGroup> getPQPools() {
        return this.m_pqpools;
    }

    public void setForceFlag(boolean force) throws DatabaseException {
        this.m_force = force;
    }

    public Boolean getForceFlag() {
        return this.m_force;
    }

    public void setCSSCriticalOption(CRSResource.CSSCritical option) throws DatabaseException {
        this.sureNotNull((Object)option, "dbOptionalArgs-css_critical");
        this.m_cssCritical = option;
    }

    public CRSResource.CSSCritical getCSSCriticalOption() {
        return this.m_cssCritical;
    }

    public void setCPUCount(int count) throws InvalidArgsException {
        if (count <= 0) {
            throw new InvalidArgsException((MessageKey)PrCdMsgID.INVALID_DB_CPUCOUNT_VALUE, String.valueOf(count));
        }
        this.m_cpuCount = new Integer(count);
    }

    public Integer getCPUCount() {
        return this.m_cpuCount;
    }

    public void setMemoryTarget(int target) throws InvalidArgsException {
        this.m_memTarget = new Integer(target);
    }

    public Integer getMemoryTarget() {
        return this.m_memTarget;
    }

    public void setMaxMemory(int maxMem) throws InvalidArgsException {
        this.m_maxMemory = new Integer(maxMem);
    }

    public Integer getMaxMemory() {
        return this.m_maxMemory;
    }

    public void setCPUCap(int cpuCap) throws InvalidArgsException {
        this.m_cpuCap = new Integer(cpuCap);
    }

    public Integer getCPUCap() {
        return this.m_cpuCap;
    }

    public void setDrainTimeout(Integer timeout) throws DatabaseException {
        this.sureNotNull(timeout, "dbOptionalArgs-drain_timeout");
        if (timeout < -1) {
            throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_INTEGER, timeout.toString());
        }
        this.m_drainTimeout = timeout;
    }

    public Integer getDrainTimeout() {
        return this.m_drainTimeout;
    }

    public void setStopTimeout(Integer timeout) throws DatabaseException {
        if (timeout < -1) {
            throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_INTEGER, timeout.toString());
        }
        this.m_stopTimeout = timeout;
    }

    public Integer getStopTimeout() {
        return this.m_stopTimeout;
    }

    public void setVerboseListener(VerboseListener vlsnr) throws DatabaseException {
        this.sureNotNull(vlsnr, "dbOptionalArgs-verboseListener");
        this.m_vlsnr = vlsnr;
    }

    public VerboseListener getVerboseListener() {
        return this.m_vlsnr;
    }

    public List<ServerGroup> getRFPools() {
        return this.m_rfPools;
    }

    public void setRFPools(List<ServerGroup> rfPools) throws DatabaseException {
        this.sureNotNull(rfPools, "ServiceARgs-setRFPool");
        this.m_rfPools = rfPools;
    }

    public void setDefaultNetwork(Network defaultNetwork) throws DatabaseException {
        this.m_defaultNetwork = defaultNetwork;
    }

    public Network getDefaultNetwork() {
        return this.m_defaultNetwork;
    }

    private void sureNotEmptyString(String str, String name) throws DatabaseException {
        if (str == null || str.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, name);
        }
    }

    private void sureNotNull(Object o, String name) throws DatabaseException {
        if (o == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, name);
        }
    }
}

