/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.database;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.DiskSpaceFlags;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.NotSupportedException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.common.UnsupportedVersionException;
import oracle.cluster.crs.VersionMismatchException;
import oracle.cluster.database.AlreadyInOptionException;
import oracle.cluster.database.CardinalDatabase;
import oracle.cluster.database.CardinalService;
import oracle.cluster.database.DBInstancesSelection;
import oracle.cluster.database.DBServicesSelection;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseOptionalArgs;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.FailedOmotionNotExistException;
import oracle.cluster.database.HAService;
import oracle.cluster.database.IncompatibleOptionException;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.MgmtDBConnection;
import oracle.cluster.database.MgmtDatabase;
import oracle.cluster.database.MoveDatabaseException;
import oracle.cluster.database.MoveDatabaseOptionalArgs;
import oracle.cluster.database.NoDatabasesToMoveException;
import oracle.cluster.database.OmotionAlreadyActiveException;
import oracle.cluster.database.OmotionAlreadyFailedException;
import oracle.cluster.database.OmotionArgs;
import oracle.cluster.database.RACOneNodeDatabase;
import oracle.cluster.database.RACOneNodeService;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.database.SingleInstanceDatabase;
import oracle.cluster.database.SingleInstanceService;
import oracle.cluster.database.StartOptions;
import oracle.cluster.home.HomeException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyDowngradedException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyUpgradedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.DowngradeException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;

public class DatabaseFactory {
    private static DatabaseFactory s_instance;
    private DatabaseFactoryImpl s_factoryImpl = DatabaseFactoryImpl.getInstance();

    private DatabaseFactory() throws SoftwareModuleException {
    }

    public static synchronized DatabaseFactory getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new DatabaseFactory();
        }
        return s_instance;
    }

    public Database createMgmtDatabase(DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        return this.s_factoryImpl.createMgmtDatabase(databaseOptions, version);
    }

    public Database createDatabase(String dbUniqueName, ServerGroup serverGroup, boolean isClusterDB, String oracleHome, Version version) throws AlreadyExistsException, DatabaseException {
        return this.s_factoryImpl.createDatabase(dbUniqueName, serverGroup, isClusterDB, oracleHome, null, version);
    }

    public Database createDatabase(String dbUniqueName, ServerGroup serverGroup, boolean isClusterDB, String oracleHome, DatabaseOptionalArgs dbOptionalArgs, Version version) throws AlreadyExistsException, DatabaseException {
        if (dbOptionalArgs == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbOptionalArgs", dbOptionalArgs);
        }
        return this.s_factoryImpl.createDatabase(dbUniqueName, serverGroup, isClusterDB, oracleHome, dbOptionalArgs, version);
    }

    public Database createDatabase(String dbUniqueName, boolean isClusterDB, List<ServerGroup> serverGroupList, String oracleHome, Version version) throws AlreadyExistsException, DatabaseException {
        return this.s_factoryImpl.createDatabase(dbUniqueName, isClusterDB, serverGroupList, oracleHome, version);
    }

    public Database createDatabase(String dbUniqueName, boolean isClusterDB, List<ServerGroup> serverGroupList, String oracleHome, DatabaseOptionalArgs dbOptionalArgs, Version version) throws AlreadyExistsException, DatabaseException {
        if (dbOptionalArgs == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbOptionalArgs", dbOptionalArgs);
        }
        return this.s_factoryImpl.createDatabase(dbUniqueName, isClusterDB, serverGroupList, oracleHome, dbOptionalArgs, version);
    }

    public Database createDatabase(String dbUniqueName, DatabaseType dbType, ServerPool serverPool, String oracleHome, DatabaseOptionalArgs dbOptionalArgs, Version version) throws AlreadyExistsException, DatabaseException {
        if (dbOptionalArgs == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbOptionalArgs", dbOptionalArgs);
        }
        return this.s_factoryImpl.createDatabase(dbUniqueName, dbType, serverPool, oracleHome, dbOptionalArgs, version);
    }

    public Database createDatabase(String dbUniqueName, DatabaseType dbType, List<Server> serverList, String oracleHome, DatabaseOptionalArgs dbOptionalArgs, Version version) throws AlreadyExistsException, DatabaseException {
        if (dbOptionalArgs == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbOptionalArgs", dbOptionalArgs);
        }
        if (serverList == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverList", serverList);
        }
        return this.s_factoryImpl.createDatabase(dbUniqueName, dbType, serverList.toArray(new Server[serverList.size()]), oracleHome, dbOptionalArgs, version);
    }

    public Database createDatabase(String dbUniqueName, String nodeName, String oracleHome, boolean isFixed) throws AlreadyExistsException, DatabaseException {
        DatabaseOptionalArgs databaseOptions = new DatabaseOptionalArgs();
        return this.createDatabase(dbUniqueName, nodeName, oracleHome, isFixed, databaseOptions);
    }

    public Database createDatabase(String dbUniqueName, String nodeName, String oracleHome, boolean isFixed, DatabaseOptionalArgs databaseOptions) throws AlreadyExistsException, DatabaseException {
        return this.s_factoryImpl.createDatabase(dbUniqueName, nodeName, oracleHome, isFixed, databaseOptions);
    }

    public Database createLocalDatabase(String dbUniqueName, DatabaseType dbType, List<ServerGroup> serverGroupList) throws DatabaseException {
        return this.s_factoryImpl.createLocalDatabase(dbUniqueName, dbType, serverGroupList);
    }

    public Database createLocalDatabase(String dbUniqueName, DatabaseType dbType, List<ServerGroup> serverGroupList, DatabaseOptionalArgs dbargs) throws DatabaseException {
        return this.s_factoryImpl.createLocalDatabase(dbUniqueName, dbType, serverGroupList, dbargs);
    }

    @Deprecated
    public Version getDatabaseVersion(String dbUniqueName) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getDatabaseVersion(dbUniqueName);
    }

    public Version getSupportedDatabaseVersion(String dbUniqueName) throws InvalidArgsException, NotExistsException, UnsupportedVersionException, DatabaseException {
        return this.s_factoryImpl.getSupportedDatabaseVersion(dbUniqueName);
    }

    public Database getDatabase(String dbUniqueName) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getDatabase(dbUniqueName);
    }

    public Database getDatabase(String dbUniqueName, Version version) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getDatabase(dbUniqueName, version);
    }

    public Database getDatabase(Version version, String dbUniqueName) throws NotExistsException, DatabaseException, VersionMismatchException {
        return this.s_factoryImpl.getDatabase(version, dbUniqueName);
    }

    public List<Database> getDatabases() throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getDatabases();
    }

    public List<Database> getDatabases(String oracleHome) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getDatabases(oracleHome);
    }

    public List<Database> getDatabases(Version version) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getDatabases(version);
    }

    public List<String> getDatabaseNames() throws DatabaseException {
        return this.s_factoryImpl.getDatabaseNames();
    }

    public Map<String, LinkedList> getDatabaseInfos() throws DatabaseException {
        return this.s_factoryImpl.getDatabaseInfos();
    }

    public SingleInstanceDatabase getSingleInstanceDatabase(String dbUniqueName) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getSingleInstanceDatabase(dbUniqueName);
    }

    public SingleInstanceDatabase getSingleInstanceDatabase(String dbUniqueName, Version version) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getSingleInstanceDatabase(dbUniqueName, version);
    }

    public CardinalDatabase getCardinalDatabase(String dbUniqueName) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getCardinalDatabase(dbUniqueName);
    }

    public CardinalDatabase getCardinalDatabase(String dbUniqueName, Version version) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getCardinalDatabase(dbUniqueName, version);
    }

    public RACOneNodeDatabase getRACOneNodeDatabase(String dbUniqueName) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getRACOneNodeDatabase(dbUniqueName);
    }

    public MgmtDatabase getMgmtDatabase() throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getMgmtDatabase();
    }

    public String getPDBName() throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getPDBName();
    }

    public MgmtDBConnection getMgmtDBConnection() throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getMgmtDBConnection();
    }

    public MgmtDBConnection getMgmtDBConnection(String clusterName) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getMgmtDBConnection(clusterName);
    }

    public MgmtDBConnection getGIMRDBConnection(String clusterGUID) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.getGIMRDBConnection(clusterGUID);
    }

    public void modifyDatabase(RACOneNodeDatabase racOneDB, List<Server> serverList) throws NotExistsException, DatabaseException {
        this.s_factoryImpl.modifyDatabase(racOneDB, serverList);
    }

    public CardinalDatabase convertDatabase(RACOneNodeDatabase racOneDB, DatabaseOptionalArgs dbArgs) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.convertDatabase(racOneDB, dbArgs);
    }

    public RACOneNodeDatabase convertDatabase(CardinalDatabase racDB, DatabaseOptionalArgs dbArgs) throws NotExistsException, DatabaseException {
        return this.s_factoryImpl.convertDatabase(racDB, dbArgs);
    }

    public Service createService(String serviceName, Database database, ServiceTAF tafPolicy, Version version) throws AlreadyExistsException, NetworkException, ServiceException {
        return this.s_factoryImpl.createService(serviceName, database, tafPolicy, version);
    }

    public Service createService(String serviceName, Database database, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version) throws AlreadyExistsException, NetworkException, ServiceException {
        if (serviceArgs == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serviceArgs", serviceArgs);
        }
        return this.s_factoryImpl.createService(serviceName, database, tafPolicy, serviceArgs, version);
    }

    public Service createService(String serviceName, Database database, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version, boolean checkListener) throws AlreadyExistsException, NetworkException, ServiceException {
        if (serviceArgs == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serviceArgs", serviceArgs);
        }
        return this.s_factoryImpl.createService(serviceName, database, tafPolicy, serviceArgs, version, checkListener);
    }

    public Service createPQService(String pqservice, String pqpool, Service mainSvc, Version version) throws AlreadyExistsException, ServiceException {
        return this.s_factoryImpl.createPQService(pqservice, pqpool, mainSvc, version);
    }

    public Service createPQService(String pqservice, String pqpool, String serviceName, Database db, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version) throws AlreadyExistsException, NetworkException, ServiceException {
        return this.s_factoryImpl.createPQService(pqservice, pqpool, serviceName, db, tafPolicy, serviceArgs, version);
    }

    public Service getService(String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        return this.s_factoryImpl.getService(dbUniqueName, serviceName);
    }

    public Service getService(String dbUniqueName, String serviceName, Version dbVer) throws InvalidArgsException, NotExistsException, ServiceException {
        return this.s_factoryImpl.getService(dbUniqueName, serviceName, dbVer);
    }

    public Service getPQService(Service service) throws NotExistsException, ServiceException {
        return this.s_factoryImpl.getPQService(service);
    }

    public CardinalService getCardinalService(String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        return this.s_factoryImpl.getCardinalService(dbUniqueName, serviceName);
    }

    public CardinalService getCardinalService(String dbUniqueName, String serviceName, Version dbVer) throws InvalidArgsException, NotExistsException, ServiceException {
        return this.s_factoryImpl.getCardinalService(dbUniqueName, serviceName, dbVer);
    }

    public SingleInstanceService getSingleInstanceService(String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        return this.s_factoryImpl.getSingleInstanceService(dbUniqueName, serviceName);
    }

    public SingleInstanceService getSingleInstanceService(String dbUniqueName, String serviceName, Version dbVer) throws InvalidArgsException, NotExistsException, ServiceException {
        return this.s_factoryImpl.getSingleInstanceService(dbUniqueName, serviceName, dbVer);
    }

    public HAService getHAService(String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        return this.s_factoryImpl.getHAService(dbUniqueName, serviceName);
    }

    public HAService getHAService(String dbUniqueName, String serviceName, Version dbVer) throws InvalidArgsException, NotExistsException, ServiceException {
        return this.s_factoryImpl.getHAService(dbUniqueName, serviceName, dbVer);
    }

    public HAService getHAService(Service service) throws ServiceException {
        return this.s_factoryImpl.getHAService(service);
    }

    public RACOneNodeService getRACOneNodeService(String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        return this.s_factoryImpl.getRACOneNodeService(dbUniqueName, serviceName);
    }

    public RACOneNodeService getRACOneNodeService(String dbUniqueName, String serviceName, Version dbVer) throws InvalidArgsException, NotExistsException, ServiceException {
        return this.s_factoryImpl.getRACOneNodeService(dbUniqueName, serviceName, dbVer);
    }

    public Service createLocalService(String serviceName, Database database) throws ServiceException {
        return this.s_factoryImpl.createLocalService(serviceName, database);
    }

    public Service createLocalService(String serviceName, Database database, ServiceArgs svcargs) throws ServiceException {
        return this.s_factoryImpl.createLocalService(serviceName, database, svcargs);
    }

    public DatabaseInstance createDatabaseInstance(Database database, String instanceName) throws InstanceException {
        return this.s_factoryImpl.createDatabaseInstance(database, instanceName);
    }

    public DatabaseInstance createDatabaseInstance(Database database, String instanceName, String nodeName) throws InstanceException {
        return this.s_factoryImpl.createDatabaseInstance(database, instanceName, nodeName);
    }

    public ServiceArgs getArgs(Service service) throws ServiceException {
        return this.s_factoryImpl.getArgs(service);
    }

    public void modify(Service service, ServiceArgs args, boolean global, boolean force) throws ServiceException {
        this.s_factoryImpl.modify(service, args, global, force);
    }

    public void modify(Service service, ServiceArgs args, boolean global) throws ServiceException {
        this.s_factoryImpl.modify(service, args, global);
    }

    public void modify(Service service, ServiceArgs args) throws ServiceException {
        this.s_factoryImpl.modify(service, args, false);
    }

    public void modifyMgmtDatabase(MgmtDatabase db, DatabaseOptionalArgs args) throws DatabaseException {
        this.s_factoryImpl.modifyMgmtDatabase(db, args);
    }

    public void modifyDatabase(Database db, ServerPool sp) throws DatabaseException {
        this.s_factoryImpl.modifyDatabase(db, sp);
    }

    public void modifyDatabase(Database db, ServerPool sp, boolean force) throws DatabaseException {
        this.s_factoryImpl.modifyDatabase(db, sp, force);
    }

    public void modifyDatabase(Database db, DatabaseOptionalArgs args) throws DatabaseException {
        this.s_factoryImpl.modifyDatabase(db, args);
    }

    public void modifyDatabase(Database db, DatabaseOptionalArgs args, String oracleHome) throws DatabaseException {
        this.s_factoryImpl.modifyDatabase(db, args, oracleHome);
    }

    public static String getDatabaseResourceName(String dbUniqueName) {
        return DatabaseFactory.getDatabaseResourceName(dbUniqueName, false, dbUniqueName.equals(ResourceLiterals.MGMTDB_UNIQUE_NAME.toString()));
    }

    public static String getDatabaseResourceName(String dbUniqueName, boolean preserveCase) {
        return DatabaseFactory.getDatabaseResourceName(dbUniqueName, preserveCase, dbUniqueName.equals(ResourceLiterals.MGMTDB_UNIQUE_NAME.toString()));
    }

    public static String getDatabaseResourceName(String dbUniqueName, boolean preserveCase, boolean isMgmtDB) {
        if (isMgmtDB) {
            return "ora." + ResourceLiterals.MGMTDB.toString();
        }
        return "ora." + (preserveCase ? dbUniqueName : dbUniqueName.toLowerCase()) + '.' + ResourceLiterals.DB.toString();
    }

    public static String getDatabaseUniqueName(String dbResName) throws DatabaseException {
        if (dbResName == null || dbResName.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.Database.NAME.name(), dbResName);
        }
        String[] values = dbResName.split(Pattern.quote(String.valueOf('.')));
        if (values.length == 2 && values[1].equalsIgnoreCase(ResourceLiterals.MGMTDB.toString()) && "ora.".equalsIgnoreCase(values[0] + String.valueOf('.'))) {
            return ResourceLiterals.MGMTDB_UNIQUE_NAME.toString();
        }
        if (values.length != 3 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.DB.toString().equalsIgnoreCase(values[2])) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.Database.NAME.name(), dbResName);
        }
        return values[1];
    }

    public void omotionDatabase(RACOneNodeDatabase racOneDB) throws OmotionAlreadyActiveException, OmotionAlreadyFailedException, DatabaseException {
        this.s_factoryImpl.omotionDatabase(racOneDB);
    }

    public void omotionDatabase(RACOneNodeDatabase racOneDB, OmotionArgs args) throws OmotionAlreadyActiveException, OmotionAlreadyFailedException, DatabaseException {
        this.s_factoryImpl.omotionDatabase(racOneDB, args);
    }

    public RACOneNodeDatabase.OmotionStatus getOmotionStatus(RACOneNodeDatabase racOneDB) throws DatabaseException {
        return this.s_factoryImpl.getOmotionStatus(racOneDB);
    }

    public void abortOmotion(RACOneNodeDatabase racOneDB, OmotionArgs args) throws FailedOmotionNotExistException, DatabaseException {
        this.s_factoryImpl.abortOmotion(racOneDB, args);
    }

    public void upgradeDatabase(String dbUniqueName, String oracleHome) throws UpgradeException, AlreadyUpgradedException, CompositeOperationException {
        this.s_factoryImpl.upgradeDatabase(dbUniqueName, oracleHome);
    }

    public void upgradePreTBDatabaseActionScript() throws UpgradeException {
        this.s_factoryImpl.upgradePreTBDatabaseActionScript();
    }

    public void upgradeMgmtDB12102To122FirstPhase() throws UpgradeException {
        this.s_factoryImpl.upgradeMgmtDB12102To122FirstPhase();
    }

    public void upgradeDBActions12102To122FirstPhase() throws UpgradeException {
        this.s_factoryImpl.upgradeDBActions12102To122FirstPhase();
    }

    public void downgradeDatabase(String dbUniqueName, String oracleHome, String version) throws AlreadyDowngradedException, CompositeOperationException, DowngradeException {
        this.s_factoryImpl.downgradeDatabase(dbUniqueName, oracleHome, version);
    }

    public static void validateName(String name, boolean isInstance) throws DatabaseException {
        DatabaseImpl.validateName(name, isInstance);
    }

    public static String getPolicyDatabaseInstancePrefix(String dbUniqueName) {
        return DatabaseFactoryImpl.getPolicyDatabaseInstancePrefix(dbUniqueName);
    }

    public static void validateUniqueness(String dbUniqueName) throws DatabaseException {
        DatabaseFactoryImpl.validateUniqueness(dbUniqueName);
    }

    @Deprecated
    public void updateDatabaseStartOption(String dbUniqueName, StartOptions[] soArr) throws IncompatibleOptionException, AlreadyInOptionException, NotExistsException, DatabaseException {
        this.s_factoryImpl.updateDatabaseStartOption(dbUniqueName, soArr);
    }

    @Deprecated
    public void updateDatabaseStartOption(String dbUniqueName, String nodeName, StartOptions[] soArr) throws IncompatibleOptionException, AlreadyInOptionException, NotRunningException, NotExistsException, DatabaseException {
        this.s_factoryImpl.updateDatabaseStartOption(dbUniqueName, nodeName, soArr);
    }

    @Deprecated
    public void updateDatabaseInstanceStartOption(String dbUniqueName, String instName, StartOptions[] soArr) throws IncompatibleOptionException, AlreadyInOptionException, NotExistsException, DatabaseException {
        this.s_factoryImpl.updateDatabaseInstanceStartOption(dbUniqueName, instName, soArr);
    }

    public void updateDBTargetForInstances(String dbUniqueName, String targetInst, String[] instNames) throws DatabaseException {
        this.s_factoryImpl.updateDBTargetForInstances(dbUniqueName, targetInst, instNames);
    }

    public void updateDBTargetOnNodes(String dbUniqueName, String targetInst, String[] nodeNames) throws DatabaseException {
        this.s_factoryImpl.updateDBTargetOnNodes(dbUniqueName, targetInst, nodeNames);
    }

    public void updateDBTarget(String dbUniqueName, String targetInst) throws DatabaseException {
        this.s_factoryImpl.updateDBTarget(dbUniqueName, targetInst);
    }

    public static boolean isPQPoolSupported() throws DatabaseException, ClusterOperationException, ClusterException {
        return DatabaseFactoryImpl.isPQPoolSupported();
    }

    public void moveDatabases(String oldOraHome, String newOraHome) throws HomeException, VersionMismatchException, MoveDatabaseException {
        this.s_factoryImpl.moveDatabases(oldOraHome, newOraHome);
    }

    public void moveDatabases(String oldOraHome, String newOraHome, boolean rolling) throws HomeException, VersionMismatchException, MoveDatabaseException {
        this.s_factoryImpl.moveDatabases(oldOraHome, newOraHome, rolling);
    }

    public void moveDatabases(List<String> dbNames, String newOraHome, boolean rolling) throws InvalidArgsException, VersionMismatchException, NoDatabasesToMoveException, MoveDatabaseException {
        this.s_factoryImpl.moveDatabases(dbNames, newOraHome, rolling);
    }

    public void moveDatabases(List<String> dbNames, String dstHome, List<String> batch, MoveDatabaseOptionalArgs args) throws InvalidArgsException, NotExistsException, VersionMismatchException, NotSupportedException, NoDatabasesToMoveException, MoveDatabaseException {
        this.s_factoryImpl.moveDatabases(dbNames, dstHome, batch, args);
    }

    public void moveDatabases(List<String> dbNames, String dstHome, List<String> batch) throws InvalidArgsException, NotExistsException, VersionMismatchException, NotSupportedException, NoDatabasesToMoveException, MoveDatabaseException {
        this.s_factoryImpl.moveDatabases(dbNames, dstHome, batch);
    }

    public void moveDatabases(String srcHome, String dstHome, List<String> batch, MoveDatabaseOptionalArgs args) throws InvalidArgsException, NotExistsException, VersionMismatchException, NotSupportedException, NoDatabasesToMoveException, MoveDatabaseException {
        this.s_factoryImpl.moveDatabases(srcHome, dstHome, batch, args);
    }

    public void moveDatabases(String srcHome, String dstHome, List<String> batch) throws InvalidArgsException, NotExistsException, VersionMismatchException, NotSupportedException, NoDatabasesToMoveException, MoveDatabaseException {
        this.s_factoryImpl.moveDatabases(srcHome, dstHome, batch);
    }

    public void moveDatabases(List<String> dbNames, String newOraHome, MoveDatabaseOptionalArgs args) throws InvalidArgsException, VersionMismatchException, NoDatabasesToMoveException, MoveDatabaseException {
        this.s_factoryImpl.moveDatabases(dbNames, newOraHome, args);
    }

    public void resumeMoveDatabases(MoveDatabaseException e) throws InvalidArgsException, MoveDatabaseException {
        this.s_factoryImpl.resumeMoveDatabases(e);
    }

    public void updateServiceAttrsForPatch18697602() throws NotExistsException, DatabaseException {
        this.s_factoryImpl.updateServiceAttrsForPatch18697602();
    }

    public List<DatabaseInstance> getRunningInstances(String node) throws NotExistsException, NotRunningException, DatabaseException {
        return this.s_factoryImpl.getRunningInstances(node);
    }

    public List<DatabaseInstance> getAdminDatabaseInstances(String node) throws InvalidArgsException, DatabaseException {
        return this.s_factoryImpl.getAdminDatabaseInstances(node);
    }

    public Map<String, List<DatabaseInstance>> getDatabaseInstances(String home) throws InvalidArgsException, UnsupportedVersionException, NotExistsException, DatabaseException {
        return this.s_factoryImpl.getDatabaseInstances(home);
    }

    public Map<String, List<DatabaseInstance>> getDatabaseInstances(Version version) throws InvalidArgsException, NotExistsException, DatabaseException {
        return this.s_factoryImpl.getDatabaseInstances(version);
    }

    public void relocateServices(List<Service> svcs, ServiceArgs args, boolean force, String tgtNode) throws InvalidArgsException, NotRunningException, CompositeOperationException, DatabaseException {
        this.s_factoryImpl.relocateServices(svcs, args, force, tgtNode);
    }

    public void relocateServices(List<Service> svcs, ServiceArgs args, boolean force) throws InvalidArgsException, NotRunningException, CompositeOperationException, DatabaseException {
        this.s_factoryImpl.relocateServices(svcs, args, force);
    }

    public DBInstancesSelection getDBInstancesSelection(List<String> dbNames, List<String> nodes) throws InvalidArgsException, DatabaseException {
        return this.s_factoryImpl.getDBInstancesSelection(dbNames, nodes);
    }

    public DBInstancesSelection getDBInstancesSelectionByNodes(List<String> nodes) throws InvalidArgsException, DatabaseException {
        return this.s_factoryImpl.getDBInstancesSelectionByNodes(nodes);
    }

    public DBInstancesSelection getDBInstancesSelection(List<String> dbNames) throws InvalidArgsException, DatabaseException {
        return this.s_factoryImpl.getDBInstancesSelection(dbNames);
    }

    public DBServicesSelection getDBServicesSelectionByNodes(List<String> nodes) throws InvalidArgsException, ServiceException {
        return this.s_factoryImpl.getDBServicesSelectionByNodes(nodes);
    }

    public DBServicesSelection getDBServicesSelection(List<Service> svcs, List<String> nodes) throws InvalidArgsException, ServiceException {
        return this.s_factoryImpl.getDBServicesSelection(svcs, nodes);
    }

    public DBServicesSelection getDBServicesSelectionByDBsAndNodes(List<String> dbNames, List<String> nodes) throws InvalidArgsException, ServiceException {
        return this.s_factoryImpl.getDBServicesSelectionByDBsAndNodes(dbNames, nodes);
    }

    public DBServicesSelection getDBServicesSelection(List<Service> svcs) throws InvalidArgsException, ServiceException {
        return this.s_factoryImpl.getDBServicesSelection(svcs);
    }

    public DBServicesSelection getDBServicesSelectionByDBs(List<String> dbNames) throws InvalidArgsException, ServiceException {
        return this.s_factoryImpl.getDBServicesSelectionByDBs(dbNames);
    }

    public int getIncrementalGIMRSize(int noOfPDBs, EnumSet<DiskSpaceFlags> diskSpaceFlagEnumSet) throws DatabaseException {
        return this.s_factoryImpl.getIncrementalGIMRSize(noOfPDBs, diskSpaceFlagEnumSet);
    }
}

