/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.database;

import oracle.cluster.database.DatabaseException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.util.Utils;

public enum DBRole {
    PRIMARY("PRIMARY"),
    PHYSICAL_STANDBY("PHYSICAL_STANDBY"),
    LOGICAL_STANDBY("LOGICAL_STANDBY"),
    SNAPSHOT_STANDBY("SNAPSHOT_STANDBY"),
    FAR_SYNC("FAR_SYNC");

    private String m_dbRole;

    private DBRole(String dbRole) {
        this.m_dbRole = dbRole;
    }

    public String toString() {
        return this.m_dbRole;
    }

    public static String toString(DBRole[] roles) {
        return DBRole.toString(roles, " ");
    }

    public static String toString(DBRole[] roles, String separator) {
        if (roles == null) {
            throw new IllegalArgumentException(MessageBundle.getMessage(PrCcMsgID.PARAM_CANNOT_BE_NULL, true, "roles"));
        }
        StringBuilder sb = null;
        for (DBRole r : roles) {
            if (sb != null) {
                sb.append(separator).append(r.toString());
                continue;
            }
            sb = new StringBuilder(r.toString());
        }
        return sb.toString();
    }

    public static DBRole[] decode(String dbRoles) throws DatabaseException {
        if (dbRoles == null) {
            return new DBRole[0];
        }
        return DBRole.decode(Utils.getStringArray(dbRoles, " "));
    }

    public static DBRole[] decode(String[] dbRoles) throws DatabaseException {
        if (dbRoles == null) {
            throw new IllegalArgumentException(MessageBundle.getMessage(PrCcMsgID.PARAM_CANNOT_BE_NULL, true, "dbRoles"));
        }
        DBRole[] result = new DBRole[dbRoles.length];
        int i = 0;
        for (String r : dbRoles) {
            result[i++] = DBRole.getEnumMember(r);
        }
        return result;
    }

    public static DBRole getEnumMember(String dbRole) throws DatabaseException {
        for (DBRole role : DBRole.values()) {
            if (!role.m_dbRole.equalsIgnoreCase(dbRole)) continue;
            return role;
        }
        throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_DATABASE_ROLE, dbRole);
    }
}

