/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cvu;

import oracle.cluster.cvu.CVU;
import oracle.cluster.cvu.CVUException;
import oracle.cluster.impl.cvu.CVUFactoryImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;

public class CVUFactory {
    private static CVUFactory s_cvu;
    private CVUFactoryImpl s_cvuImpl = CVUFactoryImpl.getInstance();

    private CVUFactory() throws CVUException {
    }

    public static synchronized CVUFactory getInstance() throws CVUException {
        if (null == s_cvu) {
            s_cvu = new CVUFactory();
        }
        return s_cvu;
    }

    public CVU createCVU(Version version, String destLoc) throws AlreadyExistsException, CVUException {
        if (null == version) {
            throw new CVUException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version");
        }
        if (null == destLoc || destLoc.equals("")) {
            throw new CVUException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "destLoc");
        }
        return this.s_cvuImpl.createCVU(version, destLoc);
    }

    public CVU createCVU(Version version) throws AlreadyExistsException, CVUException {
        if (null == version) {
            throw new CVUException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version");
        }
        return this.s_cvuImpl.createCVU(version, null);
    }

    public CVU createCVU(Version version, int checkInterval, String destLoc) throws AlreadyExistsException, CVUException {
        if (null == version) {
            throw new CVUException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version");
        }
        if (checkInterval < 10) {
            throw new CVUException((MessageKey)PrCnMsgID.BELOW_MIN_CVU_CHECK_INTERVAL, checkInterval, 10);
        }
        if (null == destLoc || destLoc.equals("")) {
            throw new CVUException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "destLoc");
        }
        return this.s_cvuImpl.createCVU(version, checkInterval, destLoc);
    }

    public CVU createCVU(Version version, int checkInterval) throws AlreadyExistsException, CVUException {
        if (null == version) {
            throw new CVUException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version");
        }
        if (checkInterval < 10) {
            throw new CVUException((MessageKey)PrCnMsgID.BELOW_MIN_CVU_CHECK_INTERVAL, checkInterval, 10);
        }
        return this.s_cvuImpl.createCVU(version, checkInterval, null);
    }

    public CVU getCVU() throws NotExistsException, CVUException {
        return this.s_cvuImpl.getCVU();
    }
}

