/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.crs;

import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.crs.ActionMessage;
import oracle.cluster.crs.ActionResult;
import oracle.cluster.crs.CompositeActionResult;
import oracle.cluster.server.Node;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class CompositeActionException
extends ManageableEntityException {
    private CompositeActionResult m_comActRes = null;
    private Status m_status = Status.ACTION_STATUS_FAILURE;
    private static final String LSEP = System.getProperty("line.separator");

    public CompositeActionException(MessageKey key, Object ... args) {
        super(key, args);
    }

    public CompositeActionException(MessageKey key, Throwable cause, Object ... args) {
        super(key, cause, args);
    }

    public CompositeActionException(MessageKey key, CompositeActionResult car, Object ... args) {
        super(key, args);
        this.m_comActRes = car;
    }

    public CompositeActionException(MessageKey key, Throwable cause, CompositeActionResult car, Object ... args) {
        super(key, cause, args);
        this.m_comActRes = car;
    }

    public CompositeActionException(MessageKey key, Throwable cause, CompositeActionResult car, int clscrs_status, Object[] args) {
        super(key, cause, args);
        this.m_comActRes = car;
        switch (clscrs_status) {
            case 227: {
                this.m_status = Status.ACTION_STATUS_INVALID_RESNAME;
                break;
            }
            case 254: {
                this.m_status = Status.ACTION_STATUS_AUTHORIZATION_FAILURE;
                break;
            }
            case 200: {
                this.m_status = Status.ACTION_STATUS_FAILURE;
                break;
            }
            case 184: {
                this.m_status = Status.ACTION_STATUS_CONNECTION;
                break;
            }
            default: {
                Trace.out("Not Supported Status Value");
            }
        }
    }

    public CompositeActionException(Throwable cause) {
        super(cause);
    }

    public CompositeActionResult getCompositeActionResult() {
        return this.m_comActRes;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        StringBuilder failedMsg = new StringBuilder();
        String causedByMsg = super.getMessage();
        if (causedByMsg.length() != 0) {
            failedMsg.append(causedByMsg);
            failedMsg.append(LSEP);
        }
        if (this.m_comActRes != null) {
            String sep = "";
            for (ActionResult ar : this.m_comActRes.getActionResultsForFailedNodes()) {
                try {
                    Node node = ar.getNode();
                    String nodeName = node.getName();
                    failedMsg.append(sep + nodeName + ": ");
                    ActionMessage fm = ar.getFinalMessage();
                    if (fm != null) {
                        failedMsg.append(fm.getMessage());
                    }
                }
                catch (NodeException e) {
                    Trace.out(e);
                }
                sep = LSEP;
            }
        }
        return failedMsg.toString();
    }

    public Status getStatus() {
        return this.m_status;
    }

    public static enum Status {
        ACTION_STATUS_FAILURE,
        ACTION_STATUS_CONNECTION,
        ACTION_STATUS_INVALID_RESNAME,
        ACTION_STATUS_AUTHORIZATION_FAILURE;

    }
}

