/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.credentials;

import java.util.List;
import java.util.Map;
import oracle.cluster.credentials.CredDomain;
import oracle.cluster.credentials.Credentials;
import oracle.cluster.credentials.CredentialsACLPerm;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsType;
import oracle.cluster.credentials.KeyPairCredentials;
import oracle.cluster.credentials.SharedKeyCredentials;
import oracle.cluster.credentials.UserPassCredentials;
import oracle.cluster.credentials.WalletCredentials;
import oracle.cluster.util.NotExistsException;

public interface CredentialsSet {
    public Credentials getCredentials(int var1) throws CredentialsException, NotExistsException;

    public WalletCredentials getWalletCredentials(int var1) throws CredentialsException, NotExistsException;

    public UserPassCredentials getUserPassCredentials(int var1) throws CredentialsException, NotExistsException;

    public SharedKeyCredentials getSharedKeyCredentials(int var1) throws CredentialsException, NotExistsException;

    public KeyPairCredentials getKeyPairCredentials(int var1) throws CredentialsException, NotExistsException;

    public List<Credentials> getAllCredentials() throws CredentialsException;

    public void importFromWrapFile(String var1) throws CredentialsException;

    public void importFromWrapBuffer(String var1) throws CredentialsException;

    public void exportToWrapFile(String var1) throws CredentialsException;

    public void exportToWrapFile(String var1, int var2) throws CredentialsException;

    public String exportToWrapBuffer() throws CredentialsException;

    public String exportToWrapBuffer(int var1) throws CredentialsException;

    public void removeCredentials(int var1) throws CredentialsException, NotExistsException;

    public CredentialsType getCredType();

    public void setAttributes(Map<String, String> var1) throws CredentialsException;

    public Map<String, String> getAttributes(List<String> var1) throws CredentialsException, NotExistsException;

    public CredDomain getDomain();

    public UserPassCredentials createUserPassCredentials(String var1, String var2) throws CredentialsException;

    public UserPassCredentials createUserPassCredentials(String var1, String var2, Map<String, String> var3) throws CredentialsException;

    public KeyPairCredentials createKeyPairCredentials(String var1, String var2) throws CredentialsException;

    public KeyPairCredentials createKeyPairCredentials(String var1, String var2, Map<String, String> var3) throws CredentialsException;

    public SharedKeyCredentials createSharedKeyCredentials(String var1) throws CredentialsException;

    public SharedKeyCredentials createSharedKeyCredentials(String var1, Map<String, String> var2) throws CredentialsException;

    public WalletCredentials createWalletCredentials(String var1) throws CredentialsException;

    public WalletCredentials createWalletCredentials(String var1, Map<String, String> var2) throws CredentialsException;

    public WalletCredentials createWalletCredentials(String var1, String var2) throws CredentialsException;

    public WalletCredentials createWalletCredentials(String var1, String var2, Map<String, String> var3) throws CredentialsException;

    public void setPGroup(String var1) throws CredentialsException;

    public String getPGroup() throws CredentialsException, NotExistsException;

    public void setOwner(String var1) throws CredentialsException;

    public String getOwner() throws CredentialsException, NotExistsException;

    public void setOwnerPerms(CredentialsACLPerm ... var1) throws CredentialsException;

    public String getOwnerPerms() throws CredentialsException, NotExistsException;

    public void setPGroupPerms(CredentialsACLPerm ... var1) throws CredentialsException;

    public String getPGroupPerms() throws CredentialsException, NotExistsException;

    public void setOtherPerms(CredentialsACLPerm ... var1) throws CredentialsException;

    public String getOtherPerms() throws CredentialsException, NotExistsException;
}

