/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.credentials;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.credentials.ASMProperties;
import oracle.cluster.credentials.CredDomain;
import oracle.cluster.credentials.CredFileDomain;
import oracle.cluster.credentials.CredentialsACLPerm;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.GIMRProperties;
import oracle.cluster.credentials.GNSProperties;
import oracle.cluster.credentials.MGMTDBProperties;
import oracle.cluster.credentials.UserPassCredentials;
import oracle.cluster.database.GIMRComponent;
import oracle.cluster.deployment.ClientClusterComponent;
import oracle.cluster.impl.credentials.CredentialsFactoryImpl;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;

public class CredentialsFactory {
    private static CredentialsFactory s_instance;
    private CredentialsFactoryImpl s_factoryImpl = CredentialsFactoryImpl.getInstance();
    private static final String PASSWD_ALGORITHM = "SHA1PRNG";
    private static final int PASSWORD_LENGTH = 16;
    private static final char[] PUNCTUATION_CHARS;

    private CredentialsFactory() throws CredentialsException {
    }

    public static synchronized CredentialsFactory getInstance() throws CredentialsException {
        if (null == s_instance) {
            s_instance = new CredentialsFactory();
        }
        return s_instance;
    }

    public ASMProperties getAndValidateASMProperties(HashMap<String, String> propmap) throws CredentialsException {
        return this.s_factoryImpl.getASMProperties(propmap);
    }

    public ASMProperties getASMProperties(HashMap<String, String> propmap) throws CredentialsException {
        return this.s_factoryImpl.getASMProperties(propmap);
    }

    public HashMap<String, String> getCredentialProperties(String credFile, String sectionName) throws CredentialsException {
        return this.s_factoryImpl.getCredentialProperties(credFile, sectionName);
    }

    public Map<String, String> getCredProperties(String credFile, String sectionName) throws CredentialsException, NotExistsException {
        return this.s_factoryImpl.getCredProperties(credFile, sectionName);
    }

    public String getCredentialProperty(String credFile, String sectionName, String propertyName) throws CredentialsException {
        return this.s_factoryImpl.getCredentialProperty(credFile, sectionName, propertyName);
    }

    public ASMProperties getASMProperties(String asmCredFile) throws CredentialsException {
        return this.s_factoryImpl.getASMProperties(asmCredFile);
    }

    public GNSProperties getGNSProperties(String gnsCredFile) throws CredentialsException {
        return this.s_factoryImpl.getGNSProperties(gnsCredFile);
    }

    public GNSProperties getGNSPropertiesFromManifest(String manifestFile) throws CredentialsException, NotExistsException {
        return this.s_factoryImpl.getGNSPropertiesFromManifest(manifestFile);
    }

    public MGMTDBProperties getMGMTDBProperties() throws CredentialsException {
        return this.s_factoryImpl.getMGMTDBProperties();
    }

    public GIMRProperties getGIMRProperties() throws CredentialsException, NotExistsException {
        return this.s_factoryImpl.getGIMRProperties();
    }

    public GIMRProperties getGIMRProperties(String credFile) throws CredentialsException, NotExistsException {
        return this.s_factoryImpl.getGIMRProperties(credFile);
    }

    public GIMRProperties getGIMRProperties(String clientCluster, String credFile) throws CredentialsException, NotExistsException {
        return this.s_factoryImpl.getGIMRProperties(clientCluster, credFile);
    }

    public UserPassCredentials getGIMRComponentCredentials(GIMRComponent comp) throws CredentialsException, NotExistsException {
        return this.s_factoryImpl.getGIMRComponentCredentials(comp);
    }

    public UserPassCredentials getGIMRComponentCredentials(GIMRComponent comp, String clientCluster) throws CredentialsException, NotExistsException {
        return this.s_factoryImpl.getGIMRComponentCredentials(comp, clientCluster);
    }

    public UserPassCredentials getGIMRComponentCredFromClusterGUID(GIMRComponent comp, String clusterGUID) throws CredentialsException, NotExistsException {
        return this.s_factoryImpl.getGIMRComponentCredFromClusterGUID(comp, clusterGUID);
    }

    public int importWalletFromFile(String clientData, String target) throws CredentialsException {
        return this.s_factoryImpl.importWalletFromFile(clientData, target);
    }

    public int importWalletFromFile(String clientData, String target, String domain) throws CredentialsException {
        return this.s_factoryImpl.importWalletFromFile(clientData, target, domain);
    }

    public int importWalletFromFile(String clientData, String target, String domain, String owner, String pgroup) throws CredentialsException {
        return this.s_factoryImpl.importWalletFromFile(clientData, target, domain, owner, pgroup);
    }

    public void deleteWallet(String domain, int memberId) throws CredentialsException {
        this.s_factoryImpl.deleteWallet(domain, memberId);
    }

    public static char[] generateRandomPassword() throws CredentialsException {
        try {
            SecureRandom sr = SecureRandom.getInstance(PASSWD_ALGORITHM);
            char[] password = new char[16];
            char[][] chars = new char[3][];
            int x = 0;
            int i = 0;
            chars[0] = new char[52];
            for (i = 97; i <= 122; ++i) {
                chars[0][x++] = (char)i;
            }
            for (i = 65; i <= 90; ++i) {
                chars[0][x++] = (char)i;
            }
            x = 0;
            chars[1] = new char[10];
            for (i = 48; i <= 57; ++i) {
                chars[1][x++] = (char)i;
            }
            x = 0;
            chars[2] = new char[PUNCTUATION_CHARS.length];
            for (i = 0; i < PUNCTUATION_CHARS.length; ++i) {
                chars[2][x++] = PUNCTUATION_CHARS[i];
            }
            i = 0;
            while (i < 16) {
                x = sr.nextInt(chars.length);
                password[i++] = chars[x][sr.nextInt(chars[x].length)];
            }
            return password;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CredentialsException(nsae);
        }
    }

    public void storeUserpassCredentials(String username, String password, HashMap<String, String> attributes, String target, String domain, String owner) throws CredentialsException {
        this.s_factoryImpl.storeUserpassCredentials(username, password, attributes, target, domain, owner);
    }

    public void storeWalletCredentials(String walletPath, HashMap<String, String> attributes, String target, String domain, String owner) throws CredentialsException {
        this.s_factoryImpl.storeWalletCredentials(walletPath, attributes, target, domain, owner);
    }

    public void storeUserpassAndWalletCredentials(String username, String password, String walletPath, String walletPassword, HashMap<String, String> attributes, String target, String domain, String owner) throws CredentialsException {
        this.s_factoryImpl.storeUserpassAndWalletCredentials(username, password, walletPath, walletPassword, attributes, target, domain, owner);
    }

    public void deleteCredentials(String target, String domain) throws NotExistsException, CredentialsException {
        this.s_factoryImpl.deleteCredentials(target, domain);
    }

    public HashMap<String, String> getAttributes(String target, String domain, String[] attrNames) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getAttributes(target, domain, attrNames);
    }

    public String getUsername(String target, String domain) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getUsername(target, domain);
    }

    public CredDomain createDomain(String path) throws AlreadyExistsException, CredentialsException {
        return this.s_factoryImpl.createDomain(path, true);
    }

    public CredDomain createDomain(String path, boolean isOCR) throws AlreadyExistsException, CredentialsException {
        return this.s_factoryImpl.createDomain(path, isOCR);
    }

    public CredDomain createDomain(String path, String target) throws AlreadyExistsException, CredentialsException {
        return this.s_factoryImpl.createDomain(path, target, true);
    }

    public CredDomain createDomain(String path, String target, boolean isOCR) throws AlreadyExistsException, CredentialsException {
        return this.s_factoryImpl.createDomain(path, target, isOCR);
    }

    public CredDomain createDomain(String path, String target, Map<String, String> attrKeyValue) throws AlreadyExistsException, CredentialsException {
        return this.s_factoryImpl.createDomain(path, target, attrKeyValue, true);
    }

    public CredDomain createDomain(String path, String target, Map<String, String> attrKeyValue, boolean isOCR) throws AlreadyExistsException, CredentialsException {
        return this.s_factoryImpl.createDomain(path, target, attrKeyValue, isOCR);
    }

    public CredDomain createDomain(String path, Map<String, String> attrKeyValue) throws AlreadyExistsException, CredentialsException {
        return this.s_factoryImpl.createDomain(path, attrKeyValue, true);
    }

    public CredDomain createDomain(String path, Map<String, String> attrKeyValue, boolean isOCR) throws AlreadyExistsException, CredentialsException {
        return this.s_factoryImpl.createDomain(path, attrKeyValue, isOCR);
    }

    public CredDomain createDomain(String path, CredDomain baseDomain) throws AlreadyExistsException, CredentialsException {
        return this.s_factoryImpl.createDomain(path, baseDomain);
    }

    public CredDomain createDomain(String path, CredDomain baseDomain, Map<String, String> attrKeyValue) throws AlreadyExistsException, CredentialsException {
        return this.s_factoryImpl.createDomain(path, baseDomain, attrKeyValue);
    }

    public CredDomain getDomainByPath(String path) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getDomainByPath(path, true);
    }

    public CredDomain getDomainByPath(String path, CredDomain baseDomain) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getDomainByPath(path, baseDomain);
    }

    public CredDomain getDomainByPath(String path, CredDomain baseDomain, boolean skipPermErrs) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getDomainByPath(path, baseDomain, skipPermErrs);
    }

    public CredFileDomain getDomainByPath(String path, String credFile) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getDomainByPath(path, credFile);
    }

    public CredFileDomain getDomainByPath(String path, String credFile, String section) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getDomainByPath(path, credFile, section);
    }

    public CredFileDomain getDomainByPath(String path, CredFileDomain baseDomain) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getDomainByPath(path, baseDomain);
    }

    public CredDomain getDomainByPath(String path, boolean isOCR) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getDomainByPath(path, isOCR);
    }

    public CredDomain getDomainByPath(String path, boolean skipPermErrs, boolean isOCR) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getDomainByPath(path, skipPermErrs, isOCR);
    }

    public CredDomain getDomainByTarget(String target, CredDomain baseDomain) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getDomainByTarget(target, baseDomain);
    }

    public CredDomain getDomainByTarget(String target) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getDomainByTarget(target, true);
    }

    public CredDomain getDomainByTarget(String target, boolean isOCR) throws NotExistsException, CredentialsException {
        return this.s_factoryImpl.getDomainByTarget(target, isOCR);
    }

    public static String formatOwnerACLString(String user, CredentialsACLPerm ... aclPerms) throws CredentialsException {
        return CredentialsFactoryImpl.formatOwnerACLString(user, aclPerms);
    }

    public static String formatGroupACLString(String group, CredentialsACLPerm ... aclPerms) throws CredentialsException {
        return CredentialsFactoryImpl.formatGroupACLString(group, aclPerms);
    }

    public static String formatOtherACLString(CredentialsACLPerm ... aclPerms) throws CredentialsException {
        return CredentialsFactoryImpl.formatOtherACLString(aclPerms);
    }

    public List<ClientClusterComponent> getClusterServices(String credFile) throws CredentialsException {
        return this.s_factoryImpl.getClusterServices(credFile);
    }

    static {
        PUNCTUATION_CHARS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', '-', '.', '/', ';', '<', '=', '>', '@', '[', ']', '^', '_', '`', '{', '|', '}', '~'};
    }
}

