/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.credentials;

import oracle.cluster.credentials.CredentialsException;
import oracle.ops.mgmt.trace.Trace;

public interface ASMProperties {
    public static final String ASM_ATTRIBUTES = "ASM_attributes";

    public String getASMClusterName() throws CredentialsException;

    public String getClientClusterNames() throws CredentialsException;

    public String getClusterGUID() throws CredentialsException;

    public String getASMClusterGUID() throws CredentialsException;

    public static enum ASMPropName {
        CLIENT_CLUSTER_VERSION("CLIENT_CLUSTER_VERSION"),
        CLUSTER_GUID("CLUSTER_GUID"),
        ASM_DISCOVERY_ADDRESS("ASM_DISCOVERY_ADDRESS"),
        CLUSTER_NAMES("CLUSTER_NAMES"),
        ASM_CLUSTER_GUID("ASM_CLUSTER_GUID"),
        ASM_CLUSTER_NAME("ASM_CLUSTER_NAME"),
        ASM_ACCESS_MODE("ASM_ACCESS_MODE"),
        VERSION("VERSION");

        private String m_propname;

        private ASMPropName(String propname) {
            this.m_propname = propname;
        }

        private ASMPropName() {
            this.m_propname = null;
        }

        public String toString() {
            return this.m_propname;
        }

        public static ASMPropName getEnumMember(String value) throws EnumConstantNotPresentException {
            for (ASMPropName v : ASMPropName.values()) {
                if (!v.toString().equals(value)) continue;
                return v;
            }
            Trace.out("Invalid ASM Property name [" + value + "]");
            throw new EnumConstantNotPresentException(ASMPropName.class, value);
        }
    }
}

