/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.common;

import java.lang.reflect.Method;
import java.util.List;
import oracle.cluster.common.InnerInterruptHandler;
import oracle.cluster.common.InterruptHandlerException;
import oracle.cluster.resources.PrCgMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class InterruptHandler {
    private static InnerInterruptHandler m_inner = null;
    private static MessageBundle m_msgBndl;

    public void registerInterruptHandler(Method method, List<Object> args) throws InterruptHandlerException {
        m_msgBndl = MessageBundle.getMessageBundle(PrCgMsgID.facility);
        m_msgBndl.setPackage("oracle.cluster.resources");
        if (m_inner == null) {
            m_inner = new InnerInterruptHandler();
            Trace.out("Registering shutdown hook.....");
            Runtime.getRuntime().addShutdownHook(m_inner);
            Trace.out("Registered shutdown hook.....");
        }
        if (method != null) {
            m_inner.addInterruptHandler(method, args);
        }
    }

    public void unRegisterInterruptHandler() throws InterruptHandlerException {
        try {
            Trace.out("UNRegistering shutdown hook.....");
            if (m_inner != null) {
                Runtime.getRuntime().removeShutdownHook(m_inner);
            }
            Trace.out("UnRegistered shutdown hook.....");
        }
        catch (IllegalStateException e) {
            Trace.out("Illegal state exceptoin...");
            throw new InterruptHandlerException(m_msgBndl.getMessage(PrCgMsgID.INTERNAL_ERROR, true));
        }
    }
}

