/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.SQLPLUSUtil;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.MoveDatabaseOptionalArgs;
import oracle.cluster.database.OracleGroupsEnum;
import oracle.cluster.database.ServiceStopArgs;
import oracle.cluster.database.StopOptions;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.remote.ExecCommandNoUserEq;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.RemoteArgs;
import oracle.cluster.remote.RemoteFactory;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.remote.SecureFileTransfer;
import oracle.cluster.remote.SecureFileTransferException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class RHPHELPERUtil {
    private CmdToolUtil m_cmdtool = null;
    private String m_home = null;
    private Version m_homeVer = null;
    private RemoteUserInfo m_uInfo = null;
    private String m_asUser = null;
    private String m_rhpScriptDst = null;
    private String m_rhpJarDst = null;
    private String m_rhpPerlDst = null;
    private String m_rhpPerlModDst = null;
    private boolean m_performCopy = true;
    private boolean m_rhpBoot = false;
    private static final String RHPHELPERUTL = "rhphelper";
    private static final String RHPDATA_DIR = "/crs/install/rhpdata/";
    private static final String HELPER_DIR = "/crs/install/rhpdata//helper/";
    private static final String ADMIN_DIR = "/srvm/admin/";
    private static final String RHPHELPER_JAR_DIR = "/jlib/";
    private static final String RHPHELPER112_JAR = "rhphelper112.jar";
    private static final String RHPHELPER12102_JAR = "rhphelper12102.jar";
    private static final String RHPHELPER122_JAR = "rhphelper122.jar";
    private static final String RHPPROV121_PERL_SCRIPT = "rhpmovegi.pl";
    private static final String RHPPROV122_PERL_SCRIPT = "rhpmovegi.pl";
    private static final String RHPPROV_PERL_MOD = "crscpcfg.pm";
    private static final String RHPPROV112_PERL_SCRIPT = "rhpmovegi112.pl";
    private static final String INSTALL_DIR = "/crs/install/";
    private static final String RHPMOVDB_PERL_SCRIPT = "rhpmovedb.pl";
    public static final String LSEP = System.getProperty("line.separator");

    public RHPHELPERUtil(String oHome, RemoteUserInfo uInfo, String owner) throws InvalidArgsException, CmdToolUtilException {
        this(oHome, uInfo, owner, true);
    }

    public RHPHELPERUtil(String oHome, RemoteUserInfo uInfo, String owner, boolean performCopy) throws InvalidArgsException, CmdToolUtilException {
        this(oHome, uInfo, owner, performCopy, false);
    }

    public RHPHELPERUtil(String oHome, RemoteUserInfo uInfo, String owner, boolean performCopy, boolean isRhpBoot) throws InvalidArgsException, CmdToolUtilException {
        this(oHome, uInfo, owner, performCopy, isRhpBoot, null);
    }

    public RHPHELPERUtil(String oHome, RemoteUserInfo uInfo, String owner, boolean performCopy, boolean isRhpBoot, Version imver) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(oHome, "RHPHELPERUtil-constr-oHome");
        Utils.assertInputNotNull(uInfo, "RHPHELPERUtil-constr-uInfo");
        Utils.assertInput(owner, "RHPHELPERUtil-constr-owner");
        this.m_homeVer = imver;
        this.m_home = oHome;
        this.m_uInfo = uInfo;
        this.m_asUser = owner;
        this.m_performCopy = performCopy;
        this.m_rhpBoot = isRhpBoot;
    }

    public static void copyScriptAndJars(String home, boolean isGIMove) throws CmdToolUtilException {
        RHPHELPERUtil.internalCopyScriptAndJars(home, isGIMove, null);
    }

    public static void copyScriptAndJars(String home, boolean isGIMove, Version homeVer) throws CmdToolUtilException {
        RHPHELPERUtil.internalCopyScriptAndJars(home, isGIMove, homeVer);
    }

    private static Version internalCopyScriptAndJars(String home, boolean isGIMove, Version homeVer) throws CmdToolUtilException {
        try {
            if (homeVer == null) {
                SQLPLUSUtil sqlplusUtl = new SQLPLUSUtil(home);
                homeVer = sqlplusUtl.getSQLPLUSVersion();
                Trace.out((Object)"home exists and version is %s", homeVer.toString());
            } else {
                Trace.out((Object)"version is specified: %s", homeVer.toString());
            }
            String giHome = new Util().getCRSHome();
            Trace.out((Object)"GI home is %s", giHome);
            String rhpDataDir = home + RHPDATA_DIR;
            String destDir = home + HELPER_DIR;
            String rhpScriptSrc = giHome + ADMIN_DIR + RHPHELPERUTL;
            String rhpScriptDst = destDir + RHPHELPERUTL;
            String rhpJarSrc = null;
            String rhpJarDst = null;
            if (Version.isPre12c(homeVer)) {
                rhpJarSrc = giHome + RHPHELPER_JAR_DIR + RHPHELPER112_JAR;
                rhpJarDst = destDir + RHPHELPER112_JAR;
            } else if (Version.isPre122(homeVer)) {
                rhpJarSrc = giHome + RHPHELPER_JAR_DIR + RHPHELPER12102_JAR;
                rhpJarDst = destDir + RHPHELPER12102_JAR;
            } else {
                rhpJarSrc = giHome + RHPHELPER_JAR_DIR + RHPHELPER122_JAR;
                rhpJarDst = destDir + RHPHELPER122_JAR;
            }
            String localHost = new Util().getLocalHostName();
            String[] nodes = new String[]{localHost};
            ClusterCmd clusterCmd = new ClusterCmd();
            if (!clusterCmd.dirExists(localHost, rhpDataDir)) {
                clusterCmd.createDirWithPermissionsOnNodes(nodes, rhpDataDir, "755");
                clusterCmd.createDirWithPermissionsOnNodes(nodes, destDir, "755");
            } else if (!clusterCmd.dirExists(localHost, destDir)) {
                clusterCmd.createDirWithPermissionsOnNodes(nodes, destDir, "755");
            }
            if (isGIMove) {
                String rhpPerlSrc = null;
                String rhpPerlDst = null;
                String rhpPerlModSrc = giHome + INSTALL_DIR + RHPPROV_PERL_MOD;
                String rhpPerlModDst = rhpDataDir + RHPPROV_PERL_MOD;
                if (Version.isPre12c(homeVer)) {
                    rhpPerlSrc = giHome + ADMIN_DIR + RHPPROV112_PERL_SCRIPT;
                    rhpPerlDst = rhpDataDir + RHPPROV112_PERL_SCRIPT;
                } else if (Version.isPre122(homeVer)) {
                    rhpPerlSrc = giHome + ADMIN_DIR + "rhpmovegi.pl";
                    rhpPerlDst = rhpDataDir + "rhpmovegi.pl";
                } else {
                    rhpPerlSrc = giHome + ADMIN_DIR + "rhpmovegi.pl";
                    rhpPerlDst = rhpDataDir + "rhpmovegi.pl";
                }
                Trace.out("Copying %s to %s on node %s", rhpPerlSrc, rhpPerlDst, localHost);
                clusterCmd.copyFileToNode(rhpPerlSrc, localHost, rhpPerlDst, false);
                Trace.out("Copying %s to %s on node %s", rhpPerlModSrc, rhpPerlModDst, localHost);
                clusterCmd.copyFileToNode(rhpPerlModSrc, localHost, rhpPerlModDst, false);
            }
            Trace.out("Copying %s to %s on node %s", rhpScriptSrc, rhpScriptDst, localHost);
            clusterCmd.copyFileToNode(rhpScriptSrc, localHost, rhpScriptDst, false);
            Trace.out("Copying %s to %s on node %s", rhpJarSrc, rhpJarDst, localHost);
            clusterCmd.copyFileToNode(rhpJarSrc, localHost, rhpJarDst, false);
            return homeVer;
        }
        catch (ClusterException | UtilException e) {
            Trace.out((Exception)e);
            throw new CmdToolUtilException(e);
        }
    }

    private void copyRHPHelperFiles(String node) throws CmdToolUtilException {
        this.internalcopyRHPHelperFiles(node, false);
    }

    private void copyRHPHelperFiles(String node, boolean isGIMove) throws CmdToolUtilException {
        this.internalcopyRHPHelperFiles(node, isGIMove);
    }

    private void internalCopyDBFiles(String node, String sfile, String dfile, boolean isRoll) throws CmdToolUtilException {
        try {
            String tmpPath = "/tmp/";
            String giHome = new Util().getCRSHome();
            String rhpDataDir = this.m_home + RHPDATA_DIR;
            String rhpPerlSrc = giHome + ADMIN_DIR + RHPMOVDB_PERL_SCRIPT;
            this.m_rhpPerlDst = rhpDataDir + RHPMOVDB_PERL_SCRIPT;
            Trace.out("Performing remote copy ...");
            RemoteFactory rf = RemoteFactory.getInstance();
            ExecCommandNoUserEq execCmd = rf.getExecCommandNoUserEq(new RemoteArgs(this.m_uInfo));
            if (!rf.isDirExists(rhpDataDir, node, new RemoteArgs(this.m_uInfo))) {
                rf.createDirOnNodes(new String[]{node}, rhpDataDir, this.m_asUser, this.m_uInfo, 755);
            } else {
                Trace.out("Executing chown in case directory is not owned by asUser");
                execCmd.runCmd("/usr/bin/chown", new String[]{"-R", this.m_asUser, rhpDataDir}, new String[]{node}, 120);
            }
            if (isRoll) {
                rf.copyFileToNodes(sfile, new String[]{node}, tmpPath, false, this.m_uInfo, 120);
                rf.copyFileToNodes(dfile, new String[]{node}, tmpPath, false, this.m_uInfo, 120);
            }
            if (this.m_uInfo.getMode() == ConfigurationSetup.ConfigMethod.SUDO && !this.m_uInfo.getUsername().equals(this.m_asUser)) {
                ArrayList<String> copiedFiles = new ArrayList<String>();
                String copiedFile = tmpPath + Utils.getFileNameFromPath(rhpPerlSrc);
                Trace.out("Copying %s to %s on node %s", rhpPerlSrc, tmpPath, node);
                rf.copyFileToNodes(rhpPerlSrc, new String[]{node}, tmpPath, false, this.m_uInfo, 120);
                copiedFiles.add(tmpPath + Utils.getFileNameFromPath(rhpPerlSrc));
                Trace.out("Chowning the files in temp path to " + this.m_asUser);
                ArrayList<String> chownCmdArgs = new ArrayList<String>();
                chownCmdArgs.add(this.m_asUser);
                chownCmdArgs.add(copiedFile);
                execCmd.runCmd("/usr/bin/chown", Utils.convertListToStringArray(chownCmdArgs), new String[]{node}, 120);
                Trace.out((Object)"Copying the files from temp path to final destination %s", rhpDataDir);
                ExecCommandNoUserEq execCmdAsUser = rf.getExecCommandNoUserEq(this.m_uInfo, this.m_asUser);
                execCmdAsUser.runCmd("/usr/bin/mv -f", new String[]{(String)copiedFiles.get(0), rhpDataDir}, new String[]{node}, 120);
            } else {
                Trace.out("Copying %s to %s on node %s", rhpPerlSrc, rhpDataDir, node);
                rf.copyFileToNodes(rhpPerlSrc, new String[]{node}, rhpDataDir, false, this.m_uInfo, 120);
                execCmd.runCmd("/usr/bin/chown", new String[]{"-R", this.m_asUser, rhpDataDir}, new String[]{node}, 120);
            }
        }
        catch (InvalidArgsException | ExecException | CompositeOperationException | UtilException e) {
            Trace.out((Exception)e);
            throw new CmdToolUtilException(e);
        }
    }

    private void internalcopyRHPHelperFiles(String node, boolean isGIMove) throws CmdToolUtilException {
        SecureFileTransfer sftp = null;
        try {
            if (this.m_rhpBoot && this.m_homeVer == null) {
                this.m_homeVer = new Version();
            } else if (this.m_homeVer == null) {
                SQLPLUSUtil sqlplusUtl = new SQLPLUSUtil(this.m_home, this.m_uInfo);
                this.m_homeVer = sqlplusUtl.getSQLPLUSVersion(node);
                Trace.out((Object)"home exists and version is %s", this.m_homeVer.toString());
            }
            String toolLoc = this.m_home + HELPER_DIR;
            this.m_cmdtool = new CmdToolUtil(this.m_uInfo, RHPHELPERUTL, toolLoc);
            String giHome = new Util().getCRSHome();
            Trace.out((Object)"GI home is %s", giHome);
            String rhpPerlSrc = null;
            String rhpPerlModSrc = null;
            String rhpDataDir = this.m_home + RHPDATA_DIR;
            String destDir = this.m_home + HELPER_DIR;
            String rhpScriptSrc = giHome + ADMIN_DIR + RHPHELPERUTL;
            this.m_rhpScriptDst = destDir + RHPHELPERUTL;
            String rhpJarSrc = null;
            if (Version.isPre12c(this.m_homeVer)) {
                rhpJarSrc = giHome + RHPHELPER_JAR_DIR + RHPHELPER112_JAR;
                this.m_rhpJarDst = destDir + RHPHELPER112_JAR;
            } else if (Version.isPre122(this.m_homeVer)) {
                rhpJarSrc = giHome + RHPHELPER_JAR_DIR + RHPHELPER12102_JAR;
                this.m_rhpJarDst = destDir + RHPHELPER12102_JAR;
            } else {
                rhpJarSrc = giHome + RHPHELPER_JAR_DIR + RHPHELPER122_JAR;
                this.m_rhpJarDst = destDir + RHPHELPER122_JAR;
            }
            if (isGIMove) {
                if (Version.isPre12c(this.m_homeVer)) {
                    rhpPerlSrc = giHome + ADMIN_DIR + RHPPROV112_PERL_SCRIPT;
                    this.m_rhpPerlDst = rhpDataDir + RHPPROV112_PERL_SCRIPT;
                } else if (Version.isPre122(this.m_homeVer)) {
                    rhpPerlSrc = giHome + ADMIN_DIR + "rhpmovegi.pl";
                    this.m_rhpPerlDst = rhpDataDir + "rhpmovegi.pl";
                } else {
                    rhpPerlSrc = giHome + ADMIN_DIR + "rhpmovegi.pl";
                    this.m_rhpPerlDst = rhpDataDir + "rhpmovegi.pl";
                }
                rhpPerlModSrc = giHome + INSTALL_DIR + RHPPROV_PERL_MOD;
                this.m_rhpPerlModDst = rhpDataDir + RHPPROV_PERL_MOD;
            }
            if (this.m_performCopy) {
                Trace.out("Performing remote copy ...");
                RemoteFactory rf = RemoteFactory.getInstance();
                ExecCommandNoUserEq execCmd = rf.getExecCommandNoUserEq(new RemoteArgs(this.m_uInfo));
                sftp = rf.getSecureFileTransfer(node, this.m_uInfo);
                if (!rf.isDirExists(rhpDataDir, node, new RemoteArgs(this.m_uInfo))) {
                    rf.createDirOnNodes(new String[]{node}, rhpDataDir, this.m_asUser, this.m_uInfo, 755);
                    rf.createDirOnNodes(new String[]{node}, destDir, this.m_asUser, this.m_uInfo, 755);
                } else {
                    Trace.out("Executing chown in case directory is not owned by asUser");
                    execCmd.runCmd("/usr/bin/chown", new String[]{"-R", this.m_asUser, rhpDataDir}, new String[]{node}, 120);
                }
                if (!rf.isDirExists(destDir, node, new RemoteArgs(this.m_uInfo))) {
                    rf.createDirOnNodes(new String[]{node}, destDir, this.m_asUser, this.m_uInfo, 755);
                }
                if (this.m_uInfo.getMode() == ConfigurationSetup.ConfigMethod.SUDO && !this.m_uInfo.getUsername().equals(this.m_asUser)) {
                    String tmpPath = "/tmp/";
                    ArrayList<String> copiedFiles = new ArrayList<String>();
                    Trace.out("Copying %s to %s on node %s", rhpScriptSrc, tmpPath, node);
                    sftp.put(rhpScriptSrc, tmpPath);
                    sftp.chmod(493, tmpPath + Utils.getFileNameFromPath(rhpScriptSrc));
                    copiedFiles.add(tmpPath + Utils.getFileNameFromPath(rhpScriptSrc));
                    Trace.out("Copying %s to %s on node %s", rhpJarSrc, tmpPath, node);
                    sftp.put(rhpJarSrc, tmpPath);
                    sftp.chmod(493, tmpPath + Utils.getFileNameFromPath(rhpJarSrc));
                    copiedFiles.add(tmpPath + Utils.getFileNameFromPath(rhpJarSrc));
                    if (isGIMove) {
                        Trace.out("Copying %s to %s on node %s", rhpPerlSrc, tmpPath, node);
                        sftp.put(rhpPerlSrc, tmpPath);
                        sftp.chmod(493, tmpPath + Utils.getFileNameFromPath(rhpPerlSrc));
                        copiedFiles.add(tmpPath + Utils.getFileNameFromPath(rhpPerlSrc));
                        Trace.out("Copying %s to %s on node %s", rhpPerlModSrc, tmpPath, node);
                        sftp.put(rhpPerlModSrc, tmpPath);
                        sftp.chmod(493, tmpPath + Utils.getFileNameFromPath(rhpPerlModSrc));
                        copiedFiles.add(tmpPath + Utils.getFileNameFromPath(rhpPerlModSrc));
                    }
                    Trace.out("Chowning the files in temp path to " + this.m_asUser);
                    ArrayList<String> chownCmdArgs = new ArrayList<String>();
                    chownCmdArgs.add(this.m_asUser);
                    for (String copiedFile : copiedFiles) {
                        chownCmdArgs.add(copiedFile);
                    }
                    execCmd.runCmd("/usr/bin/chown", Utils.convertListToStringArray(chownCmdArgs), new String[]{node}, 120);
                    Trace.out("Copying the files from tmp path to final destination");
                    ExecCommandNoUserEq execCmdAsUser = rf.getExecCommandNoUserEq(this.m_uInfo, this.m_asUser);
                    execCmdAsUser.runCmd("/usr/bin/mv -f", new String[]{(String)copiedFiles.get(0), destDir}, new String[]{node}, 120);
                    execCmdAsUser.runCmd("/usr/bin/mv -f", new String[]{(String)copiedFiles.get(1), destDir}, new String[]{node}, 120);
                    if (isGIMove) {
                        execCmdAsUser.runCmd("/usr/bin/mv -f", new String[]{(String)copiedFiles.get(2), rhpDataDir}, new String[]{node}, 120);
                        execCmdAsUser.runCmd("/usr/bin/mv -f", new String[]{(String)copiedFiles.get(3), rhpDataDir}, new String[]{node}, 120);
                    }
                } else {
                    Trace.out("Copying %s to %s on node %s", rhpScriptSrc, destDir, node);
                    sftp.put(rhpScriptSrc, destDir);
                    sftp.chmod(493, destDir + File.separator + Utils.getFileNameFromPath(rhpScriptSrc));
                    Trace.out("Copying %s to %s on node %s", rhpJarSrc, destDir, node);
                    sftp.put(rhpJarSrc, destDir);
                    sftp.chmod(493, destDir + File.separator + Utils.getFileNameFromPath(rhpJarSrc));
                    if (isGIMove) {
                        Trace.out("Copying %s to %s on node %s", rhpPerlSrc, destDir, node);
                        sftp.put(rhpPerlSrc, rhpDataDir);
                        sftp.chmod(493, rhpDataDir + File.separator + Utils.getFileNameFromPath(rhpPerlSrc));
                        Trace.out("Copying %s to %s on node %s", rhpPerlModSrc, destDir, node);
                        sftp.put(rhpPerlModSrc, rhpDataDir);
                        sftp.chmod(493, rhpDataDir + File.separator + Utils.getFileNameFromPath(rhpPerlModSrc));
                    }
                    execCmd.runCmd("/bin/chown", new String[]{"-R", this.m_asUser, destDir}, new String[]{node}, 120);
                }
            }
        }
        catch (CompositeOperationException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        catch (ExecException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        catch (UtilException e) {
            Trace.out((Exception)((Object)e));
            throw new CmdToolUtilException(e);
        }
        catch (SecureFileTransferException e) {
            Trace.out("SecureFileTransferException: " + e);
            throw new CmdToolUtilException(e);
        }
        finally {
            Trace.out("Clean up sftp");
            if (sftp != null && sftp.isConnected()) {
                sftp.disconnect();
            }
        }
    }

    private void deleteRHPHelperFiles(String node) throws CmdToolUtilException {
        try {
            if (!this.m_performCopy) {
                Trace.out("Delete does not need to be performed");
                return;
            }
            if (this.m_homeVer == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "RHPHELPERUtil-rmFiles-error01");
            }
            String destDir = this.m_home + HELPER_DIR;
            RemoteFactory rf = RemoteFactory.getInstance();
            ExecCommandNoUserEq execCmd = rf.getExecCommandNoUserEq(new RemoteArgs(this.m_uInfo));
            execCmd.runCmd("/usr/bin/rm -f", new String[]{destDir + "/rhphelper*"}, new String[]{node}, 120);
        }
        catch (InvalidArgsException | ExecException | CompositeOperationException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
    }

    public String getInventoryLoc(String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(node, "RHPHELPERUtil-getInventoryLoc-node");
        Trace.out("Retrieving oracle inventory for node : " + node);
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getInventory"};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, null, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = this.getOutput(result);
        Trace.out("Processed output : " + resultMsg);
        return resultMsg;
    }

    public String[] getOracleHomes(String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(node, "RHPHELPERUtil-getOracleHomes-node");
        Trace.out("Retrieving oracle inventory contents for node : " + node);
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getOracleHomes"};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, null, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = this.getOutput(result);
        Trace.out("Processed output : " + resultMsg);
        if (resultMsg != null) {
            return resultMsg.trim().split(",");
        }
        return null;
    }

    public String getOracleHomeOwner(String oracleHome, String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(oracleHome, "RHPHELPERUtil-getHomeUser-oHome");
        Utils.assertInput(node, "RHPHELPERUtil-getHomeUser-node");
        Trace.out((Object)"Retrieving owner of %s ...", oracleHome);
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getOracleUser", oracleHome};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, null, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = this.getOutput(result);
        Trace.out("Processed output : " + resultMsg);
        return resultMsg;
    }

    public boolean isSharedPath(String path, String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(path, "RHPHELPERUtil-isShared-path");
        Utils.assertInput(node, "RHPHELPERUtil-isShared-node");
        Trace.out((Object)"Checking if %s is shared ...", path);
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "isSharedPath", "null", path};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = this.getOutput(result);
        Trace.out("Processed output : " + resultMsg);
        return Boolean.valueOf(resultMsg);
    }

    public void copyDBs(String srcHome, String destHome, String dbName, String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(srcHome, "RHPHELPERUtil-copyDBs-srcHome");
        Utils.assertInput(destHome, "RHPHELPERUtil-copyDBs-destHome");
        Utils.assertInput(dbName, "RHPHELPERUtil-copyDBs-dbName");
        Utils.assertInput(node, "RHPHELPERUtil-copyDBs-node");
        Trace.out("Copying dbs files from %s to %s ...", srcHome, destHome);
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-copydbs", srcHome, destHome, dbName};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void copyDBs(String srcHome, String destHome, String dbName, List<String> nodes) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(srcHome, "RHPHELPERUtil-copyDBs2-srcHome");
        Utils.assertInput(destHome, "RHPHELPERUtil-copyDBs2-destHome");
        Utils.assertInput(dbName, "RHPHELPERUtil-copyDBs2-dbName");
        Utils.assertInputNotNull(nodes, "RHPHELPERUtil-copyDBs2-nodes");
        Trace.out("Copying dbs files from %s to %s ...", srcHome, destHome);
        if (this.m_homeVer == null) {
            SQLPLUSUtil sqlplusUtl = new SQLPLUSUtil(this.m_home, this.m_uInfo);
            this.m_homeVer = sqlplusUtl.getSQLPLUSVersion(nodes.get(0));
        }
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-copydbs", srcHome, destHome, dbName};
        String[] env = this.getTraceEnvs();
        for (String node : nodes) {
            this.copyRHPHelperFiles(node);
            CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
            this.isSuccess(result, node);
            this.deleteRHPHelperFiles(node);
        }
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void copyDBs(String srcHome, String destHome, String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(srcHome, "RHPHELPERUtil-copyDBs3-srcHome");
        Utils.assertInput(destHome, "RHPHELPERUtil-copyDBs3-destHome");
        Utils.assertInput(node, "RHPHELPERUtil-copyDBs3-node");
        Trace.out("Copying dbs files from %s to %s ...", srcHome, destHome);
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-copydbs", srcHome, destHome};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void transfer(String srcPath, String[] nodeList, String[] destPath, String excludeListFile, String node) throws InvalidArgsException, CmdToolUtilException {
        String oracleHome = this.m_home;
        Utils.assertInputNotNull(nodeList, "RHPHELPERUtil-transfer-nodeList");
        Utils.assertInput(srcPath, "RHPHELPERUtil-transfer-srcPath");
        Utils.assertInputNotNull(destPath, "RHPHELPERUtil-transfer-destPath");
        Utils.assertInput(excludeListFile, "RHPHELPERUtil-transfer-excludeListFile");
        Utils.assertInput(node, "RHPHELPERUtil-transfer-node");
        Trace.out("Performing transfer of directory from " + srcPath);
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-transfer", oracleHome, Utils.strArrToList(nodeList), srcPath, Utils.strArrToList(destPath), excludeListFile};
        String[] env = this.getTraceEnvs();
        env = Arrays.copyOf(env, env.length + 1);
        env[env.length - 1] = "ORACLE_HOME=" + oracleHome;
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void transfer(String srcPath, String[] nodeList, String[] destPath, String node) throws InvalidArgsException, CmdToolUtilException {
        this.transfer(srcPath, nodeList, destPath, node, 36000);
    }

    public void transfer(String srcPath, String[] nodeList, String[] destPath, String node, int timeout) throws InvalidArgsException, CmdToolUtilException {
        String oracleHome = this.m_home;
        Utils.assertInputNotNull(nodeList, "RHPHELPERUtil-transfer-nodeList");
        Utils.assertInput(srcPath, "RHPHELPERUtil-transfer-srcPath");
        Utils.assertInputNotNull(destPath, "RHPHELPERUtil-transfer-destPath");
        Utils.assertInput(node, "RHPHELPERUtil-transfer-node");
        Trace.out("Performing transfer of directory from " + srcPath);
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-transfer", this.m_home, Utils.strArrToList(nodeList), srcPath, Utils.strArrToList(destPath)};
        String[] env = this.getTraceEnvs();
        env = Arrays.copyOf(env, env.length + 1);
        env[env.length - 1] = "ORACLE_HOME=" + oracleHome;
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true, timeout);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void mergeListeners(String srcHome, String destHome, String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(srcHome, "RHPHELPERUtil-mergeLsnr-srcHome");
        Utils.assertInput(destHome, "RHPHELPERUtil-mergeLsnr-destHome");
        Utils.assertInput(node, "RHPHELPERUtil-mergeLsnr-node");
        Trace.out("Merging lsnr files in %s and %s ...", srcHome, destHome);
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-mergeListenerOra", srcHome, destHome};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void mergeListeners(String srcHome, String destHome, List<String> nodes) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(srcHome, "RHPHELPERUtil-mergeLsnr2-srcHome");
        Utils.assertInput(destHome, "RHPHELPERUtil-mergeLsnr2-destHome");
        Utils.assertInputNotNull(nodes, "RHPHELPERUtil-mergeLsnr2-nodes");
        Trace.out("Merging lsnr files in %s and %s ...", srcHome, destHome);
        if (this.m_homeVer == null) {
            SQLPLUSUtil sqlplusUtl = new SQLPLUSUtil(this.m_home, this.m_uInfo);
            this.m_homeVer = sqlplusUtl.getSQLPLUSVersion(nodes.get(0));
        }
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-mergeListenerOra", srcHome, destHome};
        String[] env = this.getTraceEnvs();
        for (String node : nodes) {
            this.copyRHPHelperFiles(node);
            CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
            this.isSuccess(result, node);
            this.deleteRHPHelperFiles(node);
        }
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void mergeSqlNet(String srcHome, String destHome, String node) throws InvalidArgsException, CmdToolUtilException {
        ArrayList<String> nList = new ArrayList<String>(1);
        nList.add(node);
        this.mergeSqlNet(srcHome, destHome, nList);
    }

    public void mergeSqlNet(String srcHome, String destHome, List<String> nodes) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(srcHome, "RHPHELPERUtil-mergeSqlNet-srcHome");
        Utils.assertInput(destHome, "RHPHELPERUtil-mergeSqlNet-destHome");
        Utils.assertInputNotNull(nodes, "RHPHELPERUtil-mergeSqlNet-nodes");
        Trace.out("Merging sqlnet files in %s and %s ...", srcHome, destHome);
        if (this.m_homeVer == null) {
            SQLPLUSUtil sqlplusUtl = new SQLPLUSUtil(this.m_home, this.m_uInfo);
            this.m_homeVer = sqlplusUtl.getSQLPLUSVersion(nodes.get(0));
        }
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-mergeSqlNetOra", srcHome, destHome};
        String[] env = this.getTraceEnvs();
        for (String node : nodes) {
            this.copyRHPHelperFiles(node);
            CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
            this.isSuccess(result, node);
            this.deleteRHPHelperFiles(node);
        }
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void mergeTNSNames(String srcHome, String destHome, String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(srcHome, "RHPHELPERUtil-mergeTNS-srcHome");
        Utils.assertInput(destHome, "RHPHELPERUtil-mergeTNS-destHome");
        Utils.assertInput(node, "RHPHELPERUtil-mergeTNS-node");
        Trace.out("Merging tns files in %s and %s ...", srcHome, destHome);
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-mergeTNSNames", srcHome, destHome};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void mergeTNSNames(String srcHome, String destHome, List<String> nodes) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(srcHome, "RHPHELPERUtil-mergeTNS2-srcHome");
        Utils.assertInput(destHome, "RHPHELPERUtil-mergeTNS2-destHome");
        Utils.assertInputNotNull(nodes, "RHPHELPERUtil-mergeTNS2-nodes");
        Trace.out("Merging tns files in %s and %s ...", srcHome, destHome);
        if (this.m_homeVer == null) {
            SQLPLUSUtil sqlplusUtl = new SQLPLUSUtil(this.m_home, this.m_uInfo);
            this.m_homeVer = sqlplusUtl.getSQLPLUSVersion(nodes.get(0));
        }
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-mergeTNSNames", srcHome, destHome};
        String[] env = this.getTraceEnvs();
        for (String node : nodes) {
            this.copyRHPHelperFiles(node);
            CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
            this.isSuccess(result, node);
            this.deleteRHPHelperFiles(node);
        }
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void moveDatabase(List<String> dbNames, String destHome, MoveDatabaseOptionalArgs mvDBargs, String node) throws InvalidArgsException, CmdToolUtilException {
        boolean isNonrolling;
        Utils.assertInputNotNull(dbNames, "RHPHELPERUtil-moveDB-dbNames");
        Utils.assertInputNotNull(mvDBargs, "RHPHELPERUtil-moveDB-mvDbargs");
        Utils.assertInput(node, "RHPHELPERUtil-moveDB-node");
        Trace.out((Object)"Moving databases %s ...", dbNames.toString());
        this.copyRHPHelperFiles(node);
        StopOptions stopOpt = mvDBargs.getStopOption();
        Boolean isDisconnect = mvDBargs.getDisconnectOption();
        Boolean isNoreplay = mvDBargs.getNoreplayOption();
        boolean bl = isNonrolling = mvDBargs.getNonrollingOption() != null && mvDBargs.getNonrollingOption() != false;
        if (isDisconnect != null && Version.isPre112(this.m_homeVer)) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "RHPHELPERUtil-moveDB-err1");
        }
        if (isNoreplay != null && Version.isPre12c(this.m_homeVer)) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "RHPHELPERUtil-moveDB-err2");
        }
        ProgressListener plsnr = mvDBargs.getProgressListener();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_home);
        args.add(this.m_homeVer.toString());
        args.add("-moveDatabase");
        args.add(Utils.strListToList2(dbNames));
        args.add(destHome != null ? destHome : "NOT_SPECIFIED");
        if (plsnr != null) {
            String plsnrArg = plsnr.getListenerHost() + ":" + Integer.toString(plsnr.getListenerPort());
            args.add(plsnrArg);
        } else {
            args.add("NOT_SPECIFIED");
        }
        args.add(isNonrolling ? "NOT_SPECIFIED" : node);
        args.add(stopOpt == null ? "NOT_SPECIFIED" : stopOpt.toString());
        args.add(isDisconnect == null ? "NOT_SPECIFIED" : Boolean.toString(isDisconnect));
        args.add(isNoreplay == null ? "NOT_SPECIFIED" : Boolean.toString(isNoreplay));
        String[] argsArr = args.toArray(new String[args.size()]);
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, argsArr, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void startDatabases(List<String> dbNames, String node, boolean isGlobal) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInputNotNull(dbNames, "RHPHELPERUtil-startDBs-dbNames");
        Utils.assertInput(node, "RHPHELPERUtil-startDBs-node");
        Trace.out((Object)"starting databases %s ...", dbNames.toString());
        this.copyRHPHelperFiles(node);
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_home);
        args.add(this.m_homeVer.toString());
        args.add("-startDatabases");
        args.add(Utils.strListToList2(dbNames));
        args.add(isGlobal ? "NOT_SPECIFIED" : node);
        String[] argsArr = args.toArray(new String[args.size()]);
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, argsArr, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully started databases");
    }

    public void stopDatabases(List<String> dbNames, String node, boolean isGlobal) throws InvalidArgsException, CmdToolUtilException {
        this.internalStopDatabases(dbNames, node, null, isGlobal);
    }

    public void stopDatabases(List<String> dbNames, String node, StopOptions stopOption, boolean isGlobal) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInputNotNull((Object)stopOption, "RHPHELPERUtil-stopDBs-stopOpt");
        this.internalStopDatabases(dbNames, node, stopOption, isGlobal);
    }

    private void internalStopDatabases(List<String> dbNames, String node, StopOptions stopOption, boolean isGlobal) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInputNotNull(dbNames, "RHPHELPERUtil-stopDBs-dbNames");
        Utils.assertInput(node, "RHPHELPERUtil-stopDBs-node");
        Trace.out((Object)"stopping databases %s ...", dbNames.toString());
        this.copyRHPHelperFiles(node);
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_home);
        args.add(this.m_homeVer.toString());
        args.add("-stopDatabases");
        args.add(Utils.strListToList2(dbNames));
        args.add(isGlobal ? "NOT_SPECIFIED" : node);
        args.add(stopOption == null ? "NOT_SPECIFIED" : stopOption.toString());
        String[] argsArr = args.toArray(new String[args.size()]);
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, argsArr, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully stopped databases");
    }

    public void startServices(List<String> resNames, String node, boolean isGlobal) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInputNotNull(resNames, "RHPHELPERUtil-startSvcs-resNames");
        Utils.assertInput(node, "RHPHELPERUtil-startSvcs-node");
        Trace.out((Object)"starting services %s ...", resNames.toString());
        this.copyRHPHelperFiles(node);
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_home);
        args.add(this.m_homeVer.toString());
        args.add("-startServices");
        args.add(Utils.strListToList2(resNames));
        args.add(isGlobal ? "NOT_SPECIFIED" : node);
        String[] argsArr = args.toArray(new String[args.size()]);
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, argsArr, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully started services");
    }

    public Map<String, String> relocateServices(List<String> dbNames, ServiceStopArgs stopArgs, String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInputNotNull(dbNames, "RHPHELPERUtil-relSvcs-dbNames");
        Utils.assertInputNotNull(stopArgs, "RHPHELPERUtil-relSvcs-stopArgs");
        Utils.assertInput(node, "RHPHELPERUtil-relSvcs-node");
        Trace.out("relocating services of databases %s from node %s ...", dbNames.toString(), node);
        this.copyRHPHelperFiles(node);
        Boolean isDisconnect = stopArgs.getDisconnectOpt();
        Boolean isNoreplay = stopArgs.getNoreplay();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_home);
        args.add(this.m_homeVer.toString());
        args.add("-relocateServices");
        args.add(Utils.strListToList2(dbNames));
        args.add(node);
        args.add(isDisconnect == null ? "NOT_SPECIFIED" : Boolean.toString(isDisconnect));
        args.add(isNoreplay == null ? "NOT_SPECIFIED" : Boolean.toString(isNoreplay));
        String[] argsArr = args.toArray(new String[args.size()]);
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, argsArr, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        HashMap<String, String> retval = new HashMap<String, String>();
        String resultMsg = null;
        try {
            resultMsg = this.getOutput(result);
        }
        catch (InvalidArgsException e) {
            Trace.out((Object)"failed to get output of 'rhphelper -relocateServices' : %s", e.getMessage());
            throw new CmdToolUtilException(e);
        }
        Trace.out((Object)"Processed output : %s", resultMsg);
        if (resultMsg == null || resultMsg.isEmpty()) {
            return retval;
        }
        ArrayList<String> outputVals = new ArrayList<String>(Arrays.asList(resultMsg.split(",")));
        for (String elem : outputVals) {
            String[] vals = elem.split(":");
            retval.put(vals[0], vals[1]);
        }
        Trace.out((Object)"returning Map : %s", ((Object)retval).toString());
        return retval;
    }

    public void stopServices(List<String> dbNames, ServiceStopArgs stopArgs, String node, boolean isGlobal) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInputNotNull(dbNames, "RHPHELPERUtil-stopSvcs-dbNames");
        Utils.assertInputNotNull(stopArgs, "RHPHELPERUtil-stopSvcs-stopArgs");
        Utils.assertInput(node, "RHPHELPERUtil-stopSvcs-node");
        Trace.out((Object)"stopping services of databases %s ...", dbNames.toString());
        this.copyRHPHelperFiles(node);
        Boolean isDisconnect = stopArgs.getDisconnectOpt();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_home);
        args.add(this.m_homeVer.toString());
        args.add("-stopServices");
        args.add(Utils.strListToList2(dbNames));
        args.add(!isGlobal ? node : "NOT_SPECIFIED");
        args.add(isDisconnect == null ? "NOT_SPECIFIED" : Boolean.toString(isDisconnect));
        String[] argsArr = args.toArray(new String[args.size()]);
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, argsArr, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void discover(String oraHome, String rspFile, String node) throws InvalidArgsException, CmdToolUtilException {
        this.discover(oraHome, rspFile, node, null);
    }

    public void discover(String oraHome, String rspFile, String node, EnumMap<OracleGroupsEnum, String> imgGroups) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(oraHome, "RHPHELPERUtil-discover-oraHome");
        Utils.assertInput(rspFile, "RHPHELPERUtil-discover-rspFile");
        Utils.assertInput(node, "RHPHELPERUtil-discover-node");
        Trace.out("Running discover ...");
        String oracleGroupsStr = "2d7428a6b58c406";
        if (imgGroups != null) {
            String[] oracleGroups = new String[3];
            for (int i = 0; i < 3; ++i) {
                oracleGroups[i] = "";
            }
            if (imgGroups.containsKey((Object)OracleGroupsEnum.OSDBA)) {
                oracleGroups[0] = imgGroups.get((Object)OracleGroupsEnum.OSDBA);
                Trace.out("OSDBA GROUP: " + oracleGroups[0]);
            }
            if (imgGroups.containsKey((Object)OracleGroupsEnum.OSOPER)) {
                oracleGroups[1] = imgGroups.get((Object)OracleGroupsEnum.OSOPER);
                Trace.out("OSOPER GROUP: " + oracleGroups[1]);
            }
            if (imgGroups.containsKey((Object)OracleGroupsEnum.OSASM)) {
                oracleGroups[2] = imgGroups.get((Object)OracleGroupsEnum.OSASM);
                Trace.out("OSASM GROUP: " + oracleGroups[2]);
            }
            oracleGroupsStr = Utils.strArrToList(oracleGroups);
        }
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-discover", oraHome, rspFile, oracleGroupsStr};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void verify(String oraHome, String rspFile, boolean isIgnoreWarn, String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(oraHome, "RHPHELPERUtil-verify-oraHome");
        Utils.assertInput(rspFile, "RHPHELPERUtil-verify-rspFile");
        Utils.assertInput(node, "RHPHELPERUtil-verify-node");
        Trace.out("Running verify ...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-verify", oraHome, rspFile, isIgnoreWarn ? "-ignorewarn" : "null"};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node, isIgnoreWarn);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void verify(String oraHome, String rspFile, boolean isIgnoreWarn, boolean isFixup, String node) throws InvalidArgsException, CmdToolUtilException {
        this.verify(oraHome, rspFile, isIgnoreWarn, isFixup, node, 36000);
    }

    public void verify(String oraHome, String rspFile, boolean isIgnoreWarn, boolean isFixup, String node, int timeout) throws InvalidArgsException, CmdToolUtilException {
        this.verify(oraHome, rspFile, isIgnoreWarn, isFixup, false, node, timeout);
    }

    public void verify(String oraHome, String rspFile, boolean isIgnoreWarn, boolean isFixup, boolean isSetupSSH, String node) throws InvalidArgsException, CmdToolUtilException {
        this.verify(oraHome, rspFile, isIgnoreWarn, isFixup, isSetupSSH, node, 36000);
    }

    public void verify(String oraHome, String rspFile, boolean isIgnoreWarn, boolean isFixup, boolean isSetupSSH, String node, int timeout) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(oraHome, "RHPHELPERUtil-verify-oraHome");
        Utils.assertInput(rspFile, "RHPHELPERUtil-verify-rspFile");
        Utils.assertInput(node, "RHPHELPERUtil-verify-node");
        Trace.out("Running verify ...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-verify", oraHome, rspFile, isIgnoreWarn ? "-ignorewarn" : "null", isFixup ? "-fixup" : "null", this.m_uInfo.getMode() == ConfigurationSetup.ConfigMethod.ROOT ? "-root" : this.m_uInfo.getUsername(), this.m_uInfo.getMode() == ConfigurationSetup.ConfigMethod.SUDO ? this.m_uInfo.getSudoLocation() : "null", isSetupSSH ? "-setupSSH" : "null"};
        String[] env = this.getTraceEnvs();
        CommandResult result = null;
        result = isFixup ? this.m_cmdtool.execute(node, args, env, new String[]{this.m_uInfo.getPassword()}, this.m_asUser, true, timeout) : this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true, timeout);
        this.isSuccess(result, node, isIgnoreWarn);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void verifyUpgrade(String oraHome, String node, String clNodes, String dstHomePath) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(oraHome, "RHPHELPERUtil-verifyUpgrade-oraHome");
        Utils.assertInput(node, "RHPHELPERUtil-verifyUpgrade-node");
        Trace.out("Running verify upgrade ...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-verifyUpgrade", oraHome, clNodes, dstHomePath};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void checkEnoughSpace(String[] nodes, String path, int size) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(path, "RHPHELPERUtil-checkEnoughSpace-path");
        Utils.assertInputNotNull(nodes, "RHPHELPERUtil-checkEnoughSpace-node");
        Trace.out("Running checkEnoughSpace ...");
        this.copyRHPHelperFiles(nodes[0]);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-checkEnoughSpace", this.m_home, Utils.strArrToString(nodes, ","), path, String.valueOf(size)};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(nodes[0], args, env, null, this.m_asUser, true);
        this.isSuccess(result, nodes[0]);
        this.deleteRHPHelperFiles(nodes[0]);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public Map<String, String> getDBInfo(String node) throws InvalidArgsException, CmdToolUtilException {
        String[] candidateDBs;
        Utils.assertInput(node, "RHPHELPERUtil-getDBInfo-node");
        Trace.out("Running getDBInfo ...");
        HashMap<String, String> dbList = new HashMap<String, String>();
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getDBInfo"};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = null;
        try {
            resultMsg = this.getOutput(result);
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        Trace.out("Processed output : " + resultMsg);
        if (resultMsg == null || resultMsg.isEmpty()) {
            return dbList;
        }
        for (String dbInfo : candidateDBs = resultMsg.split("\\n")) {
            String[] splitResult = dbInfo.split(":");
            String dbName = splitResult[0];
            Trace.out((Object)"DB name : %s", dbName);
            String vals = splitResult[1].trim();
            Trace.out((Object)"vals : %s", vals);
            String dbHome = vals.substring(vals.indexOf("[") + 1, vals.indexOf("]")).split(",")[0];
            Trace.out((Object)"DB home : %s", dbHome);
            dbList.put(dbName, dbHome);
        }
        return dbList;
    }

    public DatabaseType getDBType(String dbName, String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(dbName, "RHPHELPERUtil-getDBType-dbName");
        Utils.assertInput(node, "RHPHELPERUtil-getDBType-node");
        Trace.out("Running getDBType ...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getDBType", dbName};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = this.getOutput(result);
        Trace.out("Processed output : " + resultMsg);
        DatabaseType type = null;
        try {
            type = DatabaseType.getEnumMember(resultMsg);
        }
        catch (EnumConstNotFoundException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        return type;
    }

    public boolean isDBRunning(String dbName, String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(dbName, "RHPHELPERUtil-isDBRunning-dbName");
        Utils.assertInput(node, "RHPHELPERUtil-isDBRunning-node");
        Trace.out("Running isDBRunning ...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-isDBRunning", dbName};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = this.getOutput(result);
        Trace.out("Processed output : " + resultMsg);
        return Boolean.valueOf(resultMsg);
    }

    public String getDBStopNode(String dbName, String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(dbName, "RHPHELPERUtil-getDBStopNode-dbName");
        Utils.assertInput(node, "RHPHELPERUtil-getDBStopNode-node");
        Trace.out("Running isDBRunning ...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getDBStopNode", dbName};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = this.getOutput(result);
        Trace.out("Processed output : " + resultMsg);
        return resultMsg;
    }

    public void copyDir(String srcDir, String srcNode, List<String> nodes) throws InvalidArgsException, CmdToolUtilException {
        this.copyDir(srcDir, srcNode, nodes, null);
    }

    public void copyDir(String srcDir, String srcNode, List<String> nodes, String excludeListFile) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(srcDir, "RHPHELPERUtil-copyDir-srcDir");
        Utils.assertInputNotNull(nodes, "RHPHELPERUtil-copyDir-nodes");
        Utils.assertInput(srcNode, "RHPHELPERUtil-copyDir-node");
        Trace.out("Running copyDir ...");
        this.copyRHPHelperFiles(srcNode);
        String excludeListArg = "NOT_SPECIFIED";
        if (excludeListFile != null) {
            excludeListArg = excludeListFile;
        }
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-copyDir", this.m_home, srcDir, excludeListArg, Utils.strListToList2(nodes)};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(srcNode, args, env, null, this.m_asUser, true);
        this.isSuccess(result, srcNode);
        this.deleteRHPHelperFiles(srcNode);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public String getClusterName(String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(node, "RHPHELPERUtil-getClusterName-node");
        Trace.out("Retrieving cluster name ...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getClusterName"};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, null, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = null;
        try {
            resultMsg = this.getOutput(result);
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        Trace.out("Processed output : " + resultMsg);
        return resultMsg;
    }

    public Map<String, String> getClusterNodesRoles(String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(node, "RHPHELPERUtil-getClusterNodes-Role");
        Trace.out("Retrieving cluster nodes roles...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getClusterNodesRoles", this.m_home};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, null, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = null;
        try {
            resultMsg = this.getOutput(result);
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        Trace.out("Processed output : " + resultMsg);
        String[] nodeRoleArr = resultMsg.split(",");
        HashMap<String, String> returnMap = new HashMap<String, String>();
        for (String nodeRole : nodeRoleArr) {
            String[] nodeRoleSplit = nodeRole.split(":");
            if (nodeRoleSplit.length > 1) {
                returnMap.put(nodeRoleSplit[0], nodeRoleSplit[1]);
                continue;
            }
            returnMap.put(nodeRoleSplit[0], "");
        }
        Trace.out("Returning the filled hashmap");
        return returnMap;
    }

    public List<String> getClusterNodes(String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(node, "RHPHELPERUtil-getClusterNodes-node");
        Trace.out("Retrieving cluster nodes ...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getClusterNodes"};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, null, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = null;
        try {
            resultMsg = this.getOutput(result);
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        Trace.out("Processed output : " + resultMsg);
        return new ArrayList<String>(Arrays.asList(resultMsg.split(",")));
    }

    public List<String> getHistoricalClusterNodes(String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(node, "RHPHELPERUtil-getHistoricalClusterNodes-node");
        Trace.out("Retrieving historical cluster nodes ...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getHistoricalClusterNodes", this.m_home};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, null, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = null;
        try {
            resultMsg = this.getOutput(result);
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        Trace.out("Processed output : " + resultMsg);
        return new ArrayList<String>(Arrays.asList(resultMsg.split(",")));
    }

    public void stopCluster(List<String> nodes) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInputNotNull(nodes, "RHPHELPERUtil-stopCluster-nodes");
        Trace.out("Stopping Cluster ...");
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-stopCluster", this.m_home};
        String[] env = this.getTraceEnvs();
        for (String node : nodes) {
            Trace.out("Shutting down CRS stack on node " + node);
            this.copyRHPHelperFiles(node);
            CommandResult result = this.m_cmdtool.execute(node, args, env, null, null, true);
            this.isSuccess(result, node);
            this.deleteRHPHelperFiles(node);
        }
        Trace.out("Successfully executed rhphelper cmd for stopping Cluster");
    }

    public void stopListener(List<String> nodes) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInputNotNull(nodes, "RHPHELPERUtil-stopListener-nodes");
        Trace.out("Stopping listener ...");
        this.copyRHPHelperFiles(nodes.get(0));
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-stopListener", this.m_home, Utils.strListToList2(nodes)};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(nodes.get(0), args, env, null, null, true);
        this.isSuccess(result, nodes.get(0));
        this.deleteRHPHelperFiles(nodes.get(0));
        Trace.out("Successfully executed rhphelper cmd");
    }

    public Map<String, List<String>> getRunningNodes(String node) throws InvalidArgsException, CmdToolUtilException {
        String[] dbs;
        Utils.assertInput(node, "RHPHELPERUtil-getRunNodes-node");
        Trace.out("Running getRunningNodes ...");
        HashMap<String, List<String>> retval = new HashMap<String, List<String>>();
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getRunningNodes", this.m_home};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = null;
        try {
            resultMsg = this.getOutput(result);
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        Trace.out("Processed output : " + resultMsg);
        if (resultMsg == null || resultMsg.isEmpty()) {
            return retval;
        }
        for (String dbInfo : dbs = resultMsg.split("\\n")) {
            String[] splitResult = dbInfo.split(":");
            String dbName = splitResult[0];
            Trace.out((Object)"DB name : %s", dbName);
            ArrayList<String> nodes = new ArrayList<String>(Arrays.asList(splitResult[1].split(",")));
            Trace.out("nodes : %s", nodes);
            retval.put(dbName, nodes);
        }
        return retval;
    }

    public Map<String, List<List<String>>> getServiceInfo(String node) throws InvalidArgsException, CmdToolUtilException {
        return this.internalGetServiceInfo(node, null);
    }

    public Map<String, List<List<String>>> getServiceInfo(String node, List<String> dbs) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInputNotNull(dbs, "RHPHELPERUtil-getSvcInfo-dbs");
        return this.internalGetServiceInfo(node, dbs);
    }

    private Map<String, List<List<String>>> internalGetServiceInfo(String node, List<String> dbs) throws InvalidArgsException, CmdToolUtilException {
        String[] svcInfos;
        Utils.assertInput(node, "RHPHELPERUtil-getSvcInfo-node");
        Trace.out("Running getSvcInfo ...");
        HashMap<String, List<List<String>>> retval = new HashMap<String, List<List<String>>>();
        this.copyRHPHelperFiles(node);
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_home);
        args.add(this.m_homeVer.toString());
        args.add("-getServiceInfo");
        if (dbs != null && !dbs.isEmpty()) {
            args.add(Utils.strListToList2(dbs));
        }
        String[] argsArr = args.toArray(new String[args.size()]);
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, argsArr, env, null, this.m_asUser, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = null;
        try {
            resultMsg = this.getOutput(result);
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        Trace.out("Processed output : " + resultMsg);
        if (resultMsg == null || resultMsg.trim().isEmpty()) {
            return retval;
        }
        for (String svcInfo : svcInfos = resultMsg.split("=###=")) {
            String[] splitResult = svcInfo.split(";", 4);
            String resName = splitResult[0];
            Trace.out("res name : %s; all nodes : %s; online nodes : %s; disabled nodes : %s", resName, splitResult[1], splitResult[2], splitResult[3]);
            ArrayList<Object> allNodes = new ArrayList();
            ArrayList<Object> onlineNodes = new ArrayList();
            ArrayList<Object> disabledNodes = new ArrayList();
            if (!splitResult[1].trim().isEmpty()) {
                allNodes = new ArrayList<String>(Arrays.asList(splitResult[1].split(",")));
                Trace.out(((Object)allNodes).toString());
            }
            if (!splitResult[2].trim().isEmpty()) {
                onlineNodes = new ArrayList<String>(Arrays.asList(splitResult[2].split(",")));
                Trace.out(((Object)onlineNodes).toString());
            }
            if (!splitResult[3].trim().isEmpty()) {
                disabledNodes = new ArrayList<String>(Arrays.asList(splitResult[3].split(",")));
                Trace.out(((Object)disabledNodes).toString());
            }
            ArrayList<ArrayList<Object>> val = new ArrayList<ArrayList<Object>>();
            val.add(allNodes);
            val.add(onlineNodes);
            val.add(disabledNodes);
            retval.put(resName, val);
        }
        return retval;
    }

    public void relocateServices(List<String> nodes) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInputNotNull(nodes, "RHPHELPERUtil-relocateSvcs-nodes");
        Trace.out("relocating services ...");
        this.copyRHPHelperFiles(nodes.get(0));
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-relocateServices", Utils.strListToList2(nodes)};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(nodes.get(0), args, env, null, null, true);
        this.isSuccess(result, nodes.get(0));
        this.deleteRHPHelperFiles(nodes.get(0));
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void relocateService(String dbName, String svcName, String srcNode, String dstNode) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(dbName, "RHPHELPERUtil-relocateSvc-db");
        Utils.assertInput(svcName, "RHPHELPERUtil-relocateSvc-svc");
        Utils.assertInput(srcNode, "RHPHELPERUtil-relocateSvc-src");
        Utils.assertInput(dstNode, "RHPHELPERUtil-relocateSvc-dst");
        Trace.out("relocating service %s from %s to %s ...", svcName, srcNode, dstNode);
        this.copyRHPHelperFiles(srcNode);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-relocateService", dbName, svcName, srcNode, dstNode};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(srcNode, args, env, null, null, true);
        this.isSuccess(result, srcNode);
        this.deleteRHPHelperFiles(srcNode);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public List<String> getAdminManagedDatabases(String node, List<String> dbs) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(node, "RHPHELPERUtil-getAdminDBs-node");
        Utils.assertInputNotNull(dbs, "RHPHELPERUtil-getAdminDBs-dbs");
        Trace.out("Retrieving admin-managed dbs ...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getAdminManagedDatabases", Utils.strListToList2(dbs)};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, null, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = null;
        try {
            resultMsg = this.getOutput(result);
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        Trace.out("Processed output : " + resultMsg);
        if (resultMsg != null && !resultMsg.trim().isEmpty()) {
            return new ArrayList<String>(Arrays.asList(resultMsg.split(",")));
        }
        return new ArrayList<String>();
    }

    public List<String> getCardinalDatabases(String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(node, "RHPHELPERUtil-getCardinalDBs-node");
        Trace.out("Retrieving admin-managed dbs ...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getCardinalDatabases"};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, null, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = null;
        try {
            resultMsg = this.getOutput(result);
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        Trace.out("Processed output : " + resultMsg);
        if (resultMsg != null && !resultMsg.trim().isEmpty()) {
            return new ArrayList<String>(Arrays.asList(resultMsg.split(",")));
        }
        return new ArrayList<String>();
    }

    public void updateOratab(String sid, String home, String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(sid, "RHPHELPERUtil-getCardinalDBs-sid");
        Utils.assertInput(home, "RHPHELPERUtil-getCardinalDBs-home");
        Utils.assertInput(node, "RHPHELPERUtil-getCardinalDBs-node");
        Trace.out((Object)"updating /etc/oratab on node %s ...", node);
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-updateOratab", sid, home};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, null, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper -updateOratab");
    }

    public void setupGIMove(String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(node, "RHPHELPERUtil-setupGIMove-node");
        this.internalcopyRHPHelperFiles(node, true);
    }

    public void setupDBMove(String node, String sfile, String dfile, boolean isRoll) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(node, "RHPHELPERUtil-setupDBMove-node");
        this.internalCopyDBFiles(node, sfile, dfile, isRoll);
    }

    private String[] getTraceEnvs() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String traceFileName = "rhphelp_" + sdf.format(new Date()) + ".trc";
        String traceFileLocEnv = "RHPHELPER_TRACEFILE=/tmp/" + traceFileName;
        return new String[]{"SRVM_TRACE=true", traceFileLocEnv};
    }

    private String getOutput(CommandResult result) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInputNotNull(result, "RHPHELPERUtil-getOutput-result");
        String[] output = result.getResultString();
        if (output == null || output.length != 1) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "RHPHELPERUtil-getOutput-err1");
        }
        String tagOutput = output[0].trim();
        Trace.out("Tagged output : " + tagOutput);
        String resultMsg = tagOutput.substring(tagOutput.indexOf("<HLP_OUT>") + "<HLP_OUT>".length(), tagOutput.indexOf("</HLP_OUT>")).trim();
        return resultMsg;
    }

    private String getErrorMessage(NativeResult result) throws InvalidArgsException {
        Utils.assertInputNotNull(result, "RHPHELPERUtil-getErrMsg-result");
        String resultMsg = "RHPHELPERUtil-getErrMsg-default";
        String[] output = result.getResultString();
        if (output != null) {
            String tagOutput = Utils.strArrToString(output, LSEP).trim();
            Trace.out("Tagged output : " + tagOutput);
            if (tagOutput.contains("<HLP_EMSG>")) {
                resultMsg = tagOutput.substring(tagOutput.indexOf("<HLP_EMSG>") + "<HLP_EMSG>".length(), tagOutput.indexOf("</HLP_EMSG>")).trim();
            }
            Trace.out("Result is :" + resultMsg);
        }
        return resultMsg;
    }

    private String getWarningMessage(NativeResult result) throws InvalidArgsException {
        Utils.assertInputNotNull(result, "RHPHELPERUtil-getWarnMsg-result");
        String resultMsg = "RHPHELPERUtil-getWarnMsg-default";
        String[] output = result.getResultString();
        if (output != null) {
            String tagOutput = Utils.strArrToString(output, LSEP).trim();
            Trace.out("Tagged output : " + tagOutput);
            if (tagOutput.contains("<HLP_WMSG>")) {
                resultMsg = tagOutput.substring(tagOutput.indexOf("<HLP_WMSG>") + "<HLP_WMSG>".length(), tagOutput.indexOf("</HLP_WMSG>")).trim();
            }
            Trace.out("Result is :" + resultMsg);
        }
        return resultMsg;
    }

    private int getVRESValue(NativeResult result) throws InvalidArgsException {
        Utils.assertInputNotNull(result, "RHPHELPERUtil-getVRESValue-result");
        int vres = -1;
        String[] output = result.getResultString();
        if (output != null) {
            String tagOutput = Utils.strArrToString(output, LSEP).trim();
            Trace.out("Tagged output : " + tagOutput);
            String resultMsg = "";
            if (tagOutput.contains("<HLP_VRES>")) {
                resultMsg = tagOutput.substring(tagOutput.indexOf("<HLP_VRES>") + "<HLP_VRES>".length(), tagOutput.indexOf("</HLP_VRES>")).trim();
            }
            Trace.out("Result is :" + resultMsg);
            try {
                vres = Integer.parseInt(resultMsg);
            }
            catch (NumberFormatException e) {
                Trace.out("NumberFormatException:\n " + e);
            }
        }
        return vres;
    }

    private void isSuccess(CommandResult result, String node) throws CmdToolUtilException {
        this.isSuccess(result, node, false);
    }

    private void isSuccess(CommandResult result, String node, boolean ignoreWarn) throws CmdToolUtilException {
        if (result == null || node == null || node.trim().isEmpty()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-processErr-error01");
        }
        String msg = "RHPHELPERUtil-errMsg-default";
        String warnMsg = "RHPHELPERUtil-warnMsg-default";
        int vres = -1;
        try {
            msg = this.getErrorMessage(result);
            warnMsg = this.getWarningMessage(result);
            vres = this.getVRESValue(result);
        }
        catch (InvalidArgsException iae) {
            Trace.out(iae);
        }
        Trace.out("rhphelper's vres is %d and message is %s", vres, msg);
        if (!ignoreWarn && vres == 1) {
            throw new CmdToolUtilException(true, (MessageKey)PrCtMsgID.COMMAND_TOOL_WARN, new Exception(warnMsg), this.m_cmdtool.getToolName());
        }
        Exception e = null;
        e = vres == 3 ? new Exception(msg) : (vres == 2 ? new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, msg) : result.getException());
        if (e != null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, (Throwable)e, this.m_cmdtool.getToolName(), node);
        }
    }

    public List<String> getHubNodes(String node) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(node, "RHPHELPERUtil-getHubNodes-node");
        Trace.out("Retrieving hub nodes ...");
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-getHubNodes"};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(node, args, env, null, null, true);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
        String resultMsg = null;
        try {
            resultMsg = this.getOutput(result);
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new CmdToolUtilException(e);
        }
        Trace.out("Processed output : " + resultMsg);
        return new ArrayList<String>(Arrays.asList(resultMsg.split(",")));
    }

    public void checkPatchedBugs(String oracleHome, String bugNums, String[] nodes, boolean isRacHome, String oracleHomeVer) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(oracleHome, "RHPHELPERUtil-checkPatchedBugs-oracleHome");
        Utils.assertInputNotNull(bugNums, "RHPHELPERUtil-checkPatchedBugs-bugNums");
        Utils.assertInputNotNull(nodes, "RHPHELPERUtil-checkPatchedBugs-node");
        Utils.assertInputNotNull(isRacHome, "RHPHELPERUtil-checkPatchedBugs-isRacHome");
        Utils.assertInput(oracleHomeVer, "RHPHELPERUtil-checkPatchedBugs-oracleHomeVer");
        Trace.out("Running checkPatchedBugs ...");
        this.copyRHPHelperFiles(nodes[0]);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-checkPatchedBugs", this.m_home, oracleHome, bugNums, Utils.strArrToString(nodes, ","), Boolean.toString(isRacHome), oracleHomeVer};
        String[] env = this.getTraceEnvs();
        CommandResult result = this.m_cmdtool.execute(nodes[0], args, env, null, this.m_asUser, true);
        this.isSuccess(result, nodes[0]);
        this.deleteRHPHelperFiles(nodes[0]);
        Trace.out("Successfully executed rhphelper cmd");
    }

    public void transferNoUserEq(String srcPath, String[] nodeList, String[] destPath, String asUser, String node) throws InvalidArgsException, CmdToolUtilException {
        String oracleHome = this.m_home;
        Utils.assertInputNotNull(nodeList, "RHPHELPERUtil-transferNoUserEq-nodeList");
        Utils.assertInput(srcPath, "RHPHELPERUtil-transferNoUserEq-srcPath");
        Utils.assertInputNotNull(destPath, "RHPHELPERUtil-transferNoUserEq-destPath");
        Utils.assertInput(asUser, "RHPHELPERUtil-transferNoUserEq-asUser");
        Utils.assertInput(node, "RHPHELPERUtil-transferNoUserEq-node");
        Trace.out("Performing transferNoUserEq of directory from " + srcPath);
        this.copyRHPHelperFiles(node);
        String[] args = new String[]{this.m_home, this.m_homeVer.toString(), "-transferNoUserEq", oracleHome, Utils.strArrToList(nodeList), srcPath, Utils.strArrToList(destPath), this.m_uInfo.getMode() == ConfigurationSetup.ConfigMethod.ROOT ? "-root" : this.m_uInfo.getUsername(), this.m_uInfo.getMode() == ConfigurationSetup.ConfigMethod.SUDO ? this.m_uInfo.getSudoLocation() : "null", this.m_asUser};
        String[] env = this.getTraceEnvs();
        env = Arrays.copyOf(env, env.length + 1);
        env[env.length - 1] = "ORACLE_HOME=" + oracleHome;
        CommandResult result = this.m_cmdtool.execute(node, args, env, new String[]{this.m_uInfo.getPassword()}, this.m_asUser, true, 36000);
        this.isSuccess(result, node);
        this.deleteRHPHelperFiles(node);
        Trace.out("Successfully executed rhphelper cmd");
    }
}

