/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.server.Node;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class PrivilegeUtil {
    private CmdToolUtil m_cmdtool;
    private String m_crsHome;
    private static final String ROOTCMD = "rootcmd";
    private static final String EXE_LOC = "srvm" + File.separator + "admin";
    private final String[] ROOTCMD_DEP = new String[]{"rootcmd"};
    private static final String ROOTCMD_USEROPT = "-u";
    private static final String NEWLINE = System.getProperty("line.separator");

    public PrivilegeUtil(String crsHome) throws CmdToolUtilException {
        CmdToolUtil.assertDir(crsHome, true);
        this.m_crsHome = crsHome;
        String toolLoc = crsHome + File.separator + EXE_LOC;
        this.m_cmdtool = new CmdToolUtil(ROOTCMD, toolLoc, this.ROOTCMD_DEP);
        Trace.out("Toolname: rootcmd   ---    Tool location: " + toolLoc + "Tool dependencies: " + this.ROOTCMD_DEP);
    }

    public CommandResult submit(String cmd) throws CmdToolUtilException {
        if (cmd == null || cmd.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "cmd");
        }
        String[] args = new String[]{cmd};
        CommandResult result = this.m_cmdtool.executeLocally(args, null);
        Trace.out("result.getBooleanResult()" + result.getBooleanResult());
        return result;
    }

    public CommandResult submit(String userName, String cmd) throws CmdToolUtilException {
        if (userName == null || userName.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "userName");
        }
        if (cmd == null || cmd.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "cmd");
        }
        String[] args = new String[]{ROOTCMD_USEROPT, userName, cmd};
        CommandResult result = this.m_cmdtool.executeLocally(args, null, true);
        Trace.out("result.getBooleanResult()" + result.getBooleanResult());
        return result;
    }

    public CommandResult submit(Node node, String userName, String cmd) throws CmdToolUtilException {
        if (userName == null || userName.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "userName");
        }
        if (cmd == null || cmd.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "cmd");
        }
        try {
            String[] args = new String[]{ROOTCMD_USEROPT, userName, cmd};
            CommandResult result = this.m_cmdtool.execute(node.getName(), args, null, false, true);
            Trace.out("result.getBooleanResult()" + result.getBooleanResult());
            return result;
        }
        catch (NodeException e) {
            throw new CmdToolUtilException(e);
        }
    }

    public CommandResult submit(Node node, String cmd) throws CmdToolUtilException {
        if (cmd == null || cmd.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "cmd");
        }
        try {
            String[] args = new String[]{cmd};
            CommandResult result = this.m_cmdtool.execute(node.getName(), args, null, false, true);
            Trace.out("result.getBooleanResult()" + result.getBooleanResult());
            return result;
        }
        catch (NodeException e) {
            throw new CmdToolUtilException(e);
        }
    }
}

