/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.database.OSDBAGroup;
import oracle.cluster.database.OracleGroupsEnum;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class OSDBAGRPUtil {
    private CmdToolUtil m_cmdtool;
    NativeSystem nativeSystem = new SystemFactory().CreateSystem();
    private final String OSDBAGRP_CMD = this.nativeSystem.getExeName("osdbagrp");
    private final String[] OSDBAGRP_DEP = new String[]{this.OSDBAGRP_CMD};
    private static final String OSDBAGRP_SYSDBA = "-d";
    private static final String OSDBAGRP_SYSOPER = "-o";
    private static final String OSDBAGRP_SYSASM = "-a";
    private static final String OSDBAGRP_SYSBACKUP = "-b";
    private static final String OSDBAGRP_SYSDG = "-g";
    private static final String OSDBAGRP_SYSKM = "-k";
    private static final String OSDBAGRP_SYSRAC = "-r";
    private static final String[] argArray122 = new String[]{"-d", "-o", "-a", "-b", "-g", "-k", "-r"};
    private static final String[] groupStringArray122 = new String[]{OSDBAGroup.SYSDBA.toString(), OSDBAGroup.SYSOPER.toString(), OSDBAGroup.SYSASM.toString(), OSDBAGroup.SYSBACKUP.toString(), OSDBAGroup.SYSDG.toString(), OSDBAGroup.SYSKM.toString(), OSDBAGroup.SYSRAC.toString()};
    private static final String[] argArray12 = new String[]{"-d", "-o", "-a", "-b", "-g", "-k"};
    private static final String[] groupStringArray12 = new String[]{OSDBAGroup.SYSDBA.toString(), OSDBAGroup.SYSOPER.toString(), OSDBAGroup.SYSASM.toString(), OSDBAGroup.SYSBACKUP.toString(), OSDBAGroup.SYSDG.toString(), OSDBAGroup.SYSKM.toString()};
    private static final String[] argArray11 = new String[]{"-d", "-o", "-a"};
    private static final String[] groupStringArray11 = new String[]{OSDBAGroup.SYSDBA.toString(), OSDBAGroup.SYSOPER.toString(), OSDBAGroup.SYSASM.toString()};
    private static final String NEWLINE = "\\n";
    private HashMap<String, String> m_groupTable = new HashMap();
    private Version m_version;
    private String m_node = null;

    public OSDBAGRPUtil(String location) throws CmdToolUtilException {
        try {
            oracle.cluster.impl.util.Utils.assertInput(location, "OSDBAGRPUtil-constr1-location");
            this.m_cmdtool = new CmdToolUtil(this.OSDBAGRP_CMD, location, this.OSDBAGRP_DEP);
        }
        catch (InvalidArgsException e) {
            throw new CmdToolUtilException(e);
        }
    }

    public OSDBAGRPUtil(String location, Version version) throws CmdToolUtilException {
        try {
            oracle.cluster.impl.util.Utils.assertInput(location, "OSDBAGRPUtil-constr2-location");
            oracle.cluster.impl.util.Utils.assertInputNotNull(version, "OSDBAGRPUtil-constr2-version");
            this.m_cmdtool = new CmdToolUtil(this.OSDBAGRP_CMD, location, this.OSDBAGRP_DEP);
            this.m_version = version;
        }
        catch (InvalidArgsException e) {
            throw new CmdToolUtilException(e);
        }
    }

    public OSDBAGRPUtil(String location, Version version, RemoteUserInfo uInfo) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(location, "OSDBAGRPUtil-constr3-location");
        oracle.cluster.impl.util.Utils.assertInputNotNull(version, "OSDBAGRPUtil-constr3-version");
        oracle.cluster.impl.util.Utils.assertInputNotNull(uInfo, "OSDBAGRPUtil-constr3-uInfo");
        this.m_cmdtool = new CmdToolUtil(uInfo, this.OSDBAGRP_CMD, location);
        this.m_version = version;
    }

    private void populateGroups(String[] argumentArray, String[] groupStrings) throws CmdToolUtilException {
        for (int i = 0; i < argumentArray.length; ++i) {
            String[] errorString;
            String[] args = new String[]{argumentArray[i]};
            CommandResult result = null;
            result = this.m_node == null ? this.m_cmdtool.execute(args, null) : this.m_cmdtool.execute(this.m_node, args, null, false, true);
            if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
                if (this.m_node == null) {
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.OSDBAGRP_COMMAND_FAIL, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
                }
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.OSDBAGRP_COMMAND_FAIL_NODE, this.m_node, Utils.getString(errorString, NEWLINE));
            }
            Object[] outputs = result.getResultString();
            String groupOutput = "";
            if (outputs != null) {
                groupOutput = Arrays.toString(outputs);
                groupOutput = groupOutput.substring(1, groupOutput.length() - 1);
            }
            this.m_groupTable.put(groupStrings[i], groupOutput);
        }
    }

    public HashMap<String, String> getAdminGroups() throws CmdToolUtilException {
        return this.getAdminGroups(null);
    }

    public HashMap<String, String> getAdminGroups(String node) throws CmdToolUtilException {
        this.m_node = node == null ? null : node;
        Trace.out("node: " + this.m_node);
        if (this.m_version == null) {
            this.m_version = new Version();
        }
        if (Version.isPre122(this.m_version)) {
            if (Version.isPre12c(this.m_version)) {
                this.populateGroups(argArray11, groupStringArray11);
            } else {
                this.populateGroups(argArray12, groupStringArray12);
            }
        } else {
            this.populateGroups(argArray122, groupStringArray122);
        }
        return this.m_groupTable;
    }

    public EnumMap<OracleGroupsEnum, String> getOracleGroups() throws CmdToolUtilException {
        return this.getOracleGroups(null);
    }

    public EnumMap<OracleGroupsEnum, String> getOracleGroups(String node) throws CmdToolUtilException {
        HashMap<String, String> admingrps = node == null ? this.getAdminGroups() : this.getAdminGroups(node);
        EnumMap<OracleGroupsEnum, String> grps = new EnumMap<OracleGroupsEnum, String>(OracleGroupsEnum.class);
        if (admingrps.containsKey(OSDBAGroup.SYSDBA.toString()) && !admingrps.get(OSDBAGroup.SYSDBA.toString()).trim().isEmpty()) {
            grps.put(OracleGroupsEnum.OSDBA, admingrps.get(OSDBAGroup.SYSDBA.toString()));
        }
        if (admingrps.containsKey(OSDBAGroup.SYSOPER.toString()) && !admingrps.get(OSDBAGroup.SYSOPER.toString()).trim().isEmpty()) {
            grps.put(OracleGroupsEnum.OSOPER, admingrps.get(OSDBAGroup.SYSOPER.toString()));
        }
        if (admingrps.containsKey(OSDBAGroup.SYSASM.toString()) && !admingrps.get(OSDBAGroup.SYSASM.toString()).trim().isEmpty()) {
            grps.put(OracleGroupsEnum.OSASM, admingrps.get(OSDBAGroup.SYSASM.toString()));
        }
        if (admingrps.containsKey(OSDBAGroup.SYSBACKUP.toString()) && !admingrps.get(OSDBAGroup.SYSBACKUP.toString()).trim().isEmpty()) {
            grps.put(OracleGroupsEnum.OSBACKUP, admingrps.get(OSDBAGroup.SYSBACKUP.toString()));
        }
        if (admingrps.containsKey(OSDBAGroup.SYSDG.toString()) && !admingrps.get(OSDBAGroup.SYSDG.toString()).trim().isEmpty()) {
            grps.put(OracleGroupsEnum.OSDG, admingrps.get(OSDBAGroup.SYSDG.toString()));
        }
        if (admingrps.containsKey(OSDBAGroup.SYSKM.toString()) && !admingrps.get(OSDBAGroup.SYSKM.toString()).trim().isEmpty()) {
            grps.put(OracleGroupsEnum.OSKM, admingrps.get(OSDBAGroup.SYSKM.toString()));
        }
        if (admingrps.containsKey(OSDBAGroup.SYSRAC.toString()) && !admingrps.get(OSDBAGroup.SYSRAC.toString()).trim().isEmpty()) {
            grps.put(OracleGroupsEnum.OSRAC, admingrps.get(OSDBAGroup.SYSRAC.toString()));
        }
        return grps;
    }
}

