/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ORADNFSUtil {
    private CmdToolUtil m_cmdTool;
    private String m_oracleHome;
    private static final boolean s_isUnixSystem = new SystemFactory().CreateSystem().isUnixSystem();
    private static final boolean isDevEnv = Utils.isDevelopmentEnv();
    private String ORADNFS;
    private String[] ORADNFS_DEP;
    private String ORADNFS_EXE_LOC = isDevEnv ? ResourceLiterals.PATHSEP.toString() + "rdbms" + ResourceLiterals.PATHSEP.toString() + "bin" : ResourceLiterals.PATHSEP.toString() + "bin";
    private String ORADNFS_ISDNFSENABLED = "isdnfsenabled";
    private String ORADNFS_ISPATHONDNFS = "ispathondnfs";
    private String OPT_OHOME = "-oh";
    private String OPT_PATH = "-path";
    private String ORADNFS_DNFS_ENABLED = "ODNFS-65009:";
    private String ORADNFS_DNFS_DISABLED = "ODNFS-65010:";
    private String ORADNFS_PATH_IS_ENABLED = "ODNFS-65071:";
    private String ORADNFS_PATH_IS_DISABLED = "ODNFS-65072:";
    private String ORADNFS_OPERATION_FAILED = "ODNFS-65022:";

    public ORADNFSUtil(String location) throws CmdToolUtilException {
        CmdToolUtil.assertDir(location, true);
        this.m_oracleHome = location;
        String toolLoc = location;
        if (s_isUnixSystem) {
            if (isDevEnv) {
                Trace.out("Linux test environment, use base binary for unit tests");
                this.ORADNFS = new SystemFactory().CreateSystem().getExeName("oradnfs");
            } else {
                this.ORADNFS = new SystemFactory().CreateSystem().getScriptFileName("oradnfs_run.sh");
            }
        } else {
            this.ORADNFS = new SystemFactory().CreateSystem().getScriptFileName("oradnfs_run");
        }
        this.ORADNFS_DEP = new String[]{this.ORADNFS};
        toolLoc = toolLoc + File.separator + this.ORADNFS_EXE_LOC;
        this.m_cmdTool = new CmdToolUtil(this.ORADNFS, toolLoc, this.ORADNFS_DEP);
        Trace.out("Toolname: " + this.ORADNFS + Constants.NEWLINE + "  Tool location: " + toolLoc + "Tool dependencies: " + this.ORADNFS_DEP);
    }

    public boolean isPathOnDNFS(String path) throws CmdToolUtilException {
        CmdToolUtil.assertDir(path, true);
        boolean isEnabled = false;
        String[] args = new String[]{this.ORADNFS_ISPATHONDNFS, this.OPT_OHOME, this.m_oracleHome, this.OPT_PATH, path};
        String[] envs = new String[]{"ORACLE_HOME=" + this.m_oracleHome};
        try {
            String[] output;
            String[] errorString;
            CommandResult result = this.m_cmdTool.executeLocally(args, envs, false, false);
            if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
                Trace.out("m_cmdtool.execute failed ");
                String[] stringArray = errorString;
                int n = stringArray.length;
                int n2 = 0;
                if (n2 < n) {
                    String line = stringArray[n2];
                    String lineClean = line.trim();
                    if (lineClean.startsWith(this.ORADNFS_PATH_IS_DISABLED)) {
                        return false;
                    }
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.ORADNFS_ISPATHENABLED_FAIL, Utils.getString(errorString, Constants.NEWLINE));
                }
            }
            for (String line : output = result.getResultString()) {
                String lineClean = line.trim();
                if (!lineClean.startsWith(this.ORADNFS_PATH_IS_ENABLED)) continue;
                isEnabled = true;
                break;
            }
            if (!isEnabled) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ORADNFS_ISPATHENABLED_FAIL, Utils.getString(output, Constants.NEWLINE));
            }
        }
        catch (CmdToolUtilException cte) {
            String exMessage = cte.getMessage().trim();
            Trace.out("Ex message> " + exMessage);
            if (exMessage.contains(this.ORADNFS_PATH_IS_DISABLED)) {
                Trace.out("Path " + path + " is not DNFS enabled");
                isEnabled = false;
            }
            if (exMessage.contains(this.ORADNFS_OPERATION_FAILED)) {
                Trace.out("Operation failed in oradnfs binary");
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ORADNFS_ISPATHENABLED_FAIL, exMessage);
            }
            Trace.out("Remote execution error");
            throw new CmdToolUtilException(cte);
        }
        return isEnabled;
    }

    public boolean isOHOMEDNFSEnabled(String oracleHome) throws CmdToolUtilException {
        boolean isEnabled;
        block8: {
            CmdToolUtil.assertDir(oracleHome, true);
            isEnabled = false;
            String[] args = new String[]{this.ORADNFS_ISDNFSENABLED, oracleHome};
            String[] envs = new String[]{"ORACLE_HOME=" + this.m_oracleHome};
            try {
                String[] output;
                int n;
                int n2;
                String[] stringArray;
                String[] errorString;
                CommandResult result = this.m_cmdTool.executeLocally(args, envs, false, false);
                if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
                    Trace.out("m_cmdtool.execute failed ");
                    stringArray = errorString;
                    n2 = stringArray.length;
                    n = 0;
                    if (n < n2) {
                        String line = stringArray[n];
                        String lineClean = line.trim();
                        if (lineClean.startsWith(this.ORADNFS_DNFS_DISABLED)) {
                            return false;
                        }
                        throw new CmdToolUtilException((MessageKey)PrCtMsgID.ORADNFS_ISPATHENABLED_FAIL, Utils.getString(errorString, Constants.NEWLINE));
                    }
                }
                if ((n = 0) >= (n2 = (stringArray = (output = result.getResultString())).length)) break block8;
                String line = stringArray[n];
                String lineClean = line.trim();
                if (lineClean.startsWith(this.ORADNFS_DNFS_ENABLED)) {
                    isEnabled = true;
                    break block8;
                }
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ORADNFS_ISPATHENABLED_FAIL, Utils.getString(output, Constants.NEWLINE));
            }
            catch (CmdToolUtilException cte) {
                String exMessage = cte.getMessage().trim();
                Trace.out("Ex message> " + exMessage);
                if (exMessage.contains(this.ORADNFS_DNFS_DISABLED)) {
                    Trace.out("Path " + oracleHome + " is not DNFS enabled");
                    isEnabled = false;
                }
                if (exMessage.contains(this.ORADNFS_OPERATION_FAILED)) {
                    Trace.out("Operation failed in oradnfs binary");
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.ORADNFS_ISPATHENABLED_FAIL, exMessage);
                }
                Trace.out("Remote execution error");
                throw new CmdToolUtilException(cte);
            }
        }
        return isEnabled;
    }
}

