/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class OPATCHUtil {
    private static final String SEMICOLON_STR = ";";
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle(PrCtMsgID.facility);
    private CmdToolUtil m_cmdtool;
    private String[] m_envs;
    private boolean m_isRemote = false;
    private String m_asUser = null;
    NativeSystem nativeSystem = new SystemFactory().CreateSystem();
    private final String OPATCHUTL = this.nativeSystem.getExeName("opatch");
    private static final String OPATCH_EXE_LOC = "OPatch";
    private final String[] OPATCHUTL_DEP = new String[]{this.OPATCHUTL};
    public static final String OPATCH_ORACLE_HOME_OPTION = "-oh";
    private static final String OPATCH_JDK_OPTION = "-jdk";
    private static final String OPATCH_OUI_OPTION = "-oui_loc";
    private static final String OPATCH_PATCH_OPTION = "-patch";
    private static final String OPATCH_INV_LOC_OPTION = "-invPtrLoc";
    public static final String OPATCH_BUGS_OPTION = "-bugs";
    private static final String OPATCH_BUGS_FIXED_OPTION = "-bugs_fixed";
    private static final String OPATCH_IS_ROLLING_PATCH_OPTION = "-is_rolling_patch";
    public static final String OPATCH_COMMAND_LSPATCHES = "lspatches";
    private static final String OPATCH_COMMAND_LSINVENTORY = "lsinventory";
    public static final String OPATCH_COMMAND_QUERY = "query";
    private static final String PATCH_LOC = "/inventory/oneoffs/";
    private static final String NO_PATCHES = "There are no Interim patches installed in this Oracle Home";
    private static final String IS_ROLLING_PATCH_FIELD = "Patch is a rolling patch";
    private static final String INTERIM_PATCHES = "Interim patches";
    private static final String PATCH = "Patch";
    private static final String DESCRIPTION = "description:";
    private static final String LSINVENTORY_SUCCEEDED = "OPatch succeeded";
    private static final String BUGS_FIXED = "List of Bugs fixed";
    private static final String REGEX_ONLY_DIGITS = "\\d+";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String LOCALNODE = "local=node";

    public OPATCHUtil(String crsHome) throws CmdToolUtilException {
        Object cHome = null;
        CmdToolUtil.assertDir(crsHome, true);
        String opatchLoc = crsHome + File.separator + OPATCH_EXE_LOC;
        this.m_cmdtool = new CmdToolUtil(this.OPATCHUTL, opatchLoc, this.OPATCHUTL_DEP);
        this.enforceEnglishVars();
    }

    public OPATCHUtil(String crsHome, RemoteUserInfo uInfo, String asUser) throws CmdToolUtilException, InvalidArgsException {
        oracle.cluster.impl.util.Utils.assertInput(crsHome, "OPATCHUtil-constr2-crsHome");
        oracle.cluster.impl.util.Utils.assertInput(asUser, "OPATCHUtil-constr2-asUser");
        oracle.cluster.impl.util.Utils.assertInputNotNull(uInfo, "OPATCHUtil-constr2-uInfo");
        String opatchLoc = crsHome + File.separator + OPATCH_EXE_LOC;
        this.m_cmdtool = new CmdToolUtil(uInfo, this.OPATCHUTL, opatchLoc);
        this.m_isRemote = true;
        this.enforceEnglishVars();
        this.m_asUser = asUser;
        Trace.out((Object)"cmd will be executed as %s", this.m_asUser);
    }

    public List<String> getIDPatchesLspatches(String oracleHome) throws CmdToolUtilException {
        return this.getIDPatchesLspatches(oracleHome, null);
    }

    public List<String> getIDPatchesLspatches(String oracleHome, String invLoc) throws CmdToolUtilException {
        String[] errorString;
        String[] args;
        CommandResult result = null;
        if (invLoc != null) {
            args = new String[]{OPATCH_COMMAND_LSPATCHES, OPATCH_ORACLE_HOME_OPTION, oracleHome, OPATCH_INV_LOC_OPTION, invLoc};
            result = this.m_cmdtool.executeLocally(args, this.m_envs, true);
        } else {
            args = new String[]{OPATCH_COMMAND_LSPATCHES, OPATCH_ORACLE_HOME_OPTION, oracleHome};
            result = this.m_cmdtool.executeLocally(args, this.m_envs, true);
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OPATCH_LSPATCHES_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultStr = result.getResultString();
        String[] output = null;
        output = resultStr != null && resultStr.length > 0 && resultStr[0].contains(NEWLINE) ? resultStr[0].split(NEWLINE) : resultStr;
        ArrayList<String> IDPatches = new ArrayList<String>();
        if (output == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OPATCH_LSPATCHES_FAIL_WITH_MSG, this.m_cmdtool.getSourceLocation());
        }
        for (String s : output) {
            if (s.contains(NO_PATCHES)) {
                return new ArrayList<String>();
            }
            String[] row = s.split(SEMICOLON_STR);
            String idPatch = row[0].trim();
            if (!this.isNumber(idPatch)) continue;
            IDPatches.add(idPatch);
        }
        return IDPatches;
    }

    public List<String> getIDPatchesLspatches(String oracleHome, String invLoc, String nodeName) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = null;
        ArrayList<String> argsLst = new ArrayList<String>();
        argsLst.add(OPATCH_COMMAND_LSPATCHES);
        argsLst.add(OPATCH_ORACLE_HOME_OPTION);
        argsLst.add(oracleHome);
        if (invLoc != null) {
            argsLst.add(OPATCH_INV_LOC_OPTION);
            argsLst.add(invLoc);
        }
        Object[] args = argsLst.toArray(new String[argsLst.size()]);
        Trace.out((Object)"Arguments are: %s", Arrays.toString(args));
        if (nodeName.equals(LOCALNODE)) {
            result = this.m_cmdtool.executeLocally((String[])args, this.m_envs, true);
        } else if (this.m_isRemote) {
            Trace.out((Object)"executing cmd as %s", this.m_asUser);
            result = this.m_cmdtool.execute(nodeName, (String[])args, this.m_envs, null, this.m_asUser, true);
        } else {
            result = this.m_cmdtool.execute(nodeName, (String[])args, this.m_envs, false, true);
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OPATCH_LSPATCHES_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultStr = result.getResultString();
        String[] output = null;
        output = resultStr != null && resultStr.length > 0 && resultStr[0].contains(NEWLINE) ? resultStr[0].split(NEWLINE) : resultStr;
        ArrayList<String> IDPatches = new ArrayList<String>();
        if (output == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OPATCH_LSPATCHES_FAIL_WITH_MSG, this.m_cmdtool.getSourceLocation());
        }
        for (String s : output) {
            if (s.contains(NO_PATCHES)) {
                return new ArrayList<String>();
            }
            String[] row = s.split(SEMICOLON_STR);
            String idPatch = row[0].trim();
            if (!this.isNumber(idPatch)) continue;
            IDPatches.add(idPatch);
        }
        return IDPatches;
    }

    public List<String> getIDPatchesLsinventory(String oracleHome) throws CmdToolUtilException {
        return this.getIDPatchesLsinventory(oracleHome, null);
    }

    public List<String> getIDPatchesLsinventory(String oracleHome, String invLoc) throws CmdToolUtilException {
        String[] errorString;
        String[] args;
        CommandResult result = null;
        if (invLoc != null) {
            args = new String[]{OPATCH_COMMAND_LSINVENTORY, OPATCH_PATCH_OPTION, OPATCH_ORACLE_HOME_OPTION, oracleHome, OPATCH_INV_LOC_OPTION, invLoc};
            result = this.m_cmdtool.executeLocally(args, this.m_envs, true);
        } else {
            args = new String[]{OPATCH_COMMAND_LSINVENTORY, OPATCH_PATCH_OPTION, OPATCH_ORACLE_HOME_OPTION, oracleHome};
            result = this.m_cmdtool.executeLocally(args, this.m_envs, true);
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OPATCH_LSINVENTORY_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultStr = result.getResultString();
        String[] output = null;
        output = resultStr != null && resultStr.length > 0 && resultStr[0].contains(NEWLINE) ? resultStr[0].split(NEWLINE) : resultStr;
        ArrayList<String> IDPatches = new ArrayList<String>();
        if (output[output.length - 1].contains(LSINVENTORY_SUCCEEDED)) {
            boolean hasPatches = false;
            String patch = null;
            for (String line : output) {
                String[] row;
                if (!hasPatches) {
                    if (!line.startsWith(INTERIM_PATCHES)) continue;
                    hasPatches = true;
                    continue;
                }
                if (!line.startsWith(PATCH) || (patch = (row = line.split("\\s+"))[1].trim()).toLowerCase().equals(DESCRIPTION)) continue;
                IDPatches.add(patch);
                Trace.out("Added patch: " + patch);
            }
            return IDPatches;
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, Utils.getString(output, NEWLINE));
    }

    public List<String> getBugNumbersLspatches(String oracleHome) throws CmdToolUtilException {
        return this.getBugNumbersLspatches(oracleHome, null);
    }

    public List<String> getBugNumbersLspatches(String oracleHome, String invLoc) throws CmdToolUtilException {
        return this.getBugNumbersLspatches(oracleHome, invLoc, LOCALNODE);
    }

    public List<String> getBugNumbersLspatches(String oracleHome, String invLoc, String nodeName) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = null;
        ArrayList<String> argsLst = new ArrayList<String>();
        argsLst.add(OPATCH_COMMAND_LSPATCHES);
        argsLst.add(OPATCH_BUGS_OPTION);
        argsLst.add(OPATCH_ORACLE_HOME_OPTION);
        argsLst.add(oracleHome);
        if (invLoc != null) {
            argsLst.add(OPATCH_INV_LOC_OPTION);
            argsLst.add(invLoc);
        }
        Object[] args = argsLst.toArray(new String[argsLst.size()]);
        Trace.out((Object)"Arguments are: %s", Arrays.toString(args));
        if (nodeName.equals(LOCALNODE)) {
            result = this.m_cmdtool.executeLocally((String[])args, this.m_envs, true);
        } else if (this.m_isRemote) {
            Trace.out((Object)"executing cmd as %s", this.m_asUser);
            result = this.m_cmdtool.execute(nodeName, (String[])args, this.m_envs, null, this.m_asUser, true);
        } else {
            result = this.m_cmdtool.execute(nodeName, (String[])args, this.m_envs, false, true);
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OPATCH_LSPATCHES_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultStr = result.getResultString();
        String[] output = null;
        output = resultStr != null && resultStr.length > 0 && resultStr[0].contains(NEWLINE) ? resultStr[0].split(NEWLINE) : resultStr;
        ArrayList<String> bugNumbers = new ArrayList<String>();
        for (String s : output) {
            if (s.contains(NO_PATCHES)) {
                return new ArrayList<String>();
            }
            String[] row = s.split(SEMICOLON_STR);
            String bugNums = row[row.length - 1].trim();
            for (String bug : row = bugNums.split(",")) {
                if (!this.isNumber(bug.trim())) continue;
                bugNumbers.add(bug.trim());
            }
        }
        return bugNumbers;
    }

    public List<String> getBugNumbersLsinventory(String oracleHome) throws CmdToolUtilException {
        return this.getBugNumbersLsinventory(oracleHome, null);
    }

    public List<String> getBugNumbersLsinventory(String oracleHome, String invLoc) throws CmdToolUtilException {
        return this.getBugNumbersLsinventory(oracleHome, invLoc, LOCALNODE);
    }

    public List<String> getBugNumbersLsinventory(String oracleHome, String invLoc, String nodeName) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = null;
        ArrayList<String> argsLst = new ArrayList<String>();
        argsLst.add(OPATCH_COMMAND_LSINVENTORY);
        argsLst.add(OPATCH_PATCH_OPTION);
        argsLst.add(OPATCH_BUGS_FIXED_OPTION);
        argsLst.add(OPATCH_ORACLE_HOME_OPTION);
        argsLst.add(oracleHome);
        if (invLoc != null) {
            argsLst.add(OPATCH_INV_LOC_OPTION);
            argsLst.add(invLoc);
        }
        Object[] args = argsLst.toArray(new String[argsLst.size()]);
        Trace.out((Object)"Arguments are: %s", Arrays.toString(args));
        if (nodeName.equals(LOCALNODE)) {
            result = this.m_cmdtool.executeLocally((String[])args, this.m_envs, true);
        } else if (this.m_isRemote) {
            Trace.out((Object)"executing cmd as %s", this.m_asUser);
            result = this.m_cmdtool.execute(nodeName, (String[])args, this.m_envs, null, this.m_asUser, true);
        } else {
            result = this.m_cmdtool.execute(nodeName, (String[])args, this.m_envs, false, true);
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OPATCH_LSINVENTORY_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultStr = result.getResultString();
        String[] output = null;
        output = resultStr != null && resultStr.length > 0 && resultStr[0].contains(NEWLINE) ? resultStr[0].split(NEWLINE) : resultStr;
        ArrayList<String> bugNumbers = new ArrayList<String>();
        if (output == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OPATCH_LSPATCHES_FAIL_WITH_MSG, this.m_cmdtool.getSourceLocation());
        }
        if (output[output.length - 1].contains(LSINVENTORY_SUCCEEDED)) {
            boolean hasBugs = false;
            String bug = null;
            for (String line : output) {
                if (!hasBugs) {
                    if (!line.startsWith(BUGS_FIXED)) continue;
                    hasBugs = true;
                    continue;
                }
                String[] row = line.split("\\s+");
                try {
                    bug = row[0].trim();
                    Integer.parseInt(bug);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                bugNumbers.add(bug);
                Trace.out("Added bug num: " + bug);
            }
            return bugNumbers;
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, Utils.getString(output, NEWLINE));
    }

    public boolean isRollingPatch(String oracleHome, String patchID, String node) throws InvalidArgsException, CmdToolUtilException {
        String[] output;
        String[] errorString;
        oracle.cluster.impl.util.Utils.assertInput(oracleHome, "OPATCHUtil-isRollingPatch-home");
        oracle.cluster.impl.util.Utils.assertInput(patchID, "OPATCHUtil-isRollingPatch-patchID");
        Trace.out("checking if patch %s in home %s is a rolling patch ...", patchID, oracleHome);
        CommandResult result = null;
        ArrayList<String> argsLst = new ArrayList<String>();
        argsLst.add(OPATCH_COMMAND_QUERY);
        argsLst.add(OPATCH_IS_ROLLING_PATCH_OPTION);
        argsLst.add(oracleHome + PATCH_LOC + patchID);
        argsLst.add(OPATCH_ORACLE_HOME_OPTION);
        argsLst.add(oracleHome);
        Object[] args = argsLst.toArray(new String[0]);
        Trace.out((Object)"arguments : %s", Arrays.toString(args));
        if (node == null || LOCALNODE.equals(node)) {
            result = this.m_cmdtool.executeLocally((String[])args, this.m_envs, true);
        } else if (this.m_isRemote) {
            Trace.out((Object)"executing cmd as %s using jsch", this.m_asUser);
            result = this.m_cmdtool.execute(node, (String[])args, this.m_envs, null, this.m_asUser, true);
        } else {
            result = this.m_cmdtool.execute(node, (String[])args, this.m_envs, false, true);
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OPATCH_ISROLLINGPATCH_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultStr = result.getResultString();
        String[] stringArray = output = resultStr != null && resultStr.length > 0 && resultStr[0].contains(NEWLINE) ? resultStr[0].split(NEWLINE) : resultStr;
        if (output == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "OPATCHUtil-isRollingPatch-1");
        }
        for (String line : output) {
            Trace.out((Object)"output line : %s", line);
            if (!line.contains(IS_ROLLING_PATCH_FIELD)) continue;
            String[] row = line.split(":");
            if (row.length < 2 || row[1] == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "OPATCHUtil-isRollingPatch-2");
            }
            Trace.out("split vals : %s", Arrays.asList(row));
            return Boolean.valueOf(row[1].trim());
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "OPATCHUtil-isRollingPatch-3");
    }

    private void enforceEnglishVars() {
        Trace.out("Set environment for English language");
        this.m_envs = new String[2];
        this.m_envs[0] = "LANG=en_US.UTF-8";
        this.m_envs[1] = "NLS_LANG=American_America.UTF8";
        if (System.getenv("HAS_DEVELOPMENT_ENVIRONMENT") != null) {
            Trace.out("Development environment, inherit variables");
            this.inheritEnvironment();
        }
    }

    private void inheritEnvironment() {
        HashMap<String, String> currentEnv = new HashMap<String, String>(System.getenv());
        ArrayList<String> execEnv = new ArrayList<String>();
        if (this.m_isRemote) {
            return;
        }
        if (this.m_envs != null) {
            for (String element : this.m_envs) {
                String[] splitVar = element.split("=");
                if (currentEnv.containsKey(splitVar[0])) {
                    currentEnv.remove(splitVar[0]);
                }
                currentEnv.put(splitVar[0], splitVar.length == 1 ? "" : splitVar[1]);
            }
        }
        for (Map.Entry entry : currentEnv.entrySet()) {
            execEnv.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        this.m_envs = execEnv.toArray(new String[execEnv.size()]);
    }

    private boolean isNumber(String num) {
        if (num.matches(REGEX_ONLY_DIGITS)) {
            return true;
        }
        Trace.out((Object)"The string %s is not a number", num);
        return false;
    }
}

