/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.common.NodeRole;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class OLSNODESUtil {
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle(PrCtMsgID.facility);
    NativeSystem nativeSystem = new SystemFactory().CreateSystem();
    private final String OLSNUTL = this.nativeSystem.getExeName("olsnodes");
    private static final String OLSN_EXE_LOC = "bin";
    private final String[] OLSNUTL_DEP = new String[]{this.OLSNUTL};
    private static final String OLSN_CLUSTER_NAME = "-c";
    private static final String OLSN_NODE_STATUS = "-s";
    private static final String OLSN_NODE_PINSTAT = "-t";
    private static final String OLSN_NODE_PRIVATE_IP_ALL = "-p";
    private static final String OLSN_ACTIVE_NODE_ROLE = "-a";
    private static final String OLSN_HISTORICAL_NODE_LIST = "-f";
    private static final String DELIMITER = "\\s+";
    private static final String NEWLINE = "\\n";
    private static final String NODE_ACTIVE_STATE = "Active";
    private static final String NODE_INACTIVE_STATE = "Inactive";
    private static final String NODE_PINNED_STATE = "Pinned";
    private static final String NODE_UNPINNED_STATE = "Unpinned";
    private CmdToolUtil m_cmdtool;
    private String m_remoteNode = null;

    public OLSNODESUtil(String crsHome) throws CmdToolUtilException {
        CmdToolUtil.assertDir(crsHome, true);
        String olsnloc = crsHome + File.separator + OLSN_EXE_LOC;
        this.m_cmdtool = new CmdToolUtil(this.OLSNUTL, olsnloc, this.OLSNUTL_DEP);
    }

    public OLSNODESUtil(String node, String crsHome) throws CmdToolUtilException {
        CmdToolUtil.assertNode(node);
        CmdToolUtil.assertDir(crsHome, false);
        String olsnloc = crsHome + File.separator + OLSN_EXE_LOC;
        this.m_cmdtool = new CmdToolUtil(this.OLSNUTL, olsnloc, this.OLSNUTL_DEP);
        this.m_remoteNode = node;
    }

    public String getClusterName() throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = this.m_cmdtool.execute(new String[]{OLSN_CLUSTER_NAME}, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.FAILED_TO_GET_ORCL_CLUSTER_NAME, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] res = result.getResultString();
        if (res == null || res.length <= 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OLSNODES_EMPTY_RESULT_ORCL_CLUSTER_NAME, new Object[0]);
        }
        Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
        res[0] = res[0].trim();
        return res[0];
    }

    private Map<String, String> getClusterNodeStatus() throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = this.m_cmdtool.execute(new String[]{OLSN_NODE_STATUS}, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.FAILED_TO_GET_NODE_STATUS, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
        String[] outputs = result.getResultString();
        HashMap<String, String> nodemap = null;
        if (outputs != null && outputs.length > 0) {
            int outputLen = outputs != null ? outputs.length : 0;
            nodemap = new HashMap<String, String>(outputLen);
            for (int i = 0; i < outputLen; ++i) {
                Trace.out("outputs[" + i + "] = " + outputs[i]);
                String[] values = outputs[i].trim().split(DELIMITER);
                Trace.out("values length = " + values.length);
                Trace.out("nodename = " + values[0]);
                Trace.out("nodestat = " + values[1]);
                if (values.length != 2) continue;
                nodemap.put(values[0], values[1]);
            }
        } else {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OLSNODES_EMPTY_RESULT, new Object[0]);
        }
        return nodemap;
    }

    public List<String> getActiveClusterNodes() throws CmdToolUtilException {
        Map<String, String> clustNodeStat = null;
        ArrayList<String> actNodelist = new ArrayList<String>();
        clustNodeStat = this.getClusterNodeStatus();
        for (Map.Entry<String, String> entry : clustNodeStat.entrySet()) {
            String nodename = entry.getKey();
            String status = entry.getValue();
            Trace.out("nodename = " + nodename);
            Trace.out("status   = " + status);
            if (!status.equals(NODE_ACTIVE_STATE)) continue;
            actNodelist.add(nodename);
        }
        return actNodelist;
    }

    public List<String> getInactiveClusterNodes() throws CmdToolUtilException {
        Map<String, String> clustNodeStat = null;
        ArrayList<String> inactNodelist = new ArrayList<String>();
        clustNodeStat = this.getClusterNodeStatus();
        for (Map.Entry<String, String> entry : clustNodeStat.entrySet()) {
            String nodename = entry.getKey();
            String status = entry.getValue();
            Trace.out("nodename = " + nodename);
            Trace.out("status   = " + status);
            if (!status.equals(NODE_INACTIVE_STATE)) continue;
            inactNodelist.add(nodename);
        }
        return inactNodelist;
    }

    private Map<String, String> getClusterNodesPinMap() throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = this.m_cmdtool.execute(new String[]{OLSN_NODE_PINSTAT}, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.FAILED_TO_GET_NODE_STATUS, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
        String[] outputs = result.getResultString();
        HashMap<String, String> nodemap = null;
        if (outputs != null && outputs.length > 0) {
            int outputLen = outputs != null ? outputs.length : 0;
            nodemap = new HashMap<String, String>(outputLen);
            for (int i = 0; i < outputLen; ++i) {
                Trace.out("outputs[" + i + "] = " + outputs[i]);
                String[] values = outputs[i].trim().split(DELIMITER);
                Trace.out("values length = " + values.length);
                Trace.out("nodename = " + values[0]);
                Trace.out("nodestat = " + values[1]);
                if (values.length != 2) continue;
                nodemap.put(values[0], values[1]);
            }
        } else {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OLSNODES_EMPTY_RESULT1, new Object[0]);
        }
        return nodemap;
    }

    public List<String> getPinnedClusterNodes() throws CmdToolUtilException {
        Map<String, String> clustNodeStat = null;
        ArrayList<String> pinNodelist = new ArrayList<String>();
        clustNodeStat = this.getClusterNodesPinMap();
        for (Map.Entry<String, String> entry : clustNodeStat.entrySet()) {
            String nodename = entry.getKey();
            String status = entry.getValue();
            Trace.out("nodename = " + nodename);
            Trace.out("status   = " + status);
            if (!status.equals(NODE_PINNED_STATE)) continue;
            pinNodelist.add(nodename);
        }
        return pinNodelist;
    }

    public List<String> getUnpinnedClusterNodes() throws CmdToolUtilException {
        Map<String, String> clustNodeStat = null;
        ArrayList<String> unpinNodelist = new ArrayList<String>();
        clustNodeStat = this.getClusterNodesPinMap();
        for (Map.Entry<String, String> entry : clustNodeStat.entrySet()) {
            String nodename = entry.getKey();
            String status = entry.getValue();
            Trace.out("nodename = " + nodename);
            Trace.out("status   = " + status);
            if (!status.equals(NODE_UNPINNED_STATE)) continue;
            unpinNodelist.add(nodename);
        }
        return unpinNodelist;
    }

    public HashMap<String, String> getClusterPrivateHosts() throws CmdToolUtilException {
        Object[] errorString;
        CommandResult result = this.m_cmdtool.execute(new String[]{OLSN_NODE_PRIVATE_IP_ALL}, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OLSNODES_FAILED_GET_PRIVATE_HOSTNAME, errorString);
        }
        Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
        String[] outputs = result.getResultString();
        HashMap<String, String> nodePrivateHostNameMap = null;
        if (outputs != null && outputs.length > 0) {
            int outputLen = outputs != null ? outputs.length : 0;
            nodePrivateHostNameMap = new HashMap<String, String>(outputLen);
            for (int i = 0; i < outputLen; ++i) {
                Trace.out("outputs[" + i + "] = " + outputs[i]);
                String[] values = outputs[i].trim().split(DELIMITER);
                Trace.out("values length = " + values.length);
                if (values.length != 2) continue;
                Trace.out("nodename = " + values[0]);
                Trace.out("node private hostname = " + values[1]);
                nodePrivateHostNameMap.put(values[0], values[1]);
            }
        } else {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OLSNODES_EMPTY_RESULT2, new Object[0]);
        }
        return nodePrivateHostNameMap;
    }

    public HashMap<String, NodeRole> getClusterNodeRoles() throws CmdToolUtilException {
        Object[] errorString;
        CommandResult result = this.m_cmdtool.executeLocally(new String[]{OLSN_ACTIVE_NODE_ROLE}, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OLSNODES_GET_ACTIVE_NODE_ROLE_FAILED, errorString);
        }
        Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
        String[] outputs = result.getResultString();
        HashMap<String, NodeRole> nodeRoleMap = null;
        if (outputs != null && outputs.length > 0) {
            int outputLen = outputs.length;
            nodeRoleMap = new HashMap<String, NodeRole>(outputLen);
            for (int i = 0; i < outputLen; ++i) {
                Trace.out("outputs[" + i + "] = " + outputs[i]);
                String[] values = outputs[i].trim().split(DELIMITER);
                Trace.out("values length = " + values.length);
                if (values.length == 2) {
                    if (NodeRole.NONE == NodeRole.getEnumMember(values[1].toString())) {
                        nodeRoleMap.put(values[0], NodeRole.HUB);
                        continue;
                    }
                    nodeRoleMap.put(values[0], NodeRole.getEnumMember(values[1].toString()));
                    continue;
                }
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.OLSNODES_EXECUTION_FAILED, new Object[0]);
            }
        } else {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OLSNODES_EMPTY_RESULT3, new Object[0]);
        }
        return nodeRoleMap;
    }

    public HashMap<String, NodeRole> getClusterNodeActiveRoles() throws CmdToolUtilException {
        Object[] errorString;
        CommandResult result = this.m_cmdtool.executeLocally(new String[]{OLSN_ACTIVE_NODE_ROLE}, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OLSNODES_GET_ACTIVE_NODE_ROLE_FAILED, errorString);
        }
        Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
        String[] outputs = result.getResultString();
        HashMap<String, NodeRole> nodeActiveRoleMap = null;
        if (outputs != null && outputs.length > 0) {
            int outputLen = outputs.length;
            nodeActiveRoleMap = new HashMap<String, NodeRole>(outputLen);
            for (int i = 0; i < outputLen; ++i) {
                Trace.out("outputs[" + i + "] = " + outputs[i]);
                this.parseNodeRole(outputs[i], nodeActiveRoleMap);
            }
        } else {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OLSNODES_EMPTY_RESULT3, new Object[0]);
        }
        return nodeActiveRoleMap;
    }

    private void parseNodeRole(String outputLine, HashMap<String, NodeRole> nodeActiveRoleMap) throws CmdToolUtilException {
        String[] values = outputLine.trim().split(DELIMITER);
        Trace.out("values length = " + values.length);
        if (values.length != 2) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OLSNODES_EXECUTION_FAILED, new Object[0]);
        }
        Trace.out("putting values " + values[0].toString() + " " + values[1].toString() + " in map");
        nodeActiveRoleMap.put(values[0], NodeRole.getEnumMember(values[1].toString()));
    }

    public String getRemoteClusterName() throws CmdToolUtilException {
        String[] errorString;
        ArrayList nodelist = new ArrayList();
        CmdToolUtil.assertNode(this.m_remoteNode);
        CommandResult result = this.m_cmdtool.execute(this.m_remoteNode, new String[]{OLSN_CLUSTER_NAME});
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed to obtain cluster name.");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.FAILED_TO_GET_CLUSTER_NAME, this.m_remoteNode);
        }
        String[] outputs = result.getResultString();
        if (outputs == null || outputs.length <= 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OLSNODES_EMPTY_RESULT, new Object[0]);
        }
        Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
        outputs[0] = outputs[0].trim();
        return outputs[0];
    }

    public List<String> getHistoricalClusterNodes() throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = this.m_cmdtool.execute(new String[]{OLSN_HISTORICAL_NODE_LIST}, null);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.FAILED_TO_GET_HISTORICAL_NODE_LIST, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
        String[] outputs = result.getResultString();
        ArrayList<String> nodeList = new ArrayList<String>();
        if (outputs != null && outputs.length > 0) {
            int outputLen = outputs != null ? outputs.length : 0;
            for (int i = 0; i < outputLen; ++i) {
                Trace.out("outputs[" + i + "] = " + outputs[i]);
                nodeList.add(outputs[i].trim());
            }
        }
        return nodeList;
    }
}

