/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class OIFCFGUtil {
    public static final String OIFCFGUTL = new SystemFactory().CreateSystem().getExeName("oifcfg");
    private static final String OIFCFG_GETIF = "getif";
    private static final String OIFCFG_SETIF = "setif";
    private static final String OIFCFG_IFLIST = "iflist";
    private static final String OIFCFG_PROFILE = "-from";
    private static final String OIFCFG_GPNP = "gpnp";
    private static final String OIFCFG_OCR = "ocr";
    private static final String OIFCFG_GLOBAL = "-global";
    private static final String OIFCFG_NODENAME = "-nodename";
    private static final String OIFCFG_IFTYPEASM = "asm";
    private static final String OIFCFG_IFTYPECIASM = "cluster_interconnect,asm";
    private static final String OIFCFG_TYPE = "-p";
    private static final String OIFCFG_MASK = "-n";
    private static final String[] OIFCFGUTL_DEP = new String[]{OIFCFGUTL};
    private static final boolean IS_UNIX_SYSTEM = new SystemFactory().CreateSystem().isUnixSystem();
    private static final String FSEP = System.getProperty("file.separator");
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private CmdToolUtil m_cmdTool;
    private boolean m_skipCopy;
    private boolean m_useLightWeight;

    public OIFCFGUtil(String oifcfgSrcLoc) throws CmdToolUtilException {
        this(oifcfgSrcLoc, false, false);
    }

    public OIFCFGUtil(String oifcfgSrcLoc, boolean useLightWeight) throws CmdToolUtilException {
        this(oifcfgSrcLoc, false, useLightWeight);
    }

    public OIFCFGUtil(String oifcfgSrcLoc, boolean skipCopy, boolean useLightWeight) throws CmdToolUtilException {
        this.m_skipCopy = skipCopy;
        this.m_useLightWeight = useLightWeight;
        CmdToolUtil.assertDir(oifcfgSrcLoc, false);
        String oifcfgDestLoc = skipCopy ? oifcfgSrcLoc : this.getTempLoc();
        this.m_cmdTool = new CmdToolUtil(OIFCFGUTL, oifcfgSrcLoc, oifcfgDestLoc, OIFCFGUTL_DEP);
    }

    private String getTempLoc() throws CmdToolUtilException {
        long l = System.currentTimeMillis();
        String subDir = "oifcfg" + Long.toHexString(l);
        return TEMP_DIR + FSEP + subDir;
    }

    public List<OIFCFGResult> listInterfaces(String nodeName) throws CmdToolUtilException {
        String[] args = this.m_useLightWeight ? new String[]{OIFCFG_TYPE, OIFCFG_MASK} : new String[]{OIFCFG_IFLIST, OIFCFG_TYPE, OIFCFG_MASK};
        String[] cmdOutput = this.getOifcfgCmdOutput(nodeName, args);
        return this.parseOutput(cmdOutput, nodeName, args[0]);
    }

    public List<OIFCFGResult> listClusterInterfaces() throws CmdToolUtilException {
        String[] args = new String[]{OIFCFG_GETIF, OIFCFG_PROFILE, OIFCFG_GPNP};
        String[] cmdOutput = this.getOifcfgCmdOutput("localnode", args);
        return this.parseOutput(cmdOutput, "localnode", args[0]);
    }

    public List<OIFCFGResult> listClusterInterfaces(Version version) throws CmdToolUtilException {
        if (!Version.isPre12c(version)) {
            return this.listClusterInterfaces();
        }
        String[] args = new String[]{OIFCFG_GETIF};
        String[] cmdOutput = this.getOifcfgCmdOutput("localnode", args);
        return this.parseOutput(cmdOutput, "localnode", args[0]);
    }

    public List<OIFCFGResult> listClusterInterfacesInOCR() throws CmdToolUtilException {
        String[] args = new String[]{OIFCFG_GETIF, OIFCFG_PROFILE, OIFCFG_OCR};
        String[] cmdOutput = this.getOifcfgCmdOutput("localnode", args);
        return this.parseOutput(cmdOutput, "localnode", args[0]);
    }

    private List<OIFCFGResult> parseOutput(String[] cmdOutput, String nodeName, String arg) throws CmdToolUtilException {
        ArrayList<OIFCFGResult> list = new ArrayList<OIFCFGResult>(cmdOutput.length);
        String interfaceName = null;
        String subnetStr = null;
        InetAddress subnet = null;
        String interfaceType = null;
        String subnetMaskStr = null;
        String nodeScope = null;
        InetAddress subnetMaskIPv4 = null;
        int prefixLengthIPv6 = -1;
        for (int i = 0; i < cmdOutput.length; ++i) {
            OIFCFGResult temp_OIFCFGResult;
            boolean isIPv6Result;
            cmdOutput[i] = cmdOutput[i].trim();
            Trace.out("OUTPUT RESULT LINE #" + i + " -->" + cmdOutput[i]);
            if (Utils.isDevelopmentEnv() && cmdOutput[i].startsWith("PRIF-51:")) continue;
            StringTokenizer tokenizer = new StringTokenizer(cmdOutput[i], " ");
            int numOfTokens = tokenizer.countTokens();
            boolean bl = isIPv6Result = cmdOutput[i].indexOf(":") != -1;
            if (numOfTokens < 4) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.NOT_ENOUGH_OIFCFG_RESULT_FIELDS, cmdOutput[i]);
            }
            String[] tokens = new String[numOfTokens];
            int tokenIndex = 0;
            while (tokenizer.hasMoreElements()) {
                tokens[tokenIndex] = tokenizer.nextToken();
                ++tokenIndex;
            }
            if (this.m_useLightWeight || arg.equals(OIFCFG_IFLIST)) {
                block19: {
                    subnetMaskStr = tokens[numOfTokens - 1];
                    if (isIPv6Result) {
                        try {
                            if (subnetMaskStr.startsWith("/")) {
                                subnetMaskStr = subnetMaskStr.substring(1);
                            }
                            if ((prefixLengthIPv6 = Integer.valueOf(subnetMaskStr).intValue()) < 0 || prefixLengthIPv6 > 128) {
                                throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_IPV6_PREFIX_LENGTH, subnetMaskStr);
                            }
                            break block19;
                        }
                        catch (NumberFormatException nfe) {
                            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_IPV6_PREFIX_LENGTH, subnetMaskStr);
                        }
                    }
                    try {
                        subnetMaskIPv4 = InetAddress.getByName(subnetMaskStr);
                    }
                    catch (UnknownHostException uhe) {
                        throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_IPADDR_FORMAT, subnetMaskStr);
                    }
                }
                interfaceType = tokens[numOfTokens - 2];
                nodeScope = nodeName;
            } else if (arg.equals(OIFCFG_GETIF)) {
                subnetMaskIPv4 = null;
                prefixLengthIPv6 = 128;
                interfaceType = tokens[numOfTokens - 1];
                nodeScope = tokens[numOfTokens - 2];
            }
            subnetStr = tokens[numOfTokens - 3];
            try {
                subnet = InetAddress.getByName(subnetStr);
            }
            catch (UnknownHostException uhe) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_IPADDR_FORMAT, subnetStr);
            }
            int interfaceNameEndIndex = cmdOutput[i].indexOf(subnetStr);
            interfaceName = cmdOutput[i].substring(0, interfaceNameEndIndex).trim();
            if (isIPv6Result) {
                try {
                    temp_OIFCFGResult = new OIFCFGResult(interfaceName, subnet, interfaceType, prefixLengthIPv6, nodeScope);
                }
                catch (IPAddressException ipae) {
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "invalid-ipv6-prefix-length-error_1");
                }
            } else {
                temp_OIFCFGResult = new OIFCFGResult(interfaceName, subnet, interfaceType, subnetMaskIPv4, nodeScope);
            }
            list.add(temp_OIFCFGResult);
        }
        return list;
    }

    public String[] getOifcfgCmdOutput(String nodeName) throws CmdToolUtilException {
        String[] args = this.m_useLightWeight ? new String[]{OIFCFG_TYPE, OIFCFG_MASK} : new String[]{OIFCFG_IFLIST, OIFCFG_TYPE, OIFCFG_MASK};
        return this.getOifcfgCmdOutput(nodeName, args);
    }

    public void setASMNetwork(String ifname, String subnet, boolean clusterInterconnect) throws CmdToolUtilException {
        String quoteStr = "";
        Object[] args = new String[3];
        args[0] = OIFCFG_SETIF;
        args[1] = OIFCFG_GLOBAL;
        boolean isWindows = !new SystemFactory().CreateSystem().isUnixSystem();
        quoteStr = isWindows ? "\\\"" : "\"";
        args[2] = !clusterInterconnect ? quoteStr + ifname + quoteStr + "/" + subnet + ":" + OIFCFG_IFTYPEASM : quoteStr + ifname + quoteStr + "/" + subnet + ":" + OIFCFG_IFTYPECIASM;
        Trace.out("Arguments: " + Arrays.toString(args));
        String[] cmdOutput = this.getOifcfgCmdOutput("localnode", (String[])args);
    }

    private String[] getOifcfgCmdOutput(String nodeName, String[] args) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result;
        String[] env = null;
        if (nodeName.equals("localnode")) {
            result = this.m_cmdTool.executeLocally(args, env, true);
        } else {
            boolean mustCopy = !this.m_skipCopy;
            result = this.m_cmdTool.execute(nodeName, args, env, mustCopy, true);
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdTool.execute failed ");
            StringBuilder stringBuilder = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                stringBuilder.append(errorString[i]);
            }
            if (nodeName == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.OIFCFG_FAIL, stringBuilder.toString());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OIFCFG_NODE_FAIL, nodeName, stringBuilder.toString());
        }
        return result.getResultString();
    }

    public OIFCFGResult getOIFCFGResultObj(String interfaceName, InetAddress subnet, String interfaceType, InetAddress subnetMask, String nodeScope) {
        return new OIFCFGResult(interfaceName, subnet, interfaceType, subnetMask, nodeScope);
    }
}

