/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class MGMTCAUtil {
    private CmdToolUtil m_cmdtool;
    private String m_nodeName;
    NativeSystem nativeSystem = new SystemFactory().CreateSystem();
    private final String MGMTCA = this.nativeSystem.getScriptFileName("mgmtca");
    private static final String EXE_LOC = "bin";
    private final String[] MGMTCA_DEP = new String[]{this.MGMTCA};
    private static final String SETPASSWD = "setpasswd";
    private static final String RESETREPOS = "resetRepos";
    private static final String MIGRATE_RHP_SCHEMA = "migrateRHPSchema";
    private static final String USER_OPT = "-user";
    private static final String GRIDHOME = "gridhome";
    private static final String FROM_OPT = "-from";
    private static final String TO_OPT = "-to";
    private static final String NEWLINE = "\\n";

    public MGMTCAUtil(String crshome, String nodeName) throws CmdToolUtilException {
        CmdToolUtil.assertDir(crshome, true);
        String toolLoc = crshome + File.separator + EXE_LOC;
        this.m_cmdtool = new CmdToolUtil(this.MGMTCA, toolLoc, this.MGMTCA_DEP);
        this.m_nodeName = nodeName;
    }

    public void createGHCredentials() throws CmdToolUtilException {
        this.setGHSUserPass();
    }

    public void setGHSUserPass() throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{SETPASSWD, USER_OPT, GRIDHOME};
        CommandResult result = this.m_cmdtool.execute(this.m_nodeName, args, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed on node, " + this.m_nodeName);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.MGMTCA_SETPWD_FAIL, this.m_nodeName, Utils.getString(errorString, NEWLINE));
        }
    }

    public void resetRepos() throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{RESETREPOS, USER_OPT, GRIDHOME};
        CommandResult result = this.m_cmdtool.execute(this.m_nodeName, args, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed on node, " + this.m_nodeName);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.MGMTCA_RESETREPOS_FAIL, this.m_nodeName, Utils.getString(errorString, NEWLINE));
        }
    }

    public void migrateRHPSchema(String oldSchema, String newSchema) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{MIGRATE_RHP_SCHEMA, FROM_OPT, oldSchema, TO_OPT, newSchema};
        CommandResult result = this.m_cmdtool.execute(this.m_nodeName, args, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed on node %s with error %s", this.m_nodeName, Utils.getString(errorString, NEWLINE));
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "MGMTCAUtil-migrateRHPSchema-error");
        }
    }
}

