/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class KFODUtil {
    private CmdToolUtil m_cmdtool;
    private RemoteUserInfo m_uInfo = null;
    NativeSystem nativeSystem = new SystemFactory().CreateSystem();
    private final String KFODUTL_CMD = this.nativeSystem.getExeName("kfod");
    private final String KFODUTL_CMD_BIN = "kfod.bin";
    private final String[] KFODUTL_DEP = new String[]{this.KFODUTL_CMD};
    private final String[] KFODUTL_DEP_BIN = new String[]{"kfod.bin"};
    private static boolean m_isPreGIInst = false;
    private static final String KFODUTL_ARG_NOHDR = "nohdr=";
    private static final String KFODUTL_ARG_OP = "op=";
    private static final String KFODUTL_ARG_NODELIST = "hostlist=";
    private static final String KFODUTL_ARG_WRAP = "wrap=";
    private static final String KFODUTL_ARG_DI = "disks=";
    private static final String KFODUTL_ARG_ASM_ALLOW_ONLY_RAW_DISKS = "_asm_allow_only_raw_disks=";
    private static final String KFODUTL_ARG_ASM_DISKSTRING = "asm_diskstring=";
    private static final String KFODUTL_ARG_BOOT = "_boot=";
    private static final String KFODUTL_ARG_DSCVGROUP = "dscvgroup=";
    private static final String KFODUTL_NOHDR_TRUE = "true";
    private static final String KFODUTL_OP_GROUPS = "groups";
    private static final String KFODUTL_OP_INSTS = "insts";
    private static final String KFODUTL_OP_VERSION = "version";
    private static final String KFODUTL_RM = "rm";
    private static final String KFODUTL_OP_WRAP = "verifywrap";
    private static final String KFODUTL_OP_DISKS = "disks";
    private static final String KFODUTL_OP_DISKS_ARG = "disks";
    private static final String KFODUTL_OP_DISKS_ASM = "disks=asm";
    private static final String KFODUTL_OP_STATUS = "status=true";
    private static final String KFODUTL_OP_DEFAULT_DISCSTR = "DFLTDSTR";
    private static final String KFODUTL_OP_CREDVERIFY = "credverify";
    private static final String KFODUTL_OP_BOOT_TRUE = "TRUE";
    private static final String KFODUTL_DSCVGROUP_TRUE = "TRUE";
    private static final String KFODUTL_DI_ALL = "all";
    private static final String KFODUTL_BAD_SIZE = "badsize";
    private static final String KFODUTL_ASM_ALLOW_ONLY_RAW_DISKS_FALSE = "false";
    private static final String KFODUTL_OP_LABEL_TRUE = "LABEL=TRUE";
    private static final String KFODUTL_ASM_DISKSTRING_NOT_AP = "NA";
    private static final String KFODUTL_DISK_NOT_LABELED_TOKEN = "#";
    private static final String KFODUTL_OUTPUT_YES = "YES";
    private static final String KFODUTL_OUTPUT_NO = "NO";
    private static final String KFODUTL_OUTPUT_MEMBER = "member";
    private static final String KFOD_MSGID_1001 = "KFOD-01001: ";
    private static final String DELIMITER = "\\s+";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String COLON = ":";
    private static final String FSEP = System.getProperty("file.separator");
    private static final String LD_LIBRARY_PATH_ENV = "LD_LIBRARY_PATH";
    private static final String LD_LIBRARY_PATH64_ENV = "LD_LIBRARY_PATH_64";
    private static final String LIBPATH_ENV = "LIBPATH";
    private static final String ORACLE_HOME_ENV = "ORACLE_HOME";

    public KFODUtil() throws CmdToolUtilException {
        String[] cmddep;
        String cmd;
        Trace.out("Calling KFODUtil() constructor");
        String classLocation = CmdToolUtil.getClassLocation(this.getClass());
        String cmdLocation = CmdToolUtil.getSourceLocation(classLocation, this.KFODUTL_CMD);
        if (cmdLocation != null) {
            cmd = this.KFODUTL_CMD;
            cmddep = this.KFODUTL_DEP;
        } else {
            cmdLocation = CmdToolUtil.getSourceLocation(classLocation, "kfod.bin");
            if (cmdLocation != null) {
                cmd = "kfod.bin";
                cmddep = this.KFODUTL_DEP_BIN;
                m_isPreGIInst = true;
            } else {
                String crshome = null;
                NativeSystem system = new SystemFactory().CreateSystem();
                try {
                    crshome = system.getCRSHome(new Version());
                }
                catch (NativeException e) {
                    throw new CmdToolUtilException((MessageKey)PrCfMsgID.BINARY_NOT_FOUND, (Throwable)e, this.KFODUTL_CMD);
                }
                cmdLocation = crshome + FSEP + "bin";
                cmd = this.KFODUTL_CMD;
                cmddep = this.KFODUTL_DEP;
            }
        }
        this.m_cmdtool = new CmdToolUtil(cmd, cmdLocation, cmddep);
    }

    public KFODUtil(String location) throws CmdToolUtilException {
        this(location, false);
    }

    public KFODUtil(String location, boolean isPreGIInst) throws CmdToolUtilException {
        CmdToolUtil.assertDir(location, true);
        m_isPreGIInst = isPreGIInst;
        this.m_cmdtool = this.nativeSystem.isUnixSystem() && isPreGIInst ? new CmdToolUtil("kfod.bin", location, this.KFODUTL_DEP_BIN) : new CmdToolUtil(this.KFODUTL_CMD, location, this.KFODUTL_DEP);
    }

    public KFODUtil(String loc, RemoteUserInfo uInfo, boolean isPreGIInst) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(loc, "KFODUtil-constr4-oHome");
        oracle.cluster.impl.util.Utils.assertInputNotNull(uInfo, "KFODUtil-constr4-uInfo");
        m_isPreGIInst = isPreGIInst;
        this.m_uInfo = uInfo;
        this.m_cmdtool = this.nativeSystem.isUnixSystem() && isPreGIInst ? new CmdToolUtil(uInfo, "kfod.bin", loc) : new CmdToolUtil(uInfo, this.KFODUTL_CMD, loc);
    }

    private String[] getErrorAndOutput(CommandResult result) {
        String[] outString;
        ArrayList<String> errorAndOut = new ArrayList<String>();
        String[] errorString = result.getResultString();
        if (errorString != null && errorString.length > 0) {
            errorAndOut.addAll(Arrays.asList(errorString));
        }
        if ((outString = result.getOutputString()) != null && outString.length > 0) {
            errorAndOut.addAll(Arrays.asList(outString));
        }
        return errorAndOut.toArray(new String[errorAndOut.size()]);
    }

    public String getASMActiveVersion() throws CmdToolUtilException {
        String localNode = "";
        try {
            localNode = Utils.getLocalHost();
            return this.doGetASMActiveVersion(localNode);
        }
        catch (UnknownHostException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ASM_ACTIVE_VERSION_FAIL, (Throwable)e, new Object[0]);
        }
    }

    public String getASMActiveVersion(String nodename) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodename);
        return this.doGetASMActiveVersion(nodename);
    }

    private String doGetASMActiveVersion(String nodename) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{"nohdr=true", "op=version", "hostlist='" + nodename + "'"};
        CommandResult result = this.m_cmdtool.execute(args, null, true, true);
        if (!result.getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for nodename, " + nodename);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_ASM_ACTIVE_VERSION_NODE_FAIL, nodename, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        this.print_outputTrace(result.getResultString());
        String version = this.parseOutput(nodename, result.getResultString(), 0, 2);
        Trace.out("asm active version for the node, " + nodename + " = " + version);
        return version;
    }

    public boolean getASMInstanceType() throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{"nohdr=true", "op=version"};
        CommandResult result = this.m_cmdtool.execute(args, null, true, true);
        if (!result.getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_ASM_INSTANCE_TYPE_FAIL, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        this.print_outputTrace(result.getResultString());
        String type = this.parseOutput(null, result.getResultString(), 0, 1);
        Trace.out("asm instance type = " + type);
        if (!type.equals(KFODUTL_OUTPUT_YES) && !type.equals(KFODUTL_OUTPUT_NO)) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_WRONG_ASM_INST_TYPE_OUTPUT, type);
        }
        return type.equals(KFODUTL_OUTPUT_YES);
    }

    public boolean isASMRunning(String nodename) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{"nohdr=true", "op=insts", "hostlist='" + nodename + "'"};
        CommandResult result = this.m_cmdtool.execute(args, null, true, true);
        if (!result.getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for nodename, " + nodename);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_CHECK_ASM_RUNNING_FAIL, nodename, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        this.print_outputTrace(result.getResultString());
        if (result.getResultString() != null && result.getResultString().length > 0) {
            Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
            String runningNode = this.parseOutput(nodename, result.getResultString(), 0, 2);
            Trace.out("running node = " + runningNode);
            if (runningNode.equals(nodename)) {
                Trace.out("ASM is running on node, " + nodename);
                return true;
            }
            Trace.out("ASM is not running on node, " + nodename);
            return false;
        }
        Trace.out("ASM is not running on node, " + nodename);
        return false;
    }

    public boolean isRollingMigration() throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{"nohdr=true", "op=rm"};
        CommandResult result = this.m_cmdtool.execute(args, null, true, true);
        if (!result.getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for localnode, ");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_CHECK_RM_FAIL, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        this.print_outputTrace(result.getResultString());
        if (result.getResultString() != null && result.getResultString().length > 0) {
            Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
            return "active".equalsIgnoreCase(Utils.getString(result.getResultString(), NEWLINE));
        }
        Trace.out("ASM is not in rolling migration");
        return false;
    }

    public List<String> getDiskGroupNames() throws CmdToolUtilException {
        return this.internalGetDiskGroupNames(null);
    }

    public List<String> getDiskGroupNames(String nodename) throws CmdToolUtilException {
        return this.internalGetDiskGroupNames(nodename);
    }

    private List<String> internalGetDiskGroupNames(String nodename) throws CmdToolUtilException {
        String[] errorString;
        String[] args = nodename != null ? new String[]{"nohdr=true", "op=groups", "hostlist='" + nodename + "'"} : new String[]{"nohdr=true", "op=groups"};
        CommandResult result = this.m_cmdtool.execute(args, null, true, true);
        if (!result.getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            if (nodename != null) {
                Trace.out("m_cmdtool.execute failed for nodename, " + nodename);
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_GET_DISKGROUP_NAMES_FAIL, nodename, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
            }
            Trace.out("m_cmdtool.execute failed");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_GET_ALL_DISKGROUP_NAMES_FAIL, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] outputs = result.getResultString();
        int outputLen = outputs != null ? outputs.length : 0;
        ArrayList<String> dgNameList = new ArrayList<String>(outputLen);
        for (int i = 0; i < outputLen; ++i) {
            Trace.out("outputs[" + i + "] = " + outputs[i]);
            String[] values = outputs[i].trim().split(DELIMITER);
            if (values.length <= 3) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_PARSE_OUTPUT_FAIL, outputs[i], this.m_cmdtool.getSourceLocation());
            }
            Trace.out("values length = " + values.length);
            Trace.out("values0 = " + values[0]);
            Trace.out("values1 = " + values[1]);
            Trace.out("values2 = " + values[2]);
            Trace.out("values3 = " + values[3]);
            dgNameList.add(values[3]);
        }
        return dgNameList;
    }

    public Vector<String[]> getDiskGroupData(String nodename) throws CmdToolUtilException {
        String[] errorString;
        Vector<String[]> stList = new Vector<String[]>();
        String[] args = new String[]{"nohdr=true", "op=groups", "hostlist='" + nodename + "'"};
        CommandResult result = this.m_cmdtool.execute(args, null, true, true);
        if (!result.getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for nodename, " + nodename);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_GET_DISKGROUP_NAMES_FAIL, nodename, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] outputs = result.getResultString();
        int outputLen = outputs != null ? outputs.length : 0;
        ArrayList dgNameList = new ArrayList(outputLen);
        for (int i = 0; i < outputLen; ++i) {
            Trace.out("outputs[" + i + "] = " + outputs[i]);
            String[] values = outputs[i].trim().split(DELIMITER);
            if (values.length <= 3) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_PARSE_VALUE_NODE_FAIL, outputs[i], nodename, this.m_cmdtool.getSourceLocation());
            }
            Trace.out("values length = " + values.length);
            Trace.out("values0 = " + values[0]);
            Trace.out("values1 = " + values[1]);
            Trace.out("values2 = " + values[2]);
            Trace.out("values3 = " + values[3]);
            stList.add(values);
        }
        return stList;
    }

    private String parseOutput(String nodename, String[] strArr, int row, int col) throws CmdToolUtilException {
        if (strArr == null || strArr.length <= row) {
            if (nodename == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_PARSE_OUTPUT_FAIL, this.m_cmdtool.getSourceLocation());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_PARSE_OUTPUT_NODE_FAIL, nodename, this.m_cmdtool.getSourceLocation());
        }
        String[] values = strArr[row].split(DELIMITER);
        if (values.length <= col) {
            if (nodename == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_PARSE_VALUE_FAIL, strArr[row], this.m_cmdtool.getSourceLocation());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_PARSE_VALUE_NODE_FAIL, strArr[row], nodename, this.m_cmdtool.getSourceLocation());
        }
        return values[col];
    }

    private void print_outputTrace(String[] result) {
        if (result != null && result.length > 0) {
            for (int i = 0; i < result.length; ++i) {
                Trace.out("result[" + i + "] = " + result[i]);
            }
        }
    }

    public void validateASMCredentials(String credFileLocation) throws CmdToolUtilException {
        String[] errorString;
        CmdToolUtil.assertFile(credFileLocation);
        String[] args = new String[]{"nohdr=true", "op=credverify", "wrap='" + credFileLocation + "'", "_boot=TRUE"};
        CommandResult result = this.m_cmdtool.execute(args, null, true, true);
        if (!result.getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_VERIFY_WRAP_FAIL_PRE_CRSINST, credFileLocation, Utils.getString(errorString, NEWLINE));
        }
    }

    public void validateASMCredentials() throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{"nohdr=true", "op=groups"};
        CommandResult result = this.m_cmdtool.execute(args, null, true, true);
        if (!result.getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_VERIFY_WRAP_FAIL_POST_CRSINST, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
    }

    public HashMap<String, String> getASMProperties(String asmCredFile) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result;
        HashMap<String, String> propmap = new HashMap<String, String>();
        String[] args = new String[]{"nohdr=true", "op=credverify", "wrap='" + asmCredFile + "'", "_boot=TRUE"};
        String[] envs = null;
        if (m_isPreGIInst) {
            envs = this.getEnvForKfodBin();
        }
        if (!(result = this.m_cmdtool.execute(args, envs, true, true)).getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for credfile, " + asmCredFile);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_GET_ASM_PROPERTY_FAIL, asmCredFile, Utils.getString(errorString, NEWLINE));
        }
        String[] outputs = result.getResultString();
        int msgidlen = KFOD_MSGID_1001.length();
        if (outputs != null && outputs.length > 0) {
            for (String asmPropStr : outputs) {
                if (!asmPropStr.startsWith(KFOD_MSGID_1001)) continue;
                String propStr = asmPropStr.substring(msgidlen).trim();
                Trace.out("Property string is " + propStr);
                int colonIndx = propStr.indexOf(COLON);
                if (colonIndx < 0) {
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_PARSE_OUTPUT_FAIL, propStr, this.m_cmdtool.getSourceLocation());
                }
                String propKey = propStr.substring(0, colonIndx).trim();
                if (propKey.equals("")) {
                    Trace.out("Get empty string as property key");
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_PARSE_OUTPUT_FAIL, propStr, this.m_cmdtool.getSourceLocation());
                }
                String propValue = propStr.substring(colonIndx + 1).trim();
                propmap.put(propKey, propValue);
            }
            return propmap;
        }
        Trace.out("Failed to get ASM properties from credential file: " + asmCredFile);
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_GET_ASM_PROPERTY_FAIL, asmCredFile);
    }

    public List<String> getMissizedASMDiskList(String nodeName, String discoveryString) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result;
        if (discoveryString == null || discoveryString.isEmpty()) {
            Trace.out("Discovery string found to be null or an empty string");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, new Object[0]);
        }
        Trace.out("The discovery string : " + discoveryString);
        String[] args = new String[]{"nohdr=true", "op=disks", "disks=badsize", "_asm_allow_only_raw_disks=false", KFODUTL_ARG_ASM_DISKSTRING + discoveryString};
        String[] envs = null;
        if (m_isPreGIInst) {
            envs = this.getEnvForKfodBin();
        }
        if (!(result = this.m_cmdtool.execute(args, envs, true, true)).getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed to check incorrectly sized ASM disks");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_GET_MISSIZED_ASM_DISKS_FAIL, nodeName, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] outputs = result.getResultString();
        ArrayList<String> asmMissizedDiskList = new ArrayList<String>();
        if (outputs != null && outputs.length > 0) {
            for (String missizedDisk : outputs) {
                Trace.out("Missized Disk:" + missizedDisk);
                String missizedDiskStr = null;
                if (missizedDisk != null) {
                    missizedDiskStr = missizedDisk.trim();
                }
                if (missizedDiskStr.length() <= 0) continue;
                asmMissizedDiskList.add(missizedDiskStr);
            }
        } else {
            Trace.out("No missized disks");
        }
        return asmMissizedDiskList;
    }

    public List<String> getASMDiskList(String nodename) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{"nohdr=true", "op=disks", "hostlist='" + nodename + "'"};
        CommandResult result = this.m_cmdtool.execute(args, null, true, true);
        if (!result.getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for nodename, " + nodename);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_GET_ASM_DISKS_FAIL, nodename, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] outputs = result.getResultString();
        int outputLen = outputs != null ? outputs.length : 0;
        ArrayList<String> asmDiskList = new ArrayList<String>(outputLen);
        for (int i = 0; i < outputLen; ++i) {
            Trace.out("outputs[" + i + "] = " + outputs[i]);
            String[] outputSplitArr = outputs[i].trim().split(DELIMITER);
            String path = outputSplitArr[1].trim();
            asmDiskList.add(path);
        }
        return asmDiskList;
    }

    public List<String> getASMMemberDiskList(String nodename) throws CmdToolUtilException {
        return this.getASMMemberDiskList(nodename, new Version());
    }

    public List<String> getASMMemberDiskList(String nodename, Version version) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result;
        int arrLength = 4;
        int columnCount = 5;
        String[] env = null;
        if (Version.isPre11i(version)) {
            Trace.out("pre 11.1 asm home");
            arrLength = 3;
            columnCount = 3;
        }
        if (Version.isPre112(version)) {
            env = new String[1];
            String oraHome = this.m_cmdtool.getSourceLocation();
            env[0] = "ORACLE_HOME=" + oraHome.substring(0, oraHome.lastIndexOf(File.separator));
        }
        String[] args = new String[arrLength];
        args[0] = "nohdr=true";
        args[1] = KFODUTL_OP_DISKS_ASM;
        args[2] = KFODUTL_OP_STATUS;
        if (!Version.isPre11i(version)) {
            args[3] = "hostlist='" + nodename + "'";
        }
        if (!(result = this.m_cmdtool.execute(args, env, true, true)).getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for nodename, " + nodename);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_GET_ASM_DISKS_FAIL, nodename, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] outputs = result.getResultString();
        int outputLen = outputs != null ? outputs.length : 0;
        ArrayList<String> asmMemberDiskList = new ArrayList<String>(outputLen);
        Trace.out("each line of output should have " + columnCount + " columns");
        for (int i = 0; i < outputLen; ++i) {
            String status;
            Trace.out("outputs[" + i + "] = " + outputs[i]);
            String[] outputSplitArr = outputs[i].trim().split(DELIMITER);
            if (outputSplitArr.length != columnCount || !KFODUTL_OUTPUT_MEMBER.equalsIgnoreCase(status = outputSplitArr[1].trim())) continue;
            String path = outputSplitArr[2].trim();
            asmMemberDiskList.add(path);
        }
        return asmMemberDiskList;
    }

    public String getASMDefaultDiscoveryString() throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{"nohdr=true", "op=DFLTDSTR"};
        CommandResult result = this.m_cmdtool.execute(args, null, true, true);
        if (!result.getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_GET_ASM_DEFAULT_DISKSTR_FAIL, Utils.getString(errorString, NEWLINE));
        }
        String[] outputs = result.getResultString();
        if (outputs != null && outputs.length != 0) {
            return outputs[0];
        }
        return null;
    }

    public List<String> findDiskGroups(String node) throws InvalidArgsException, CmdToolUtilException {
        return this.internalFindDiskGroups(null, node);
    }

    public List<String> findDiskGroups(String discStr, String node) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(discStr, "KFODUtil-findDiskGroups-discStr");
        return this.internalFindDiskGroups(discStr, node);
    }

    private List<String> internalFindDiskGroups(String discStr, String node) throws InvalidArgsException, CmdToolUtilException {
        String[] errorString;
        CommandResult result;
        oracle.cluster.impl.util.Utils.assertInput(node, "KFODUtil-findDiskGroups-node");
        Trace.out("Retrieving disk groups ...");
        int numColumns = 5;
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("nohdr=true");
        argList.add("disks=all");
        argList.add("op=disks");
        argList.add("dscvgroup=TRUE");
        if (discStr != null) {
            argList.add("asm_diskstring='" + discStr + "'");
        }
        String[] args = argList.toArray(new String[0]);
        String[] env = null;
        if (m_isPreGIInst) {
            ArrayList<String> envList = new ArrayList<String>();
            String oraHome = this.m_cmdtool.getSourceLocation();
            oraHome = oraHome.substring(0, oraHome.lastIndexOf(FSEP));
            envList.add("ORACLE_HOME=" + oraHome);
            String lib = oraHome + FSEP + "lib";
            envList.add("LD_LIBRARY_PATH=" + lib);
            env = envList.toArray(new String[0]);
        }
        if (!(result = this.m_cmdtool.execute(node, args, env, null, null, true)).getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for nodename, " + node);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_GET_DISKGROUP_NAMES_FAIL2, node, Utils.getString(errorString, NEWLINE));
        }
        ArrayList<String> diskGrps = new ArrayList<String>();
        String[] output = result.getResultString();
        if (output != null && output.length > 0) {
            for (int i = 0; i < output.length; ++i) {
                String[] rows;
                Trace.out("rows[%d] = %s", i, output[i]);
                for (String row : rows = output[i].trim().split("\\n")) {
                    String diskGrp;
                    String[] rowSplit = row.trim().split(DELIMITER);
                    if (rowSplit.length != numColumns || diskGrps.contains(diskGrp = rowSplit[2].trim()) || String.valueOf('#').equals(diskGrp)) continue;
                    diskGrps.add(diskGrp);
                }
            }
        }
        Trace.out((Object)"found diskgroups %s", ((Object)diskGrps).toString());
        return diskGrps;
    }

    private String[] getEnvForKfodBin() {
        HashMap<String, String> envMap = new HashMap<String, String>();
        String sourceLocation = this.m_cmdtool.getSourceLocation();
        String homeLocation = new File(sourceLocation).getParentFile().getAbsolutePath();
        NativeSystem ns = new SystemFactory().CreateSystem();
        boolean isUnixSystem = ns.isUnixSystem();
        String osName = DeterminePlatform.getOSName();
        Trace.out("OS Name is..." + osName);
        envMap.put(ORACLE_HOME_ENV, System.getenv(ORACLE_HOME_ENV));
        if (envMap.get(ORACLE_HOME_ENV) == null) {
            envMap.put(ORACLE_HOME_ENV, homeLocation);
        }
        if (isUnixSystem) {
            String oldLibPath = System.getenv(LD_LIBRARY_PATH_ENV);
            String libPath = oldLibPath != null ? homeLocation + FSEP + "lib" + COLON + oldLibPath : homeLocation + FSEP + "lib";
            envMap.put(LD_LIBRARY_PATH_ENV, libPath);
            Trace.out("Env value of LD_LIBRARY_PATH is : " + libPath);
            if (DeterminePlatform.getOSName().equals("AIX")) {
                oldLibPath = System.getenv(LIBPATH_ENV);
                libPath = oldLibPath != null ? homeLocation + FSEP + "lib" + COLON + oldLibPath : homeLocation + FSEP + "lib";
                envMap.put(LIBPATH_ENV, libPath);
                Trace.out("Env value of LIBPATH is : " + libPath);
            } else if (DeterminePlatform.getOSName().equals("Solaris") || DeterminePlatform.getOSName().equals("SunOS")) {
                String oldLibPath64 = System.getenv(LD_LIBRARY_PATH64_ENV);
                String libPath64 = oldLibPath64 != null ? homeLocation + "/lib" + COLON + oldLibPath64 : homeLocation + "/lib";
                envMap.put(LD_LIBRARY_PATH64_ENV, libPath64);
                Trace.out("Env value of LD_LIBRARY_PATH_64 is : " + libPath64);
            }
        }
        ArrayList<String> envList = new ArrayList<String>();
        for (String envvar : envMap.keySet()) {
            String value = (String)envMap.get(envvar);
            String envvarNameValuePair = envvar + "=" + value;
            envList.add(envvarNameValuePair);
        }
        return envList.toArray(new String[envList.size()]);
    }

    public Hashtable<String, String> getASMDiskLabelTable(String nodeName) throws CmdToolUtilException {
        return this.getASMDiskLabelTable(nodeName, KFODUTL_ASM_DISKSTRING_NOT_AP);
    }

    public Hashtable<String, String> getASMDiskLabelTable(String nodeName, String discoveryString) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result;
        Hashtable<String, String> diskLabelTab = new Hashtable<String, String>();
        if (discoveryString == null || discoveryString.isEmpty()) {
            Trace.out("Discovery string found to be null or an empty string");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, new Object[0]);
        }
        Trace.out("The discovery string : " + discoveryString);
        String[] args = new String[]{"nohdr=true", "op=disks", "disks=all", KFODUTL_OP_LABEL_TRUE, KFODUTL_ARG_ASM_DISKSTRING + discoveryString};
        String[] envs = null;
        if (m_isPreGIInst) {
            envs = this.getEnvForKfodBin();
        }
        if (!(result = this.m_cmdtool.execute(args, envs, true, true)).getBooleanResult() && (errorString = this.getErrorAndOutput(result)) != null && errorString.length > 0) {
            Trace.out("failed to get ASM disks");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.KFOD_GET_ASM_DISKS_FAIL, nodeName, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        String[] output = result.getResultString();
        if (output != null && output.length > 0) {
            for (int i = 0; i < output.length; ++i) {
                String[] rows;
                Trace.out("rows[%d] = %s", i, output[i]);
                for (String row : rows = output[i].trim().split("\\n")) {
                    String[] rowSplit = row.trim().split(DELIMITER);
                    if (rowSplit.length < 5 || rowSplit[4].equals(KFODUTL_DISK_NOT_LABELED_TOKEN)) continue;
                    Trace.out("Adding disk:" + rowSplit[1] + ", label:" + rowSplit[4] + " to the table.");
                    diskLabelTab.put(rowSplit[1], rowSplit[4]);
                }
            }
        } else {
            Trace.out("No disks found labeled");
        }
        return diskLabelTab;
    }
}

